/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.transaction.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitMemberBean;
import com.yqbsoft.laser.html.facade.est.bean.EstReserveUnitReBean;
import com.yqbsoft.laser.html.facade.est.bean.SfDdReBean;
import com.yqbsoft.laser.html.facade.est.project.bean.HouseReBean;
import com.yqbsoft.laser.html.facade.est.project.domain.PtHouseReDomain;
import com.yqbsoft.laser.html.facade.est.project.repository.PtHouseRepository;
import com.yqbsoft.laser.html.facade.est.repository.DdCacheRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitMemberRepository;
import com.yqbsoft.laser.html.facade.est.repository.ReserveUnitRepository;
import com.yqbsoft.laser.html.facade.um.domain.UmUserReDomainBean;
import com.yqbsoft.laser.html.facade.um.repository.UserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devest/print-preview"})
public class PrintPreviewCon
extends SpringmvcController {
    @Autowired
    private ReserveUnitRepository reserveUnitRepository;
    @Autowired
    private ReserveUnitMemberRepository reserveUnitMemberRepository;
    @Autowired
    private DdCacheRepository ddCacheRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PtHouseRepository ptHouseRepository;
    private static final Map<Integer, String> ttPriceMap = new HashMap<Integer, String>();

    static {
        ttPriceMap.put(0, "\u96f6");
        ttPriceMap.put(1, "\u58f9");
        ttPriceMap.put(2, "\u8d30");
        ttPriceMap.put(3, "\u53c1");
        ttPriceMap.put(4, "\u8086");
        ttPriceMap.put(5, "\u4f0d");
        ttPriceMap.put(6, "\u9646");
        ttPriceMap.put(7, "\u67d2");
        ttPriceMap.put(8, "\u634c");
        ttPriceMap.put(9, "\u7396");
    }

    @ResponseBody
    @RequestMapping(value={"contract/form"}, produces={"application/xml;charset=utf-8"})
    public String getContractForm(HttpServletRequest request, String reserveUnitCode) throws IOException {
        if (StringUtils.isBlank((String)reserveUnitCode)) {
            return "";
        }
        String tempTxt = "";
        String filePath = "/META-INF/templet/contract_form.html";
        URL fileURL = PrintPreviewCon.class.getResource(filePath);
        if (fileURL != null) {
            InputStream inputStream = PrintPreviewCon.class.getResourceAsStream(filePath);
            tempTxt = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            Map<String, Object> resultMap = this.getReserveUnit(request, reserveUnitCode);
            tempTxt = this.forSetKeyValueByString(tempTxt, resultMap);
        }
        return tempTxt;
    }

    private String forSetKeyValueByString(String context, Map<String, Object> resultMap) {
        if (resultMap == null || resultMap.size() <= 0) {
            return "";
        }
        try {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                System.out.println("key= " + entry.getKey() + " and value= " + entry.getValue());
                context = context.replaceAll("#" + entry.getKey() + "#", String.valueOf(entry.getValue()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        context = context.replaceAll("\\#(.*?)\\#", "");
        return context;
    }

    private Map<String, Object> getReserveUnit(HttpServletRequest request, String reserveUnitCode) {
        UserSession userSession = this.getUserSession(request);
        TreeMap<String, Object> resultMap = new TreeMap<String, Object>();
        HashMap tResultMap = new HashMap();
        try {
            String discountTypeTag;
            List reserveUnitMembers;
            EstReserveUnitReBean reserveUnit = this.reserveUnitRepository.getReserveUnitByCode(reserveUnitCode, userSession.getTenantCode());
            if (reserveUnit != null) {
                String handoverDateStr;
                PtHouseReDomain houseDomain;
                UmUserReDomainBean userReDomainBean = this.userRepository.getUserByCode(reserveUnit.getUserCode());
                if (userReDomainBean != null) {
                    resultMap.put("propConsultantName", userReDomainBean.getUserRelname());
                }
                if (reserveUnit.getDeposit() != null) {
                    resultMap.put("deposit", reserveUnit.getDeposit().setScale(0, 4));
                    resultMap.put("depositUppercase", PrintPreviewCon.digitUppercase(String.valueOf(reserveUnit.getDeposit())));
                }
                if (reserveUnit.getClinchDealUnitPrice() != null) {
                    resultMap.put("clinchDealUnitPrice", reserveUnit.getClinchDealUnitPrice().setScale(0, 4));
                }
                if (StringUtils.isNotBlank((String)reserveUnit.getContractNo())) {
                    resultMap.put("contractNo", reserveUnit.getContractNo());
                }
                if (StringUtils.isNotBlank((String)reserveUnit.getSigningDate())) {
                    resultMap.put("signingDate", reserveUnit.getSigningDate());
                }
                if (reserveUnit.getTotalTransactionPrice() != null) {
                    String ttPrice;
                    int length;
                    char[] priceStrArray;
                    resultMap.put("totalTransactionPrice", reserveUnit.getTotalTransactionPrice().setScale(0, 4));
                    String ttPriceStr = "";
                    char[] cArray = priceStrArray = String.valueOf(reserveUnit.getTotalTransactionPrice().setScale(0, 4).intValue()).toCharArray();
                    int n = priceStrArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char pint = cArray[n2];
                        ttPriceStr = String.valueOf(ttPriceStr) + ttPriceMap.get(Integer.valueOf(String.valueOf(pint)));
                        ++n2;
                    }
                    priceStrArray = ttPriceStr.toCharArray();
                    boolean j = false;
                    int k = 0;
                    int i = length = ttPriceStr.length();
                    while (i > 0) {
                        ttPrice = "ttPrice" + k;
                        resultMap.put(ttPrice, Character.valueOf(priceStrArray[i - 1]));
                        --i;
                        ++k;
                    }
                    i = k;
                    while (i < 7) {
                        ttPrice = "ttPrice" + i;
                        resultMap.put(ttPrice, "\u96f6");
                        ++i;
                    }
                }
                if (StringUtils.isNotBlank((String)reserveUnit.getContractArea())) {
                    DecimalFormat df = new DecimalFormat("#.00");
                    resultMap.put("contractArea", df.format(Double.valueOf(reserveUnit.getContractArea())));
                }
                resultMap.put("roomYear", "");
                resultMap.put("roomMon", "");
                resultMap.put("roomDay", "");
                if (StringUtils.isNotBlank((String)reserveUnit.getHouseCode()) && (houseDomain = this.ptHouseRepository.getHouseByCode(reserveUnit.getHouseCode(), reserveUnit.getTenantCode())).getHouseHandoverDate() != null && StringUtils.isNotBlank((String)(handoverDateStr = DateUtil.getDateString((Date)houseDomain.getHouseHandoverDate(), (String)"yyyy-MM-dd")))) {
                    String[] dateStrs = handoverDateStr.split("-");
                    resultMap.put("roomYear", dateStrs[0]);
                    resultMap.put("roomMon", dateStrs[1]);
                    resultMap.put("roomDay", dateStrs[2]);
                }
            }
            if (ListUtil.isNotEmpty((Collection)(reserveUnitMembers = this.reserveUnitMemberRepository.getReserveUnitMemberList(reserveUnit.getReserveUnitCode())))) {
                int i = 0;
                int k = 2;
                while (i < reserveUnitMembers.size()) {
                    if (((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getMembership().equals(0)) {
                        resultMap.put("memberName", ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getMemberName());
                        resultMap.put("memberAddr", ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getMemberAddr());
                        resultMap.put("memberPhone", ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getMemberPhone());
                        resultMap.put("identityCardNumber", ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getIdentityCardNumber());
                    } else {
                        resultMap.put("memberName" + k, ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getMemberName());
                        resultMap.put("identityCardNumber" + k, ((EstReserveUnitMemberBean)reserveUnitMembers.get(i)).getIdentityCardNumber());
                        ++k;
                    }
                    ++i;
                }
            }
            reserveUnit.setPaymentDetails(reserveUnit.getEstPaymentDetails());
            if (StringUtils.isNotBlank((String)reserveUnit.getHouseCode())) {
                HouseReBean houseReBean = this.reserveUnitRepository.getHouse(reserveUnit.getHouseCode(), null, reserveUnit.getTenantCode());
                if (houseReBean != null) {
                    if (houseReBean.getPrivateArea() != null) {
                        resultMap.put("privateArea", String.format("%.2f ", houseReBean.getPrivateArea()));
                    }
                    if (houseReBean.getPublicArea() != null) {
                        resultMap.put("publicArea", String.format("%.2f ", houseReBean.getPublicArea()));
                    }
                }
                String houseTag = this.getHouseTag(reserveUnit);
                resultMap.put("houseTag", houseTag);
            }
            if (StringUtils.isNotBlank((String)reserveUnit.getDiscountTypeCode()) && (discountTypeTag = this.getDiscountTypeTag(reserveUnit.getDiscountTypeCode())) != null) {
                reserveUnit.setDiscountTypeTag(discountTypeTag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultMap;
    }

    private String getHouseTag(EstReserveUnitReBean reserveUnitReBean) {
        String houseTag = "";
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getBuildingNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getBuildingNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getUnitNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getUnitNumber();
        }
        if (StringUtils.isNotBlank((String)reserveUnitReBean.getRoomNumber())) {
            houseTag = String.valueOf(houseTag) + reserveUnitReBean.getRoomNumber();
        }
        return houseTag;
    }

    private String getDiscountTypeTag(String discountTypeCode) {
        List ddReBeanList = this.ddCacheRepository.queryDdList("EstReserveUnit", "discountTypeCode", "", "up");
        if (ddReBeanList == null || ddReBeanList.size() <= 0) {
            return null;
        }
        for (SfDdReBean sfDdReBean : ddReBeanList) {
            if (sfDdReBean == null || !sfDdReBean.getDdCode().equals(discountTypeCode)) continue;
            return sfDdReBean.getDdValue();
        }
        return null;
    }

    public static String digitUppercase(String num) throws Exception {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[] unit1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
        String[] unit2 = new String[]{"\u5143", "\u4e07", "\u4ebf", "\u4e07\u4ebf"};
        BigDecimal bigDecimal = new BigDecimal(num);
        bigDecimal = bigDecimal.multiply(new BigDecimal(100));
        String strVal = String.valueOf(bigDecimal.toBigInteger());
        String head = strVal.substring(0, strVal.length() - 2);
        String end = strVal.substring(strVal.length() - 2);
        String endMoney = "";
        String headMoney = "";
        if ("00".equals(end)) {
            endMoney = "";
        } else {
            if (!end.substring(0, 1).equals("0")) {
                endMoney = String.valueOf(endMoney) + digit[Integer.valueOf(end.substring(0, 1))] + "\u89d2";
            } else if (end.substring(0, 1).equals("0") && !end.substring(1, 2).equals("0")) {
                endMoney = String.valueOf(endMoney) + "\u96f6";
            }
            if (!end.substring(1, 2).equals("0")) {
                endMoney = String.valueOf(endMoney) + digit[Integer.valueOf(end.substring(1, 2))] + "\u5206";
            }
        }
        char[] chars = head.toCharArray();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        boolean zeroKeepFlag = false;
        int vidxtemp = 0;
        int i = 0;
        while (i < chars.length) {
            int idx = (chars.length - 1 - i) % 4;
            int vidx = (chars.length - 1 - i) / 4;
            String s = digit[Integer.valueOf(String.valueOf(chars[i]))];
            if (!"\u96f6".equals(s)) {
                headMoney = String.valueOf(headMoney) + s + unit1[idx] + unit2[vidx];
                zeroKeepFlag = false;
            } else if (i == chars.length - 1 || map.get("zero" + vidx) != null) {
                headMoney = String.valueOf(headMoney);
            } else {
                headMoney = String.valueOf(headMoney) + s;
                zeroKeepFlag = true;
                map.put("zero" + vidx, true);
            }
            if (vidxtemp != vidx || i == chars.length - 1) {
                headMoney = headMoney.replaceAll(unit2[vidx], "");
                headMoney = String.valueOf(headMoney) + unit2[vidx];
            }
            if (zeroKeepFlag && (chars.length - 1 - i) % 4 == 0) {
                headMoney = headMoney.replaceAll("\u96f6", "");
            }
            ++i;
        }
        return String.valueOf(headMoney) + endMoney;
    }

    protected String getContext() {
        return null;
    }
}

