<#include '/layout/Head.ftl' />

				 <div id="updateLayer">
						<div class="layerDiv">
							<#if house?exists>
							<form name="mainFrm" class="form-horizontal">
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>房号</label>
									<div class="col-sm-8">
											<input type="text" name="houseName" id="houseName" value="${house.houseName!}" readonly/>
											<input type="hidden" name="houseCode" id="houseCode" value="${house.houseCode!}"/>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>户型</label>
									<div class="col-sm-8">
										<input type="text" name="houseStyle" id="houseStyle" value="${house.houseStyle!}"/>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>面积</label>
									<div class="col-sm-8">
										<input type="text" name="totalArea" id="totalArea" value="${house.totalArea!}"/>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>表价(元)</label>
									<div class="col-sm-8">
										<input type="text" name="averagePrice" id="averagePrice" value="${house.averagePrice!}"/>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>底价(元)</label>
									<div class="col-sm-8">
										<input type="text" name="minPrice" id="minPrice" value="${house.minPrice!}"/>
									</div>
								</div>
								
								
								<div class="form-group">
									<label class="control-label col-sm-3">佣金类型</label>
									<div class="col-sm-8">
										<div class="select-wrapper input_nomal">
											<select name="commissionType" id="commissionType" onchange="switchCommission(this);">
												<#if commissionTypes?exists>
													<#list commissionTypes as commissionType>
						                                <option value="${commissionType.ddCode}" <#if (((house.commissionType!0)?string("0")) == '${commissionType.ddCode?number}')>selected="selected"</#if> >${commissionType.ddValue!}</option>
													</#list>
												</#if>
											</select>
										</div>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-sm-3" id="commissionText">金额</label>
									<div class="col-sm-8">
										<input type="text" name="commission" id="commission" value="${house.commission!}"/>
									</div>
								</div>
								
								
								<input type="hidden" name="tenantCode" id="tenantCode" value="${house.tenantCode!}"/>
								<input type="hidden" name="oldDataState" value="${house.dataState!}"/>
							
								<div class="form-group">
									<label class="control-label col-sm-3"><span class="red">*</span>状态</label>
									<div class="col-sm-8">
										<div class="select-wrapper input_nomal">
											<select id="dataState" name="dataState" onChange="changeHint(this);">
												<#if (house.memo == '1')>
												<!--有订单-->
													<#if (house.dataState == 1)>
														<option value="1">认筹</option>
													<#elseif (house.dataState == 2)>
														<option value="2">认购</option>
													<#elseif (house.dataState == 3)>
														<option value="3">已售</option>
													<#else>
														<option value="0" <#if (house.dataState == 0)> selected</#if>>可售</option>
														<option value="4" <#if (house.dataState == 4)> selected</#if>>保留</option>
														<option value="1">认筹</option>
														<option value="2">认购</option>
														<option value="3">已售</option>
													</#if>
												<#else>
														<!--无订单-->
														<option value="0" <#if (house.dataState == 0)> selected</#if>>可售</option>
														<option value="4" <#if (house.dataState == 4)> selected</#if>>保留</option>
														<option value="1" <#if (house.dataState == 1)> selected</#if>>认筹</option>
														<option value="2" <#if (house.dataState == 2)> selected</#if>>认购</option>
														<option value="3" <#if (house.dataState == 3)> selected</#if>>已售</option>
												</#if>
											</select>
										</div>
									</div>
								</div>
								
								
								<div class="button_div">
									<button type="button" onclick="submitUpdate(this);" class="button bg_blue">确定</button>
									<button type="button" class="button bg_blue closeLayer" onclick="closeLayer();">取消</button>
								</div>
							</form>
				</#if>
					</div>	
			</div>
					
					
<script>
			function changeHint(obj){
				//alert('您所选的状态为：'+(obj.options[obj.selectedIndex].text));
			}
			/*提交修改*/
			function submitUpdate(obj){
				obj.disabled=true;
				var houseCode=$("input[name='houseCode']").val();
				var commission=$("input[name='commission']").val();
				var commissionType=$("#commissionType").val();
				var houseName=$("input[name='houseName']").val();
				var houseStyle=$("input[name='houseStyle']").val();
				var totalArea=$("input[name='totalArea']").val();
				var averagePrice=$("input[name='averagePrice']").val();
				var dataState=$("select[name='dataState']").val();
				var oldDataState=$("input[name='oldDataState']").val();
				var tenantCode=$("input[name='tenantCode']").val();
				var minPrice=$("input[name='minPrice']").val();
				
				if((!checkNull(averagePrice,'表价'))||(!checkNum(averagePrice,'表价'))){
					return false;
				}
				if((!checkNull(minPrice,'底价'))||(!checkNum(minPrice,'底价'))){
					return false;
				}
				var jsonData = {"commission":commission,"commissionType":commissionType,"houseCode":houseCode,"houseName":houseName, "houseStyle":houseStyle,"totalArea":totalArea,"averagePrice":averagePrice,"dataState":dataState,"oldDataState":oldDataState,"tenantCode":tenantCode,"minPrice":minPrice};
				$.ajax({
					type: "POST",
		            contentType: "application/json; charset=utf-8",
		            dataType: "json",
		            url: "${sysAppContextPath}/web/pt/house/dev/updateHouse.json",
		          	data: JSON.stringify(jsonData),
		            success: function (data) {
		            	if(data.success == true && data.sysRecode == 'success'){
		            		parent.location.reload(); 
		            		parent.layer.close(parent.layer.getFrameIndex(window.name));
		            	}else {
		                	alert(data.msg);
		                	return false;
		            	}
		             },
		             error: function (data) {
		                  alert(data.msg)
		                  return false;
		             }
		         });
			}
			
			/*非空校验*/
			function checkNull(obj,msg){
				if(obj == null||obj == ''){
       				alert("请输入："+msg);
       				return false;
       			}
       			return true;
			}
			
			/*3位小数校验*/
			function checkNum(obj,msg){
       			var reg = new RegExp("^[0-9]+(.[0-9]{1,3})?$");
				if(!reg.test(obj)){
   			 		alert(msg+":请输入非零数,最多保留3位小数!");
   				 	return false;
    			}
    			return true;
  			}
  			
  			//佣金
  			function switchCommission(obj){
				var type = obj.value;
				if(type == 1){
					$("#commissionText").text("金额");
				}else if(type == 2){
					$("#commissionText").text("比例值");
				}
			}
			
			$(document).ready(function(){
				commissionTypeChange();
    		});
    		
    		function closeLayer(){
    			parent.layer.close(parent.layer.getFrameIndex(window.name));
    		}
    		
    		/*触发佣金类型选择事件*/
    		function commissionTypeChange(){
    			$("select[name='commissionType']").trigger("change"); 
    		}
    		
    		
</script>