<#include '/layout/Head.ftl' />

<style>
    .circle-r {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        font-size: 20px;
        color: #ffffff;
        line-height: 50px;
        text-align: center;
        background: #d0d0d0;
        text-align: center;
        line-height: 50px;
    }
    .list-group-item-content{
        overflow:hidden;
        margin-top: 10px;
        position: relative;
    }
    .list-group-item-content-text{
        position: absolute;
        right: 40px;
        top: -5px;
    }
</style>

<script src="${path_servername}/${webRoot}/commonjs/chartjs/Chart.js"></script>
<script src="${path_servername}/${webRoot}/commonjs/echarts.min.js"></script>
<div id="bj_wrapper">
    <div class="page_pad">
        <div class="page_bar" style="display: flow-root">
            <div class="float_left">
							<span>
								<label>
							<h1 style="font-size: 25px">首页</h1>
									</label>
								</span>
            </div>
            <div class="float_right">
							<span>
                            <label>
                            ${.now}
                            </label>
							</span>
            </div>
        </div>
        <form class="form_list" name="mainFrm">

            <div class="page_content">
                <div class="content_table">

                    <div class="table_tools clearfix">
                        <div class="float_left">
									<span>
										<label>项目名称：</label>
										<div class="select-wrapper inline_200">
										<select name="projectCode" onChange="changeProject(this);">
                                        <#if projects?exists>
                                            <#list projects as project>
                                                <option value="${project.projectCode}"
                                                        <#if (((projectCode)!'') == '${project.projectCode!}')>selected="selected"</#if>>${project.projectName!}</option>
                                            </#list>
                                        </#if>
											</select>
										</div>
									</span>
                        </div>
                    </div>

                    <div class="table_main  row" style="display: block;">
                        <!--趋势图-->
                        <div class="col-md-8">
                            <ul class="table_tag clearfix mpan_tab" style="margin-bottom: 30px;">
                                <li id="classfiy_1" data="${reportDataWeekArray!'[]'}" class="active"><a
                                        href="javascript:;">汇总分析</a></li>
                            <#--<li id="classfiy_2" data="${reportDataWeekArray!'[]'}"><a href="javascript:;">报备</a></li>
                            <li id="classfiy_3" data="${visitingDataWeekArray!'[]'}"><a href="javascript:;">客户来访趋势</a></li>
                            <li id="classfiy_5" data="${sbuyDataWeekArray!'[]'}"><a href="javascript:;">预定量</a></li>
                            <li id="classfiy_6" data="${tradeDataWeekArray!'[]'}"><a href="javascript:;">成交量</a></li>-->
                            </ul>

                            <div id="canvas-holder" style="width:75%;float: left">
                                <canvas id="canvas"/>
                            </div>
                        </div>

                        <!--漏斗图-->
                        <div class="col-md-4">
                            <div id="funnel_main" style="width: 500px;height:400px;"></div>
                        </div>

                    </div>


                </div>
            </div>
        </form>


        <div class="page_content" style="margin-top: 20px">
            <div class="panel panel-info row">
                <div class="list-group col-md-8">
                    <a href="#" class="list-group-item active">
                        实时动态
                    </a>

                <#if reportList?exists>
                    <#list reportList as report>
                        <a href="#" class="list-group-item">
                            <span><label style="color: #bfbfbf;">${report.reportDate!}</label></span>
                            &nbsp;
                            <span><label style="color: #000000;">
                            <#if ('0001001' == '${report.roleCode!}')>
                                  拓客
                            </#if>
                            <#if ('0001003' == '${report.roleCode!}')>
                                  置业顾问
                            </#if>
                            <#if ('BK00001' == '${report.roleCode!}')>
                                  经纪人
                            </#if>
                            </label></span>
                            &nbsp;
                            <span><label style="color: #4ebf58;">${report.reportUname!}</label></span>
                            &nbsp;
                            <span><label style="color: #828282;">添加了一组客户，客户姓名"${report.memberName!}"电话"${report.memberPhone!}"</label></span>
                        </a>

                    </#list>
                </#if>
                </div>

                <div class="list-group col-md-4">
                    <a href="#" class="list-group-item active">
                        业绩排名(月)
                    </a>
                    <a href="#" class="list-group-item">
                    <#if mmSalesList?exists>
                        <#list mmSalesList as mmSales>
                        <div class="list-group-item-content">
                            <div style="margin-right: 10px;display: inline-block;">
                                <div class="circle-r">${mmSales.userName!'无'}</div>
                            </div>
                            <div class="list-group-item-content-text" ><span>${mmSales.salesAmount?string("currency")!}</span></div>
                            <div style="vertical-align:middle;display: inline-block;width: 80%;vertical-align: middle;">
                                <div class="progress" style="height: 5px; ">
                                    <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="${mmSales.salesAmountP!0}"
                                         aria-valuemin="0" aria-valuemax="100" style="width: ${mmSales.salesAmountP!0}%">
                                        <span class="sr-only">40% Complete (success)</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        </#list>
                    </#if>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        (function () {

            /*var reportAnalysis =[{
                label: "报备",
                backgroundColor: window.chartColors.blue,
                borderColor: window.chartColors.blue,
                data: ${reportDataWeekArray!'[]'}
            ,
                        fill: false,
                    }];
                    var visitingAnalysis = [{
                        label: "来访",
                        backgroundColor: window.chartColors.green,
                        borderColor: window.chartColors.green,
                        data: ${visitingDataWeekArray!'[]'}
            ,
                        fill: false,
                    }];
                    var sbuyAnalysis = [{
                        label: "认购",
                        backgroundColor: window.chartColors.yellow,
                        borderColor: window.chartColors.yellow,
                        data: ${sbuyDataWeekArray!'[]'}
            ,
                        fill: false,
                    }];
                    var tradeAnalysis = [{
                        label: "成交",
                        backgroundColor: window.chartColors.orange,
                        borderColor: window.chartColors.orange,
                        data: ${tradeDataWeekArray!'[]'}
            ,
                        fill: false,
                    }];*/
            var collectAnalysis = [{
                label: "报备",
                backgroundColor: window.chartColors.blue,
                borderColor: window.chartColors.blue,
                data: ${visitingDataWeekArray!'[]'},
                fill: false,
            }, {
                label: "来访",
                backgroundColor: window.chartColors.green,
                borderColor: window.chartColors.green,
                data: ${visitingDataWeekArray!'[]'},
                fill: false,
            }, {
                label: "认购",
                backgroundColor: window.chartColors.yellow,
                borderColor: window.chartColors.yellow,
                data: ${sbuyDataWeekArray!'[]'},
                fill: false,
            }, {
                label: "成交",
                backgroundColor: window.chartColors.red,
                borderColor: window.chartColors.red,
                data: ${tradeDataWeekArray!'[]'},
                fill: false,
            }];
            var config = {
                type: 'line',
                data: {
                    labels: ${reportDateWeekArray!'[]'},
                    datasets: collectAnalysis
                },
                options: {
                    responsive: true,
                    title: {
                        display: false,
                        text: '统计'
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                    },
                    hover: {
                        mode: 'nearest',
                        intersect: false
                    },
                    scales: {
                        xAxes: [{
                            display: true,
                            scaleLabel: {
                                display: false,
                                labelString: 'Month'
                            }
                        }],
                        yAxes: [{
                            display: true,
                            scaleLabel: {
                                display: true,
                                labelString: ''
                            }
                        }]
                    }
                }
            };

            window.onload = function () {
                var ctx = document.getElementById("canvas").getContext("2d");
                window.myLine = new Chart(ctx, config);
                var $withd = $("#canvas-holder").width();  //获取父级的宽度
                document.getElementById("canvas").width = $withd;
            };

            //漏斗图 初始化echarts实例
            option = {
                title: {
                    text: '漏斗图',
                    subtext: '(月)'
                },
                tooltip: {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c}%"
                },
                toolbox: {
                    feature: {
                        dataView: {readOnly: false},
                        restore: {},
                        saveAsImage: {}
                    }
                },
                legend: {
                    data: ['报备', '有效客户', '到访量', '成交量']
                },
                calculable: true,
                series: [
                    {
                        name: '漏斗图',
                        type: 'funnel',
                        left: '10%',
                        top: 60,
                        //x2: 80,
                        bottom: 60,
                        width: '80%',
                        // height: {totalHeight} - y - y2,
                        min: 0,
                        max: 100,
                        minSize: '0%',
                        maxSize: '100%',
                        sort: 'descending',
                        gap: 2,
                        label: {
                            normal: {
                                show: true,
                                position: 'inside'
                            },
                            emphasis: {
                                textStyle: {
                                    fontSize: 20
                                }
                            }
                        },
                        labelLine: {
                            normal: {
                                length: 10,
                                lineStyle: {
                                    width: 1,
                                    type: 'solid'
                                }
                            }
                        },
                        itemStyle: {
                            normal: {
                                borderColor: '#fff',
                                borderWidth: 1
                            }
                        },
                        data: [
                            {value: ${reportPercent!0}, name: '报备'},
                            {value: ${reportPPercent!0}, name: '有效客户'},
                            {value: ${visitingPercent!0}, name: '到访量'},
                            {value: ${reserveUnitPercent!0}, name: '成交量'}
                        ]
                    }
                ]
            };

            var myChart = echarts.init(document.getElementById('funnel_main'));
            // 使用刚指定的配置项和数据显示图表。
            myChart.setOption(option);


            $(".mpan_tab").on("click", "li", function () {
                $("ul li").removeClass("active");
                $(this).addClass("active");
            });

        })();


        function changeProject(obj) {
            exeSubmit();
        }

        function exeSubmit() {
            mainFrm.action = "";
            mainFrm.method = "post";
            mainFrm.submit();
        }

        $('#detaileBtn').on('click', function () {
            var index = layer.open({
                type: 2,
                skin: 'layui-layer-lan',
                title: '登记详情',
                shade: 0.5,
                area: ['600px', '300px'],
                content: 'transactionexamdetail'
            });
            $('.closeLayer').on('click', function () {
                layer.close(index);
            });
        });

        /*注册绑定按钮事件*/
        function bindBtnEvent() {
            $("button[name='handleFlush']").click(function () {
                location.reload();
            });
            $("button[name='handleExp']").click(function () {
                //导出该列表

            });
            $("button[name='queryBtn']").click(function () {
                //筛选 查询
                exeSubmit();
            });

        }

        $(document).ready(function () {
            bindBtnEvent();
            seleProject();
        });

        //查询后选中状态
        function seleProject() {
            var projectCode = '';
        <#if paramMap.projectCode?exists>
            projectCode = '${paramMap.projectCode!}';
        </#if>
            if (projectCode) {
                $("select[name='projectCode'] option").each(function () {
                    if ($(this).val() == projectCode) {
                        $(this).attr("selected", "selected");
                    }
                });
            }
        }
    </script>
