/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.login_exchange.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.ar.repository.RdrandomRepository;
import com.yqbsoft.laser.html.facade.mm.repository.MmMerberRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/security"})
@Layout(frameName="application")
public class SecurityCon
extends SpringmvcController {
    @Autowired
    private MmMerberRepository merberRepository;
    @Autowired
    private RdrandomRepository rdrandomRepository;

    @Autowired
    protected String getContext() {
        return "security";
    }

    @RequestMapping(value={"updatepwd"})
    public String realname(HttpServletRequest request, ModelMap map) {
        UserSession session = this.getUserSession(request);
        String mbuserPhone = session.getUserPhone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        map.addAttribute("mbuserPhone", (Object)mbuserPhone);
        return String.valueOf(this.getFtlTempPath(request)) + "updatepwd";
    }

    @RequestMapping(value={"updatepwd.json"})
    @ResponseBody
    private HtmlJsonReBean checkCode(HttpServletRequest request, String verCode, String imgCode, String userPassword) {
        if (StringUtils.isBlank((String)verCode) || StringUtils.isBlank((String)imgCode)) {
            this.logger.error("updatepwd.json", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        UserSession user = this.getUserSession(request);
        String tenantCode = user.getTenantCode();
        if (!this.checkVerCode("2", request.getRemoteAddr(), imgCode, tenantCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u56fe\u7247\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        if (!this.checkVerCode("0", user.getUserPhone(), verCode, tenantCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        return this.merberRepository.updatePasawordById(user.getUserId(), userPassword);
    }

    @RequestMapping(value={"getVerCode.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean getVerCode(HttpServletRequest request) {
        UserSession user = this.getUserSession(request);
        Map result = this.rdrandomRepository.getRandom("0", user.getUserPhone(), ServletMain.getAppName(), user.getTenantCode());
        if (((Boolean)result.get("flag")).booleanValue()) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, result.get("message").toString());
    }

    private boolean checkVerCode(String businessType, String host, String verCode, String tenantCode) {
        Map result_code = this.rdrandomRepository.check(businessType, host, tenantCode, verCode);
        return (Boolean)result_code.get("flag");
    }
}

