<script src="${webRoot}/commonjs/layer/layer.js"></script> 

<div class="account_main">
	<h3 class="account_main_title"><span>收货地址管理</span></h3>
	<div class="account_main_pad clearfix">
		<div class="account_adress">
			<#if list?exists>
			<#list list as address>
				<div class="adress_item">
					<dl>
						<dt><span class="adress_name">${address.addressMember?if_exists}</span></dt>
						<dd>${address.addressPhone?if_exists}</dd>
						<dd>${address.provinceName?if_exists} ${address.areaName?if_exists} ${address.cityName?if_exists}</dd>
						<dd>${address.addressDetail?if_exists}</dd>
						<dd>(${address.addressZipcode?if_exists})</dd>
					</dl>
					<div class="reset_text">
						<a href="javascript:;" class="modifyAdress" onclick="showdiv('${address.addressCode}')">修改</a>
						<span>|</span>
						<a href="javascript:deleteaddress('${address.addressCode}');">删除</a>
					</div>
					<#if address.addressDefault?exists&& address.addressDefault=="1">
					<a href="javascript:setdefault('${address.addressCode}');" class="default default_block">默认地址</a>
					<#else>
					<a href="javascript:setdefault('${address.addressCode}');" class="default">设为默认地址</a>
					</#if>
				</div>
			</#list>
			</#if>
			 <div class="adress_item null">
				<a href="javascript:void(0);" class="add_adress" id="addAdress" onclick="showdiv('');">
					<i>+</i> 增加新地址
				</a>
			</div>
		</div>
	</div>
</div>
 
 


<div id="addAdressDiv" class="hidden">
	<div class="pad_top20 pad_bot20">
		<form name="form_address" method="post">
			<input type="hidden" name="addressCode" >
			<div class="input_group clearfix">
				<label>所在地区</label>
				<div class="input_control">
					<select class="input_width100" name="provinceCode" id="provinceCode" onchange="selctpro()">
						<option>请选择省</option>
							<#if province?exists>
							<#list province as p>
								<option value="${p.provinceCode}">${p.provincName}</option>
						 	</#list>
					 		</#if>
					</select>
					
					<select class="input_width100" name="areaCode" id="areas" onchange="selectarea()">
						<option value="">请选择市</option>
					</select>
					
					<select class="input_width100" name="cityCode" id="cityCode">
						<option value="">请选择</option>
					</select>
					<p class="error_text_provinceCode"></p>
				</div>
			</div>
			<div class="input_group clearfix">
				<label>详细地址</label>
				<div class="input_control">
					<textarea name="addressDetail" id="addressDetail" onblur="detail();" class="input_width300" placeholder="建议您如实填写详细收货地址，例如街道名称，门牌号码，楼层和房间号等信息"></textarea>
					<p class="error_text_detail"></p>
				</div>
			</div>
			<div class="input_group clearfix">
				<label>邮政编码</label>
				<div class="input_control">
					<input type="text" name="addressZipcode" class="input_width300" placeholder="如您不清楚邮递区号，请填写000000" />
				</div>
			</div>
			<div class="input_group clearfix">
				<label>收货人姓名</label>
				<div class="input_control">
					<input type="text" name="addressMember" id="addressMember" onblur="member();" class="input_width300" maxlength="20" placeholder="长度不超过25个字符" />
					<p class="error_text_member"></p>
				</div>
			</div>
			<div class="input_group clearfix">
				<label>手机号</label>
				<div class="input_control">
					<input type="text" name="addressPhone" id="addressPhone" onblur="phone();" class="input_width300" placeholder="联系人手机号" />
					<p class="error_text_phone"></p>
				</div>
			</div>
			<div class="input_group clearfix">
				<label>&nbsp;</label>
				<div class="input_control">
					<input type="checkbox" name="addressDefault" value="1"/>设置为默认收货地址
					<p class="pad_top10"><button type="button" id="btn" class="btn btn_block120 bg_red closeLayer">保存</button></p>
				</div>
			</div>
		</form>
	</div>
</div>

<script>
function showdiv(code){
	if(code!=''){
		setaddress(code);
	}
	var index = layer.open({
		type: 1,
		skin: 'demo-class',
		title: '新增收货地址',
		area: ['630px', '530px'],
		shadeClose: true, //点击遮罩关闭
		content: $('#addAdressDiv')
	});

$('.closeLayer').on('click', function() {
	
		if(!checkprovince()){
			return false;
		}
		if(!detail()){
			return false;
		}
		if(!member()){
			return false;
		}
		if(!phone()){
			return false;
		}
		var obj=$(this);
		if(code!=''){
		   updateress();
		}else{
		   addaddress();
		}
		obj.prop("disabled",false);
		layer.close(index);
});
}



function checkprovince(){
  $(".error_text_provinceCode").html("");
  var cityCode=$("#cityCode").val();
  if(cityCode==''){
  		$(".error_text_provinceCode").html("<i class='error_icon'></i>"+"请选择省份地区");
		return false;
  }else{
		return true;
  }
}
//地址非空验证
function detail(){
  $(".error_text_detail").html("");
  var addressDetail=$("#addressDetail").val();
  if(!$.trim(addressDetail)){
  		$("textarea[name='addressDetail']").addClass("error_border");
  		$(".error_text_detail").append("<i class='error_icon'></i>"+"地址不能为空");
		return false;
  }else{
		$("textarea[name='addressDetail']").removeClass("error_border");
		return true;
	}
}

//姓名非空验证
function member(){
  $(".error_text_member").html("");
  var addressMember=$("#addressMember").val();
  if(!$.trim(addressMember)){
  		$("input[name='addressMember']").addClass("error_border");
  		$(".error_text_member").append("<i class='error_icon'></i>"+"姓名不能为空");
		return false;
  }else{
		$("input[name='addressMember']").removeClass("error_border");
		return true;
	}
}

//电话验证
function phone(){
  $(".error_text_phone").html("");
  var addressPhone=$("#addressPhone").val();
  if(!(/^1[0-9][0-9]\d{8}/.test(addressPhone))){
  		 $("input[name='addressPhone']").addClass("error_border");
  		 $(".error_text_phone").append("<i class='error_icon'></i>"+"手机号码格式不正确");
		 return false;
	}else{
		$("input[name='addressPhone']").removeClass("error_border");
		return true;
	}
}

function setdefault(addressCode){
	var data=new Object();
	data.addressCode=addressCode;
	$.ajax({
			type:"POST",
			url:"setaddressDefault.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						 window.location.reload();
					}else if(!data.success){
					}
			}
		});
}

function deleteaddress(addressCode){
	if(confirm("确认本条地址删除？")){
	var data=new Object();
	data.addressCode=addressCode;
	$.ajax({
			type:"POST",
			url:"deleteAddress.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						 window.location.reload();
					}else if(!data.success){
					}
			}
		});
	}
}

function setaddress(addressCode){
	var data=new Object();
	data.addressCode=addressCode;
	$.ajax({
			type:"POST",
			url:"getAddress.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						$("input[name='addressCode']").val(data.dataObj.addressCode);
						$("select[name='provinceCode']").val(data.dataObj.provinceCode);
						selctpro();
						$("select[name='areaCode']").val(data.dataObj.areaCode);
						selectarea();
						$("select[name='cityCode']").val(data.dataObj.cityCode);
						$("input[name='addressPhone']").val(data.dataObj.addressPhone);
						$("input[name='addressMember']").val(data.dataObj.addressMember);
						$("textarea[name='addressDetail']").html(data.dataObj.addressDetail);
						$("input[name='addressZipcode']").val(data.dataObj.addressZipcode);
						if(data.dataObj.addressDefault=="1"){
							$("input[name='addressDefault']").attr("checked",true);
						}else{
						 $("input[name='addressDefault']").attr("checked",false);
						}
					}else if(!data.success){
					}
			}
		});
}

function setObj(){
	
    var provinceCode=$("select[name='provinceCode']").val();
	var areaCode= $("select[name='areaCode']").val();
	var cityCode= $("select[name='cityCode']").val();
	var provinceName=$("select[name='provinceCode']").find("option:selected").text();
	var areaName= $("select[name='areaCode']").find("option:selected").text();
	var cityName= $("select[name='cityCode']").find("option:selected").text();
	var addressZipcode= $("input[name='addressZipcode']").val();
	var addressMember= $("input[name='addressMember']").val();
	var addressPhone= $("input[name='addressPhone']").val();
	var addressDetail= $("textarea[name='addressDetail']").val();
	var addressDefault= $("input[name='addressDefault']").val();
	var data=new Object();
	data.provinceCode=provinceCode;
	data.areaCode=areaCode;
	data.cityCode=cityCode;
	data.addressZipcode=addressZipcode;
	data.addressMember=addressMember;
	data.addressPhone=addressPhone;
	data.addressDetail=addressDetail;
	data.provinceName=provinceName;
	data.areaName=areaName;
	data.cityName=cityName;
	data.addressDefault=addressDefault;
	return data;
}

function updateress(){
	var data=setObj();
	var addressCode=$("input[name='addressCode']").val();
	data.addressCode=addressCode;
	$.ajax({
			type:"POST",
			url:"updateAddress.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						 window.location.reload();
					}else if(!data.success){
					}
			}
		});
}

function addaddress(){
	var data=setObj();
	$.ajax({
			type:"POST",
			url:"saveAddress.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						  window.location.reload();
					}else if(!data.success){
					}
			} 
		});
}

var arealist=new Array();

function selctpro(){
	var provinceCode=$("select[name='provinceCode']").val();
	var data=new Object();
	data.provinceCode=provinceCode;
	$.ajax({
			type:"POST",
			url:"getarea.json",
			async:false,
			data:data,
			dataType:"json",
			contentType:"application/x-www-form-urlencoded",
			success : function(data, textStatus, jqXHR) {
					if(data.success){
						arealist=data.dataObj;
						var html="";
						$.each(data.dataObj,function(i,o){
  		 					html=html+"<option value='"+o.areaCode+"'>"+o.areaName+"</option>";
  						})
  						$("select[name='areaCode']").html(html);
  						selectarea();
					}else if(!data.success){
						 
					}
			} 
		});
}

function selectarea(){
	var areaCode=$("select[name='areaCode']").val();
	$.each(arealist,function(i,obj){
  		if(obj.areaCode==areaCode){
  			var html="";
  		 	$.each(obj.children,function(i,o){
  		 		html=html+"<option value='"+o.areaCode+"'>"+o.areaName+"</option>";
  		 	})
  		 	$("select[name='cityCode']").html(html)
  		}
   })
}
</script>

