/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.payment.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.exchange.bean.OcContract;
import com.yqbsoft.laser.html.facade.exchange.domian.OcContractDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.ContractRepository;
import com.yqbsoft.laser.html.facade.pay.domain.PaPaymentDomain;
import com.yqbsoft.laser.html.facade.pay.enums.PtradpdeEnum;
import com.yqbsoft.laser.html.facade.pte.bean.PtradeBean;
import com.yqbsoft.laser.html.facade.pte.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.html.facade.pte.repository.PtradeRepository;
import com.yqbsoft.laser.html.payment.controller.PaymentCon;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.spring.SupSpringApplicationContextUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/payment/cash"})
@Layout(frameName="application")
public class CashPaymentCon
extends SpringmvcController {
    @Autowired
    ContractRepository contractRepository;
    @Autowired
    PtradeRepository ptradeRepository;

    protected String getContext() {
        return null;
    }

    @RequestMapping(value={"getAmount"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean getCashAmount(HttpServletRequest request, String startDate, String endDate, ModelMap map) {
        SupQueryResult<OcContract> reslut = this.queryWaitCashSettlContract(request, startDate, endDate);
        BigDecimal payAmount = BigDecimal.ZERO;
        Integer sumNum = 0;
        if (reslut != null && ListUtil.isNotEmpty((Collection)reslut.getList())) {
            map.put((Object)"contractList", (Object)reslut.getList());
            map.put((Object)"orderSize", (Object)reslut.getList().size());
            for (OcContract contact : reslut.getList()) {
                if (contact.getCashAmount() != null) {
                    payAmount = payAmount.add(contact.getCashAmount());
                }
                sumNum = sumNum + contact.getGoodsNum().intValue();
            }
        }
        return new HtmlJsonReBean((Object)payAmount.setScale(2, 4));
    }

    @RequestMapping(value={"commit"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean commit(HttpServletRequest request, ModelMap map, @RequestBody PaPaymentDomain payment) {
        UserSession userSession = this.getUserSession(request);
        OcContractDomain contract = new OcContractDomain();
        contract.setAppmanageIcode(ServletMain.getAppName());
        contract.setTenantCode(userSession.getTenantCode());
        contract.setMemberCcode(userSession.getUserPcode());
        contract.setMemberCname(userSession.getUserRelname());
        contract.setMemberCode(userSession.getUserPcode());
        contract.setMemberName(userSession.getUserRelname());
        contract.setGoodsSupplierCode(userSession.getUserPcode());
        contract.setContractTypepro("0");
        contract.setGoodsSupplierName(userSession.getUserRelname());
        contract.setContractPmode("1");
        contract.setMemberBcode(userSession.getUserPcode());
        contract.setMemberBname(userSession.getUserRelname());
        contract.setGoodsNum(new BigDecimal(1));
        contract.setContractMoney(payment.getOrderAmount());
        contract.setFchannelCode("cash");
        contract.setFaccountName("\u73b0\u91d1\u652f\u4ed8");
        String contractBillcode = this.contractRepository.addContract(contract, null);
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean("CashPaymentCon.commit.bill", "\u8ba2\u5355\u751f\u6210\u5931\u8d25!");
        }
        PaymentCon pay = (PaymentCon)((Object)SupSpringApplicationContextUtil.getBean(PaymentCon.class));
        payment.setPtradpdeCode(PtradpdeEnum.PAYMENTLINE.getCode());
        payment.setPartnerCode(payment.getMerchantCode());
        String ptradeSeqno = pay.savePay(request, payment);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setFchannelMode("1");
        ptradeBean.setFchannelPmodeCode("WEB");
        ptradeBean.setPartnerCode(payment.getMerchantCode());
        ptradeBean.setTenantCode(userSession.getTenantCode());
        ArrayList<PtePtradeParticipantDomain> ptePtradeParticipants = new ArrayList<PtePtradeParticipantDomain>();
        PtePtradeParticipantDomain ptePtradeParticipant = new PtePtradeParticipantDomain();
        ptePtradeParticipant.setDicActorCode("BANK");
        ptePtradeParticipant.setFaccountName("\u73b0\u91d1\u652f\u4ed8");
        ptePtradeParticipant.setFchannelCode("cash");
        ptePtradeParticipant.setFchannelClassifyCode("cash");
        ptePtradeParticipant.setOrderAmount(payment.getOrderAmount());
        ptePtradeParticipants.add(ptePtradeParticipant);
        ptradeBean.setPartList(ptePtradeParticipants);
        this.ptradeRepository.commitParticipantByPtrade(ptradeBean);
        String result = this.ptradeRepository.checkPtradeSuccess(userSession.getTenantCode(), ptradeSeqno, "3,4,5");
        if (StringUtils.isNotBlank((String)result) && Boolean.valueOf(result).booleanValue()) {
            this.updateOcContract(contractBillcode, userSession.getTenantCode(), ptradeSeqno, payment.getOrderAmount());
            return new HtmlJsonReBean((Object)true);
        }
        return new HtmlJsonReBean("CashPaymentCon.commit.pay", "\u8ba2\u5355\u6536\u6b3e\u5931\u8d25!");
    }

    private void updateOcContract(String contractBillcode, String tenantCode, String ptradeSeqno, BigDecimal orderAmount) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContract contract = this.contractRepository.getContract(map);
        contract.setPtradeSeqno(ptradeSeqno);
        contract.setCashAmount(orderAmount);
        this.contractRepository.updateContract(contract);
        this.contractRepository.updateContractDataState(contract.getContractId(), Integer.valueOf(3), Integer.valueOf(0));
    }

    private SupQueryResult<OcContract> queryWaitCashSettlContract(HttpServletRequest request, String startDate, String endDate) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        UserSession user = this.getUserSession(request);
        queryMap.put("fchannelCode", "cash");
        queryMap.put("goodsSupplierCode", user.getUserPcode());
        queryMap.put("tenantCode", user.getTenantCode());
        queryMap.put("cashSettl", 0);
        queryMap.put("fuzzy", true);
        if (StringUtils.isNotBlank((String)startDate)) {
            queryMap.put("startDate", startDate);
        }
        if (StringUtils.isNotBlank((String)endDate)) {
            queryMap.put("endDate", endDate);
        }
        SupQueryResult reslut = this.contractRepository.queryContractPage(queryMap);
        return reslut;
    }
}

