/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.payment.controller;

import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.ar.repository.OsLoginRepository;
import com.yqbsoft.laser.html.facade.cm.domain.CmFchannelConfigReDomain;
import com.yqbsoft.laser.html.facade.cm.repository.CmChannelRepository;
import com.yqbsoft.laser.html.facade.cm.repository.FchannelRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MmMbuser;
import com.yqbsoft.laser.html.facade.mm.bean.MmMerberDomain;
import com.yqbsoft.laser.html.facade.mm.domain.MmChannelDomain;
import com.yqbsoft.laser.html.facade.mm.domain.MmMbuserReDomain;
import com.yqbsoft.laser.html.facade.mm.repository.MmChannelRepository;
import com.yqbsoft.laser.html.facade.mm.repository.MmMerberRepository;
import com.yqbsoft.laser.html.facade.mm.repository.MmUserRepository;
import com.yqbsoft.laser.html.facade.pay.domain.PaPaymentDomain;
import com.yqbsoft.laser.html.facade.pay.repository.PaPaymentRepositroy;
import com.yqbsoft.laser.html.facade.pte.bean.DicactorEnum;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtfchannelDomain;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtradeDomain;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtradeParticipant;
import com.yqbsoft.laser.html.facade.pte.bean.PtradeBean;
import com.yqbsoft.laser.html.facade.pte.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.html.facade.pte.repository.PtfchannelRepository;
import com.yqbsoft.laser.html.facade.pte.repository.PtradeParticipantRepository;
import com.yqbsoft.laser.html.facade.pte.repository.PtradeRepository;
import com.yqbsoft.laser.html.facade.vd.bean.VdFaccountInfo;
import com.yqbsoft.laser.html.facade.vd.repository.VdFaccountRepository;
import com.yqbsoft.laser.html.payment.bean.ChannelRestForm;
import com.yqbsoft.laser.html.payment.bean.CommitPayContext;
import com.yqbsoft.laser.html.payment.constans.FaccountTypeEnum;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/payment"})
public class DynamicPayController
extends SpringmvcController {
    @Autowired
    private MmMerberRepository memberRepository;
    @Autowired
    private PaPaymentRepositroy paymentRepositroy;
    @Autowired
    FchannelRepository fchannelRepository;
    @Autowired
    private MmChannelRepository mmChannelRepository;
    @Autowired
    private MmUserRepository mmUserRepository;
    @Autowired
    private OsLoginRepository osLoginRepository;
    @Autowired
    private VdFaccountRepository faccountRepository;
    @Autowired
    private PtradeParticipantRepository ptradeParticipantRepository;
    @Autowired
    PaPaymentRepositroy paPaymentRepositroy;
    @Autowired
    private CmChannelRepository channelRepository;
    private static final String ALIPAY_CODE = "alipayjs";
    private static final String WECHAT_CODE = "wechatjs";
    private static final String CTEST = "ctest";
    @Autowired
    PtradeRepository ptradeRepository;
    @Autowired
    PtfchannelRepository ptfchannelRepository;

    protected String getContext() {
        return "dynamic";
    }

    @RequestMapping(value={"/redirect/{tenantCode}/{merchantCode}"}, method={RequestMethod.GET})
    public String redirect(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="merchantCode") String merchantCode) {
        String userAgent = request.getHeader("User-Agent");
        map.put((Object)"userAgent", (Object)userAgent);
        String fchannelCode = this.transformFchannelCode(userAgent);
        String redirectURI = this.getRequestservice(request) + request.getContextPath() + "/web/payment/dynamic/" + fchannelCode + "/" + tenantCode + "-" + merchantCode;
        if (userAgent.contains("Alipay")) {
            redirectURI = this.encodeURI(redirectURI);
            CmFchannelConfigReDomain ccf = this.getFconfig(tenantCode, fchannelCode, "app_id");
            if (ccf != null) {
                String appid = ccf.getFchannelConfigValue();
                redirectURI = "https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=" + appid + "&scope=auth_base&redirect_uri=" + redirectURI;
            }
        } else if (userAgent.contains("MicroMessenger")) {
            redirectURI = this.encodeURI(redirectURI);
            CmFchannelConfigReDomain ccf = this.getFconfig(tenantCode, fchannelCode, "appid");
            if (ccf != null) {
                String appid = ccf.getFchannelConfigValue();
                redirectURI = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + appid + "&redirect_uri=" + redirectURI + "&response_type=code&scope=snsapi_base&state=123#wechat_redirect";
            }
        } else {
            fchannelCode = CTEST;
        }
        try {
            response.sendRedirect(redirectURI);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    @RequestMapping(value={"/dynamic/{fchannelCode}/{tenantCode}-{merchantCode}"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="merchantCode") String merchantCode, @PathVariable(value="fchannelCode") String fchannelCode) {
        PtePtfchannelDomain channel;
        String userAgent = request.getHeader("User-Agent");
        map.put((Object)"tenantCode", (Object)tenantCode);
        map.put((Object)"merchantCode", (Object)merchantCode);
        map.put((Object)"fchannelCode", (Object)fchannelCode);
        MmMerberDomain member = this.getMmMerber(merchantCode, tenantCode);
        if (member != null) {
            map.put((Object)"paymentMemo", (Object)member.getMerberCompname());
        }
        if ((channel = this.getPtfchannel(tenantCode, BrowTypeUtil.type.JSAPI.name(), fchannelCode)) != null) {
            map.put((Object)"channelName", (Object)channel.getFchannelName());
        }
        HashMap<String, String> extra = new HashMap<String, String>();
        String agentId = "";
        if (userAgent.contains("Alipay")) {
            agentId = this.getAlipayUserId(request, tenantCode, fchannelCode);
            extra.put("jsapi", "true");
        } else if (userAgent.contains("MicroMessenger")) {
            agentId = this.getOpenId(request, tenantCode, fchannelCode);
        }
        if (StringUtils.isBlank((String)agentId)) {
            UserSession userSession = this.getUserSession(request);
            this.logger.info("userSession\uff1a" + userSession);
            if (userSession != null) {
                agentId = userSession.getOpenId();
            }
        }
        this.logger.info("agentId\uff1a" + agentId);
        extra.put("openId", agentId);
        map.put((Object)"extra", (Object)this.transform(JsonUtil.buildNormalBinder().toJson(extra)));
        String merberCode = this.createMerber(agentId, tenantCode, fchannelCode);
        MmMbuser user = null;
        MmMerberDomain merber = null;
        if (StringUtils.isNotBlank((String)merberCode)) {
            this.logger.info("\u4f1a\u5458\u4ee3\u7801\uff1a" + merberCode);
            HashMap<String, String> merberMap = new HashMap<String, String>();
            merberMap.put("tenantCode", tenantCode);
            merberMap.put("merberCode", merberCode);
            merber = this.memberRepository.getMerberByCode(merberMap);
            map.put((Object)"merber", (Object)merber);
            user = this.getUser(agentId, tenantCode, merberCode);
            map.put((Object)"mbuser", (Object)user);
            map.put((Object)"accountBalance", (Object)BigDecimal.ZERO);
            VdFaccountInfo account = this.getFaccountOuterByCode(merberCode, tenantCode, FaccountTypeEnum.BASE_ACCOUNT.getCode());
            if (account != null) {
                BigDecimal accountBalance = account.getFaccountAmount();
                map.put((Object)"accountBalance", (Object)accountBalance);
                map.put((Object)"saleContext", (Object)("\u53ef\u62b5\u6263\u91d1\u989d" + accountBalance.setScale(2, 4) + "\u5143"));
            }
        }
        if (user != null) {
            this.writeToken(request, response, tenantCode, user.getMbuserName());
        }
        String saleActivity = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "epay-saleActivity"));
        map.put((Object)"saleActivity", (Object)saleActivity);
        map.put((Object)"agentId", (Object)agentId);
        map.put((Object)"merberCode", (Object)merberCode);
        return this.getFtlTempPath(request) + "index";
    }

    @RequestMapping(value={"/dynamic/result"}, method={RequestMethod.GET})
    public String payResult(HttpServletRequest request, ModelMap map, String ptradeSeqno, String tenantCode) {
        boolean hbflag;
        PtePtradeDomain ptePtradeDomain = this.getPaymentDomain(ptradeSeqno, tenantCode);
        map.put((Object)"accountBalance", (Object)BigDecimal.ZERO);
        map.put((Object)"transferAmount", (Object)BigDecimal.ZERO);
        map.put((Object)"saleAmount", (Object)BigDecimal.ZERO);
        if (ptePtradeDomain == null) {
            return this.getFtlTempPath(request) + "result";
        }
        MmMerberDomain member = this.getMmMerber(ptePtradeDomain.getMerchantCode(), tenantCode);
        if (member != null) {
            map.put((Object)"merberCompname", (Object)member.getMerberCompname());
        }
        map.put((Object)"orderAmount", (Object)ptePtradeDomain.getOrderAmount());
        UserSession userSession = this.getUserSession(request);
        if (userSession != null && StringUtils.isNotBlank((String)userSession.getUserPhone())) {
            Map extMap;
            VdFaccountInfo vdFaccountInfo = this.getFaccountOuterByCode(userSession.getUserPcode(), userSession.getTenantCode(), FaccountTypeEnum.BASE_ACCOUNT.getCode());
            BigDecimal accountBalance = vdFaccountInfo.getFaccountAmount();
            map.put((Object)"accountBalance", (Object)accountBalance);
            if (StringUtils.isNotBlank((String)ptePtradeDomain.getExtension()) && MapUtil.isNotEmpty((Map)(extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptePtradeDomain.getExtension(), String.class, String.class))) && StringUtils.isNotBlank((String)((String)extMap.get("transferAmount")))) {
                map.put((Object)"transferAmount", (Object)new BigDecimal((String)extMap.get("transferAmount")));
            }
            HashMap<String, String> partMap = new HashMap<String, String>();
            partMap.put("tenantCode", tenantCode);
            partMap.put("ptradeSeqno", ptradeSeqno);
            SupQueryResult result = this.ptradeParticipantRepository.list(partMap);
            if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                for (PtePtradeParticipant part : result.getList()) {
                    if (!DicactorEnum.BUY_B.getCode().equals(part.getDicActorCode())) continue;
                    map.put((Object)"saleAmount", (Object)part.getOrderAmount());
                }
            }
        }
        MmMbuser mbuser = this.getUser(userSession.getOpenId(), tenantCode, userSession.getUserPcode());
        map.put((Object)"mbuser", (Object)mbuser);
        String receiveHB = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "epay-receiveHB"));
        boolean bl = hbflag = StringUtils.isBlank((String)receiveHB) ? false : Boolean.valueOf(receiveHB);
        if (!hbflag || StringUtils.isNotBlank((String)mbuser.getMbuserPhone())) {
            map.put((Object)"receiveHB", (Object)false);
        } else {
            map.put((Object)"receiveHB", (Object)true);
        }
        return this.getFtlTempPath(request) + "result";
    }

    @RequestMapping(value={"/dynamic/getVerCode"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean getVerCode(HttpServletRequest request, String userPhone) {
        if (this.getUserSession(request) == null) {
            return new HtmlJsonReBean("error", "\u6ca1\u6709\u6388\u6743\u767b\u5f55\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        PostParamMap pmap = new PostParamMap("rd.random.createRandom");
        if (StringUtils.isBlank((String)userPhone)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        pmap.putParam("businessType", (Object)"0");
        pmap.putParam("host", (Object)userPhone);
        pmap.putParam("app_id", (Object)ServletMain.getAppName());
        pmap.putParam("tenantCode", (Object)userSession.getTenantCode());
        Map result = (Map)this.htmlIBaseService.sendMes(pmap, Map.class);
        if (((Boolean)result.get("flag")).booleanValue()) {
            return new HtmlJsonReBean((Object)result);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, result.get("message").toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequestMapping(value={"/dynamic/budingPhone"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean budingPhone(HttpServletRequest request, ModelMap mmap, String userPhone, String verCode, String fchannelCode) {
        UserSession user = this.getUserSession(request);
        if (user == null) {
            return new HtmlJsonReBean("error", "\u6ca1\u6709\u6388\u6743\u767b\u5f55\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        boolean checkFlag = this.checkValidateCode("0", userPhone, verCode, user.getTenantCode());
        if (!checkFlag) {
            HtmlJsonReBean result = new HtmlJsonReBean("error", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            result.setDataObj((Object)false);
            return result;
        }
        HtmlJsonReBean result = null;
        MmMbuser phoneUser = this.mmUserRepository.getMbuserByPhone(userPhone, user.getTenantCode());
        if (phoneUser == null) {
            result = this.mmUserRepository.updateMmuserPhone(user.getUserId(), userPhone);
            if (!result.isSuccess()) return result;
            result.setDataObj((Object)true);
            user.setUserPhone(userPhone);
            this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userPhone", userPhone);
            return result;
        }
        if (StringUtils.isBlank((String)phoneUser.getMbuserOpenid())) {
            if (StringUtils.isBlank((String)user.getOpenId())) {
                result = new HtmlJsonReBean("error", "\u8d26\u6237\u5f02\u5e38");
                result.setDataObj((Object)false);
                return result;
            }
            phoneUser.setMbuserOpenid(user.getOpenId());
            if (StringUtils.isBlank((String)phoneUser.getMbuserExcode())) {
                phoneUser.setMbuserExcode(phoneUser.getMbuserCode());
            }
            if (!(result = this.mmUserRepository.updateMbuser(phoneUser)).isSuccess()) {
                this.logger.error("AccountIndexCon.store_binding_phone.updateMbuser", (Object)("userPhone=" + userPhone));
                result.setDataObj((Object)false);
                result.setMsg("\u51fa\u9519\u4e86\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return result;
            }
            result = this.mmUserRepository.delMmuser(user.getUserId());
            if (!result.isSuccess()) {
                this.logger.error("AccountIndexCon.store_binding_phone.delMmuser", (Object)("userPhone=" + userPhone));
                result.setDataObj((Object)false);
                result.setMsg("\u51fa\u9519\u4e86\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return result;
            }
            MmChannelDomain loginChannel = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", user.getTenantCode());
            map.put("channelType", fchannelCode);
            map.put("channelFcode", user.getOpenId());
            SupQueryResult loginChannelResult = this.mmChannelRepository.queryChannelPage(map);
            if (loginChannelResult != null && ListUtil.isNotEmpty((Collection)loginChannelResult.getList())) {
                loginChannel = (MmChannelDomain)loginChannelResult.getList().get(0);
            }
            loginChannel.setMerberCode(phoneUser.getMerberCode());
            result = this.mmChannelRepository.updateChannel(loginChannel);
            if (result.isSuccess()) {
                result.setDataObj((Object)true);
                user.setUserPhone(userPhone);
                this.mergeUserReloadSession(user, phoneUser);
            }
            result.setDataObj((Object)true);
            return result;
        }
        if (StringUtils.isNotBlank((String)phoneUser.getMbuserOpenid()) && !phoneUser.getMbuserOpenid().equals(user.getOpenId())) {
            HashMap<String, String> map = new HashMap<String, String>();
            MmChannelDomain phoneChannel = null;
            map.put("tenantCode", user.getTenantCode());
            map.put("channelType", fchannelCode);
            map.put("merberCode", phoneUser.getMerberCode());
            SupQueryResult channelResult = this.mmChannelRepository.queryChannelPage(map);
            if (channelResult != null && ListUtil.isNotEmpty((Collection)channelResult.getList())) {
                phoneChannel = (MmChannelDomain)channelResult.getList().get(0);
            }
            if (phoneChannel != null) {
                return new HtmlJsonReBean("error", "\u51fa\u9519\u4e86\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            MmChannelDomain loginChannel = null;
            map = new HashMap();
            map.put("tenantCode", user.getTenantCode());
            map.put("channelType", fchannelCode);
            map.put("channelFcode", user.getOpenId());
            SupQueryResult loginChannelResult = this.mmChannelRepository.queryChannelPage(map);
            if (loginChannelResult != null && ListUtil.isNotEmpty((Collection)loginChannelResult.getList())) {
                loginChannel = (MmChannelDomain)loginChannelResult.getList().get(0);
            }
            if (loginChannel == null) {
                return new HtmlJsonReBean("error", "\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c\uff0c\u8bf7\u66f4\u6362\u624b\u673a\u53f7");
            }
            loginChannel.setMerberCode(phoneUser.getMerberCode());
            result = this.mmChannelRepository.updateChannel(loginChannel);
            if (!result.isSuccess()) return result;
            result.setDataObj((Object)true);
            user.setUserPhone(userPhone);
            this.mergeUserReloadSession(user, phoneUser);
            return result;
        }
        result = new HtmlJsonReBean();
        result.setDataObj((Object)false);
        result.setMsg("\u5df2\u7ed1\u5b9a\u624b\u673a\u53f7");
        return result;
    }

    @RequestMapping(value={"/dynamic/{tenantCode}-{merchantCode}"}, method={RequestMethod.GET})
    public String activeindex(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="merchantCode") String merchantCode) {
        map.put((Object)"tenantCode", (Object)tenantCode);
        map.put((Object)"merchantCode", (Object)merchantCode);
        MmMerberDomain member = this.getMmMerber(merchantCode, tenantCode);
        if (member != null) {
            map.put((Object)"paymentMemo", (Object)member.getMerberCompname());
        }
        return this.getFtlTempPath(request) + "activeindex";
    }

    @RequestMapping(value={"order/redirect/{tenantCode}/{pteSeqno}-{merberCode}"}, method={RequestMethod.GET})
    public String orderRedirectPay(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="pteSeqno") String pteSeqno, @PathVariable(value="merberCode") String merberCode) {
        PtePtradeDomain ptePtradeDomain = this.getPaymentDomain(pteSeqno, tenantCode);
        if (ptePtradeDomain == null) {
            return "";
        }
        String userAgent = request.getHeader("User-Agent");
        map.put((Object)"userAgent", (Object)userAgent);
        String fchannelCode = this.transformFchannelCode(userAgent);
        String redirectURI = this.getRequestservice(request) + request.getContextPath() + "/web/payment/caller/app/" + fchannelCode + "/" + tenantCode + "-" + pteSeqno + "-" + merberCode;
        if (userAgent.contains("Alipay")) {
            redirectURI = this.encodeURI(redirectURI);
            CmFchannelConfigReDomain ccf = this.getFconfig(tenantCode, fchannelCode, "app_id");
            if (ccf != null) {
                String appid = ccf.getFchannelConfigValue();
                redirectURI = "https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=" + appid + "&scope=auth_base&redirect_uri=" + redirectURI;
            }
        } else if (userAgent.contains("MicroMessenger")) {
            redirectURI = this.encodeURI(redirectURI);
            CmFchannelConfigReDomain ccf = this.getFconfig(tenantCode, fchannelCode, "appid");
            if (ccf != null) {
                String appid = ccf.getFchannelConfigValue();
                redirectURI = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + appid + "&redirect_uri=" + redirectURI + "&response_type=code&scope=snsapi_base&state=123#wechat_redirect";
            }
        } else {
            fchannelCode = CTEST;
        }
        try {
            response.sendRedirect(redirectURI);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    @RequestMapping(value={"/caller/app/{fchannelCode}/{tenantCode}-{pteSeqno}-{merberCode}"}, method={RequestMethod.GET})
    public String callerAppPay(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="pteSeqno") String pteSeqno, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="merberCode") String merberCode) {
        PtePtradeDomain ptePtradeDomain;
        String userAgent = request.getHeader("User-Agent");
        map.put((Object)"tenantCode", (Object)tenantCode);
        map.put((Object)"pteSeqno", (Object)pteSeqno);
        map.put((Object)"fchannelCode", (Object)fchannelCode);
        PtePtfchannelDomain channel = this.getPtfchannel(tenantCode, BrowTypeUtil.type.JSAPI.name(), fchannelCode);
        if (channel != null) {
            map.put((Object)"channelName", (Object)channel.getFchannelName());
        }
        if ((ptePtradeDomain = this.getPaymentDomain(pteSeqno, tenantCode)) == null) {
            return "";
        }
        MmMerberDomain member = this.getMmMerber(ptePtradeDomain.getMerchantCode(), tenantCode);
        HashMap<String, String> extra = new HashMap<String, String>();
        if (member == null) {
            // empty if block
        }
        if (userAgent.contains("Alipay")) {
            String agentId = this.getAlipayUserId(request, tenantCode, fchannelCode);
            extra.put("jsapi", "true");
            extra.put("openId", agentId);
            map.put((Object)"extra", (Object)JsonUtil.buildNormalBinder().toJson(extra));
        } else if (userAgent.contains("MicroMessenger")) {
            String openId = this.getOpenId(request, tenantCode, fchannelCode);
            extra.put("openId", openId);
            map.put((Object)"extra", (Object)JsonUtil.buildNormalBinder().toJson(extra));
        }
        PaPaymentDomain payment = new PaPaymentDomain();
        payment.setTenantCode(tenantCode);
        payment.setExtra((String)map.get((Object)"extra"));
        payment.setFchannelCode(fchannelCode);
        payment.setOrderAmount(ptePtradeDomain.getOrderAmount());
        payment.setMerchantCode(ptePtradeDomain.getMerchantCode());
        CommitPayContext cpc = this.commitPay(request, payment, member, pteSeqno, null, true, merberCode);
        if (cpc != null && StringUtils.isNotBlank((String)cpc.getErrorMsg())) {
            System.out.println("errorMsg = " + cpc.getErrorMsg());
        }
        return this.getFtlTempPath(request) + "callerAppPay";
    }

    @RequestMapping(value={"/dynamic/pay"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean pay(HttpServletRequest request, HttpServletResponse response, ModelMap map, @RequestBody PaPaymentDomain payment) {
        MmMerberDomain member = this.getMmMerber(payment.getMerchantCode(), payment.getTenantCode());
        if (member == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u6237\u4e0d\u5b58\u5728");
        }
        String pteSeqno = this.savePay(payment, request, request.getContextPath() + "/web/payment/redirect/" + payment.getTenantCode() + "/" + payment.getMerchantCode());
        if (StringUtils.isBlank((String)pteSeqno)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u51fa\u9519\u5566\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\uff01");
        }
        CommitPayContext cpc = this.commitPay(request, payment, member, pteSeqno, null, true, null);
        if (cpc != null && StringUtils.isNotBlank((String)cpc.getErrorMsg())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, cpc.getErrorMsg());
        }
        cpc.setPtradeSeqno(pteSeqno);
        return new HtmlJsonReBean((Object)cpc);
    }

    @RequestMapping(value={"/dynamic/activepay"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean activepay(HttpServletRequest request, HttpServletResponse response, ModelMap map, @RequestBody PaPaymentDomain payment) {
        MmMerberDomain member = this.getMmMerber(payment.getMerchantCode(), payment.getTenantCode());
        if (member == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((String)payment.getPaymentMemo())) {
            payment.setPaymentMemo(member.getMerberCompname());
        }
        String pteSeqno = this.savePay(payment, request, request.getContextPath() + "/web/payment/dynamic/" + payment.getTenantCode() + "-" + payment.getMerchantCode());
        return new HtmlJsonReBean((Object)pteSeqno);
    }

    @RequestMapping(value={"/dynamic/commitpay"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean commitpay(HttpServletRequest request, HttpServletResponse response, ModelMap map, @RequestBody PaPaymentDomain payment) {
        HashMap<String, String> querymap = new HashMap<String, String>();
        querymap.put("tenantCode", payment.getTenantCode());
        querymap.put("ptradeSeqno", payment.getPtradeSeqno());
        PtePtradeDomain ptePtradeDomain = this.ptradeRepository.getDomainByUK(querymap);
        String pteSeqno = payment.getPtradeSeqno();
        if (ptePtradeDomain == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u51fa\u9519\u5566\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\uff01");
        }
        if (ptePtradeDomain.getDataState().equals(2)) {
            // empty if block
        }
        if (StringUtils.isBlank((String)payment.getVerCode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u51fa\u9519\u5566\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\uff01");
        }
        payment.setMerchantCode(ptePtradeDomain.getMerchantCode());
        payment.setOrderAmount(ptePtradeDomain.getOrderAmount());
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("verCode", payment.getVerCode());
        payment.setExtra(JsonUtil.buildNormalBinder().toJson(extra));
        MmMerberDomain member = this.getMmMerber(ptePtradeDomain.getMerchantCode(), payment.getTenantCode());
        if (member == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u6237\u4e0d\u5b58\u5728");
        }
        String fchannelMode = StringUtils.isBlank((String)payment.getFchannelMode()) ? "0" : payment.getFchannelMode();
        CommitPayContext cpc = this.commitPay(request, payment, member, pteSeqno, fchannelMode, true, payment.getOpuserCode());
        if (cpc != null && StringUtils.isNotBlank((String)cpc.getErrorMsg())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, cpc.getErrorMsg());
        }
        ChannelRestForm rest = this.getFormCachStr(payment.getPtradeSeqno(), payment.getTenantCode());
        return new HtmlJsonReBean((Object)rest);
    }

    @RequestMapping(value={"/dynamic/getAccountBalance"})
    @ResponseBody
    public HtmlJsonReBean getAccountBalance(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> account = new HashMap<String, Object>();
        if (userSession == null) {
            return new HtmlJsonReBean(account);
        }
        VdFaccountInfo vdFaccountInfo = this.getFaccountOuterByCode(userSession.getUserPcode(), userSession.getTenantCode(), FaccountTypeEnum.BASE_ACCOUNT.getCode());
        if (account != null) {
            BigDecimal accountBalance = vdFaccountInfo.getFaccountAmount();
            account.put("accountBalance", accountBalance.setScale(2, 4));
            account.put("saleContext", "\u53ef\u62b5\u6263\u91d1\u989d" + accountBalance.setScale(2, 4) + "\u5143");
        }
        return new HtmlJsonReBean(account);
    }

    @RequestMapping(value={"/dynamic/paymentFormSubmit"})
    @ResponseBody
    public HtmlJsonReBean paymentFormSubmit(HttpServletRequest request, ModelMap map, String ptradeSeqno, String tenantCode) {
        return new HtmlJsonReBean((Object)this.getFormCachStr(ptradeSeqno, tenantCode));
    }

    private ChannelRestForm getFormCachStr(String ptradeSeqno, String tenantCode) {
        String restJson = this.ptradeRepository.getFormCachStr(tenantCode, ptradeSeqno);
        if (StringUtils.isBlank((String)restJson)) {
            return null;
        }
        ChannelRestForm channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(restJson, ChannelRestForm.class);
        return channelRestForm;
    }

    private void writeToken(HttpServletRequest request, HttpServletResponse response, String tenantCode, String agentId) {
        String rs = this.login(agentId, tenantCode = StringUtils.isBlank((String)tenantCode) ? ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode") : ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode") + "," + tenantCode);
        if (StringUtils.isBlank((String)rs)) {
            return;
        }
        Map userSessionMap = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(rs, String.class, String.class);
        String token = (String)userSessionMap.get("tokenkey");
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        if (StringUtils.isNotBlank((String)token)) {
            Cookie[] cookies = request.getCookies();
            String key = "tokenkey-" + group;
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(key)) continue;
                cookie.setValue("");
            }
            Cookie _cookie = new Cookie(key, token);
            _cookie.setPath("/");
            _cookie.setDomain(request.getServerName());
            response.addCookie(_cookie);
        }
    }

    private String createMerber(String agentId, String tenantCode, String fchannelCode) {
        if (StringUtils.isBlank((String)agentId) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String merberCode = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map = new HashMap();
            map.put("tenantCode", tenantCode);
            map.put("channelType", fchannelCode);
            map.put("channelFcode", agentId);
            SupQueryResult result = this.mmChannelRepository.queryChannelPage(map);
            if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                return ((MmChannelDomain)result.getList().get(0)).getMerberCode();
            }
            map.put("mbuserOpenid", agentId);
            map.put("tenantCode", tenantCode);
            SupQueryResult rs = this.memberRepository.queryMbuserPage(map);
            this.logger.info("\u67e5\u8be2\u7528\u6237", (Object)(agentId + "---" + rs.getList().size()));
            if (rs != null && rs.getList() != null && rs.getList().size() > 0) {
                this.saveChannel(agentId, tenantCode, fchannelCode, ((MmMbuserReDomain)rs.getList().get(0)).getMerberCode());
                return ((MmMbuserReDomain)rs.getList().get(0)).getMerberCode();
            }
            MmMerberDomain mUser = new MmMerberDomain();
            mUser.setUserName(agentId);
            mUser.setMbuserOpenid(agentId);
            mUser.setTenantCode(tenantCode);
            mUser.setMerberType(Integer.valueOf(1));
            mUser.setMerberExcode(agentId);
            mUser.setMerberOrg("epay");
            PostParamMap pmap = new PostParamMap("mm.merber.sendOpenMerber");
            pmap.putParamToJson("mmMerberDomain", (Object)mUser);
            merberCode = this.htmlIBaseService.sendMesReJson(pmap);
            this.saveChannel(agentId, tenantCode, fchannelCode, merberCode);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return merberCode;
    }

    private void saveChannel(String agentId, String tenantCode, String fchannelCode, String merberCode) {
        if (StringUtils.isBlank((String)merberCode)) {
            return;
        }
        try {
            MmChannelDomain mmChannelDomain = new MmChannelDomain();
            mmChannelDomain.setTenantCode(tenantCode);
            mmChannelDomain.setChannelType(fchannelCode);
            mmChannelDomain.setChannelFcode(agentId);
            mmChannelDomain.setMerberCode(merberCode);
            this.mmChannelRepository.saveChannel(mmChannelDomain);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u6e20\u9053\u5931\u8d25", (Throwable)e);
        }
    }

    public String savePay(PaPaymentDomain payment, HttpServletRequest request, String returnurl) {
        payment.setPartnerCode(payment.getMerchantCode());
        payment.setPaymentReturnurl(returnurl);
        UserSession userSession = this.getUserSession(request);
        if (userSession != null && StringUtils.isNotBlank((String)userSession.getUserPhone()) && !userSession.getUserPcode().equals(payment.getMerchantCode())) {
            payment.setOpuserCode(userSession.getUserPcode());
            VdFaccountInfo account = this.getFaccountOuterByCode(userSession.getUserPcode(), userSession.getTenantCode(), FaccountTypeEnum.BASE_ACCOUNT.getCode());
            if (account.getFaccountAmount().compareTo(BigDecimal.ZERO) > 0 && payment.getOrderAmount().compareTo(account.getFaccountAmount()) > -1) {
                payment.setPaymentMemo(payment.getPaymentMemo() + "\u3010\u8d26\u6237\u62b5\u6263" + account.getFaccountAmount().setScale(2) + "\u5143\u3011");
            }
        } else {
            payment.setOpuserCode("anonymous");
        }
        payment.setOpuserName("anonymous");
        payment.setPtradeType("03");
        payment.setRouterDir("0");
        payment.setAppId(ServletMain.getAppName());
        return this.paymentRepositroy.savePyamentToPte(payment);
    }

    private PtePtradeDomain getPaymentDomain(String ptradeSeqno, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ptradeSeqno", ptradeSeqno);
        map.put("tenantCode", tenantCode);
        return this.ptradeRepository.getDomainByUK(map);
    }

    public String savePayment(PaPaymentDomain payment, HttpServletRequest request) {
        payment.setPartnerCode(payment.getMerchantCode());
        payment.setPaymentReturnurl(request.getContextPath() + "/web/payment/redirect/" + payment.getTenantCode() + "/" + payment.getMerchantCode());
        payment.setOpuserCode("anonymous");
        payment.setOpuserName("anonymous");
        payment.setPtradeType("03");
        payment.setRouterDir("0");
        payment.setAppId(ServletMain.getAppName());
        PostParamMap paramMap = new PostParamMap("pa.payment.savePyamentToPte");
        paramMap.putParamToJson("paPaymentDomain", (Object)payment);
        return this.htmlIBaseService.sendMesReJson(paramMap);
    }

    private MmMerberDomain getMmMerber(String merchantCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("merberCode", merchantCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.memberRepository.queryMerberPage(map);
        if (supQueryResult != null && supQueryResult.getList() != null && !supQueryResult.getList().isEmpty()) {
            MmMerberDomain mmMerber = (MmMerberDomain)supQueryResult.getList().get(0);
            return mmMerber;
        }
        return null;
    }

    private CommitPayContext commitPay(HttpServletRequest request, PaPaymentDomain payment, MmMerberDomain member, String ptradeSeqno, String mode, boolean accountPay, String merberCode) {
        PtradeBean ptradeBean = new PtradeBean();
        if (StringUtils.isBlank((String)mode)) {
            ptradeBean.setFchannelMode("1");
        } else {
            ptradeBean.setFchannelMode(mode);
        }
        ptradeBean.setFchannelPmodeCode(BrowTypeUtil.type.JSAPI.name());
        ptradeBean.setTenantCode(payment.getTenantCode());
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartnerCode(member.getMerberCode());
        ptradeBean.setExtension(payment.getExtra());
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        PtePtradeParticipantDomain ptePtradeParticipant = new PtePtradeParticipantDomain();
        PtePtfchannelDomain ptfchannel = this.getPtfchannel(payment.getTenantCode(), ptradeBean.getFchannelPmodeCode(), payment.getFchannelCode());
        if (ptfchannel == null) {
            return new CommitPayContext("\u4e0d\u652f\u6301\u8be5\u652f\u4ed8\u65b9\u5f0f", false);
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null && StringUtils.isNotBlank((String)merberCode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("merberCode", merberCode);
            map.put("tenantCode", payment.getTenantCode());
            SupQueryResult rs = this.mmUserRepository.queryMbuserPage(map);
            if (rs != null && rs.getList() != null && rs.getList().size() == 1) {
                userSession = new UserSession();
                userSession.setUserPcode(merberCode);
                userSession.setTenantCode(payment.getTenantCode());
                userSession.setUserPhone(((MmMbuser)rs.getList().get(0)).getMbuserPhone());
            }
        }
        boolean isBankPay = true;
        BigDecimal bankAmount = payment.getOrderAmount();
        BigDecimal accountAmount = BigDecimal.ZERO;
        if (accountPay && userSession != null && StringUtils.isNotBlank((String)userSession.getUserPhone()) && !userSession.getUserPcode().equals(payment.getMerchantCode())) {
            VdFaccountInfo account = this.getFaccountOuterByCode(userSession.getUserPcode(), userSession.getTenantCode(), userSession.getUserPcode().substring(0, 1) + "01");
            if (account.getFaccountAmount().compareTo(BigDecimal.ZERO) > 0) {
                List<PtePtfchannelDomain> ptfchannelList = this.queryPtfchannelDomain(userSession, ptradeBean.getFchannelPmodeCode());
                PtePtfchannelDomain accountChannel = null;
                for (PtePtfchannelDomain ptePtfchannelDomain : ptfchannelList) {
                    if (!ptePtfchannelDomain.getFchannelType().equals(account.getFaccountType())) continue;
                    accountChannel = ptePtfchannelDomain;
                }
                if (accountChannel != null) {
                    PtePtradeParticipantDomain accountPart = new PtePtradeParticipantDomain();
                    accountPart.setDicActorCode(accountChannel.getDicActorCode());
                    accountPart.setFaccountName(accountChannel.getFchannelName());
                    accountPart.setFchannelCode(accountChannel.getFchannelCode());
                    accountPart.setFaccountId(account.getFaccountOuterNo());
                    accountPart.setFchannelClassifyCode(accountChannel.getFchannelType());
                    if (account.getFaccountAmount().compareTo(payment.getOrderAmount()) > -1) {
                        isBankPay = false;
                        accountPart.setOrderAmount(payment.getOrderAmount());
                        bankAmount = BigDecimal.ZERO;
                    } else {
                        accountPart.setOrderAmount(account.getFaccountAmount());
                        bankAmount = payment.getOrderAmount().subtract(account.getFaccountAmount());
                    }
                    accountAmount = payment.getOrderAmount().subtract(bankAmount);
                    partList.add(accountPart);
                }
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("accountAmount", accountAmount);
            paramMap.put("bankAmount", bankAmount);
            paramMap.put("orderAmount", payment.getOrderAmount());
            BigDecimal transferAmount = this.calBackAmount(paramMap, payment.getTenantCode());
            if (transferAmount != null) {
                Map<String, String> extMap = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)ptradeBean.getExtension())) {
                    extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptradeBean.getExtension(), String.class, String.class);
                }
                extMap.put("transferAmount", transferAmount.toString());
                ptradeBean.setExtension(JsonUtil.buildNormalBinder().toJson(extMap));
            }
        }
        if (isBankPay) {
            ptePtradeParticipant.setDicActorCode(ptfchannel.getDicActorCode());
            ptePtradeParticipant.setFaccountName(ptfchannel.getFchannelName());
            ptePtradeParticipant.setFchannelCode(payment.getFchannelCode());
            ptePtradeParticipant.setFchannelClassifyCode(ptfchannel.getFchannelType());
            ptePtradeParticipant.setOrderAmount(bankAmount);
            partList.add(ptePtradeParticipant);
        }
        ptradeBean.setPartList(partList);
        this.ptradeRepository.commitParticipantByPtrade(ptradeBean);
        CommitPayContext cpc = new CommitPayContext(null, !isBankPay);
        cpc.setAccountAmount(accountAmount.setScale(2).toString());
        return cpc;
    }

    private PtePtfchannelDomain getPtfchannel(String tenantCode, String fchannelPmodeCode, String fchannelCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("fchannelDr", "PAY");
        map.put("fchannelCode", fchannelCode);
        map.put("dataState", 1);
        map.put("fuzzy", true);
        SupQueryResult supQueryResult = this.ptfchannelRepository.queryPtfchannelPage(map);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            return (PtePtfchannelDomain)supQueryResult.getList().get(0);
        }
        return null;
    }

    private List<PtePtfchannelDomain> queryPtfchannelDomain(UserSession userSession, String fchannelPmodeCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", userSession.getTenantCode());
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("fchannelDr", "PAY");
        map.put("dataState", 1);
        map.put("fuzzy", true);
        SupQueryResult supQueryResult = this.ptfchannelRepository.queryPtfchannelPage(map);
        if (supQueryResult != null) {
            return supQueryResult.getList();
        }
        return null;
    }

    private String encodeURI(String redirectURI) {
        try {
            redirectURI = URLEncoder.encode(redirectURI, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("redirect", (Throwable)e);
        }
        return redirectURI;
    }

    private String getOpenId(HttpServletRequest request, String tenantCode, String fchannelCode) {
        CmFchannelConfigReDomain ccfappid = this.getFconfig(tenantCode, fchannelCode, "appid");
        CmFchannelConfigReDomain ccfsecret = this.getFconfig(tenantCode, fchannelCode, "appid_secret");
        if (ccfappid == null || ccfsecret == null) {
            this.logger.error("ccfappid or ccfsecret is null");
            return null;
        }
        String appid = ccfappid.getFchannelConfigValue();
        String secret = ccfsecret.getFchannelConfigValue();
        String code = request.getParameter("code");
        String accessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
        String openId = "";
        try {
            String resJson = WebUtils.doGet((String)accessTokenUrl, null);
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resJson, String.class, String.class);
            if (resMap.containsKey("openid")) {
                openId = (String)resMap.get("openid");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return openId;
    }

    private String getAlipayUserId(HttpServletRequest request, String tenantCode, String fchannelCode) {
        CmFchannelConfigReDomain ccfappid = this.getFconfig(tenantCode, fchannelCode, "app_id");
        CmFchannelConfigReDomain rsa_private_key = this.getFconfig(tenantCode, fchannelCode, "rsa_private_key");
        CmFchannelConfigReDomain rsa_public_key_open = this.getFconfig(tenantCode, fchannelCode, "rsa_public_key_open");
        if (ccfappid == null || rsa_private_key == null || rsa_public_key_open == null) {
            this.logger.error("ccfappid or ccfsecret is null");
            return null;
        }
        String appid = ccfappid.getFchannelConfigValue();
        String secret = rsa_private_key.getFchannelConfigValue();
        String pubsecret = rsa_public_key_open.getFchannelConfigValue();
        String code = request.getParameter("auth_code");
        String userId = "";
        try {
            AlipaySystemOauthTokenRequest request2 = new AlipaySystemOauthTokenRequest();
            request2.setGrantType("authorization_code");
            request2.setCode(code);
            DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appid, secret, "json", "utf-8", pubsecret);
            AlipaySystemOauthTokenResponse response2 = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request2);
            if (response2.isSuccess()) {
                userId = response2.getUserId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userId;
    }

    public static void main(String[] args) throws IOException {
    }

    private CmFchannelConfigReDomain getFconfig(String tenantCode, String fchannelCode, String fchannelConfigKey) {
        String secret;
        if ("appid".equals(fchannelConfigKey) && fchannelCode.indexOf("wechat") > -1) {
            String appid = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", tenantCode + "-appid-weChartappid");
            if (StringUtils.isNotBlank((String)appid)) {
                CmFchannelConfigReDomain config = new CmFchannelConfigReDomain();
                config.setFchannelConfigValue(appid);
                return config;
            }
        } else if ("appid_secret".equals(fchannelConfigKey) && fchannelCode.indexOf("wechat") > -1 && StringUtils.isNotBlank((String)(secret = SupDisUtil.getDisCache().getMap("DdFalgSetting-key", tenantCode + "-secret-weChartsecret")))) {
            CmFchannelConfigReDomain config = new CmFchannelConfigReDomain();
            config.setFchannelConfigValue(secret);
            return config;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("fchannelCode", fchannelCode);
        map.put("fchannelConfigKey", fchannelConfigKey);
        SupQueryResult cmc = this.fchannelRepository.queryFchannelConfigPage(map);
        if (cmc != null && ListUtil.isNotEmpty((Collection)cmc.getList())) {
            return (CmFchannelConfigReDomain)cmc.getList().get(0);
        }
        return null;
    }

    private String transformFchannelCode(String userAgent) {
        if (userAgent.contains("Alipay")) {
            return ALIPAY_CODE;
        }
        if (userAgent.contains("MicroMessenger")) {
            return WECHAT_CODE;
        }
        return CTEST;
    }

    private String transform(String orgJson) {
        return orgJson.replaceAll("\"", "&quot;");
    }

    private String login(String userName, String tenantCode) {
        PostParamMap pmap = new PostParamMap("os.oauthserver.LoginWithName");
        pmap.putParam("app_id", (Object)ServletMain.getAppName());
        pmap.putParam("browType", (Object)"1");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("userName", (Object)userName);
        return this.htmlIBaseService.sendMesReJson(pmap);
    }

    private void mergeUserReloadSession(UserSession user, MmMbuser phoneUser) {
        this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userPhone", phoneUser.getMbuserPhone());
        this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userPcode", phoneUser.getMerberCode());
        this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userId", phoneUser.getMbuserId().toString());
        this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userCode", phoneUser.getMbuserCode());
        this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userName", phoneUser.getMbuserName());
        if (StringUtils.isNotBlank((String)phoneUser.getMbuserRelname())) {
            this.osLoginRepository.updateLoginUserSession(user.getTicketTokenid(), "userRelname", phoneUser.getMbuserRelname());
        }
    }

    private MmMbuser getUser(String userName, String tenantCode, String merberCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mbuserOpenid", userName);
        map.put("tenantCode", tenantCode);
        SupQueryResult result = this.mmUserRepository.queryMbuserPage(map);
        MmMbuser user = null;
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
            user = (MmMbuser)result.getList().get(0);
        }
        if (user != null && StringUtils.isNotBlank((String)merberCode) && !user.getMerberCode().equals(merberCode)) {
            map = new HashMap();
            map.put("merberCode", merberCode);
            map.put("tenantCode", tenantCode);
            result = this.mmUserRepository.queryMbuserPage(map);
            if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                user = (MmMbuser)result.getList().get(0);
            } else {
                return null;
            }
        }
        return user;
    }

    private VdFaccountInfo getFaccountOuterByCode(String merberCode, String tenantCode, String faccountType) {
        List accountList;
        if (StringUtils.isBlank((String)faccountType)) {
            faccountType = FaccountTypeEnum.BASE_ACCOUNT.getCode();
        }
        if (ListUtil.isNotEmpty((Collection)(accountList = this.faccountRepository.queryOuterFaccount(merberCode, faccountType, tenantCode)))) {
            return (VdFaccountInfo)accountList.get(0);
        }
        return null;
    }

    public BigDecimal calBackAmount(Map<String, Object> paramMap, String tenantCode) {
        String script = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "epay-saleAmountScript"));
        if (StringUtils.isBlank((String)script)) {
            return null;
        }
        Object amount = ScriptUtil.evel((String)script, paramMap);
        if (amount == null) {
            return null;
        }
        BigDecimal backAmount = null;
        try {
            backAmount = new BigDecimal(amount.toString());
            if (backAmount.compareTo(BigDecimal.ZERO) != 1) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return backAmount.setScale(2, 4);
    }

    @RequestMapping(value={"sendverCode.json"})
    @ResponseBody
    public HtmlJsonReBean sendverCode(HttpServletRequest request, String mbuserPhone) {
        return this.sendValidateCodeByLoginUser(request, mbuserPhone, "0");
    }

    @RequestMapping(value={"getMemberByphone.json"})
    @ResponseBody
    public HtmlJsonReBean getMemberByphone(HttpServletRequest request, String userPhone, String phomeverCode) {
        if (!this.checkValidateCode("0", userPhone, phomeverCode, this.getTenantCode(request))) {
            return new HtmlJsonReBean("error", "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        MmMbuser mbuser = this.mmUserRepository.getMbuserByPhone(userPhone, this.getTenantCode(request));
        if (mbuser == null) {
            return new HtmlJsonReBean("error", "\u6ca1\u6709\u4f1a\u5458\u4fe1\u606f");
        }
        VdFaccountInfo vdFaccountInfo = this.getFaccountOuterByCode(mbuser.getMerberCode(), this.getTenantCode(request), mbuser.getMerberCode().subSequence(0, 1) + "01");
        if (vdFaccountInfo == null) {
            return new HtmlJsonReBean("error", "\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        map.put("merberCode", mbuser.getMerberCode());
        map.put("faccountAmount", vdFaccountInfo.getFaccountAmount());
        return new HtmlJsonReBean(map);
    }

    @RequestMapping(value={"sendPayAndCommit.json"})
    @ResponseBody
    public HtmlJsonReBean sendPtradePay(HttpServletRequest request, HttpServletResponse response, String verCode, String memberCode, String money) {
        if (StringUtils.isBlank((String)money)) {
            return new HtmlJsonReBean("error", "\u91d1\u989d\u4fe1\u606f\u4e3a\u7a7a");
        }
        UserSession user = this.getUserSession(request);
        PaPaymentDomain payment = new PaPaymentDomain();
        payment.setAppmanageIcode(ServletMain.getAppName());
        payment.setTenantCode(user.getTenantCode());
        payment.setPartnerCode(user.getUserPcode());
        payment.setMerchantCode(user.getUserPcode());
        payment.setOrderAmount(new BigDecimal(money));
        payment.setVerCode(verCode);
        payment.setPtradpdeCode("PAYMENTLINE");
        payment.setPtradeType("03");
        if (StringUtils.isNotBlank((String)memberCode)) {
            payment.setOpuserCode(memberCode);
        } else {
            payment.setOpuserCode("anonymous");
        }
        String fchannelCode = this.getFchannelCode(verCode);
        if (StringUtils.isEmpty((String)fchannelCode)) {
            return new HtmlJsonReBean("error", "\u4e0d\u652f\u8be5\u6301\u4ed8\u6b3e\u65b9\u5f0f\uff01");
        }
        payment.setFchannelCode(fchannelCode);
        String ptradeSeqno = this.savePay(payment);
        payment.setPtradeSeqno(ptradeSeqno);
        HashMap<String, String> map = new HashMap<String, String>();
        HtmlJsonReBean rs = this.commitpay(null, response, null, payment);
        if (rs.isSuccess()) {
            map.put("ptradeSeqno", ptradeSeqno);
            return new HtmlJsonReBean(map);
        }
        return rs;
    }

    private String getFchannelCode(String vercode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("10", WECHAT_CODE);
        map.put("11", WECHAT_CODE);
        map.put("12", WECHAT_CODE);
        map.put("13", WECHAT_CODE);
        map.put("14", WECHAT_CODE);
        map.put("15", WECHAT_CODE);
        map.put("25", ALIPAY_CODE);
        map.put("26", ALIPAY_CODE);
        map.put("27", ALIPAY_CODE);
        map.put("28", ALIPAY_CODE);
        map.put("29", ALIPAY_CODE);
        map.put("30", ALIPAY_CODE);
        return (String)map.get(vercode.substring(0, 2));
    }

    private String savePay(PaPaymentDomain payment) {
        payment.setPtradeType("03");
        if (StringUtils.isBlank((String)payment.getMerchantCode())) {
            String merchantCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(payment.getTenantCode() + "-" + "yqb-merchantCode"));
            payment.setMerchantCode(merchantCode);
            payment.setPartnerCode(merchantCode);
        }
        payment.setRouterDir("0");
        payment.setAppId(ServletMain.getAppName());
        return this.paPaymentRepositroy.savePyamentToPte(payment);
    }

    @RequestMapping(value={"queryPaymentResult.json"})
    @ResponseBody
    public HtmlJsonReBean getPaymentDataState(HttpServletRequest request, String ptradeSeqno, String queryMode) {
        HashMap<String, String> map = new HashMap<String, String>();
        UserSession userSession = this.getUserSession(request);
        String falg = this.ptradeRepository.returnPtradeSuccess(userSession.getTenantCode(), ptradeSeqno, "3");
        if ("true".equals(falg)) {
            map.put("flag", "3");
            map.put("msg", "\u652f\u4ed8\u6210\u529f");
            return new HtmlJsonReBean(map);
        }
        if (!"1".equals(queryMode)) {
            ChannelRestForm channelRestForm = this.getFormCachStr(ptradeSeqno, userSession.getTenantCode());
            if (channelRestForm == null) {
                map.put("flag", "1");
                map.put("msg", "\u652f\u4ed8\u5931\u8d25");
                return new HtmlJsonReBean(map);
            }
            Map<String, String> submsg = channelRestForm.getBankHtmlForm().getRequestData();
            String ss = submsg.get("subMsg");
            if (StringUtils.isNotBlank((String)ss)) {
                map.put("flag", "1");
                map.put("msg", ss);
                return new HtmlJsonReBean(map);
            }
        }
        map.put("flag", "2");
        map.put("msg", "\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c");
        return new HtmlJsonReBean(map);
    }
}

