/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.payment.controller;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.exchange.repository.ContractRepository;
import com.yqbsoft.laser.html.facade.mm.domain.MmMbuserReDomain;
import com.yqbsoft.laser.html.facade.mm.repository.MmMerberRepository;
import com.yqbsoft.laser.html.facade.pay.domain.PaPaymentDomain;
import com.yqbsoft.laser.html.facade.pay.repository.PaPaymentRepositroy;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtfchannelDomain;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtradeDomain;
import com.yqbsoft.laser.html.facade.pte.bean.PtradeBean;
import com.yqbsoft.laser.html.facade.pte.bean.PtradpdeEnum;
import com.yqbsoft.laser.html.facade.pte.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.html.facade.pte.repository.PtfchannelRepository;
import com.yqbsoft.laser.html.facade.pte.repository.PtradeRepository;
import com.yqbsoft.laser.html.facade.um.domain.TmTenantReDomain;
import com.yqbsoft.laser.html.facade.um.repository.TenantRepository;
import com.yqbsoft.laser.html.facade.vd.bean.VdFaccountInfo;
import com.yqbsoft.laser.html.facade.vd.repository.VdFaccountRepository;
import com.yqbsoft.laser.html.payment.bean.ChannelRestForm;
import com.yqbsoft.laser.html.payment.bean.CmFchannelConfig;
import com.yqbsoft.laser.html.payment.constans.FaccountTypeEnum;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.springmvc.interceptor.SpringMVCInterceptor;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pa/payment"})
@Layout(frameName="application")
public class PaymentCon
extends SpringmvcController {
    private static String CODE = "pa.payment.con";
    @Autowired
    PtradeRepository ptradeRepository;
    @Autowired
    PaPaymentRepositroy paPaymentRepositroy;
    @Autowired
    VdFaccountRepository faccountRepository;
    @Autowired
    PtfchannelRepository ptfchannelRepository;
    @Autowired
    MmMerberRepository merberRepository;
    @Autowired
    TenantRepository tenantRepository;
    @Autowired
    ContractRepository contractRepository;

    protected String getContext() {
        return "payment";
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, ModelMap map) {
        UserSession userSession = this.getUserSession(request);
        map.addAttribute("PtradeList", this.queryPtradeByUserCode(userSession));
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"resource"})
    public String resource(HttpServletRequest request, ModelMap map) {
        UserSession user = this.getUserSession(request);
        map.addAttribute("user", (Object)user);
        return this.getFtlTempPath(request) + "resource";
    }

    @RequestMapping(value={"cashier"})
    public String cashier(HttpServletRequest request, HttpServletResponse response, ModelMap map, PaPaymentDomain payment) throws IOException {
        String ptradeSeqno = this.savePay(request, payment);
        String browType = BrowTypeUtil.getBrowUtype((String)request.getHeader("User-Agent"));
        if (browType.equals(BrowTypeUtil.type.JSAPI.toString())) {
            String uri = this.wechatAuth(request, ptradeSeqno);
            response.sendRedirect(uri);
            return null;
        }
        HttpSession session = request.getSession();
        session.setAttribute(SpringMVCInterceptor.REBACK_URL + ptradeSeqno, (Object)request.getParameter(SpringMVCInterceptor.REBACK_URL));
        return this.payment(request, map, ptradeSeqno);
    }

    public String wechatAuth(HttpServletRequest request, String ptradeSeqno) {
        String tenantCode = this.getUserSession(request).getTenantCode();
        String userCode = this.getUserSession(request).getUserCode();
        String userName = this.getUserSession(request).getUserName();
        String redirectUri = this.getRequestservice(request).concat(request.getContextPath()).concat("/web/pa/payment/paymentWechatJsCommit/" + ptradeSeqno.concat("," + tenantCode).concat("," + userCode).concat("," + userName));
        try {
            redirectUri = URLEncoder.encode(redirectUri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CmFchannelConfig ccf = this.getFconfig(tenantCode, "wechatjs", "appid");
        String uri = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + ccf.getFchannelConfigValue() + "&redirect_uri=" + redirectUri + "&response_type=code&scope=snsapi_base&state=123#wechat_redirect";
        return uri;
    }

    @RequestMapping(value={"paymentWechatJsCommit/{info}"})
    public String paymentWechatJsCommit(HttpServletRequest request, HttpServletResponse response, ModelMap map, String code, @PathVariable String info) {
        if (StringUtils.isBlank((String)CODE)) {
            return null;
        }
        String[] infoS = info.split(",");
        String ptradeSeqno = infoS[0];
        String tenantCode = infoS[1];
        String userCode = infoS[2];
        String userName = infoS[3];
        CmFchannelConfig ccf = this.getFconfig(tenantCode, "wechatjs", "appid");
        CmFchannelConfig ccfsecret = this.getFconfig(tenantCode, "wechatjs", "appid_secret");
        String accessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + ccf.getFchannelConfigValue() + "&secret=" + ccfsecret.getFchannelConfigValue() + "&code=" + code + "&grant_type=authorization_code";
        String openId = null;
        try {
            String resJson = WebUtils.doGet((String)accessTokenUrl, null);
            JsonUtil.buildNormalBinder();
            Map resMap = JsonUtil.getJsonToMap((String)resJson);
            if (resMap.containsKey("openid")) {
                openId = (String)resMap.get("openid");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        map.addAttribute("openId", openId);
        map.put((Object)"tenantCode", (Object)tenantCode);
        map.put((Object)"userCode", (Object)userCode);
        map.put((Object)"userName", (Object)userName);
        return this.payment(request, map, ptradeSeqno);
    }

    @RequestMapping(value={"cashierInterface"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean cashierInterface(HttpServletRequest request, PaPaymentDomain payment) {
        String ptradeSeqno = this.savePay(request, payment);
        return new HtmlJsonReBean((Object)ptradeSeqno);
    }

    @RequestMapping(value={"paymentInterface"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean paymentInterface(HttpServletRequest request, String ptradeSeqno) {
        String fchannelPmodeCode = request.getParameter("fchannelPmodeCode");
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            return new HtmlJsonReBean(CODE, "ptradeSeqno or fchannelPmodeCode is null");
        }
        UserSession userSession = this.getUserSession(request);
        Map<String, Object> partMap = this.queryParticipant(userSession, fchannelPmodeCode, null, BrowTypeUtil.getBrowExplorer((String)request.getHeader("User-Agent")));
        partMap.put("ptrade", this.getPaymentDomain(ptradeSeqno, userSession.getTenantCode()));
        return new HtmlJsonReBean(partMap);
    }

    @RequestMapping(value={"payment"})
    public String payment(HttpServletRequest request, ModelMap map, String ptradeSeqno) {
        UserSession userSession = this.getUserSession(request);
        map.addAttribute("user", (Object)userSession);
        map.addAttribute("ptrade", (Object)this.getPaymentDomain(ptradeSeqno, userSession.getTenantCode()));
        String browType = BrowTypeUtil.getBrowUtype((String)request.getHeader("User-Agent"));
        Map<String, Object> partMap = this.queryParticipant(userSession, browType, map, BrowTypeUtil.getBrowExplorer((String)request.getHeader("User-Agent")));
        map.addAttribute("participantInList", partMap.get("participantInList"));
        map.addAttribute("participantOutList", partMap.get("participantOutList"));
        map.addAttribute("browType", (Object)browType);
        return this.getFtlTempPath(request) + "payment";
    }

    @Layout(frameName="publicApplication")
    @RequestMapping(value={"page"})
    public String paymentPage(HttpServletRequest request, ModelMap model, String ptradeSeqno, String tenantCode, String memberCode) {
        PtePtradeDomain ptePtradeDomain = this.getPaymentDomain(ptradeSeqno, tenantCode);
        if (ptePtradeDomain == null) {
            return null;
        }
        model.addAttribute("tenantCode", (Object)tenantCode);
        UserSession userSession = new UserSession();
        userSession.setTenantCode(tenantCode);
        List<PtePtfchannelDomain> ptfchannelDomainList = this.queryPtfchannelDomain(userSession, "WEB", model);
        this.eliminateChannel(ptePtradeDomain, ptfchannelDomainList);
        List<PtePtfchannelDomain> jsapiptfchannelDomainList = this.queryPtfchannelDomain(userSession, "JSAPI", model);
        model.addAttribute("ptePtrade", (Object)ptePtradeDomain);
        model.addAttribute("ptfchannelList", ptfchannelDomainList);
        model.addAttribute("jsapiptfchannelList", jsapiptfchannelDomainList);
        if (StringUtils.isNotBlank((String)memberCode)) {
            if (!ptePtradeDomain.getOpuserCode().equals(memberCode)) {
                throw new SupperSysException("\u4ed8\u6b3e\u4eba\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
            List vd = this.faccountRepository.queryOuterFaccount(memberCode, "", tenantCode);
            if (vd == null || vd.size() == 0) {
                throw new SupperSysException("\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
            }
            model.addAttribute("VdFaccountInfo", vd.get(0));
        }
        model.put((Object)"urlCode", (Object)(this.getRequestservice(request) + "" + request.getContextPath() + "/web/payment/order/redirect/" + tenantCode + "/" + ptePtradeDomain.getPtradeSeqno() + "-" + memberCode));
        return this.getFtlTempPath(request) + "cashier";
    }

    private void eliminateChannel(PtePtradeDomain ptePtradeDomain, List<PtePtfchannelDomain> ptfchannelDomainList) {
        if (ptePtradeDomain == null || ListUtil.isEmpty(ptfchannelDomainList)) {
            return;
        }
        if (PtradpdeEnum.PAYMENTCASH.getCode().equals(ptePtradeDomain.getPtradpdeCode())) {
            Iterator<PtePtfchannelDomain> iterator = ptfchannelDomainList.iterator();
            while (iterator.hasNext()) {
                PtePtfchannelDomain domain = iterator.next();
                if (!"cash".equals(domain.getFchannelType())) continue;
                iterator.remove();
            }
        }
    }

    private Map<String, Object> queryParticipant(UserSession userSession, String fchannelPmodeCode, ModelMap modelMap, String browType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<VdFaccountInfo> faccountList = this.queryFaccountOuterByCode(userSession, modelMap);
        HashMap<String, VdFaccountInfo> accountMap = new HashMap<String, VdFaccountInfo>();
        if (faccountList != null && !faccountList.isEmpty()) {
            for (VdFaccountInfo faccountOuterDomain : faccountList) {
                accountMap.put(faccountOuterDomain.getFaccountType(), faccountOuterDomain);
            }
        }
        List<PtePtfchannelDomain> fchannelList = this.queryPtfchannelDomain(userSession, fchannelPmodeCode, modelMap);
        ArrayList<PtePtradeParticipantDomain> participantInList = new ArrayList<PtePtradeParticipantDomain>();
        ArrayList<PtePtradeParticipantDomain> participantOutList = new ArrayList<PtePtradeParticipantDomain>();
        if (fchannelList != null && !fchannelList.isEmpty()) {
            for (PtePtfchannelDomain ptfchannelDomain : fchannelList) {
                if ("cash".equals(ptfchannelDomain.getFchannelCode()) || "pos".equals(ptfchannelDomain.getFchannelCode()) || "newplan".equals(ptfchannelDomain.getFchannelCode())) continue;
                PtePtradeParticipantDomain articipantDomain = new PtePtradeParticipantDomain();
                articipantDomain.setId(ptfchannelDomain.getPtfchannelId());
                articipantDomain.setFaccountName(ptfchannelDomain.getFchannelName());
                articipantDomain.setFchannelCode(ptfchannelDomain.getFchannelCode());
                articipantDomain.setFchannelClassifyCode(ptfchannelDomain.getFchannelType());
                articipantDomain.setImgPath(ptfchannelDomain.getFchannelBankImgurl());
                articipantDomain.setDicActorCode(ptfchannelDomain.getDicActorCode());
                articipantDomain.setMemo(ptfchannelDomain.getMemo());
                String fchannelType = ptfchannelDomain.getFchannelType();
                VdFaccountInfo faccountOuterDomain = (VdFaccountInfo)accountMap.get(fchannelType);
                if (faccountOuterDomain == null) {
                    if (StringUtils.isBlank((String)browType)) {
                        if (!"BANK".equals(ptfchannelDomain.getDicActorCode())) continue;
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (!"BANK".equals(ptfchannelDomain.getDicActorCode())) continue;
                    if (articipantDomain.getFchannelCode().equals("wechatjs") && browType.equals("MicroMessenger")) {
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (articipantDomain.getFchannelCode().equals("alipayjs") && browType.equals("Alipay")) {
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (!articipantDomain.getFchannelCode().equals("ctest")) continue;
                    participantOutList.add(articipantDomain);
                    continue;
                }
                articipantDomain.setFaccountId(faccountOuterDomain.getFaccountOuterNo());
                articipantDomain.setOrderAmount(faccountOuterDomain.getFaccountAmount().setScale(6));
                participantInList.add(articipantDomain);
            }
        }
        map.put("participantInList", participantInList);
        map.put("participantOutList", participantOutList);
        return map;
    }

    private Map<String, Object> makeParticipantList(UserSession userSession, String fchannelPmodeCode, ModelMap modelMap, PtePtradeDomain ptradeDomain, String fchannelCode, String browType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<VdFaccountInfo> faccountList = this.queryFaccountOuterByCode(userSession, modelMap);
        HashMap<String, VdFaccountInfo> accountMap = new HashMap<String, VdFaccountInfo>();
        if (faccountList != null && !faccountList.isEmpty()) {
            for (VdFaccountInfo faccountOuterDomain : faccountList) {
                accountMap.put(faccountOuterDomain.getFaccountType(), faccountOuterDomain);
            }
        }
        List<PtePtfchannelDomain> fchannelList = this.queryPtfchannelDomain(userSession, fchannelPmodeCode, modelMap);
        ArrayList<PtePtradeParticipantDomain> participantInList = new ArrayList<PtePtradeParticipantDomain>();
        ArrayList<PtePtradeParticipantDomain> participantOutList = new ArrayList<PtePtradeParticipantDomain>();
        if (fchannelList != null && !fchannelList.isEmpty()) {
            for (PtePtfchannelDomain ptfchannelDomain : fchannelList) {
                PtePtradeParticipantDomain articipantDomain = new PtePtradeParticipantDomain();
                articipantDomain.setId(ptfchannelDomain.getPtfchannelId());
                articipantDomain.setFaccountName(ptfchannelDomain.getFchannelName());
                articipantDomain.setFchannelCode(ptfchannelDomain.getFchannelCode());
                articipantDomain.setFchannelClassifyCode(ptfchannelDomain.getFchannelType());
                articipantDomain.setImgPath(ptfchannelDomain.getFchannelBankImgurl());
                articipantDomain.setDicActorCode(ptfchannelDomain.getDicActorCode());
                articipantDomain.setMemo(ptfchannelDomain.getMemo());
                String fchannelType = ptfchannelDomain.getFchannelType();
                VdFaccountInfo faccountOuterDomain = (VdFaccountInfo)accountMap.get(fchannelType);
                if (faccountOuterDomain == null) {
                    if (StringUtils.isBlank((String)browType)) {
                        if (!"BANK".equals(ptfchannelDomain.getDicActorCode())) continue;
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (!"BANK".equals(ptfchannelDomain.getDicActorCode())) continue;
                    if (articipantDomain.getFchannelCode().equals("wechatjs") && browType.equals("MicroMessenger")) {
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (articipantDomain.getFchannelCode().equals("alipayjs") && browType.equals("Alipay")) {
                        participantOutList.add(articipantDomain);
                        continue;
                    }
                    if (!articipantDomain.getFchannelCode().equals("ctest")) continue;
                    participantOutList.add(articipantDomain);
                    continue;
                }
                articipantDomain.setFaccountId(faccountOuterDomain.getFaccountOuterNo());
                articipantDomain.setOrderAmount(ptradeDomain.getOrderAmount());
                participantInList.add(articipantDomain);
            }
        }
        map.put("participantInList", participantInList);
        return map;
    }

    private PtePtradeDomain getPaymentDomain(String ptradeSeqno, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ptradeSeqno", ptradeSeqno);
        map.put("tenantCode", tenantCode);
        return this.ptradeRepository.getDomainByUK(map);
    }

    @RequestMapping(value={"commit"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean paymentCommit(HttpServletRequest request) throws IOException {
        try {
            VdFaccountInfo account;
            UserSession userSession = new UserSession();
            String ptradeSeqno = request.getParameter("ptradeSeqno");
            String fchannelCode = request.getParameter("fchannelCode");
            String fchannelMode = request.getParameter("fchannelMode");
            String faccountName = request.getParameter("faccountName");
            String dicActorCode = request.getParameter("dicActorCode");
            String tenantCode = request.getParameter("tenantCode");
            String opuserCode = request.getParameter("opuserCode");
            PtradeBean ptradeBean = null;
            if (!(StringUtils.isNotBlank((String)ptradeSeqno) && StringUtils.isNotBlank((String)fchannelCode) && StringUtils.isNotBlank((String)fchannelMode) && StringUtils.isNotBlank((String)tenantCode))) {
                return new HtmlJsonReBean(CODE + "paymentCommit.null", "\u53c2\u6570\u4e3a\u7a7a");
            }
            ptradeBean = new PtradeBean();
            ptradeBean.setPtradeSeqno(ptradeSeqno);
            HashMap<String, String> extension = new HashMap<String, String>();
            extension.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
            ptradeBean.setExtension(JsonUtil.buildNormalBinder().toJson(extension));
            PtePtradeDomain ptePtradeDomain = this.getPaymentDomain(ptradeSeqno, tenantCode);
            if (ptePtradeDomain == null) {
                return new HtmlJsonReBean(CODE + "paymentCommit.null", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            userSession.setTenantCode(tenantCode);
            userSession.setUserPcode(ptePtradeDomain.getMerchantCode());
            String fchannelPmodeCode = BrowTypeUtil.getBrowUtype((String)request.getHeader("User-Agent"));
            ptradeBean.setFchannelPmodeCode(fchannelPmodeCode);
            ArrayList<PtePtradeParticipantDomain> ptePtradeParticipants = new ArrayList<PtePtradeParticipantDomain>();
            BigDecimal bankAmount = ptePtradeDomain.getOrderAmount();
            if (StringUtils.isNotBlank((String)opuserCode) && (account = this.getFaccountOuterByCode(opuserCode, userSession.getTenantCode(), opuserCode.substring(0, 1) + "01")).getFaccountAmount().compareTo(BigDecimal.ZERO) > 0) {
                List<PtePtfchannelDomain> ptfchannelList = this.queryPtfchannelDomain(userSession, ptradeBean.getFchannelPmodeCode(), null);
                PtePtfchannelDomain accountChannel = null;
                for (PtePtfchannelDomain ptePtfchannelDomain : ptfchannelList) {
                    if (!ptePtfchannelDomain.getFchannelType().equals(account.getFaccountType())) continue;
                    accountChannel = ptePtfchannelDomain;
                }
                if (accountChannel != null) {
                    PtePtradeParticipantDomain accountPart = new PtePtradeParticipantDomain();
                    accountPart.setDicActorCode(accountChannel.getDicActorCode());
                    accountPart.setFaccountName(accountChannel.getFchannelName());
                    accountPart.setFchannelCode(accountChannel.getFchannelCode());
                    accountPart.setFaccountId(account.getFaccountOuterNo());
                    accountPart.setFchannelClassifyCode(accountChannel.getFchannelType());
                    if (account.getFaccountAmount().compareTo(BigDecimal.ZERO) > -1) {
                        bankAmount = ptePtradeDomain.getOrderAmount().subtract(account.getFaccountAmount());
                        accountPart.setOrderAmount(account.getFaccountAmount());
                        ptePtradeParticipants.add(accountPart);
                    }
                }
            }
            PtePtradeParticipantDomain ptePtradeParticipant = new PtePtradeParticipantDomain();
            ptePtradeParticipant.setDicActorCode(dicActorCode);
            ptePtradeParticipant.setFaccountName(faccountName);
            ptePtradeParticipant.setFchannelCode(fchannelCode);
            ptePtradeParticipant.setFchannelClassifyCode(fchannelCode);
            ptePtradeParticipant.setOrderAmount(bankAmount);
            ptePtradeParticipants.add(ptePtradeParticipant);
            ptradeBean.setPartList(ptePtradeParticipants);
            ptradeBean.setFchannelMode(fchannelMode);
            ptradeBean.setTenantCode(tenantCode);
            ptradeBean.setOrderShowurl("https://www.bestbeijia.com/yqb/web/vd/account/view");
            this.ptradeRepository.commitParticipantByPtrade(ptradeBean);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"paymentCommit"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean paymentCommit(HttpServletRequest request, @RequestBody PtradeBean ptradeBean) throws IOException {
        try {
            UserSession userSession = this.getUserSession(request);
            if (ptradeBean == null) {
                return new HtmlJsonReBean(CODE + "paymentCommit.null", "\u53c2\u6570\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((String)ptradeBean.getOpenId())) {
                HashMap<String, String> extension = new HashMap<String, String>();
                extension.put("openId", ptradeBean.getOpenId());
                ptradeBean.setExtension(JsonUtil.buildNormalBinder().toJson(extension));
            }
            String fchannelPmodeCode = BrowTypeUtil.getBrowUtype((String)request.getHeader("User-Agent"));
            ptradeBean.setFchannelPmodeCode(fchannelPmodeCode);
            ptradeBean.setTenantCode(userSession.getTenantCode());
            ptradeBean.setOrderShowurl("https://www.bestbeijia.com/yqb/web/vd/account/view");
            this.ptradeRepository.commitParticipantByPtrade(ptradeBean);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"weChatpaymentCommit"})
    public String weChatPaymentCommit(HttpServletRequest request, ModelMap map, String res, String out_trade_no, String fchannelCode, String tenantCode, String fchannelPmode, String total_fee) {
        if (StringUtils.isEmpty((String)res)) {
            map.put((Object)"errorMsg", (Object)"\u7cfb\u7edf\u9519\u8bef");
            return this.getFtlTempPath(request) + "wechatPc";
        }
        try {
            Map xml = XmlUtil.getMapFromXML((String)res);
            String code = (String)xml.get("return_code");
            String resultCode = (String)xml.get("result_code");
            if (!code.equals("SUCCESS") && !resultCode.equals("SUCCESS")) {
                map.put((Object)"errorMsg", xml.get("return_msg"));
                return this.getFtlTempPath(request) + "wechatPc";
            }
            String urlCode = (String)xml.get("code_url");
            map.put((Object)"urlCode", (Object)urlCode);
            map.put((Object)"out_trade_no", (Object)out_trade_no);
            map.put((Object)"fchannelCode", (Object)fchannelCode);
            map.put((Object)"tenantCode", (Object)tenantCode);
            map.put((Object)"fchannelPmode", (Object)fchannelPmode);
            map.put((Object)"total_fee", (Object)total_fee);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getFtlTempPath(request) + "wechatPc";
    }

    @RequestMapping(value={"public/weChatpayQr"})
    public void weChatPayQRByPublic(HttpServletRequest request, HttpServletResponse response, String urlCode) {
        if (StringUtils.isEmpty((String)urlCode)) {
            return;
        }
        try {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.MARGIN, 1);
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(urlCode, BarcodeFormat.QR_CODE, 300, 300, hints);
            response.setDateHeader("Expires", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Content-Type", "image/jpeg");
            BufferedImage image = this.toBufferedImage(bitMatrix);
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"weChatpayQr"})
    public void weChatPayQR(HttpServletRequest request, HttpServletResponse response, String urlCode) {
        if (StringUtils.isEmpty((String)urlCode)) {
            return;
        }
        try {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.MARGIN, 1);
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(urlCode, BarcodeFormat.QR_CODE, 300, 300, hints);
            response.setDateHeader("Expires", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Content-Type", "image/jpeg");
            BufferedImage image = this.toBufferedImage(bitMatrix);
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    @RequestMapping(value={"payBack"})
    public String payBack(HttpServletRequest request, ModelMap map, PtradeBean ptradeBean) {
        if (ptradeBean == null) {
            return null;
        }
        String returnStr = this.ptradeRepository.sendParticipantByPtrade(ptradeBean);
        if (StringUtils.isNotBlank((String)returnStr)) {
            ChannelRestForm channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(returnStr, ChannelRestForm.class);
            map.put((Object)"channelRestForm", (Object)channelRestForm);
        }
        return this.getFtlTempPath(request) + "payBack";
    }

    private List<PtePtradeDomain> queryPtradeByUserCode(UserSession userSession) {
        if (userSession == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("opuserCode", userSession.getUserCode());
        map.put("tenantCode", userSession.getTenantCode());
        map.put("dataState", "2");
        return this.ptradeRepository.query(map).getList();
    }

    public String savePay(HttpServletRequest request, PaPaymentDomain payment) {
        UserSession userSession = this.getUserSession(request);
        payment.setTenantCode(userSession.getTenantCode());
        payment.setOpuserCode(userSession.getUserPcode());
        payment.setOpuserName(userSession.getUserName());
        payment.setPtradeType("03");
        if (StringUtils.isBlank((String)payment.getMerchantCode())) {
            String merchantCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(userSession.getTenantCode() + "-" + "yqb-merchantCode"));
            payment.setMerchantCode(merchantCode);
            payment.setPartnerCode(merchantCode);
        }
        payment.setRouterDir("0");
        payment.setAppId(ServletMain.getAppName());
        return this.paPaymentRepositroy.savePyamentToPte(payment);
    }

    private List<VdFaccountInfo> queryFaccountOuterByCode(UserSession userSession, ModelMap map) {
        return this.faccountRepository.queryOuterFaccount(userSession.getUserPcode(), "", userSession.getTenantCode());
    }

    private List<PtePtfchannelDomain> queryPtfchannelDomain(UserSession userSession, String fchannelPmodeCode, ModelMap modelMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", userSession.getTenantCode());
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("fchannelDr", "PAY");
        map.put("dataState", 1);
        map.put("fuzzy", true);
        SupQueryResult supQueryResult = this.ptfchannelRepository.queryPtfchannelPage(map);
        if (supQueryResult != null) {
            return supQueryResult.getList();
        }
        return null;
    }

    @RequestMapping(value={"checkPwd"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean checkPwd(HttpServletRequest request, String pwd) {
        MmMbuserReDomain mmMbuser;
        UserSession userSession = this.getUserSession(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("merberCode", userSession.getUserPcode());
        SupQueryResult supQueryResult = this.merberRepository.queryMbuserPage(map);
        if (supQueryResult != null && supQueryResult.getList() != null && !supQueryResult.getList().isEmpty() && ((mmMbuser = (MmMbuserReDomain)supQueryResult.getList().get(0)).getMbuserPypw().length() < 32 ? mmMbuser.getMbuserPypw().equals(pwd) : MD5Util.saltMD5Verify((String)pwd, (String)mmMbuser.getMbuserPypw()))) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bc6\u7801\u9519\u8bef");
    }

    @RequestMapping(value={"paymentFormSubmit"})
    public String paymentFormSubmit(HttpServletRequest request, ModelMap map, String ptradeSeqno) {
        map.put((Object)"channelRestForm", (Object)this.getFormCachStr(request, ptradeSeqno));
        return this.getFtlTempPath(request) + "paymentCommit";
    }

    @RequestMapping(value={"paymentFormWeChatSubmit"}, produces={"application/json"})
    @ResponseBody
    public String paymentFormWeChatSubmit(HttpServletRequest request, ModelMap map, String ptradeSeqno) {
        return JsonUtil.buildNormalBinder().toJson((Object)this.getFormCachStr(request, ptradeSeqno));
    }

    private ChannelRestForm getFormCachStr(HttpServletRequest request, String ptradeSeqno) {
        UserSession userSession = this.getUserSession(request);
        String restJson = this.ptradeRepository.getFormCachStr(userSession.getTenantCode(), ptradeSeqno);
        if (StringUtils.isBlank((String)restJson)) {
            return null;
        }
        ChannelRestForm channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(restJson, ChannelRestForm.class);
        return channelRestForm;
    }

    @RequestMapping(value={"paymentFormSubmitInteface"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean paymentFormSubmitInteface(HttpServletRequest request, String ptradeSeqno) {
        try {
            return new HtmlJsonReBean((Object)this.getFormCachStr(request, ptradeSeqno));
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    private CmFchannelConfig getFconfig(String tenantCode, String fchannelCode, String fchannelConfigKey) {
        PostParamMap pmapConfg = new PostParamMap("cm.fchannelConfig.queryFchannelConfigPage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("fchannelCode", fchannelCode);
        map.put("fchannelConfigKey", fchannelConfigKey);
        pmapConfg.putParamToJson("map", map);
        SupQueryResult cmc = this.htmlIBaseService.sendReSupObject(pmapConfg, CmFchannelConfig.class);
        if (cmc != null && ListUtil.isNotEmpty((Collection)cmc.getList())) {
            return (CmFchannelConfig)cmc.getList().get(0);
        }
        return null;
    }

    private VdFaccountInfo getFaccountOuterByCode(String merberCode, String tenantCode, String faccountType) {
        List accountList;
        if (StringUtils.isBlank((String)faccountType)) {
            faccountType = FaccountTypeEnum.BASE_ACCOUNT.getCode();
        }
        if (ListUtil.isNotEmpty((Collection)(accountList = this.faccountRepository.queryOuterFaccount(merberCode, faccountType, tenantCode)))) {
            return (VdFaccountInfo)accountList.get(0);
        }
        return null;
    }

    @RequestMapping(value={"paymenCashierInterface"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean paymenCashierInterface(HttpServletRequest request, ModelMap modelMap, String ptradeSeqno, String merchantCode) {
        TmTenantReDomain tmTenantReDomain;
        String domain;
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isBlank((String)merchantCode)) {
            merchantCode = userSession.getUserPcode();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String qrUrl = "";
        List<PtePtfchannelDomain> channelList = this.queryPtfchannelDomain(userSession, BrowTypeUtil.type.JSAPI.toString(), modelMap);
        if (ListUtil.isNotEmpty(channelList) && StringUtils.isNotBlank((String)(domain = (tmTenantReDomain = this.tenantRepository.getTenantByCode(this.getTenantCode(request))).getTenantDomain()))) {
            if (domain.lastIndexOf("/") == domain.length() - 1) {
                domain = domain.substring(0, domain.length() - 1);
            }
            qrUrl = domain + request.getContextPath() + "/web/payment/redirect/" + userSession.getTenantCode() + "/" + merchantCode;
            if (StringUtils.isNotBlank((String)ptradeSeqno)) {
                qrUrl = domain + request.getContextPath() + "/web/payment/order/redirect/" + userSession.getTenantCode() + "/" + ptradeSeqno + "-" + merchantCode;
            }
        }
        result.put("qrcodeURL", qrUrl);
        return new HtmlJsonReBean(result);
    }

    @RequestMapping(value={"paymenModeInterface"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean paymenModeInterface(HttpServletRequest request, ModelMap modelMap) {
        UserSession userSession = this.getUserSession(request);
        ArrayList result = new ArrayList();
        List<PtePtfchannelDomain> channelList = this.queryPtfchannelDomain(userSession, BrowTypeUtil.type.JSAPI.toString(), modelMap);
        if (ListUtil.isNotEmpty(channelList)) {
            HashMap<String, String> c2bQrcode = new HashMap<String, String>();
            c2bQrcode.put("fchannelCode", "c2bQrcode");
            c2bQrcode.put("fchannelName", "\u4e8c\u7ef4\u7801\u6536\u6b3e");
            result.add(c2bQrcode);
            HashMap<String, String> b2cQrcode = new HashMap<String, String>();
            b2cQrcode.put("fchannelCode", "b2cQrcode");
            b2cQrcode.put("fchannelName", "\u626b\u7801\u6536\u6b3e");
            result.add(b2cQrcode);
        }
        HashMap<String, Object> cashMap = new HashMap<String, Object>();
        cashMap.put("tenantCode", userSession.getTenantCode());
        cashMap.put("fchannelCode", "cash");
        cashMap.put("fchannelDr", "PAY");
        cashMap.put("dataState", 1);
        SupQueryResult supQueryResult = this.ptfchannelRepository.queryPtfchannelPage(cashMap);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, String> b2cQrcode = new HashMap<String, String>();
            b2cQrcode.put("fchannelCode", "cash");
            b2cQrcode.put("fchannelName", "\u73b0\u91d1\u6536\u6b3e");
            result.add(b2cQrcode);
        }
        return new HtmlJsonReBean(result);
    }
}

