/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.payment.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.cm.domain.BankRequest;
import com.yqbsoft.laser.html.facade.cm.repository.CmChannelRepository;
import com.yqbsoft.laser.html.facade.cm.repository.FchannelRepository;
import com.yqbsoft.laser.html.facade.pte.bean.PtePtradeDomain;
import com.yqbsoft.laser.html.facade.pte.repository.PtradeRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.springmvc.interceptor.SpringMVCInterceptor;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.DisCacheBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/laserDirect"})
public class BankHttpController
extends SpringmvcController {
    @Autowired
    private PtradeRepository ptradeRepository;
    @Autowired
    private FchannelRepository fchannelRepository;
    @Autowired
    private CmChannelRepository channelRepository;

    protected String getContext() {
        return "bankReturn";
    }

    @RequestMapping(value={"/httpjson/post/{fchannelCode}/{tenantCode}/{fchannelPmode}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean getBankReturnApp(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode) {
        String ptradeSeqno = request.getParameter("ptradeSeqno");
        map.put((Object)"flag", (Object)this.checkReturnStr(request, response, map, fchannelCode, tenantCode, fchannelPmode, ptradeSeqno));
        return new HtmlJsonReBean((Object)map);
    }

    @RequestMapping(value={"/http/post/{fchannelCode}/{tenantCode}/{fchannelPmode}"}, method={RequestMethod.POST})
    public String postBankReturn(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode) {
        return this.getBankReturn(request, response, map, fchannelCode, tenantCode, fchannelPmode);
    }

    @RequestMapping(value={"/http/get/{token}/{tenantCode}/{appid}/{secret}"}, method={RequestMethod.GET})
    public void getJsapi(HttpServletRequest request, HttpServletResponse response, @PathVariable String token, @PathVariable String tenantCode, String code, @PathVariable String appid, @PathVariable String secret) {
        String accessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
        String openId = null;
        try {
            String resJson = WebUtils.doGet((String)accessTokenUrl, null);
            JsonUtil.buildNormalBinder();
            Map resMap = JsonUtil.getJsonToMap((String)resJson);
            if (resMap.containsKey("openid")) {
                openId = (String)resMap.get("openid");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ptradeRepository.addCharStr(accessTokenUrl, openId);
        this.logger.info("\u56de\u8c03\u62ff\u5230\u7684openId\u662f: " + openId);
    }

    @RequestMapping(value={"/http/get/{fchannelCode}/{tenantCode}/{fchannelPmode}"}, method={RequestMethod.GET})
    public String getBankReturn(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode) {
        this.setDefault(request, map);
        String ptradeSeqno = request.getParameter("ptradeSeqno");
        this.checkReturnStr(request, response, map, fchannelCode, tenantCode, fchannelPmode, ptradeSeqno);
        return this.getContext() + "/bankReturnBack";
    }

    @RequestMapping(value={"/payment/return/url"})
    @ResponseBody
    public Object getPaymentReturn(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("request: " + request.getParameterMap());
        return null;
    }

    @RequestMapping(value={"/payment/return/http/get/{fchannelCode}/{tenantCode}/{fchannelPmode}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getPaymentReturn(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode) {
        this.setDefault(request, map);
        String ptradeSeqno = request.getParameter("ptradeSeqno");
        Boolean retResultStr = Boolean.valueOf(this.checkReturnStr(request, response, map, fchannelCode, tenantCode, fchannelPmode, ptradeSeqno));
        return new HtmlJsonReBean();
    }

    private String checkReturnStr(HttpServletRequest request, HttpServletResponse response, ModelMap map, String fchannelCode, String tenantCode, String fchannelPmode, String ptradeSeqno) {
        PtePtradeDomain ptradeDomain = null;
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            Map maps = request.getParameterMap();
            String channelClearSeqno = this.getClearNo(HtmlUtil.tranMap((Map)maps), fchannelCode, tenantCode);
            ptradeDomain = this.getPtradeByClearno(channelClearSeqno, tenantCode);
        } else {
            ptradeDomain = this.getPtradeByPtradeSeqno(ptradeSeqno, tenantCode);
        }
        if (ptradeDomain == null) {
            map.addAttribute("flag", (Object)"false");
            return "false";
        }
        if (StringUtils.isNotBlank((String)ptradeDomain.getPaymentReturnurl())) {
            map.addAttribute(SpringMVCInterceptor.REBACK_URL, (Object)ptradeDomain.getPaymentReturnurl());
        }
        ptradeSeqno = ptradeDomain.getPtradeSeqno();
        String returnStr = null;
        returnStr = fchannelCode.indexOf("wechatpc") > -1 ? this.ptradeRepository.returnPtradeSuccess(tenantCode, ptradeSeqno, "3,4,5") : this.ptradeRepository.checkPtradeSuccess(tenantCode, ptradeSeqno, "3,4,5");
        map.addAttribute("flag", (Object)returnStr);
        UserSession user = this.getUserSession(request);
        if (user != null && !"anonymous".equals(ptradeDomain.getOpuserName())) {
            map.put((Object)"showAccount", (Object)"true");
        }
        return returnStr;
    }

    private String getClearNo(Map<String, Object> map, String fchannelCode, String tenantCode) {
        BankRequest bankRequest = this.fchannelRepository.paserPagecall(fchannelCode, tenantCode, map);
        if (bankRequest != null) {
            return bankRequest.getChannelClearSeqno();
        }
        return null;
    }

    private PtePtradeDomain getPtradeByClearno(String channelClearSeqno, String tenantCode) {
        if (StringUtils.isBlank((String)channelClearSeqno) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        PtePtradeDomain ptradeDomain = null;
        String paymentSeqno = "";
        String cachStr = SupDisUtil.getMap((String)"CM-BANK-NO", (String)channelClearSeqno);
        if (StringUtils.isNotBlank((String)cachStr)) {
            DisCacheBean disCacheBean = (DisCacheBean)JsonUtil.buildNormalBinder().getJsonToObject(cachStr, DisCacheBean.class);
            paymentSeqno = (String)disCacheBean.getValue();
        }
        if (StringUtils.isBlank((String)paymentSeqno)) {
            paymentSeqno = this.getPaymentByClearSeqno(channelClearSeqno, tenantCode);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("paymentSeqno", paymentSeqno);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.ptradeRepository.query(map);
        if (supQueryResult != null && supQueryResult.getList() != null && !supQueryResult.getList().isEmpty()) {
            ptradeDomain = (PtePtradeDomain)supQueryResult.getList().get(0);
        }
        return ptradeDomain;
    }

    private PtePtradeDomain getPtradeByPtradeSeqno(String ptradeSeqno, String tenantCode) {
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        PtePtradeDomain ptradeDomain = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ptradeSeqno", ptradeSeqno);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.ptradeRepository.query(map);
        if (supQueryResult != null && supQueryResult.getList() != null && !supQueryResult.getList().isEmpty()) {
            ptradeDomain = (PtePtradeDomain)supQueryResult.getList().get(0);
        }
        return ptradeDomain;
    }

    private String getPaymentByClearSeqno(String channelClearSeqno, String tenantCode) {
        return this.channelRepository.getchannelClearBySeqno(channelClearSeqno, tenantCode);
    }

    @RequestMapping(value={"/http/getresult/{fchannelCode}/{tenantCode}/{fchannelPmode}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getBankResult(HttpServletRequest request, HttpServletResponse response, ModelMap map, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode, String out_trade_no) {
        this.setDefault(request, map);
        String ptradeSeqno = request.getParameter("ptradeSeqno");
        return this.checkResult(request, response, map, fchannelCode, tenantCode, fchannelPmode, ptradeSeqno, out_trade_no);
    }

    private String checkResult(HttpServletRequest request, HttpServletResponse response, ModelMap map, String fchannelCode, String tenantCode, String fchannelPmode, String ptradeSeqno, String out_trade_no) {
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            PtePtradeDomain ptradeDomain = this.getPtradeByClearno(out_trade_no, tenantCode);
            if (ptradeDomain == null) {
                map.addAttribute("flag", (Object)"false");
                return "false";
            }
            ptradeSeqno = ptradeDomain.getPtradeSeqno();
        }
        String returnStr = this.ptradeRepository.returnPtradeSuccess(tenantCode, ptradeSeqno, "3,4,5");
        return returnStr;
    }

    @RequestMapping(value={"bankReturnBack"}, method={RequestMethod.GET})
    public String bankReturnBack(HttpServletRequest request, HttpServletResponse response, ModelMap map, String flag, String channelClearSeqno, String tenantCode) {
        this.setDefault(request, map);
        map.put((Object)"flag", (Object)flag);
        map.put((Object)"showAccount", (Object)"true");
        PtePtradeDomain ptradeDomain = this.getPtradeByClearno(channelClearSeqno, tenantCode);
        if (ptradeDomain != null && StringUtils.isNotBlank((String)ptradeDomain.getPaymentReturnurl())) {
            map.addAttribute(SpringMVCInterceptor.REBACK_URL, (Object)ptradeDomain.getPaymentReturnurl());
        }
        return this.getFtlTempPath(request) + "bankReturnBack";
    }

    private void setDefault(HttpServletRequest request, ModelMap map) {
        if (null != map && null != request) {
            request.setAttribute("path_servername", (Object)this.getRequestservice(request));
            map.addAttribute("sysAppContextPath", (Object)request.getContextPath());
            map.addAttribute("user", (Object)this.getUserSession(request));
        }
    }
}

