<#include '/layout/Head.ftl' />
<div class="homepage">
<div class="container">
	<div class="account_pad">
		<h2 class="account_main_title">支付订单</h2>
		<div class="info_box">
			<div class="info_list">
				<div class="row">
					<label class="2u 3u(mobile)">订单号</label>
					<div class="10u 9u(mobile)">
						${ptrade.ptradeSeqno}
					</div>
				</div>
				<div class="row">
					<label class="2u 3u(mobile)">商品名称</label>
					<div class="10u 9u(mobile)">
						${ptrade.paymentMemo?if_exists}
					</div>
				</div>		
				<div class="row">
					<label class="2u 3u(mobile)">商品金额</label>
					<div class="10u 9u(mobile)">
						${ptrade.orderAmount?string.currency}元
					</div>
				</div>	
				<div class="row">
					<label class="2u 3u(mobile)">应付金额</label>
					<div class="10u 9u(mobile)">
						<span class="f24">${ptrade.orderAmount?string.currency}</span>元
					</div>
				</div>
			</div>
		</div>
		<div class="pay_order">
			<div class="rest_form">
				<div class="row">
					<label class="2u 12u(mobile)">账户支付</label>
					<div class="10u 12u(mobile)">
						<ul class="account_list">
							<#if participantInList?exists>
								<#list participantInList as participant>
									<li id="${participant.id}" <#if !participant.orderAmount?exists||participant.orderAmount=0>class="disable"<#else>class="active"</#if> >
										<input type="checkbox" name="accountbox" id="box${participant.id}" value="${participant.id}" 
										<#if !participant.orderAmount?exists||participant.orderAmount=0>disabled="disabled"<#else>checked="checked" </#if> onclick="calMoney()"/>
										<label for="box${participant.id}">
											<p class="clearfix">
												<span class="float_left">${participant.faccountName?default("基本户")}账户 余额 
												<#if participant.orderAmount?exists >
													${participant.orderAmount?string.currency}
												<#else>
													￥0.00
												</#if> 元</span>
												<span class="float_right"><#if !participant.orderAmount?exists||participant.orderAmount=0>金额不足，可先充值<#else>支付&nbsp;<font class="orange" id="chooseMoney">
												<#if (participant.orderAmount > ptrade.orderAmount) >
													${ptrade.orderAmount?string.currency}
													<#else>
													${participant.orderAmount?string.currency}
												</#if>
												</font>&nbsp;元</#if></span>
											</p>
										</label>
										<input type="hidden" value="${participant.orderAmount?default('0')}" id="money"/>
										<input type="hidden" value="${participant.dicActorCode}" id="dicActorCode"/>
										<input type="hidden" value="${participant.faccountName}" id="faccountName"/>
										<input type="hidden" value="${participant.faccountId}" id="faccountId"/>
										<input type="hidden" value="${participant.fchannelCode}" id="fchannelCode"/>
										<input type="hidden" value="${participant.fchannelClassifyCode}" id="fchannelClassifyCode"/>
										<input type="hidden" value="0" id="orderAmount" name="orderAmount"/>
									</li>
								</#list>
							</#if>
						</ul>
					</div>
				</div>
				<div class="info_list" id="needlast1">
					<div class="row">
						<label class="2u 12u(mobile)">还需支付</label>
						<div class="10u 12u(mobile)">
							<p>￥<span class="orange f22" id="lastMoney">0.00</span>元</p>
						</div>
					</div>
				</div>
				<div class="row" id="needlast2">
					<label class="2u 12u(mobile)"></label>
					<div class="10u 12u(mobile)">
						<ul class="account_list">
							<#if participantOutList?exists>
								<#list participantOutList as participant>
									<li id="${participant.id}" name="partRadio" >
										<input type="radio" name="bankPay" id="radoio${participant.id}" value="${participant.id}" onclick="chooseBank()"/>
										<label for="radoio${participant.id}">
											<p class="clearfix">
												<span class="float_left bank_name"><img src="${participant.imgPath!''}">&nbsp;${participant.faccountName}</span>
												<span class="float_left"></span>
												<span class="float_right" id="bankMoney"></span>
											</p>
										</label>
										<input type="hidden" value="${participant.dicActorCode}" id="dicActorCode"/>
										<input type="hidden" value="${participant.faccountName}" id="faccountName"/>
										<input type="hidden" value="${participant.fchannelCode}" id="fchannelCode"/>
										<input type="hidden" value="${participant.fchannelClassifyCode}" id="fchannelClassifyCode"/>
										<input type="hidden" value="0" id="orderAmount" name="orderAmount"/>
									</li>
								</#list>
							</#if>
						</ul>
					</div>
				</div>
				<div style="display: none">
					<a href="${sysAppContextPath}/web/pa/payment/paymentFormSubmit?ptradeSeqno=${ptrade.ptradeSeqno}" id="formCommit" target="_blank"></a>
				</div>
				<div class="info_list" style="display:none;" id="pwd">
					<div class="row">
						<label class="2u 12u(mobile)">支付密码</label>
						<div class="10u 12u(mobile)">
							<input type="password" id="password" placeholder="请输入支付密码" class="message_input" />
						</div>
					</div>
				</div>
				<div class="info_list">
					<div class="row">
						<label class="2u 12u(mobile)"></label>
						<div class="10u 12u(mobile)">
							<p class="margin_top10"><button id="subButton" onclick="paymentCommit();" class="button bg_blue">提交</button></p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<div id="alertBox" style="display: none;">
	<div class="recharge_alter">
		<div class="align-center"><img src="${path_servername}/${webRoot}/yqb/images/loading-0.gif" /></div>
		<br />
		<p>支付成功前，请不要关闭此验证窗口 </p>
		<p>支付完成后，请根据您的实际情况点击下面的按钮</p>
		<br /><br />
		<p class="align-center">
			<a href="${sysAppContextPath}/web/vd/account/view" class="button bg_green">支付成功</a>&nbsp;&nbsp;&nbsp;
			<a href="${sysAppContextPath}/web/vd/account/view" class="button bg_blue">支付遇到问题</a>
		</p>
	</div>
</div>
</body>
<script type="text/javascript">
// 标识是否需要输入交易密码
var pwdFlag=true;
calMoney();
var flag;
// checkbox选择
function calMoney(){
	flag = false;
	var checklist = document.getElementsByName("accountbox");
	var allMoney = ${ptrade.orderAmount};
	allMoney = parseFloat(allMoney);
	var chooseMoney = 0;
	for(var i=0;i<checklist.length;i++){
		var id = checklist[i].value;
		var money = $("#"+id).find("#money").val();
		money = parseFloat(money);
		if(checklist[i].checked){
			pwdFlag = true;
			$("#pwd").css("display","");
			if(allMoney > money){
				chooseMoney = parseFloat(money);
			}else{
				flag = true;
				chooseMoney = allMoney;
			}
			$("#"+id).find("#orderAmount").val(chooseMoney);
			$("#"+id).find("#chooseMoney").html(Number(chooseMoney).toFixed(2));
			$("#"+id).attr("class","active");
		} else{
			pwdFlag = false;
			$("#pwd").css("display","none");
			$("#"+id).find("#orderAmount").val(0);
			$("#"+id).find("#chooseMoney").html("0.00");
			$("#"+id).attr("class","");
		}
		break;
	}
	var lastMoney = Number(allMoney-chooseMoney).toFixed(2);
	$("#lastMoney").html(lastMoney);
	chooseBank();
}
// radio选择
function chooseBank(){
	var list = $("input[name='bankPay']");
	for(var i=0;i<list.length;i++){
		if(flag){
			list[i].disabled="disabled";
			list[i].checked = false;
		}else{
			list[i].disabled="";
		}
		var bankId = list[i].value;
		if(list[i].checked){
			var htmlStr = "支付&nbsp;<font class='orange' >" + $("#lastMoney").html() + "</font>&nbsp;元"
			$("#"+bankId).find("#bankMoney").html(htmlStr);
			$("#"+bankId).find("#orderAmount").val($("#lastMoney").html());
		}else{
			$("#"+bankId).find("#bankMoney").html("");
			$("#"+bankId).find("#orderAmount").val(0);
		}
	}
	checkMoney();
}

// 校验金额，控制提交按钮
function checkMoney(){
	var orderAmount = ${ptrade.orderAmount};
	orderAmount = parseFloat(orderAmount);
	var payMoneys = document.getElementsByName("orderAmount");
	var payAll = 0;
	for(var i=0;i<payMoneys.length;i++){
		var money = payMoneys[i].value;
		money = parseFloat(money);
		payAll += money;
	}
	if(payAll != orderAmount){
		$("#subButton").attr("disabled",true);
	} else{
		$("#subButton").attr("disabled",false);
	}
}

function checkPwd(){
	var msg = "";
	var pwd = $("#password").val();
	if(pwd=="")
		return "请输入交易密码";
	var config = {
		url : _sysAppContextPath+'/web/pa/payment/checkPwd',
		postData : {"pwd":pwd},
		onSuccessFunction:function(data){
			if(data.sysRecode == "error"){
				msg = data.msg;
			}
		},
		async:false
	};
	myAjaxRequest(config);
	return msg;
}


function paymentCommit(){
	$("#subButton").attr("disabled",true);
	if(pwdFlag){
		var msg = checkPwd();
		if(msg !="" && msg!= null && msg != "null"){
			alert(msg);
			$("#subButton").attr("disabled",false);
			return;
		}
	}
	var checkMoney = 0;
	var checklist = document.getElementsByName("accountbox");
	var arrays = new Array();
	for(var i=0;i<checklist.length;i++){
		var id = checklist[i].value;
		if(checklist[i].checked){
			var dicActorCode = $("#"+id).find("#dicActorCode").val();
			var faccountName = $("#"+id).find("#faccountName").val();
			var faccountId = $("#"+id).find("#faccountId").val();
			var fchannelCode = $("#"+id).find("#fchannelCode").val();
			var fchannelClassifyCode = $("#"+id).find("#fchannelClassifyCode").val();
			var orderAmount = $("#"+id).find("#orderAmount").val();
			orderAmount = parseFloat(orderAmount);
			checkMoney += orderAmount;
			arrays.push({"dicActorCode":dicActorCode,
						 "faccountName":faccountName,
						 "faccountId":faccountId,
						 "fchannelCode":fchannelCode,
					 	 "fchannelClassifyCode":fchannelClassifyCode,
					 	 "orderAmount":orderAmount});
		}
	}
	var list = $("input[name='bankPay']");
	for(var i=0;i<list.length;i++){
		var bankId = list[i].value;
		if(list[i].checked){
			if($("#lastMoney").html() == "0.00")
				break;
			var htmlStr = "支付&nbsp;<font class='orange' >" + $("#lastMoney").html() + "</font>&nbsp;元"
			var dicActorCode = $("#"+bankId).find("#dicActorCode").val();
			var faccountName = $("#"+bankId).find("#faccountName").val();
			var fchannelCode = $("#"+bankId).find("#fchannelCode").val();
			var fchannelClassifyCode = $("#"+bankId).find("#fchannelClassifyCode").val();
			var orderAmount = $("#"+bankId).find("#orderAmount").val();
			orderAmount = parseFloat(orderAmount);
			checkMoney += orderAmount;
			arrays.push({"dicActorCode":dicActorCode,
						 "faccountName":faccountName,
						 "fchannelCode":fchannelCode,
					 	 "fchannelClassifyCode":fchannelClassifyCode,
					 	 "orderAmount":orderAmount});
		}
	}
	var ptradeBean = {};
	ptradeBean.ptradeSeqno = "${ptrade.ptradeSeqno}";
	if($("#lastMoney").html() == "0.00"){
		ptradeBean.fchannelMode = "1";
	} else{
		ptradeBean.fchannelMode = "0";
	}
	ptradeBean.fchannelPmodeCode='${browType}';
	ptradeBean.partList = arrays;
	ptradeBean.openId='${openId?if_exists}';
	var browType = "${browType?if_exists}";
	
		var config = {
			url : uri= _sysAppContextPath+'/web/pa/payment/paymentCommit',
			postData : JSON.stringify(ptradeBean),
			contentType : 'application/json;charset=UTF-8',
			async:false,
			onSuccessFunction : function(data) {
				if(data.sysRecode == 'error'){
					alert(data.msg);
					return;
				}
				if(ptradeBean.fchannelMode == "1"){
					var urlstr = _sysAppContextPath+"/laserDirect/http/get/ctest/${ptrade.tenantCode}/WEB?ptradeSeqno=${ptrade.ptradeSeqno}";
					location.href=urlstr;
				} else{
					if(browType == "WEB"){
						alertBox();
					}else if(browType == "JSAPI"&& ptradeBean.partList[0].fchannelCode=='wechatjs'){
						$.get('${sysAppContextPath}/web/pa/payment/paymentFormWeChatSubmit?ptradeSeqno=${ptrade.ptradeSeqno}',function(data){
							if(data!=null){
						   		WeixinJSBridge.invoke(
							       'getBrandWCPayRequest',JSON.parse(data.bankHtmlForm.htmlStr),
							       function(res){     
							           if(res.err_msg == "get_brand_wcpay_request:ok" ) {
							        	   	 var urlstr ="${sysAppContextPath}/laserDirect/http/get/"+ptradeBean.partList[0].fchannelCode+"/${ptrade.tenantCode}/JSAPI?ptradeSeqno=${ptrade.ptradeSeqno}";
							        	 //  var urlstr = "${sysAppContextPath}/laserDirect/bankReturnBack?flag=true";
							        	 	location.href=urlstr;
							         }   
							       }
							   );
							}
						});
						return;
					}
					
					document.getElementById("formCommit").click();
	// 				window.open(_sysAppContextPath+"/web/pa/payment/paymentFormSubmit");
	// 				bankSubmit(data.dataObj, browType);
				}
			},
			mask : false
		};
		myAjaxRequest(config);

}

function bankSubmit(obj, browType){
	var form = $(obj.bankHtmlForm.htmlStr);
	if(browType == "WEB"){
		form.attr("target", "_blank");
	}
	form.appendTo("body");
    form.submit();
}

function alertBox(){
	var index = layer.open({
		type: 1,
		
		skin: 'layui-layer-lan',
		shift: 4,
		title: '提示信息',
		area: ['350px', '250px'],
		content: $('#alertBox')
	});
}

$('#alertBox').on('click', function() {
	$('.closeLayer').on('click', function() {
		layer.close(index);
	});
});

document.onkeydown = function(e){
	var ev = window.event || e;
    var code = ev.keyCode || ev.which;
    if (code == 116 || code == 82) {
        if(ev.preventDefault) {
            ev.preventDefault();
        } else {
            ev.keyCode = 0;
            ev.returnValue = false;
        }
    }
}
document.oncontextmenu = function(e) {
	var ev = window.event || e;
	if(ev.preventDefault) {
        ev.preventDefault();
    } else {
        ev.keyCode = 0;
        ev.returnValue = false;
    }
}
</script>