/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.util.tongshangyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.Base64;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenUtils;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretUtils {
    private static Provider provider = new BouncyCastleProvider();
    private static Logger logger = LoggerFactory.getLogger(SecretUtils.class);

    private SecretUtils() {
    }

    public static String getSignedValue(Map<String, Object> reqMap) {
        TreeMap<String, String> copy = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : reqMap.entrySet()) {
            if (entry.getValue() == null) continue;
            copy.put(entry.getKey(), entry.getValue().toString());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : copy.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    public static String sign(PrivateKey privateKey, String text, String algorithm) throws Exception {
        String signedValue = SecretUtils.md5(text);
        Signature signature = Signature.getInstance(algorithm, provider);
        signature.initSign(privateKey);
        signature.update(signedValue.getBytes("utf8"));
        byte[] data = signature.sign();
        return Base64.encode(data);
    }

    public static String htSign(PrivateKey privateKey, String text) throws Exception {
        Signature signature = Signature.getInstance("SHA1WithRSA", provider);
        signature.initSign(privateKey);
        signature.update(text.getBytes("utf8"));
        byte[] data = signature.sign();
        return Base64.encode(data);
    }

    public static boolean verify(PublicKey publicKey, String text, String sign) throws Exception {
        if (OpenUtils.isEmpty(sign)) {
            return false;
        }
        String signedValue = SecretUtils.md5(text);
        Signature signature = Signature.getInstance("SHA256WithRSA", provider);
        signature.initVerify(publicKey);
        signature.update(signedValue.getBytes("UTF-8"));
        byte[] signed = Base64.decode(sign);
        return signature.verify(signed);
    }

    public static String md5(String src) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            result = Base64.encode(md.digest(src.getBytes("utf-8")));
        }
        catch (Exception var3) {
            logger.error(var3.getMessage(), (Throwable)var3);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadPrivateKey(String alias, String path, String password) throws Exception {
        PrivateKey var11;
        try (FileInputStream ksfis = null;){
            Enumeration<String> aliases;
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ksfis = new FileInputStream(path);
            char[] storePwd = password.toCharArray();
            char[] keyPwd = password.toCharArray();
            ks.load(ksfis, storePwd);
            if (OpenUtils.isEmpty(alias) && (aliases = ks.aliases()).hasMoreElements()) {
                alias = aliases.nextElement();
            }
            var11 = (PrivateKey)ks.getKey(alias, keyPwd);
        }
        return var11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadPublicKey(String alias, String path, String password) throws Exception {
        PublicKey var10;
        try (FileInputStream ksfis = null;){
            Enumeration<String> aliases;
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ksfis = new FileInputStream(path);
            char[] storePwd = password.toCharArray();
            ks.load(ksfis, storePwd);
            if (OpenUtils.isEmpty(alias) && (aliases = ks.aliases()).hasMoreElements()) {
                alias = aliases.nextElement();
            }
            var10 = ks.getCertificate(alias).getPublicKey();
        }
        return var10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadTLPublicKey(String certPath) throws Exception {
        FileInputStream certInputStream = null;
        PublicKey pubKey = null;
        CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
        try {
            certInputStream = new FileInputStream(certPath);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(certInputStream);
            pubKey = cert.getPublicKey();
        }
        finally {
            if (certInputStream != null) {
                certInputStream.close();
            }
        }
        return pubKey;
    }

    public static RSAPublicKey generateRSAPublicKey(byte[] modulus, byte[] publicExponent) throws Exception {
        KeyFactory keyFac = KeyFactory.getInstance("RSA", provider);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
        return (RSAPublicKey)keyFac.generatePublic(pubKeySpec);
    }

    public static RSAPrivateKey generateRSAPrivateKey(byte[] modulus, byte[] privateExponent) throws Exception {
        KeyFactory keyFac = KeyFactory.getInstance("RSA", provider);
        RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(privateExponent));
        return (RSAPrivateKey)keyFac.generatePrivate(priKeySpec);
    }

    public static String getPublicKeyString(RSAPublicKey key) throws Exception {
        String exponent = SecretUtils.byte2hex(key.getPublicExponent().toByteArray());
        String modulus = SecretUtils.byte2hex(key.getModulus().toByteArray());
        StringBuilder sb = new StringBuilder();
        sb.append(modulus).append(" ").append(exponent);
        return sb.toString();
    }

    public static String getPrivateKeyString(RSAPrivateKey key) throws Exception {
        String exponent = SecretUtils.byte2hex(key.getPrivateExponent().toByteArray());
        String modulus = SecretUtils.byte2hex(key.getModulus().toByteArray());
        StringBuilder sb = new StringBuilder();
        sb.append(modulus).append(" ").append(exponent);
        return sb.toString();
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder retString = new StringBuilder();
        byte[] var2 = bytes;
        int var3 = bytes.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            retString.append(hex.toUpperCase());
        }
        return retString.toString();
    }

    public static byte[] hex2byte(String src) {
        if (src.length() % 2 != 0) {
            src = src + "0";
        }
        byte[] ret = new byte[src.length() / 2];
        byte[] tmp = src.getBytes();
        for (int i = 0; i < src.length() / 2; ++i) {
            ret[i] = SecretUtils.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
        }
        return ret;
    }

    public static byte uniteBytes(byte src0, byte src1) {
        byte b0 = Byte.decode("0x" + new String(new byte[]{src0}));
        b0 = (byte)(b0 << 4);
        byte b1 = Byte.decode("0x" + new String(new byte[]{src1}));
        return (byte)(b0 ^ b1);
    }

    public static String encryptAES(String plainText, String privateKey) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(privateKey.getBytes());
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = plainText.getBytes("utf-8");
            cipher.init(1, secretKeySpec);
            byte[] byteRresult = cipher.doFinal(byteContent);
            String sb = "";
            byte[] var11 = byteRresult;
            int var12 = byteRresult.length;
            for (int var13 = 0; var13 < var12; ++var13) {
                byte element = var11[var13];
                String hex = Integer.toHexString(element & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb = sb.concat(hex.toUpperCase());
            }
            return sb;
        }
        catch (Exception var16) {
            return null;
        }
    }

    public static String decryptAES(String cipherText, String privateKey) {
        try {
            if (cipherText.length() < 1) {
                return null;
            }
            byte[] byteRresult = new byte[cipherText.length() / 2];
            for (int i = 0; i < cipherText.length() / 2; ++i) {
                int high = Integer.parseInt(cipherText.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(cipherText.substring(i * 2 + 1, i * 2 + 2), 16);
                byteRresult[i] = (byte)(high * 16 + low);
            }
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(privateKey.getBytes());
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] result = cipher.doFinal(byteRresult);
            return new String(result);
        }
        catch (Exception var10) {
            return null;
        }
    }

    public static String encodeOnce(Map<String, String> jo) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : jo.entrySet()) {
                String value = entry.getValue() == null ? "" : entry.getValue();
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "utf-8")).append("&");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static Map<String, String> verify(String resp, PublicKey publicKey) throws Exception {
        JSONObject map = JSON.parseObject((String)resp);
        String sign = map.getString("sign");
        map.remove((Object)"sign");
        String signedValue = JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        if (!SecretUtils.verify(publicKey, signedValue, sign)) {
            throw new Exception("verify sign error");
        }
        return (Map)JSON.parseObject((String)resp, Map.class);
    }
}

