/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.jindie.domain.OcContractDomain;
import com.yqbsoft.laser.service.jindie.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.jindie.domain.OcRefundDomain;
import com.yqbsoft.laser.service.jindie.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.jindie.model.BizParameter;
import com.yqbsoft.laser.service.jindie.model.OpenResponse;
import com.yqbsoft.laser.service.jindie.model.UmUser;
import com.yqbsoft.laser.service.jindie.model.UmUserDomainBean;
import com.yqbsoft.laser.service.jindie.model.UmUserinfo;
import com.yqbsoft.laser.service.jindie.model.UmUserinfoQua;
import com.yqbsoft.laser.service.jindie.service.MemberSettleInService;
import com.yqbsoft.laser.service.jindie.util.ImageUtil;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenClient;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenConfig;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.SecretUtils;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.TongShangYunConfig;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberSettleInServiceImpl
extends BaseServiceImpl
implements MemberSettleInService {
    private static final String SYS_CODE = "service.jindie.MemberSettleInServiceImpl";
    private static OpenConfig openConfig = null;

    public OpenConfig getConfig(String tenantCode) {
        if (null == openConfig) {
            openConfig = this.getOpenConfig(tenantCode);
        }
        return openConfig;
    }

    @Override
    public String createMember(UmUser umUser, UmUserinfo umUserinfo) {
        UmUserinfoDomainBean umUserinfoDomainBean;
        Map dataMap;
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.createMember into ", (Object)(JsonUtil.buildNormalBinder().toJson((Object)umUser) + " ==:== " + JsonUtil.buildNormalBinder().toJson((Object)umUserinfo)));
        if (null == umUser || null == umUserinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.createMember.map", (Object)"null");
            return this.resultMaInformation("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("umUser\uff1a" + umUser.getUserCode());
        String method = "allinpay.yunst.memberService.createMember";
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, "SDX_" + System.currentTimeMillis());
        if ("dealer".equals(umUserinfo.getUserinfoQuality())) {
            param.put(TongShangYunConfig.memberType, 3);
            param.put(TongShangYunConfig.source, 1);
        } else {
            param.put(TongShangYunConfig.memberType, 2);
            param.put(TongShangYunConfig.source, 2);
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.createMember.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        try {
            response = this.getClient(umUser.getTenantCode()).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.createMemberResponse.rep", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.createMemberResponse.e", (Throwable)e);
            return this.resultMaInformation("error", "\u8bf7\u6c42\u6216\u8005\u89e3\u6790\u5931\u8d25");
        }
        if (null != response && response.getCode().equals(TongShangYunConfig.resultOK) && response.getSubCode().equals(TongShangYunConfig.OK)) {
            String data = response.getData();
            if (StringUtils.isEmpty((String)response.getData())) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.createMemberResponse.rep.data", (Object)"data is null");
                this.updateUserInfoStatus(umUser, umUserinfo, 8, null);
                return this.resultMaInformation("error", "\u521b\u5efa\u901a\u5546\u4e91\u4f1a\u5458\u5931\u8d25");
            }
            dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, String.class);
            UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
            try {
                BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUserinfo);
                BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            umUserDomainBean.setTenantCode(umUser.getTenantCode());
            umUserDomainBean.setUserCode(umUser.getUserCode());
            if (null == dataMap.get(TongShangYunConfig.bizUserId)) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.createMemberResponse.bizUserId", (Object)"\u4f1a\u5458code\u4e3a\u7a7a");
                this.updateUserInfoStatus(umUser, umUserinfo, 8, null);
                return this.resultMaInformation("error", "\u4f1a\u5458code\u4e3a\u7a7a");
            }
            umUserinfo.setUserinfoOcode((String)dataMap.get(TongShangYunConfig.bizUserId));
            umUserDomainBean.setUserOcode((String)dataMap.get(TongShangYunConfig.bizUserId));
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            this.getInternalRouter().inInvoke("um.userbase.updateUserByCode", updateMap);
            umUserinfoDomainBean = new UmUserinfoDomainBean();
            try {
                BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserinfo);
                BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return this.resultMaInformation("false", null);
        }
        umUserinfoDomainBean.setUserinfoOcode((String)dataMap.get(TongShangYunConfig.bizUserId));
        this.getInternalRouter().inInvoke("um.userbase.updateUserinfoByUserinfoCode", this.getQueryParamMap("umUserinfoDomainBean", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean)}));
        this.updateUserInfoStatus(umUser, umUserinfo, 7, null);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.createMemberResponse.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return "success";
    }

    @Override
    public String sendVerificationCode(Map<String, Object> map) {
        OpenResponse response;
        this.logger.info("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCodeCollectionFlow.map", (Object)"null");
            return "null";
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        String userinfoOcode = this.getUserinfoOcode(map.get("userInfoCode").toString(), map.get("tenantCode").toString());
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCodeCollectionFlow.getUserinfoOcode null", (Object)(map.get("userInfoCode").toString() + " ==:== " + map.get("tenantCode").toString()));
            return null;
        }
        String method = "allinpay.yunst.memberService.sendVerificationCode";
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, userinfoOcode);
        param.put(TongShangYunConfig.phone, map.get(TongShangYunConfig.phone));
        param.put(TongShangYunConfig.verificationCodeType, map.get(TongShangYunConfig.verificationCodeType));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        try {
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode response:" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.e", (Throwable)e);
            return "null";
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendVerificationCode.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String bindPhone(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        UmUserinfo umUserinfo = this.getUmUserinfo(map);
        if (null == umUserinfo || StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.getUmUserinfo", (Object)("umUserinfo is null ==:== " + JsonUtil.buildNormalBinder().toJson(map)));
            return null;
        }
        String method = "allinpay.yunst.memberService.bindPhone";
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.phone, map.get(TongShangYunConfig.phone));
        param.put(TongShangYunConfig.verificationCode, map.get(TongShangYunConfig.verificationCode));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        try {
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.rep", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhoneCollectionFlow", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 11, null);
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.data", (Object)"data is null");
            this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 11, null);
            return null;
        }
        HashMap updateMap = new HashMap();
        updateMap.put("bingPhone", param.get(TongShangYunConfig.phone));
        this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 10, null);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.bindPhone.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    public void updateUmUserInfo(String userInfoCode, String conQq, String tenantCode, Map<String, Object> map) {
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        umUserinfoDomainBean.setUserinfoConPhone(null == map ? "" : (null == map.get("phone") ? "" : map.get("phone").toString()));
        umUserinfoDomainBean.setUserinfoCode(userInfoCode);
        umUserinfoDomainBean.setTenantCode(tenantCode);
        umUserinfoDomainBean.setUserinfoConQq(conQq);
        this.updateUserInfo(umUserinfoDomainBean);
    }

    @Override
    public String unbindPhone(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.userInfoOcode", (Object)"userInfoOcode or tenantCode is null");
            return "null";
        }
        UmUserinfo umUserinfo = this.getUmUserinfo(map);
        if (null == umUserinfo || StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.getUmUserinfo", (Object)("umUserinfo is null ==:== " + JsonUtil.buildNormalBinder().toJson(map)));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.phone, map.get(TongShangYunConfig.phone));
        param.put(TongShangYunConfig.verificationCode, map.get(TongShangYunConfig.verificationCode));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        try {
            String method = "allinpay.yunst.memberService.unbindPhone";
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.rep", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.e", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.data", (Object)"data is null");
            return null;
        }
        this.updateUmUserInfo(umUserinfo.getUserinfoCode(), "1,4,0,0", umUserinfo.getTenantCode(), null);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.unbindPhone.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String getBankCardBin(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.map", (Object)" map is null");
            return null;
        }
        BizParameter param = new BizParameter();
        try {
            param.put("cardNo", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("cardNo")));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            String method = "allinpay.yunst.memberService.getBankCardBin";
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.e", (Throwable)e);
            return "null";
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.data", (Object)"data is null");
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.getBankCardBin.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String setCompanyInfo(UmUser umUser, UmUserinfo umUserinfo) {
        OpenResponse response;
        if (null == umUser || null == umUserinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.param", (Object)"umUser or umUserinfo is null");
            return this.resultMaInformation("error", "\u5165\u53c2\u6570\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.into", (Object)umUserinfo.getUserinfoCode());
        if (StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.userinfoOcode", (Object)"userinfoOcode is null");
            return this.resultMaInformation("error", "userinfoOcode is null");
        }
        List<UmUserinfoQua> umUserinfoQuaList = this.getUmUserinfoQuaList(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode());
        if (ListUtil.isEmpty(umUserinfoQuaList)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.queryUserinfo", (Object)(umUserinfo.getUserinfoCode() + " =:= " + umUserinfo.getTenantCode()));
            return this.resultMaInformation("error", "\u4f01\u4e1a\u4fe1\u606f\u8ba4\u8bc1\u5931\u8d25 \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        Map<String, String> userinfoQuaMap = this.covetListToMap(umUserinfoQuaList);
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.backUrl, null);
        param.put("isAuth", true);
        Map<String, Object> companyBasicInfo = this.makeCompanyReqParam(userinfoQuaMap);
        if (MapUtil.isEmpty(companyBasicInfo)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.makeCompanyReqParam.null", (Object)(umUserinfo.getUserinfoCode() + "  \u7f3a\u5c11\u8ba4\u8bc1\u4fe1\u606f"));
            return this.resultMaInformation("error", "\u7f3a\u5c11\u8ba4\u8bc1\u4fe1\u606f");
        }
        try {
            if (null != userinfoQuaMap.get("legalIds")) {
                companyBasicInfo.put("legalIds", this.getClient(umUserinfo.getTenantCode()).encrypt(userinfoQuaMap.get("legalIds")));
            }
            param.put("companyBasicInfo", companyBasicInfo);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            String method = "allinpay.yunst.memberService.setCompanyInfo";
            response = this.getClient(umUserinfo.getTenantCode()).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.updateUserInfoStatus(umUser, umUserinfo, 20, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.e", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.updateUserInfoStatus(umUser, umUserinfo, 20, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.updateUserInfoStatus(umUser, umUserinfo, 20, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.updateUserInfoStatus(umUser, umUserinfo, 20, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.data", (Object)"data is null");
            return null;
        }
        String data = response.getData();
        this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.data", (Object)data);
        Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, String.class);
        if ("3".equals(dataMap.get("result"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.data.result", dataMap.get("failReason"));
            this.updateUserInfoStatus(umUser, umUserinfo, 20, (String)dataMap.get("failReason"));
            return this.resultMaInformation("error", "\u5ba1\u6838\u5931\u8d25 " + (String)dataMap.get("failReason"));
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.setCompanyInfo.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        this.updateUserInfoStatus(umUser, umUserinfo, 21, null);
        return "success";
    }

    private Map<String, Object> makeCompanyReqParam(Map<String, String> map) {
        LinkedHashMap<String, Object> companyBasicInfo = new LinkedHashMap<String, Object>();
        if (StringUtils.isEmpty((String)map.get("companyName"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.companyName", (Object)"companyName is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("legalName"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.legalName", (Object)"legalName is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("legalIds"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.legalIds", (Object)"legalIds is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("identityType"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.identityType", (Object)"identityType is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("legalPhone"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.legalPhone", (Object)"legalPhone is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("parentBankName"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.parentBankName", (Object)"parentBankName is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("bankName"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.bankName", (Object)"bankName is null");
            return null;
        }
        if (StringUtils.isEmpty((String)map.get("unionBank"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.makeCompanyReqParam.unionBank", (Object)"unionBank is null");
            return null;
        }
        companyBasicInfo.put("companyName", map.get("companyName"));
        if (null != map.get("companyAddress")) {
            companyBasicInfo.put("companyAddress", map.get("companyAddress"));
        }
        if (null != map.get("authType")) {
            companyBasicInfo.put("authType", map.get("authType"));
        }
        if (null != map.get("uniCredit")) {
            companyBasicInfo.put("uniCredit", "uniCredit");
        }
        if (null != map.get("businessLicense")) {
            companyBasicInfo.put("businessLicense", map.get("businessLicense"));
        }
        if (null != map.get("organizationCode")) {
            companyBasicInfo.put("organizationCode", map.get("organizationCode"));
        }
        if (null != map.get("taxRegister")) {
            companyBasicInfo.put("taxRegister", map.get("taxRegister"));
        }
        if (null != map.get("expLicense")) {
            companyBasicInfo.put("expLicense", map.get("expLicense"));
        }
        if (null != map.get("telephone")) {
            companyBasicInfo.put("telephone", map.get("telephone"));
        }
        if (null != map.get("legalName")) {
            companyBasicInfo.put("legalName", map.get("legalName"));
        }
        if (null != map.get("identityType")) {
            companyBasicInfo.put("identityType", map.get("identityType"));
        }
        if (null != map.get("legalPhone")) {
            companyBasicInfo.put("legalPhone", map.get("legalPhone"));
        }
        if (null != map.get("accountNo")) {
            companyBasicInfo.put("accountNo", map.get("accountNo"));
        }
        if (null != map.get("parentBankName")) {
            companyBasicInfo.put("parentBankName", map.get("parentBankName"));
        }
        if (null != map.get("bankCityNo")) {
            companyBasicInfo.put("bankCityNo", map.get("bankCityNo"));
        }
        if (null != map.get("bankName")) {
            companyBasicInfo.put("bankName", map.get("bankName"));
        }
        if (null != map.get("unionBank")) {
            companyBasicInfo.put("unionBank", map.get("unionBank"));
        }
        if (null != map.get("province")) {
            companyBasicInfo.put("province", map.get("province"));
        }
        if (null != map.get("city")) {
            companyBasicInfo.put("city", map.get("city"));
        }
        return companyBasicInfo;
    }

    @Override
    public String idcardCollect(UmUser umUser, UmUserinfo umUserinfo) {
        if (null == umUser || null == umUserinfo) {
            return this.resultMaInformation("error", "\u5165\u53c2\u4e3a\u7a7a");
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.into", (Object)umUserinfo.getUserinfoCode());
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", umUserinfo.getTenantCode());
        queryMap.put("userinfoCode", umUserinfo.getUserinfoCode());
        List umUserinfoQuaList = (List)this.getInternalRouter().inInvoke("um.userinfoQua.queryUserinfo", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(queryMap)}));
        if (ListUtil.isEmpty((Collection)umUserinfoQuaList)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.queryUserinfo", (Object)JsonUtil.buildNormalBinder().toJson(queryMap));
            return this.resultMaInformation("error", "\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        Map<String, String> userinfoQuaMap = this.covetListToMap(umUserinfoQuaList);
        String method = "allinpay.yunst.memberService.idcardCollect";
        BizParameter param = new BizParameter();
        if (StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.userinfoOcode", (Object)"userinfoOcode is null");
            return this.resultMaInformation("error", "userinfoOcode \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.ocrComparisonResultBackUrl, this.getDdFlag("TSY", "OCR_BACKURL", umUserinfo.getTenantCode()));
        String picture = userinfoQuaMap.get("picture");
        if (StringUtils.isEmpty((String)picture)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.picture", (Object)"picture is null");
            return this.resultMaInformation("error", "picture \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.picture", (Object)picture);
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(picture, String.class, String.class);
        if (map.containsKey("1") && map.containsKey("8") && map.containsKey("9") && StringUtils.isEmpty((String)((String)map.get("1"))) && StringUtils.isEmpty((String)((String)map.get("8"))) && StringUtils.isEmpty((String)((String)map.get("9")))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.picture", (Object)"picture \u7f3a\u5931\u4e0d\u5141\u8bb8\u5f71\u5370");
            return this.resultMaInformation("error", "picture \u7f3a\u5931\u4e0d\u5141\u8bb8\u5f71\u5370\uff01\uff01\uff01");
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            OpenResponse response;
            param.put(TongShangYunConfig.picType, entry.getKey());
            param.put(TongShangYunConfig.picture, ImageUtil.imageUrlToBase64((String)entry.getValue()));
            try {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
                response = this.getClient((String)map.get("tenantCode")).execute(method, param);
                this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            }
            catch (Exception e) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.e", (Throwable)e);
                this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 26, null);
                break;
            }
            if (response == null) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.response", (Object)"response is null");
                this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 26, null);
                break;
            }
            if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
                this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 26, null);
                break;
            }
            if (!StringUtils.isEmpty((String)response.getData())) continue;
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.data", (Object)"data is null");
            this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 25, null);
            break;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollect.end");
        return "success";
    }

    @Override
    public String idcardCollectNotice(String bizUserId, String ocrRegnumComparisonResult, String ocrIdcardComparisonResult, String resultInfo, String tenantCode) {
        this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollectNotice.intoParam", (Object)(bizUserId + " =:= " + ocrIdcardComparisonResult + " =:= " + ocrIdcardComparisonResult + " =:= " + resultInfo + " =:= " + tenantCode));
        if (StringUtils.isEmpty((String)bizUserId) || StringUtils.isEmpty((String)ocrRegnumComparisonResult) || StringUtils.isEmpty((String)ocrIdcardComparisonResult) || StringUtils.isEmpty((String)resultInfo) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollectNotice.null", (Object)(bizUserId + " =:= " + ocrIdcardComparisonResult + " =:= " + ocrIdcardComparisonResult + " =:= " + resultInfo + " =:= " + tenantCode));
            return this.resultMaInformation("error", "\u53c2\u6570\u6709\u7f3a\u5931");
        }
        UmUserinfo userinfo = this.getUmUserInfoByOcode(bizUserId, tenantCode);
        if (null == userinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollectNotice.getUmUserInfoByOcode.null", (Object)(bizUserId + " =:= " + tenantCode));
            return this.resultMaInformation("error", "\u67e5\u65e0\u6b64\u7528\u6237");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPcode", userinfo.getUserinfoCode());
        map.put("tenantCode", tenantCode);
        String userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserList", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(map)}));
        List umUserList = (List)JsonUtil.buildNormalBinder().getJsonToList(userListJson, UmUser.class);
        if (ListUtil.isEmpty((Collection)umUserList)) {
            return this.resultMaInformation("error", "\u65e0\u6b64\u7528\u6237");
        }
        if ("1".equals(ocrRegnumComparisonResult) && "1".equals(ocrIdcardComparisonResult)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollectNotice.end.success", (Object)userinfo.getUserCode());
            this.updateUserInfoStatus((UmUser)umUserList.get(0), userinfo, 18, null);
            return this.resultMaInformation("success", null);
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.idcardCollectNotice.end", (Object)userinfo.getUserCode());
        this.updateUserInfoStatus((UmUser)umUserList.get(0), userinfo, 17, null);
        return this.resultMaInformation("success", null);
    }

    public UmUserinfo getUmUserInfoByOcode(String userInfoOcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userInfoOcode);
        map.put("tenantCode", tenantCode);
        String userInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", map);
        return (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userInfoJson, UmUserinfo.class);
    }

    @Override
    public String applyBindBankCard(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        String userinfoOcode = this.getUserinfoOcode(map.get("userInfoCode").toString(), map.get("tenantCode").toString());
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.getUserinfoOcode null", (Object)(map.get("userInfoCode").toString() + " ==:== " + map.get("tenantCode").toString()));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, userinfoOcode);
        param.put(TongShangYunConfig.phone, map.get(TongShangYunConfig.phone));
        param.put("cardCheck", null == map.get("cardCheck") ? "" : map.get("cardCheck"));
        param.put(TongShangYunConfig.name, map.get(TongShangYunConfig.name));
        param.put(TongShangYunConfig.identityType, map.get("identityType"));
        param.put("isSafeCard", false);
        param.put("unionBank", null == map.get("unionBank") ? "" : map.get("unionBank"));
        try {
            if (null != map.get("cvv2") && !"".equals(map.get("cvv2"))) {
                param.put("cvv2", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("cvv2")));
            }
            if (null != map.get("validate") && !"".equals(map.get("validate"))) {
                param.put("validate", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("validate")));
            }
            param.put("identityNo", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("identityNo")));
            param.put("cardNo", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("cardNo")));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            String method = "allinpay.yunst.memberService.applyBindBankCard";
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.e", (Throwable)e);
            return "null";
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.data", (Object)"data is null");
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.applyBindBankCard.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String bindBankCard(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.map", (Object)"map is null");
            return null;
        }
        UmUserinfo umUserinfo = this.getUmUserinfo(map);
        if (null == umUserinfo || StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.getUmUserinfo", (Object)"umUserinfo is null");
            return null;
        }
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put("tranceNum", null == map.get("tranceNum") ? "" : map.get("tranceNum"));
        param.put("transDate", null == map.get("transDate") ? "" : map.get("transDate"));
        param.put(TongShangYunConfig.phone, map.get(TongShangYunConfig.phone));
        param.put("verificationCode", map.get(TongShangYunConfig.verificationCode));
        try {
            if (null != map.get("cvv2") && !"".equals(map.get("cvv2"))) {
                param.put("cvv2", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("cvv2")));
            }
            if (null != map.get("validate") && !"".equals(map.get("validate"))) {
                param.put("validate", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("validate")));
            }
            String method = "allinpay.yunst.memberService.bindBankCard";
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.e", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return response.getCode();
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.data", (Object)"data is null");
            return response.getData();
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.bindBankCard.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public Object queryBankCard(Map<String, Object> map) {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        String userinfoOcode = this.getUserinfoOcode(map.get("userInfoCode").toString(), map.get("tenantCode").toString());
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.getUserinfoOcode null", (Object)(map.get("userInfoCode").toString() + " ==:== " + map.get("tenantCode").toString()));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, userinfoOcode);
        try {
            param.put("cardNo", this.getClient((String)map.get("tenantCode")).encrypt((String)map.get("cardNo")));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            String method = "allinpay.yunst.memberService.queryBankCard";
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.e", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.data", (Object)"data is null");
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.queryBankCard.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public Object sendUnBindBankCard(Map<String, Object> map, String tenantCode) throws ApiException {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        String userinfoOcode = this.getUserinfoOcode(map.get("userInfoCode").toString(), map.get("tenantCode").toString());
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.getUserinfoOcode null", (Object)(map.get("userInfoCode").toString() + " ==:== " + map.get("tenantCode").toString()));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, userinfoOcode);
        String method = "allinpay.yunst.memberService.unbindBankCard";
        OpenClient client = this.getClient(tenantCode);
        try {
            param.put("cardNo", client.encrypt((String)map.get("cardNo")));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            response = client.execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.e", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.response", (Object)"response is null");
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return response.getCode();
        }
        if (StringUtils.isEmpty((String)response.getData())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.data", (Object)"data is null");
            return response.getData();
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendUnBindBankCard.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public void notification(Map<String, Object> map) throws ApiException {
        Map<String, String> data;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.notification.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.notification.map", (Object)"map is null");
            return;
        }
        String body = (String)map.get("body");
        String configJsonStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2020122400000001-allinPay_config-allinPay_config");
        if (StringUtils.isEmpty((String)configJsonStr)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.tongshangyunConfig is null");
        }
        Map config = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configJsonStr, String.class, String.class);
        try {
            PublicKey publicKey = SecretUtils.loadTLPublicKey((String)config.get(""));
            data = SecretUtils.verify(body, publicKey);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.notification error", (Throwable)e);
            return;
        }
        if (MapUtil.isEmpty(data)) {
            return;
        }
        String notifyType = data.get("notifyType");
        if (!StringUtils.isEmpty((String)notifyType) && "allinpay.yunst.memberService.signContract".equals(notifyType)) {
            this.logger.info("\u4f1a\u5458\u7b7e\u7ea6\u7ed3\u679c\u901a\u77e5\uff1a" + JSON.toJSONString((Object)data.get("data")));
            JSONObject jsonObject = JSON.parseObject((String)data.get("data"));
            String bizUserId = (String)jsonObject.get((Object)"bizUserId");
            String contractNo = (String)jsonObject.get((Object)"contractNo");
            String result = (String)jsonObject.get((Object)"result");
            if ("OK".equals(result)) {
                // empty if block
            }
            return;
        }
        String method = data.get("method");
        if (!StringUtils.isEmpty((String)method) && "allinpay.yunst.memberService.verifyResult".equals(method)) {
            this.logger.info("\u4f01\u4e1a\u8bbe\u7f6e\u7ed3\u679c\u901a\u77e5\uff1a" + JSON.toJSONString((Object)data.get("data")));
            JSONObject jsonObject = JSON.parseObject((String)data.get("data"));
            String bizUserId = (String)jsonObject.get((Object)"bizUserId");
            Long result = (Long)jsonObject.get((Object)"result");
            if (2L != result && 3L == result) {
                String failReason = (String)jsonObject.get((Object)"failReason");
            }
            return;
        }
        if (!StringUtils.isEmpty((String)"allinpay.yunst.memberService.ocrComparisonResult") && "".equals(method)) {
            this.logger.info("\u5f71\u5370\u91c7\u96c6\u901a\u77e5\uff1a" + JSON.toJSONString((Object)data.get("data")));
        }
    }

    @Override
    public String sendAgentCollectApply(Map<String, Object> map, OcContractDomain ocContractDomain, String tenantCode) throws ApiException {
        OpenResponse response;
        this.logger.error(".sendAgentCollectApply into param", (Object)(map + "==:==" + ocContractDomain.getContractBillcode() + "==:==" + tenantCode));
        if (null == ocContractDomain) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply ocContractDomain is null");
            return null;
        }
        OpenClient client = this.getClient(tenantCode);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 15);
        Date date = calendar.getTime();
        String orderExpireDatetime = sdf.format(date);
        BizParameter param = new BizParameter();
        param.put("bizOrderNo", ocContractDomain.getContractBillcode());
        String userinfoOcode = this.getUserinfoOcode(ocContractDomain.getMemberBcode(), tenantCode);
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.getUserinfoOcode null", (Object)ocContractDomain.getContractBillcode());
            return null;
        }
        param.put("payerId", userinfoOcode);
        JSONArray receiverList = this.makeReceiverList(ocContractDomain);
        if (null == receiverList) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply makeReceiverList is null");
            return null;
        }
        param.put("recieverList", receiverList);
        param.put("tradeCode", this.getDdFlag("TSY", "COLLECTING", tenantCode));
        param.put("amount", this.conversionCredits(ocContractDomain.getContractMoney()));
        param.put("frontUrl", map.get("frontUrl"));
        param.put("orderExpireDatetime", orderExpireDatetime);
        param.put("payMethod", this.getPayMethod(ocContractDomain, client, map));
        param.put("industryCode", this.getDdFlag("TSY", "INDUSTRY_CODE", tenantCode));
        param.put("industryName", this.getDdFlag("TSY", "INDUSTRY_NAME", tenantCode));
        param.put("source", map.get("source"));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        try {
            response = client.execute("allinpay.yunst.orderService.agentCollectApply", param);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.execute", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendAgentCollectApply.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    private JSONArray makeReceiverList(OcContractDomain ocContractDomain) {
        List<OcContractGoodsDomain> ocContractGoodsDomainList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            return null;
        }
        Map<String, List<OcContractGoodsDomain>> memberMap = this.makeMemberMap(ocContractGoodsDomainList);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.makeReceiverList", (Object)JsonUtil.buildNormalBinder().toJson(memberMap));
        JSONArray receiverList = new JSONArray();
        Set<Map.Entry<String, List<OcContractGoodsDomain>>> entries = memberMap.entrySet();
        for (Map.Entry<String, List<OcContractGoodsDomain>> entry : entries) {
            String oCode = this.getUserinfoOcode(entry.getKey(), ocContractDomain.getTenantCode());
            if (StringUtils.isEmpty((String)oCode)) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.makeReceiverList.null", (Object)JsonUtil.buildNormalBinder().toJson(entry));
                return null;
            }
            List<OcContractGoodsDomain> goods = entry.getValue();
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (OcContractGoodsDomain good : goods) {
                totalAmount = totalAmount.add(good.getContractGoodsMoney());
            }
            receiverList.add((Object)new JSONObject(this.getQueryMapParam("bizUserId,amount", new Object[]{oCode, this.conversionCredits(totalAmount)})));
        }
        return receiverList;
    }

    private Map<String, List<OcContractGoodsDomain>> makeMemberMap(List<OcContractGoodsDomain> ocContractGoodsDomainList) {
        HashMap<String, List<OcContractGoodsDomain>> memberMap = new HashMap<String, List<OcContractGoodsDomain>>();
        List<OcContractGoodsDomain> goodList = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            if (ListUtil.isEmpty((Collection)((Collection)memberMap.get(ocContractGoodsDomain.getMemberCode())))) {
                goodList = new ArrayList<OcContractGoodsDomain>();
                goodList.add(ocContractGoodsDomain);
                memberMap.put(ocContractGoodsDomain.getMemberCode(), goodList);
                continue;
            }
            goodList = (List)memberMap.get(ocContractGoodsDomain.getMemberCode());
            goodList.add(ocContractGoodsDomain);
            memberMap.put(ocContractGoodsDomain.getMemberCode(), goodList);
        }
        return memberMap;
    }

    private Map<String, Object> getPayMethod(OcContractDomain ocContractDomain, OpenClient client, Map<String, Object> map) {
        String pay;
        HashMap<String, Object> realnamePay = new HashMap<String, Object>();
        switch (pay = null == map.get("pay") ? "" : map.get("pay").toString()) {
            case "1": {
                realnamePay.put("vspCusid", this.getDdFlag("vspCusid", "TSY", ocContractDomain.getTenantCode()));
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                realnamePay.put("limitPay", "no_credit");
                break;
            }
            case "2": {
                realnamePay.put("vspCusid", this.getDdFlag("vspCusid", "TSY", ocContractDomain.getTenantCode()));
                realnamePay.put("limitPay", "no_credit");
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                realnamePay.put("acct", this.getDdFlag("openid", "TSY", ocContractDomain.getTenantCode()));
                break;
            }
            case "3": {
                realnamePay.put("vspCusid", this.getDdFlag("vspCusid", "TSY", ocContractDomain.getTenantCode()));
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                realnamePay.put("limitPay", "no_credit");
                break;
            }
            case "4": {
                realnamePay.put("vspCusid", this.getDdFlag("vspCusid", "TSY", ocContractDomain.getTenantCode()));
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                realnamePay.put("limitPay", "no_credit");
                realnamePay.put("acct", this.getDdFlag("user_id", "TSY", ocContractDomain.getTenantCode()));
                break;
            }
            case "5": {
                realnamePay.put("bankCardNo", client.encrypt((String)map.get("bankCardNo")));
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                break;
            }
            case "6": {
                realnamePay.put("vspCusid", this.getDdFlag("vspCusid", "TSY", ocContractDomain.getTenantCode()));
                realnamePay.put("amount", ocContractDomain.getContractMoney());
                realnamePay.put("paytype", "B2B");
                break;
            }
            default: {
                return null;
            }
        }
        realnamePay.put("amount", this.conversionCredits(ocContractDomain.getContractMoney()));
        realnamePay.put("paytype", this.conversionCredits(ocContractDomain.getContractMoney()));
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        payMethod.put("GATEWAY_VSP", realnamePay);
        return payMethod;
    }

    private Long conversionCredits(BigDecimal contractMoney) {
        if (null == contractMoney) {
            return BigDecimal.ZERO.longValue();
        }
        if (BigDecimal.ZERO.compareTo(contractMoney) == 0) {
            return BigDecimal.ZERO.longValue();
        }
        BigDecimal amount = contractMoney.multiply(new BigDecimal(100));
        return amount.longValue();
    }

    @Override
    public String sendBatchAgentPay(Map<String, Object> map, OcContractDomain ocContractDomain, String tenantCode) throws ApiException {
        OpenResponse response;
        this.logger.error(".sendBatchAgentPay into param", (Object)(map + "==:==" + ocContractDomain.getContractBillcode() + "==:==" + tenantCode));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay map or ocContractDomain is null");
            return null;
        }
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay ocContractDomain is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return null;
        }
        JSONArray batchPayList = new JSONArray();
        Map<String, List<OcContractGoodsDomain>> memberMap = this.makeMemberMap(ocContractDomain.getGoodsList());
        Set<Map.Entry<String, List<OcContractGoodsDomain>>> entries = memberMap.entrySet();
        for (Map.Entry<String, List<OcContractGoodsDomain>> entry : entries) {
            String oCode = this.getUserinfoOcode(entry.getKey(), ocContractDomain.getTenantCode());
            if (StringUtils.isEmpty((String)oCode)) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.getUserinfoOcode.null", (Object)JsonUtil.buildNormalBinder().toJson(entry));
                return null;
            }
            List<OcContractGoodsDomain> goods = entry.getValue();
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (OcContractGoodsDomain good : goods) {
                totalAmount = totalAmount.add(good.getContractGoodsMoney());
            }
            JSONArray collectPayList = new JSONArray();
            HashMap<String, Object> collect1 = new HashMap<String, Object>();
            collect1.put("bizOrderNo", ocContractDomain.getContractBillcode());
            collect1.put("amount", totalAmount);
            collectPayList.add((Object)new JSONObject(collect1));
            HashMap<String, Object> pay = new HashMap<String, Object>();
            pay.put("bizOrderNo", ocContractDomain.getContractBillcode());
            pay.put("collectPayList", collectPayList);
            pay.put("bizUserId", oCode);
            pay.put("accountSetNo", this.getDdFlag("TSY", "ACCOUNTSETNO", tenantCode));
            pay.put("backUrl", this.getDdFlag("TSY", "BACKURL", tenantCode));
            pay.put("amount", totalAmount);
            pay.put("fee", 0L);
            batchPayList.add(pay);
        }
        BizParameter param = new BizParameter();
        param.put("batchPayList", batchPayList);
        param.put("bizBatchNo", System.currentTimeMillis() + "ba");
        param.put("tradeCode", this.getDdFlag("TSY", "PAID", tenantCode));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        OpenClient client = this.getClient(tenantCode);
        try {
            response = client.execute("allinpay.yunst.orderService.batchAgentPay", param);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.execute", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendBatchAgentPay.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String sendPayBySMS(Map<String, Object> map, String tenantCode) throws ApiException {
        OpenResponse response;
        this.logger.error(".sendPayBySMS into param", (Object)(JsonUtil.buildNormalBinder().toJson(map) + "==:==" + tenantCode));
        if (MapUtil.isEmpty(map) || null == map.get("userinfoCode") || null == map.get("contractBillcode")) {
            return null;
        }
        String userinfoOcode = this.getUserinfoOcode(map.get("userinfoCode").toString(), tenantCode);
        if (StringUtils.isEmpty((String)userinfoOcode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.getUserinfoByUserCode", (Object)(map.get("userinfoCode") + " == " + tenantCode));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put("bizUserId", userinfoOcode);
        param.put("bizOrderNo", map.get("contractBillcode"));
        param.put("verificationCode", map.get("verificationCode"));
        param.put("consumerIp", map.get("consumerIp"));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        OpenClient client = this.getClient(tenantCode);
        try {
            response = client.execute("allinpay.yunst.orderService.payBySMS", param);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.execute", (Throwable)e);
            return null;
        }
        if (response == null) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        if (!"10000".equals(response.getCode()) || !"OK".equals(response.getSubCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.response.code", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendPayBySMS.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    public String getUserinfoOcode(String userInfoCode, String tenantCode) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("userinfoCode", userInfoCode);
        userInfoMap.put("tenantCode", tenantCode);
        String json = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfoMap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(json, UmUserinfo.class);
        if (null == umUserinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getUserinfoOcode.getUserinfoByUserCode", (Object)(userInfoCode + " == " + tenantCode));
            return null;
        }
        return umUserinfo.getUserinfoOcode();
    }

    @Override
    public String callOrderResultNotify(Map<String, Object> map, String tenantCode) throws ApiException {
        return null;
    }

    @Override
    public String sendRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        if (ocRefundDomain == null) {
            return null;
        }
        this.logger.error(".sendRefund into param", (Object)ocRefundDomain.getRefundCode());
        BizParameter param = new BizParameter();
        String oCode = this.getUserinfoOcode(ocRefundDomain.getMemberBcode(), ocRefundDomain.getTenantCode());
        if (StringUtils.isEmpty((String)oCode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendRefund.MemberBcode null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return null;
        }
        param.put("bizUserId", oCode);
        param.put("bizOrderNo", ocRefundDomain.getRefundCode());
        param.put("oriBizOrderNo", ocRefundDomain.getContractBillcode());
        param.put("amount", this.conversionCredits(ocRefundDomain.getContractMoney()));
        param.put("refundType", "D0");
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendRefund.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        OpenClient client = this.getClient(ocRefundDomain.getTenantCode());
        OpenResponse response = null;
        try {
            response = client.execute("allinpay.yunst.orderService.refund", param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == response) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendRefund.response null", (Object)param);
            return null;
        }
        if (!"10000".equals(response.getCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendRefund.errCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.getInternalRouter().inInvoke("oc.refund.updateExtrinsicStateByRefundCode", this.getQueryParamMap("refundCode,dataOpnextbillstate,tenantCode", new Object[]{ocRefundDomain.getRefundCode(), "1", ocRefundDomain.getTenantCode()}));
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendRefund.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    @Override
    public String sendQueryBalance(Map<String, Object> map, String tenantCode) throws ApiException {
        OpenResponse response;
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.map", (Object)"map is null");
            return null;
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        UmUserinfo umUserinfo = this.getUmUserinfo(map);
        if (null == umUserinfo || StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.getUmUserinfo", (Object)("umUserinfo is null ==:== " + JsonUtil.buildNormalBinder().toJson(map)));
            return null;
        }
        BizParameter param = new BizParameter();
        param.put("bizUserId", umUserinfo.getUserinfoOcode());
        param.put("accountSetNo", this.getDdFlag("TSY", "ACCOUNTSETNO", tenantCode));
        OpenClient client = this.getClient(tenantCode);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.req param", (Object)("==== " + param + " ===="));
        try {
            response = client.execute("allinpay.yunst.orderService.queryBalance", param);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance", (Throwable)e);
            return null;
        }
        if (null == response) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.response null", (Object)param);
            return null;
        }
        if (!"10000".equals(response.getCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.errCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.sendQueryBalance.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response.getData();
    }

    public String getDdFlag(String flagSettingType, String flagSettingCode, String tenantCode) {
        String key = tenantCode.concat("-").concat("flagSettingType").concat("-").concat("flagSettingCode");
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
    }

    private Map<String, String> covetListToMap(List<UmUserinfoQua> umUserinfoQuaList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (UmUserinfoQua umUserinfoQua : umUserinfoQuaList) {
            map.put(umUserinfoQua.getUserinfoQuaKey(), umUserinfoQua.getUserinfoQuaVaule());
        }
        return map;
    }

    @Override
    public String setRealName(UmUser umUser, UmUserinfo umUserinfo) {
        OpenResponse response;
        if (null == umUser || null == umUserinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.intoParam", (Object)" umUser or umUserinfo is null");
            return this.resultMaInformation("error", "\u5165\u53c2\u4e3a\u7a7a");
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.into", (Object)umUserinfo.getUserinfoCode());
        if (StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.userinfoOcode", (Object)" userinfoOcode is null");
            return this.resultMaInformation("error", "userinfoOcode \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        List<UmUserinfoQua> umUserinfoQuaList = this.getUmUserinfoQuaList(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode());
        if (ListUtil.isEmpty(umUserinfoQuaList)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.queryUserinfo", (Object)(umUserinfo.getUserinfoCode() + " =:= " + umUserinfo.getTenantCode()));
            return this.resultMaInformation("error", "\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f \u4e3a\u7a7a\uff01\uff01\uff01");
        }
        Map<String, String> userinfoQuaMap = this.covetListToMap(umUserinfoQuaList);
        String method = "allinpay.yunst.memberService.setRealName";
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.isAuth, TongShangYunConfig.isAuth_true);
        if (StringUtils.isEmpty((String)userinfoQuaMap.get("name"))) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.name", (Object)"\u5b9e\u540d\u8ba4\u8bc1\u59d3\u540d\u4e3a\u7a7a");
            return this.resultMaInformation("error", "\u5b9e\u540d\u8ba4\u8bc1\u59d3\u540d\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        param.put(TongShangYunConfig.name, userinfoQuaMap.get("name"));
        param.put(TongShangYunConfig.identityType, TongShangYunConfig.identityType_1);
        param.put("identityBeginDate", userinfoQuaMap.get("identityBeginDate"));
        param.put("identityEndDate", userinfoQuaMap.get("identityEndDate"));
        param.put("address", userinfoQuaMap.get("address"));
        param.put("professionNo", userinfoQuaMap.get("professionNo"));
        param.put("telephone", userinfoQuaMap.get("telephone"));
        try {
            if (StringUtils.isEmpty((String)userinfoQuaMap.get("identityType"))) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.identityType", (Object)"\u5b9e\u540d\u8ba4\u8bc1\u8bc1\u4ef6\u53f7\u4e3a\u7a7a");
                return this.resultMaInformation("error", "\u5b9e\u540d\u8ba4\u8bc1\u8bc1\u4ef6\u53f7\u4e3a\u7a7a\uff01\uff01\uff01");
            }
            param.put(TongShangYunConfig.identityNo, this.getClient(umUserinfo.getTenantCode()).encrypt(userinfoQuaMap.get("identityType")));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.reqParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            response = this.getClient(umUserinfo.getTenantCode()).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.e", (Throwable)e);
            return this.resultMaInformation("error", "\u5b9e\u540d\u63a5\u53e3\u5f02\u5e38");
        }
        if (null == response) {
            this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 14, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.response null", (Object)param);
            return null;
        }
        if (!"10000".equals(response.getCode())) {
            this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 14, null);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.errCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        this.updateUserState(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 13, null);
        this.logger.error("service.jindie.MemberSettleInServiceImpl.setRealName.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return "success";
    }

    public List<UmUserinfoQua> getUmUserinfoQuaList(String userinfoCode, String tenantCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("userinfoCode", userinfoCode);
        List umUserinfoQuaList = (List)this.getInternalRouter().inInvoke("um.userinfoQua.queryUserinfo", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(queryMap)}));
        return umUserinfoQuaList;
    }

    public void updateUserState(String userinfoCode, String tenantCode, Integer dataState, Integer oldDataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        this.getInternalRouter().inInvoke("um.userbase.updateUserinfoStateByCode", map);
    }

    @Override
    public String signContract(Map<String, Object> map) {
        this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.into", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.map", (Object)"map is null");
            return "null";
        }
        if (null == map.get("userInfoCode") || null == map.get("tenantCode")) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.userInfoCode", (Object)"userInfoCode or tenantCode is null");
            return "null";
        }
        UmUserinfo umUserinfo = this.getUmUserinfo(map);
        if (null == umUserinfo || StringUtils.isEmpty((String)umUserinfo.getUserinfoOcode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.getUmUserinfo", (Object)("umUserinfo is null ==:== " + JsonUtil.buildNormalBinder().toJson(map)));
            return null;
        }
        String method = "allinpay.yunst.memberService.signContract";
        BizParameter param = new BizParameter();
        param.put(TongShangYunConfig.bizUserId, umUserinfo.getUserinfoOcode());
        param.put(TongShangYunConfig.source, map.get(TongShangYunConfig.source));
        param.put("jumpPageType", null == map.get("jumpPageType") ? "" : map.get("jumpPageType"));
        param.put("jumpUrl", null == map.get("jumpUrl") ? "" : map.get("jumpUrl"));
        param.put("backUrl", this.getDdFlag("TSY", "signContract_backUrl", map.get("tenantCode").toString()));
        if ("2".equals(map.get(TongShangYunConfig.source))) {
            try {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.reqParam.2", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
                String url = this.getClient((String)map.get("tenantCode")).concatUrlParams("allinpay.yunst.memberService.signContract", param);
                this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.reqParam.2", (Object)JsonUtil.buildNormalBinder().toJson((Object)url));
                return url;
            }
            catch (Exception e) {
                this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.2.e", (Throwable)e);
                return null;
            }
        }
        OpenResponse response = null;
        try {
            param.put(TongShangYunConfig.backUrl, this.getClient((String)map.get("tenantCode")).encrypt((String)map.get(TongShangYunConfig.backUrl)));
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.reqParam.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
            response = this.getClient((String)map.get("tenantCode")).execute(method, param);
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.rep", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.1.e", (Throwable)e);
            return null;
        }
        if (null == response) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.response null", (Object)param);
            return null;
        }
        if (!"10000".equals(response.getCode())) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.errCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            this.updateUmUserInfo(umUserinfo.getUserinfoCode(), "2,0,0,0", umUserinfo.getTenantCode(), null);
            return null;
        }
        this.logger.error("service.jindie.MemberSettleInServiceImpl.signContract.end", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return JSON.parseObject((String)response.getData()).getString("url").replace("https://fintech.allinpay.com/", "https://protocol6.allinpay.com/");
    }

    @Override
    public void callBackSignContract(String bizUserId, String contractNo, String status, String tenantCode) {
        this.logger.error("service.jindie.MemberSettleInServiceImpl.callBackSignContract.into.param", (Object)(bizUserId + " =:= " + contractNo + " =:= " + status + " =:= " + tenantCode));
        if (StringUtils.isEmpty((String)bizUserId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)status) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.callBackSignContract.param.null", (Object)(bizUserId + " =:= " + contractNo + " =:= " + status + " =:= " + tenantCode));
            return;
        }
        UmUserinfo umUserinfo = this.getUmUserInfoByOcode(bizUserId, tenantCode);
        if (null == umUserinfo) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.callBackSignContract.getUmUserInfoByOcode", (Object)("umUserinfo is null !!! bizUserId:" + bizUserId));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPcode", umUserinfo.getUserinfoCode());
        map.put("tenantCode", tenantCode);
        String userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserList", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(map)}));
        List umUserList = (List)JsonUtil.buildNormalBinder().getJsonToList(userListJson, UmUser.class);
        if (ListUtil.isEmpty((Collection)umUserList)) {
            return;
        }
        if ("OK".equals(status)) {
            UmUser umUser = (UmUser)umUserList.get(0);
            this.updateUserInfoStatus(umUser, umUserinfo, 23, null);
        } else {
            UmUser umUser = (UmUser)umUserList.get(0);
            this.updateUserInfoStatus(umUser, umUserinfo, 24, null);
        }
    }

    public void updateUserInfoStatus(UmUser umUser, UmUserinfo umUserinfo, Integer status, String reason) {
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserinfo);
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        umUserinfoDomainBean.setFax(String.valueOf(status));
        umUserinfoDomainBean.setMemo(reason);
        this.getInternalRouter().inInvoke("um.userbase.updateUserinfoByUserinfoCode", this.getQueryParamMap("umUserinfoDomainBean", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean)}));
    }

    protected OpenClient getClient(String tenantCode) throws ApiException {
        OpenClient openClient;
        try {
            openClient = new OpenClient(this.getConfig(tenantCode));
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getTongshangyunOpenClientCollectionFlow", (Throwable)e);
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.getTongshangyunOpenClientCollectionFlow");
        }
        return openClient;
    }

    protected OpenClient getNotifyClient(String notifyUrl, String tenantCode) throws ApiException {
        OpenClient openClient;
        try {
            OpenConfig config = this.getConfig(tenantCode);
            config.setNotifyUrl(notifyUrl);
            openClient = new OpenClient(config);
        }
        catch (Exception e) {
            this.logger.error("service.jindie.MemberSettleInServiceImpl.getTongshangyunOpenClientCollectionFlow", (Throwable)e);
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.getTongshangyunOpenClientCollectionFlow");
        }
        return openClient;
    }

    private void updateUserInfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        HashMap<String, String> updateUserInfoMap = new HashMap<String, String>();
        updateUserInfoMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.internalInvoke("um.user.updateUserinfoByUserinfoCode", updateUserInfoMap);
    }

    private UmUserinfo getUmUserinfo(Map<String, Object> map) {
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("userinfoCode", map.get("userInfoCode"));
        pmap.put("tenantCode", map.get("tenantCode"));
        String userInfoJson = this.internalInvoke("um.user.getUserinfoByCode", pmap);
        return (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userInfoJson, UmUserinfo.class);
    }

    private OpenConfig getOpenConfig(String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.tenantCode is null");
        }
        String configJsonStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-TSY-allinPay_config"));
        this.logger.info("\u901a\u5546\u4e91\u516c\u5171\u914d\u7f6e\uff1a" + configJsonStr);
        if (StringUtils.isEmpty((String)configJsonStr)) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.tongshangyunConfig is null");
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configJsonStr, String.class, String.class);
        if (MapUtil.isEmpty((Map)map)) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.tongshangyunConfig is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.url)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.url is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.appId)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.appId is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.secretKey)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImplsecretKey is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.privateKeyPath)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.privateKeyPath is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.pwd)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.pwd is null");
        }
        if (StringUtils.isEmpty((String)((String)map.get(TongShangYunConfig.tlPublicKey)))) {
            throw new ApiException("service.jindie.MemberSettleInServiceImpl.tlPublicKeyPath is null");
        }
        String url = (String)map.get(TongShangYunConfig.url);
        String appId = (String)map.get(TongShangYunConfig.appId);
        String secretKey = (String)map.get(TongShangYunConfig.secretKey);
        String privateKeyPath = (String)map.get(TongShangYunConfig.privateKeyPath);
        String pwd = (String)map.get(TongShangYunConfig.pwd);
        String tlPublicKey = (String)map.get(TongShangYunConfig.tlPublicKey);
        return new OpenConfig(url, appId, secretKey, privateKeyPath, pwd, tlPublicKey);
    }

    private String updateUserInfoConQq(String userinfoConQq, int index, String value) {
        if (StringUtils.isEmpty((String)userinfoConQq)) {
            return "0,1,0,0";
        }
        String[] split = userinfoConQq.split(",");
        split[index] = value;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i != split.length - 1) {
                stringBuilder.append(split[i]).append(",");
                continue;
            }
            stringBuilder.append(split[i]);
        }
        return stringBuilder.toString();
    }

    private String resultMaInformation(String state, String news) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", state);
        map.put("news", news);
        String resultJson = JsonUtil.buildNormalBinder().toJson(map);
        return resultJson;
    }
}

