/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import org.apache.xmlbeans.impl.util.Base64;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class ImageUtil {
    public static void main(String[] args) throws Exception {
    }

    public static String encodeImgageToBase64Jpg(File imageFile) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    public static String encodeImgageToBase64Png(File imageFile) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    public static String encodeImgageToBase64(File imageFile, String imageType) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, imageType, outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fullFileName, byte[] contents) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(fullFileName, "rw");
            raf.seek(raf.length());
            try (FileChannel channel = raf.getChannel();){
                ByteBuffer buffer = ByteBuffer.allocate(contents.length);
                buffer.put(contents);
                buffer.flip();
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
                channel.force(true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String imageUrlToBase64(String imageUrl) {
        if (StringUtils.isEmpty((Object)imageUrl)) {
            return null;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imageUrl);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            String base64Str = new String(Base64Utils.encode((byte[])data.toByteArray()));
            is.close();
            return base64Str;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

