/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.nanwang.login.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.common.ApiCodeEnums;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.domain.CSGUserBean;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.domain.UmUserBean;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.response.OauthCSGUserResponse;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.service.SSOService;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.utils.ASCIIUtils;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.utils.SHA256Util;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

public class SSOServiceImpl
extends BaseServiceImpl
implements SSOService {
    private final String SYS_CODE = "nanwang.login.service.impl.SSOServiceImpl";
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public UmUserBean getCode() throws ApiException {
        return null;
    }

    @Override
    public UmUserBean refreshToken() throws ApiException {
        return null;
    }

    @Override
    public UmUserBean getLogin(String code, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)code)) {
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("\u4f20\u5165\u53c2\u6570\u9519\u8bef");
            return userBean;
        }
        String url = this.getUrl("url", tenantCode);
        String redirectUri = this.getUrl("redirectUri", tenantCode);
        String clientSecret = this.getUrl("clientSecret", tenantCode);
        String clientId = this.getUrl("clientId", tenantCode);
        OauthCSGUserResponse execute = new OauthCSGUserResponse();
        try {
            execute = (OauthCSGUserResponse)this.authorization_code(code, clientId, clientSecret, url, redirectUri);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (!execute.isSuccess()) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.errorCode", (Object)execute.getMessage());
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg(execute.getMessage());
            return userBean;
        }
        CSGUserBean csgUserBean = execute.getData();
        String custNumber = csgUserBean.getCustNumber();
        if (StringUtils.isBlank((String)custNumber)) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.getCustNumber", (Object)execute.getMsg());
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("custNumber is null");
            return userBean;
        }
        UmUserBean umUserBean = this.checkUserAndSave(csgUserBean, url, tenantCode);
        if (!umUserBean.isFlag()) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.checkUserAndSave.getMsg", (Object)umUserBean.getMsg());
            return umUserBean;
        }
        return this.loginUser(tenantCode, umUserBean);
    }

    private UmUserBean loginUser(String tenantCode, UmUserBean execute) {
        String userBeanStr;
        if (null == execute || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> inventoryMap = new HashMap<String, Object>(16);
        inventoryMap.put("userName", execute.getUserName());
        inventoryMap.put("tenantCode", tenantCode);
        inventoryMap.put("isValid", 3);
        UmUserBean userBean = new UmUserBean();
        try {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.loginUser");
            String api = ApiCodeEnums.checkUmApi.getApiCode();
            userBeanStr = (String)this.getInternalRouter().inInvoke(api, inventoryMap);
            if (StringUtils.isBlank((String)userBeanStr)) {
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBeanStr", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + "," + "\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
                userBean.setFlag(false);
                userBean.setMsg("queryUmuserCheck\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return userBean;
            }
        }
        catch (Exception e) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBeanStr.exception", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap), (Throwable)e);
            userBean.setFlag(false);
            userBean.setMsg("\u8acb\u6c42um.user.queryUmuserCheck\u5f02\u5e38\uff01\uff01\uff01");
            return userBean;
        }
        userBean = (UmUserBean)JsonUtil.buildNormalBinder().getJsonToObject(userBeanStr, UmUserBean.class);
        if (null == userBean || !userBean.isFlag()) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBean", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + "," + "\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
        }
        return userBean;
    }

    private UmUserBean checkUserAndSave(CSGUserBean execute, String url, String tenantCode) {
        UmUserBean userBean = new UmUserBean();
        if (null == execute || StringUtils.isBlank((String)url)) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.null");
            userBean.setFlag(false);
            userBean.setMsg("checkUserAndSave.null");
            return userBean;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("userOcode", execute.getCustNumber());
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> map = new HashMap<String, String>(16);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.queryParam", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject(ApiCodeEnums.queryUser.getApiCode(), map, UmUserBean.class);
        UmUserBean umUserBean = null;
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            umUserBean = (UmUserBean)queryResult.getList().get(0);
        }
        if (null != umUserBean && StringUtils.isBlank((String)execute.getCustNumber())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.custNumber.null");
            userBean.setFlag(false);
            userBean.setMsg("custNumber is null");
            return userBean;
        }
        if (null != umUserBean && StringUtils.isNotBlank((String)execute.getCustNumber()) && execute.getCustNumber().equals(umUserBean.getUserOcode())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.custNumber == userOcode");
            umUserBean.setFlag(true);
            return umUserBean;
        }
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.umUserBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserBean));
        if (null != umUserBean && StringUtils.isNotBlank((String)execute.getCustNumber()) && !execute.getCustNumber().equals(umUserBean.getUserOcode())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber", (Object)"===");
            try {
                HashMap<String, Object> inventoryMap = new HashMap<String, Object>(16);
                inventoryMap.put("userId", umUserBean.getUserId());
                inventoryMap.put("dataState", umUserBean.getDataState());
                inventoryMap.put("oldDataState", umUserBean.getDataState());
                HashMap<String, String> umap = new HashMap<String, String>(16);
                umap.put("userOcode", execute.getCustNumber());
                inventoryMap.put("map", JsonUtil.buildNormalBinder().toJson(umap));
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber.umap", (Object)JsonUtil.buildNormalBinder().toJson(umap));
                String api = ApiCodeEnums.updateOpenid.getApiCode();
                this.getInternalRouter().inInvoke(api, inventoryMap);
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber", (Object)((Object)inventoryMap).toString());
            }
            catch (Exception e) {
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber.e", (Throwable)e);
                userBean.setMsg(e.getMessage());
                userBean.setFlag(false);
                return userBean;
            }
        }
        CSGUserBean csgUserBean = this.queryCsgUserBean(execute.getAccess_token(), tenantCode);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.saveCustNumber", (Object)"===");
        UmUserDomainBean umUserDomainBean = this.copyFields(csgUserBean, tenantCode);
        try {
            HashMap<String, String> inventoryMap = new HashMap<String, String>(16);
            inventoryMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            String api = ApiCodeEnums.openUserinfo.getApiCode();
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.umUserDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            this.getInternalRouter().inInvoke(api, inventoryMap);
        }
        catch (Exception e) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.saveCustNumber.exception", (Throwable)e);
            userBean.setMsg(e.getMessage());
            userBean.setFlag(false);
            return userBean;
        }
        userBean.setUserName(umUserDomainBean.getUserName());
        userBean.setUserNickname(umUserDomainBean.getUserNickname());
        userBean.setUserinfoOcode(umUserDomainBean.getUserinfoOcode());
        userBean.setFlag(true);
        return userBean;
    }

    private UmUserDomainBean copyFields(CSGUserBean csgUserBean, String tenantCode) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(csgUserBean.getUserName());
        umUserDomainBean.setUserPhone(csgUserBean.getMobilePhone());
        umUserDomainBean.setUserNickname(csgUserBean.getNickName());
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserinfoCompname(csgUserBean.getMobilePhone());
        umUserDomainBean.setUserinfoOcode(csgUserBean.getCustNumber());
        umUserDomainBean.setUserOcode(csgUserBean.getCustNumber());
        String compname = umUserDomainBean.getUserinfoCompname();
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserDomainBean.getUserName();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserDomainBean.getUserPhone();
        }
        umUserDomainBean.setUserinfoCompname(compname);
        umUserDomainBean.setUserinfoQuality("buy");
        return umUserDomainBean;
    }

    private CSGUserBean queryCsgUserBean(String token, String tenantCode) {
        String url = this.getUrl("url", tenantCode);
        OauthCSGUserResponse execute = (OauthCSGUserResponse)this.getCustInfo(token, url);
        return execute.getData();
    }

    private String getUrl(String flagSettingCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat("csgSso").concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.getUrl", (Object)(tenantCode + "=" + "csgSso" + "=" + flagSettingCode + "=" + value));
        return value;
    }

    private Object authorization_code(String code, String clientId, String clientSecret, String url, String redirectUri) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("client_id", clientId);
        map.put("code", code);
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", URLEncoder.encode(redirectUri, "UTF-8"));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        BASE64Encoder encoder = new BASE64Encoder();
        String authentication = clientId + ":" + clientSecret;
        headers.set("authorization", "Basic " + encoder.encode(authentication.getBytes()));
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.postForEntity(url + "/ucs/ma/ucc/oauth/token", (Object)httpEntity, Object.class, new Object[0]);
        return exchange.getBody();
    }

    private Object getCustInfo(String accessToken, String url) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"access_token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.postForEntity(url + "/ucs/ma/ucc/oauth/getCustInfo", (Object)httpEntity, Object.class, new Object[0]);
        return exchange.getBody().toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> bodyParam = new HashMap<String, String>(16);
        String method = "cmc.csgSSO.getLogin";
        String url = "https://yy-nanwang.jd.com/";
        bodyParam.put("method", "cmc.csgSSO.getLogin");
        bodyParam.put("code", "1poQ9zJzGN5ALbF7");
        bodyParam.put("app_id", "zhaoshang");
        bodyParam.put("version", "1.0");
        bodyParam.put("timestamp", "2021-05-11 09:59:00");
        bodyParam.put("tenantCode", "422890374118244352");
        bodyParam.put("sign_type", "SHA256");
        Map confMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(bodyParam), String.class, String.class);
        String value = ASCIIUtils.stringToAscii(confMap);
        String str1 = value + "66987CB115214E59E6EC978214934FB8";
        String sign = SHA256Util.getSHA256String(str1);
        bodyParam.put("sign", sign);
        String result = "";
        try {
            result = WebUtils.doPost((String)(url + "/laserEr/http/post/+" + method + "+/1.0/422890374118244352/utf-8/zhaoshang"), bodyParam, (int)100000, (int)100000);
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(result);
    }

    public static String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }
}

