/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataInChuanHangCardRollService;
import com.yqbsoft.laser.service.ext.data.api.DataOutMessageService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.config.RequestConfiguration;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.CouponOrderInfoRQ;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCustomerInfo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.BenefitOrderChildren;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.PayOrderVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.MyCardVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ProductVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundDataVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.productItemVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.task.TaskService;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.crypto.hash.SimpleHash;

public class DataInChuanHangCardRollServiceImpl
extends DateBaseService
implements DataInChuanHangCardRollService {
    private static final String SYS_CODE = "DataInChuanHangCardRollServiceImpl";
    private DataOutMessageService dataOutMessageService;
    private TaskService taskService;

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setDataOutMessageService(DataOutMessageService dataOutMessageService) {
        this.dataOutMessageService = dataOutMessageService;
    }

    public String createBenefitOrder(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.ocContractDomain is null");
            return "fail";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberBcode(), tenantCode);
        if (userinfoByCode == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createCouponOrder.userinfoByCode is null");
            return "fail";
        }
        Map customer = this.dataOutMessageService.getCustomer(tenantCode, userinfoByCode.getUserinfoOcode());
        if (MapUtil.isEmpty((Map)customer) || !customer.containsKey("CustomerID")) {
            this.logger.error("DataInChuanHangCardRollServiceImplcustomer error", (Object)JSON.toJSONString((Object)customer));
            return "fail";
        }
        if (ListUtil.isEmpty((Collection)ocContractDomain.getGoodsList())) {
            this.logger.error("DataInChuanHangCardRollServiceImplcreateBenefitOrder.getGoodsList is null");
            return "fail";
        }
        ProductVo productVo = null;
        try {
            productVo = this.getProductofr(ocContractDomain, userinfoByCode);
            if (productVo == null) {
                this.logger.error("DataInChuanHangCardRollServiceImplproductVo is null");
                return "fail";
            }
        }
        catch (Exception e) {
            this.logger.error("DataInChuanHangCardRollServiceImplgetProductofr.e", (Object)e.getMessage());
            return "fail";
        }
        CouponOrderInfoRQ couponOrderInfoRQ = this.makeCouponOrderInfoRQ(ocContractDomain, customer, productVo);
        try {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.couponOrderInfoRQ", (Object)JSON.toJSONString((Object)couponOrderInfoRQ));
            String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.CREATEBENEFITORDER, JSON.toJSONString((Object)couponOrderInfoRQ), tenantCode);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            if (responseVo != null && responseVo.getCode() == 200 && "\u64cd\u4f5c\u6210\u529f".equals(responseVo.getMessage())) {
                ocContractDomain.setContractNbillcode(responseVo.getData().toString());
                ocContractDomain.setContractNbbillcode(responseVo.getData().toString());
                this.updateContract(ocContractDomain);
                String makePayParam = this.makePayParam(ocContractDomain, userinfoByCode);
                if (StringUtils.isBlank((String)makePayParam)) {
                    return "fail";
                }
                doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.PAYURL, makePayParam, tenantCode);
                if (StringUtils.isBlank((String)doPostJSON)) {
                    return "fail";
                }
                responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
                if (responseVo.getCode() == 200 && "\u64cd\u4f5c\u6210\u529f".equals(responseVo.getMessage())) {
                    return "success";
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "fail";
    }

    private String makePayParam(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) {
        RefundDataVo refundDataVo = this.getByOrderNo(ocContractDomain, userinfoByCode);
        if (refundDataVo != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String payTime = formatter.format(new Date());
            this.logger.error("DataInChuanHangCardRollServiceImpl.makePayParam", (Object)(ocContractDomain.getContractNbbillcode() + "-" + payTime + "-" + RequestConfiguration.CH_PRIVATEKEY));
            String id = null;
            switch (refundDataVo.getMyOrderSubListDtos().get(0).getProductType()) {
                case "COUPON": {
                    id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0).getId();
                    break;
                }
                case "BENEFIT": {
                    id = refundDataVo.getMyOrderSubListDtos().get(0).getBenefitsCoupons().get(0).getId();
                    break;
                }
                case "COUPON_UPGRADE": {
                    id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponUpgrades().get(0).getId();
                    break;
                }
                case "COUPON_REFUND": {
                    id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponRefunds().get(0).getId();
                    break;
                }
                case "COUPON_DEDUCT": {
                    id = refundDataVo.getMyOrderSubListDtos().get(0).getOdrOrderDetailCouponDeductDtos().get(0).getId();
                }
            }
            if (StringUtils.isBlank(id)) {
                this.logger.error("DataInChuanHangCardRollServiceImpl.makePayParam.refundDataVo", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundDataVo));
                return null;
            }
            return JSON.toJSONString((Object)new PayOrderVo(id, ocContractDomain.getContractNbbillcode(), this.getSnowflakeId(), this.getSnowflakeId(), new BigDecimal("0"), formatter.format(new Date()), payTime, "3", RequestConfiguration.CH_CHANNELCODE, "\u798f\u5229\u5b98\u6a21\u62df\u652f\u4ed8", RequestConfiguration.CH_CHANNELCODE, "JXMFLG", this.getSnowflakeId(), "\u5361\u5377\u652f\u4ed8", "\u5361\u5377\u652f\u4ed8", new SimpleHash("MD5", (Object)(ocContractDomain.getContractNbbillcode() + payTime + RequestConfiguration.CH_PRIVATEKEY)).toString()));
        }
        return null;
    }

    public synchronized String getSnowflakeId() {
        return String.valueOf(IdUtil.getSnowflake((long)1L, (long)1L).nextId());
    }

    private CouponOrderInfoRQ makeCouponOrderInfoRQ(OcContractDomain ocContractDomain, Map<String, Object> customer, ProductVo productVo) {
        BigDecimal productPrice;
        OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractDomain.getGoodsList().get(0);
        CouponOrderInfoRQ couponOrderInfoRQ = new CouponOrderInfoRQ();
        couponOrderInfoRQ.setActiveCode(ocContractGoodsDomain.getGoodsNo());
        couponOrderInfoRQ.setPhone(ocContractDomain.getGoodsReceiptPhone());
        couponOrderInfoRQ.setCustomerId(customer.get("CustomerID").toString());
        BigDecimal orderPrice = new BigDecimal("0");
        if (StringUtils.isNotBlank((String)productVo.getProductPrice()) && (productPrice = new BigDecimal(productVo.getProductPrice())).compareTo(BigDecimal.ZERO) > 0) {
            orderPrice = orderPrice.add(productPrice);
        }
        couponOrderInfoRQ.setBenefitOrderChildrenDtos(Arrays.asList(new BenefitOrderChildren(ocContractGoodsDomain.getSkuNo(), 1, orderPrice, orderPrice, productVo.getProductType())));
        couponOrderInfoRQ.setOrderPrice(orderPrice);
        couponOrderInfoRQ.setChannel(RequestConfiguration.CH_CHANNELCODE);
        couponOrderInfoRQ.setIsPackage(productVo.getIfPackage());
        couponOrderInfoRQ.setProductCode(ocContractGoodsDomain.getSkuNo());
        couponOrderInfoRQ.setProductUnitPrice(orderPrice);
        couponOrderInfoRQ.setCount(1);
        return couponOrderInfoRQ;
    }

    private ProductVo getProductofr(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) throws Exception {
        OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractDomain.getGoodsList().get(0);
        HashMap<String, String> rsRsParam = new HashMap<String, String>();
        rsRsParam.put("benefitActivityCode", ocContractGoodsDomain.getGoodsNo());
        rsRsParam.put("productCode", ocContractGoodsDomain.getSkuNo());
        rsRsParam.put("channel", RequestConfiguration.CH_CHANNELCODE);
        rsRsParam.put("userId", userinfoByCode.getUserinfoCompname());
        String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.PRODUCTOFR, JSON.toJSONString(rsRsParam), null);
        ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
        if (responseVo != null && responseVo.getCode() == 200) {
            return (ProductVo)JSON.parseObject((String)responseVo.getData(), ProductVo.class);
        }
        return null;
    }

    public String returnOrder(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnOrder.ocRefundDomain is null");
            return "fail";
        }
        if (!"41".equals(ocRefundDomain.getContractType())) {
            return "success";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberBcode(), tenantCode);
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocRefundDomain.getContractBillcode(), tenantCode, false}));
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryResult is null");
            return "fail";
        }
        String requestParamMsg = this.makeRefundParam((OcContractReDomain)queryResult.getList().get(0), ocRefundDomain, userinfoByCode);
        if (StringUtils.isBlank((String)requestParamMsg)) {
            throw new ApiException("requestParam is null");
        }
        try {
            String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.RETURNCARD, requestParamMsg, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            if (responseVo != null && responseVo.getCode() == 200) {
                this.taskService.cancelOrder((OcContractReDomain)queryResult.getList().get(0));
                return "success";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "fail";
    }

    private String updateContract(OcContractDomain ocContractDomain) {
        String apiCode = "oc.contract.updateContract";
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    public RefundDataVo getByOrderNo(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) {
        HashMap<String, String> rsParam = new HashMap<String, String>();
        rsParam.put("customerId", userinfoByCode.getUserinfoOcode());
        rsParam.put("orderNo", ocContractDomain.getContractNbbillcode());
        try {
            RefundDataVo refundDataVo;
            String message;
            String resultMsg = HttpUtils.doGetWithQuery(RequestConfiguration.BYORDERNO, rsParam, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)resultMsg, ResponseVo.class);
            if (responseVo.getCode() == 200 && StringUtils.isNotBlank((String)(message = responseVo.getData())) && (refundDataVo = (RefundDataVo)JSON.parseObject((String)message, RefundDataVo.class)) != null) {
                return refundDataVo;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String makeRefundParam(OcContractReDomain ocContractReDomain, OcRefundDomain ocRefundDomain, UmUserinfoReDomain userinfoByCode) {
        HashMap<String, String> rsParam = new HashMap<String, String>();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        rsParam.put("customerId", userinfoByCode.getUserinfoOcode());
        rsParam.put("orderNo", ocContractReDomain.getContractNbbillcode());
        try {
            RefundDataVo refundDataVo;
            String message;
            String resultMsg = HttpUtils.doGetWithQuery(RequestConfiguration.BYORDERNO, rsParam, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)resultMsg, ResponseVo.class);
            if (responseVo.getCode() == 200 && StringUtils.isNotBlank((String)(message = responseVo.getData())) && (refundDataVo = (RefundDataVo)JSON.parseObject((String)message, RefundDataVo.class)) != null) {
                requestParam.put("customerId", refundDataVo.getCustomerId());
                requestParam.put("detailOrderId", refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0).getOrderDetailId());
                requestParam.put("mainOrderId", refundDataVo.getMyOrderSubListDtos().get(0).getMainOrderId());
                requestParam.put("mainOrderNo", refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0).getMainOrderNo());
                requestParam.put("orderNo", refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0).getOrderNo());
                requestParam.put("orderSource", refundDataVo.getOrderSource());
                requestParam.put("productType", refundDataVo.getMyOrderSubListDtos().get(0).getProductType());
                requestParam.put("refundRemark", "1");
                requestParam.put("returnPrice", refundDataVo.getOrderPrice());
                return JSON.toJSONString(requestParam);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public String returnCheck(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnOrder.ocRefundDomain is null");
            return "fail";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberBcode(), tenantCode);
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocRefundDomain.getContractBillcode(), tenantCode, false}));
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryResult is null");
            return "fail";
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        try {
            String doPostJSON = HttpUtils.doGetWithQuery(RequestConfiguration.RETURNCHECK + userinfoByCode.getUserinfoOcode(), null, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            MyCardVo thisMyCardVo = null;
            Boolean checkCardFlag = false;
            if (responseVo != null && responseVo.getCode() == 200) {
                List myCardVos = JSON.parseArray((String)responseVo.getData(), MyCardVo.class);
                if (ListUtil.isEmpty((Collection)myCardVos)) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.myCardVos is null");
                    return "fail";
                }
                for (MyCardVo myCardVo : myCardVos) {
                    if (!ocContractReDomain.getContractNbbillcode().equals(myCardVo.getSaleOrderNo())) continue;
                    thisMyCardVo = myCardVo;
                    break;
                }
                if (thisMyCardVo == null || ListUtil.isEmpty(thisMyCardVo.getProductList())) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.thisMyCardVo is null");
                    return "fail";
                }
                for (productItemVo productItemVo2 : thisMyCardVo.getProductList()) {
                    if ("4".equals(productItemVo2.getRightsStatus())) continue;
                    checkCardFlag = true;
                    break;
                }
                if (checkCardFlag.booleanValue()) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.productItemVo.checkCardFlag", (Object)checkCardFlag);
                    return "fail";
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "success";
    }

    public OrderCustomerInfo makeOrderCustomerInfo(Map<String, Object> customer) {
        if (MapUtil.isNotEmpty(customer)) {
            String MobileNumber = customer.get("MobileNumber") == null ? "" : customer.get("MobileNumber").toString();
            String CustomerID = customer.get("CustomerID") == null ? "" : customer.get("CustomerID").toString();
            String CustomerName = customer.get("CustomerName") == null ? "" : customer.get("CustomerName").toString();
            String Email = customer.get("Email") == null ? "" : customer.get("Email").toString();
            return new OrderCustomerInfo(MobileNumber, CustomerName, CustomerID, null, null);
        }
        return null;
    }

    private UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public static void main(String[] args) {
        List myCardVos;
        String msg = "{\"code\":200,\"message\":\"\u64cd\u4f5c\u6210\u529f\",\"data\":[{\"benefitActivityCode\":\"BACT_20250310_16\",\"rightsType\":0,\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"prdShowTags\":null,\"productType\":\"coupon\",\"saleOrderNo\":\"20250619113813182317\",\"createDate\":\"2025-06-19\",\"productList\":[{\"id\":null,\"couponNo\":\"C2506191138162523F771918\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec\u514d\u7968\u5238\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}},{\"id\":null,\"couponNo\":\"C25061911381626242EA19B7\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec100\u5143\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}}]},{\"benefitActivityCode\":\"BACT_20250310_16\",\"rightsType\":0,\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"prdShowTags\":null,\"productType\":\"coupon\",\"saleOrderNo\":\"20250619113713903791\",\"createDate\":\"2025-06-19\",\"productList\":[{\"id\":null,\"couponNo\":\"C250619113716182D8031998\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec\u514d\u7968\u5238\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}},{\"id\":null,\"couponNo\":\"C25061911371619566B719DX\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec100\u5143\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}}]},{\"benefitActivityCode\":\"BACT_20250310_16\",\"rightsType\":0,\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"prdShowTags\":null,\"productType\":\"coupon\",\"saleOrderNo\":\"20250619104644313155\",\"createDate\":\"2025-06-19\",\"productList\":[{\"id\":null,\"couponNo\":\"C2506191046460146343190X\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec\u514d\u7968\u5238\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"99\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}},{\"id\":null,\"couponNo\":\"C2506191046460271D1E1975\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-19\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec100\u5143\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"99\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}}]},{\"benefitActivityCode\":\"BACT_20250310_16\",\"rightsType\":0,\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"prdShowTags\":null,\"productType\":\"coupon\",\"saleOrderNo\":\"20250618113137537710\",\"createDate\":\"2025-06-18\",\"productList\":[{\"id\":null,\"couponNo\":\"C250618113141260915B18A9\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-18\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec\u514d\u7968\u5238\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}},{\"id\":null,\"couponNo\":\"C250618113141273CB8918A1\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-18\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec100\u5143\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}}]},{\"benefitActivityCode\":\"BACT_20250310_16\",\"rightsType\":0,\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"prdShowTags\":null,\"productType\":\"coupon\",\"saleOrderNo\":\"20250618110530625186\",\"createDate\":\"2025-06-18\",\"productList\":[{\"id\":null,\"couponNo\":\"C2506181105323804362181X\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-18\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec\u514d\u7968\u5238\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}},{\"id\":null,\"couponNo\":\"C25061811053239709071862\",\"rightShowName\":\"\u4ea7\u54c1\u663e\u793a\u540d\u79f0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"rightsTitle\":null,\"source\":\"0\",\"sourceName\":\"\",\"prdShowTags\":null,\"tripInfo\":null,\"resCode\":\"C20231101008\",\"productCode\":\"P20231114004\",\"productType\":\"coupon\",\"createDate\":\"2025-06-18\",\"expiryDate\":\"2032-08-16\",\"flightDateInterval\":null,\"resDesc\":\"\u5361\u5238\u5ba2\u89c2\u6587\u672c-zyq\u6d4b\u8bd5\u673a\u7968\u5238\u5355\u72ec100\u5143\",\"revertDesc\":\"\u4ea7\u54c1\u63cf\u8ff0-zyq\u6d4b\u8bd5\u673a\u7968\u52382\u5f20\u6253\u5305\u9500\u552e\",\"revertCoupon\":null,\"revertCouponNo\":null,\"transferFlag\":null,\"transferFinishedFlag\":\"0\",\"verificationType\":null,\"rightsStatus\":\"4\",\"frontRightsStatus\":null,\"useScene\":null,\"imgProductList\":null,\"specPricingInfo\":{\"productNo\":null,\"specNo\":null,\"specName\":null,\"specPrice\":120.00,\"simpleImageUrl\":null}}]}]}";
        ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)msg, ResponseVo.class);
        if (responseVo != null && responseVo.getCode() == 200 && ListUtil.isNotEmpty((Collection)(myCardVos = JSON.parseArray((String)responseVo.getData(), MyCardVo.class)))) {
            for (MyCardVo myCardVo : myCardVos) {
            }
        }
    }
}

