/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OKHttpClientUtil {
    private static volatile OkHttpClient client = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getOkHttpClirnt() {
        if (client != null) return client;
        Class<OKHttpClientUtil> clazz = OKHttpClientUtil.class;
        synchronized (OKHttpClientUtil.class) {
            if (client != null) return client;
            client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(50, 60L, TimeUnit.SECONDS)).addInterceptor((Interceptor)new RetryInterceptor(3)).socketFactory((SocketFactory)new KeepAliveSocketFactory()).followRedirects(true).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private static class RetryInterceptor
    implements Interceptor {
        private final int maxRetries;

        public RetryInterceptor(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            IOException lastException = null;
            for (int i = 0; i <= this.maxRetries; ++i) {
                try {
                    if (i > 0) {
                        System.err.println("\u7b2c" + i + "\u6b21\u91cd\u8bd5\u8bf7\u6c42\uff1a" + request.url());
                    }
                    return chain.proceed(request);
                }
                catch (IOException e) {
                    lastException = e;
                    if (!(e instanceof SocketException) && !(e instanceof SocketTimeoutException) || i == this.maxRetries) break;
                    try {
                        Thread.sleep((long)(Math.pow(2.0, i) * 1000.0));
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            throw lastException;
        }
    }

    private static class KeepAliveSocketFactory
    extends SocketFactory {
        private final SocketFactory defaultFactory = SocketFactory.getDefault();

        private KeepAliveSocketFactory() {
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = this.defaultFactory.createSocket();
            try {
                socket.setKeepAlive(true);
                socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(60L));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.wrapSocket(this.defaultFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.wrapSocket(this.defaultFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.wrapSocket(this.defaultFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.wrapSocket(this.defaultFactory.createSocket(address, port, localAddress, localPort));
        }

        private Socket wrapSocket(Socket socket) {
            try {
                socket.setKeepAlive(true);
                socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(60L));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return socket;
        }
    }
}

