/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.support;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TimestampEditor
extends PropertyEditorSupport {
    private String full_timeformat = "yyyy-MM-dd HH:mm:ss";

    public TimestampEditor() {
    }

    public TimestampEditor(String dateFormat) {
        this.full_timeformat = dateFormat;
    }

    @Override
    public void setAsText(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.setValue(null);
            return;
        }
        String formtText = this.full_timeformat;
        if (value.length() <= this.full_timeformat.length()) {
            formtText = StringUtils.substring((String)this.full_timeformat, (int)0, (int)value.length());
        }
        Timestamp date = this.format(formtText, value);
        this.setValue(date);
    }

    protected Timestamp format(String formtText, String value) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(formtText);
            Timestamp date = new Timestamp(format.parse(value).getTime());
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        return value != null ? new SimpleDateFormat(this.full_timeformat).format(value) : "";
    }
}

