/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.web.controller;

import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.service.XuankuaService;
import com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.support.ResultCode;
import com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.vo.XkMovieOrderVo;
import com.yqbsoft.laser.service.ext.data.cyy.service.xuankua.vo.XkMovieSeatVo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
public class MovieController {
    @Autowired
    private XuankuaService xuankuaService;

    @RequestMapping(value={"/"})
    public String index() {
        return "OK";
    }

    @RequestMapping(value={"/cityList"})
    public ResultCode getCityList() {
        return this.xuankuaService.getCityList();
    }

    @RequestMapping(value={"/countyList"})
    public ResultCode getCountyList(Integer cityCode) {
        return this.xuankuaService.getCountyList(cityCode);
    }

    @RequestMapping(value={"/hotMovieList"})
    public ResultCode hotMovieList(Integer cityCode) {
        return this.xuankuaService.getHotMovie(cityCode);
    }

    @RequestMapping(value={"/futureMovieList"})
    public ResultCode getFutureMovie(Integer cityCode) {
        return this.xuankuaService.getFutureMovie(cityCode);
    }

    @RequestMapping(value={"/movieDetail"})
    public ResultCode movieDetail(Integer movieId, Integer cityCode) {
        return this.xuankuaService.getMovieDetail(movieId, cityCode);
    }

    @RequestMapping(value={"/cinemaList"})
    public ResultCode cinemaList(Integer cityCode, Integer pageNo) {
        return this.xuankuaService.getCinemaList(cityCode, pageNo);
    }

    @RequestMapping(value={"/cinemaDetail"})
    public ResultCode cinemaDetail(Integer cinemaId) {
        return this.xuankuaService.getCinemaDetail(cinemaId);
    }

    @RequestMapping(value={"/getMoviePlayCinemaList"})
    public ResultCode getMoviePlayCinemaList(Integer cityCode, Integer movieId, String playdate) {
        return this.xuankuaService.getMoviePlayCinemaList(cityCode, movieId, playdate);
    }

    @RequestMapping(value={"/getOpiList"})
    public ResultCode getOpiList(Integer cinemaId) {
        return this.xuankuaService.getOpiList(cinemaId);
    }

    @RequestMapping(value={"/getOpiV3List"})
    public ResultCode getOpiV3List(Integer cinemaId) {
        return this.xuankuaService.getOpiV3List(cinemaId);
    }

    @RequestMapping(value={"/getOpiSeat"})
    public String getOpiSeat(String opiId) {
        ResultCode<XkMovieSeatVo> code = this.xuankuaService.getSeatMap(opiId);
        if (!code.isSuccess()) {
            return code.getMsg();
        }
        List<XkMovieSeatVo.SeatVo> seatList = code.getData().getSeatList();
        HashMap<String, XkMovieSeatVo.SeatVo> seatVoMap = new HashMap<String, XkMovieSeatVo.SeatVo>();
        for (XkMovieSeatVo.SeatVo seatVo : seatList) {
            seatVoMap.put(seatVo.getRow() + ":" + seatVo.getColumn(), seatVo);
        }
        ArrayList<String> strList = new ArrayList<String>();
        XkMovieSeatVo.OpiDetailVo opiDetailVo = code.getData().getOpi();
        for (int i = opiDetailVo.getMinrow().intValue(); i <= opiDetailVo.getMaxrow(); ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = opiDetailVo.getMincolumn().intValue(); j <= opiDetailVo.getMaxcolumn(); ++j) {
                XkMovieSeatVo.SeatVo seatVo = (XkMovieSeatVo.SeatVo)seatVoMap.get(i + ":" + j);
                if (seatVo != null) {
                    if (seatVo.getStatus() == 1) {
                        sb.append("O");
                        continue;
                    }
                    sb.append("X");
                    continue;
                }
                sb.append("&nbsp;&nbsp;");
            }
            strList.add(sb.toString());
        }
        return StringUtils.join(strList, (String)"<br/>");
    }

    @RequestMapping(value={"/lockSeat"})
    public ResultCode lockSeat(String opiId, String seatids, String seatnames, String mobile) {
        return this.xuankuaService.lockSeat(opiId, seatids, seatnames, mobile);
    }

    @RequestMapping(value={"/cancelOrder"})
    public ResultCode cancelSeat(String xkTradeno) {
        return this.xuankuaService.cancelOrder(xkTradeno);
    }

    @RequestMapping(value={"/orderDetail"})
    public ResultCode orderDetail(String xkTradeno) {
        return this.xuankuaService.getOrderDetail(xkTradeno);
    }

    @RequestMapping(value={"/sellSeat"})
    public ResultCode sellSeat(String xkTradeno, String partnerTradeno) {
        return this.xuankuaService.sellSeat(xkTradeno, partnerTradeno);
    }

    @RequestMapping(value={"/receiveOrderStatus"}, produces={"text/plain;charset=UTF-8"})
    public String receiveOrderStatus(HttpServletRequest request) {
        Map<String, String> params = MovieController.getRequestParams();
        if (!this.xuankuaService.isValidSign(params)) {
            return "SIGN ERROR";
        }
        String xkTradeno = MapUtils.getString(params, (Object)"tradeno");
        String ordertype = MapUtils.getString(params, (Object)"ordertype");
        String orderStatus = MapUtils.getString(params, (Object)"orderstatus");
        String refundReason = MapUtils.getString(params, (Object)"refundReason");
        ResultCode<XkMovieOrderVo> code = this.xuankuaService.getOrderDetail(xkTradeno);
        if (!code.isSuccess()) {
            return code.getMsg();
        }
        XkMovieOrderVo xkMovieOrderVo = code.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)xkMovieOrderVo.getOrder().getOrderstatus(), (CharSequence)"S") || StringUtils.equalsIgnoreCase((CharSequence)xkMovieOrderVo.getOrder().getOrderstatus(), (CharSequence)"R")) {
            // empty if block
        }
        return "SUCCESS";
    }

    public static Map<String, String> getRequestParams() {
        HttpServletRequest request;
        ServletRequestAttributes holder = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (holder != null && (request = holder.getRequest()) != null) {
            return MovieController.getRequestMap(request);
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public static final Map<String, String> getRequestMap(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration it = request.getParameterNames();
        String key = null;
        while (it.hasMoreElements()) {
            key = (String)it.nextElement();
            result.put(key, request.getParameter(key));
        }
        return result;
    }
}

