/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaStatistics;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubAndStatisticsThread
implements Runnable {
    private final DaStatisticsService statisticsService;
    private final DaOrderTotalService orderTotalService;
    private final OcRefundDomain ocRefundDomain;
    private final DaOrderLogService orderLogService;
    private DaOrderLogDomain orderLogDomain;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public SubAndStatisticsThread(DaStatisticsService statisticsService, DaOrderTotalService orderTotalService, OcRefundDomain ocRefundDomain, DaOrderLogService orderLogService, DaOrderLogDomain orderLogDomain) {
        this.statisticsService = statisticsService;
        this.orderTotalService = orderTotalService;
        this.ocRefundDomain = ocRefundDomain;
        this.orderLogService = orderLogService;
        this.orderLogDomain = orderLogDomain;
    }

    @Override
    public void run() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("insuranceOpcode1", this.ocRefundDomain.getContractBillcode());
        param.put("tenantCode", this.ocRefundDomain.getTenantCode());
        param.put("atherTime", this.ocRefundDomain.getGmtCreate());
        for (OcRefundGoodsDomain or : this.ocRefundDomain.getOcRefundGoodsDomainList()) {
            param.put("appmanageIcode", or.getSkuCode());
            if (this.ocRefundDomain.getDataState() == 8) {
                this.logger.error("-----SubAndStatisticsThread-----\u9000\u5355\u7edf\u8ba1----");
                param.put("refundTime", this.ocRefundDomain.getGmtModified());
                param.put("dataOcstate", -1);
                this.orderTotalService.updateOrderTotalDataOcstate(param);
                this.statistics(this.ocRefundDomain);
                this.updateOrderDataOcstate(param);
                continue;
            }
            if (this.ocRefundDomain.getDataState() == 0) {
                this.logger.error("-----SubAndStatisticsThread-----\u7533\u8bf7\u552e\u540e\u65f6\u95f4----", (Object)JsonUtil.buildNormalBinder().toJson(param));
                param.put("refundCode", this.ocRefundDomain.getRefundCode());
                this.orderTotalService.updateOrderTotalDataOcstate(param);
                continue;
            }
            if (this.ocRefundDomain.getDataState() != 1 && this.ocRefundDomain.getDataState() != -1) continue;
            this.logger.error("-----SubAndStatisticsThread-----\u5ba1\u6838\u65f6\u95f4----");
            param.put("refundTime", this.ocRefundDomain.getGmtModified());
            this.orderTotalService.updateOrderTotalDataOcstate(param);
        }
    }

    public void updateOrderDataOcstate(Map<String, Object> map) {
        map.put("appmanageIcode", null);
        map.put("atherTime", null);
        map.put("refundTime", null);
        map.put("memo", "2");
        QueryResult<DaOrderTotal> daOrderTotalQueryResult = this.orderTotalService.queryOrderTotalPage(map);
        if (ListUtil.isNotEmpty((Collection)daOrderTotalQueryResult.getList())) {
            Boolean flag = true;
            for (DaOrderTotal daOrderTotal : daOrderTotalQueryResult.getList()) {
                if (daOrderTotal.getDataOcstate() == -1) continue;
                flag = false;
            }
            if (flag.booleanValue()) {
                map.put("memo", "1");
                map.put("dataOcstate", -1);
                this.orderTotalService.updateOrderTotalDataOcstate(map);
            }
        }
    }

    public void statistics(OcRefundDomain ocRefundDomain) {
        if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            for (OcRefundGoodsDomain or : ocRefundDomain.getOcRefundGoodsDomainList()) {
                this.logger.error("-----SubAndStatisticsThread-----\u9000\u5355\u7edf\u8ba1----", (Object)JsonUtil.buildNormalBinder().toJson((Object)or));
                BigDecimal refundGoodsAmt = or.getRefundGoodsAmt();
                BigDecimal pricesetRefrice = or.getPricesetRefrice();
                BigDecimal refundNum = or.getRefundGoodsNum();
                pricesetRefrice = pricesetRefrice.multiply(refundNum);
                HashMap<String, Object> param = new HashMap<String, Object>();
                String memberMcode = or.getSkuCode();
                param.put("memberMcode", memberMcode);
                String tenantCode = or.getTenantCode();
                param.put("tenantCode", tenantCode);
                String memberCode = or.getMemberCcode();
                param.put("memberCode", memberCode);
                DaStatistics statisticsByCodes = this.statisticsService.getStatisticsByCodes(tenantCode, memberMcode, memberCode);
                if (null != statisticsByCodes) {
                    pricesetRefrice = pricesetRefrice.add(statisticsByCodes.getDiscountCount());
                    param.put("discountCount", pricesetRefrice);
                    refundGoodsAmt = refundGoodsAmt.add(statisticsByCodes.getPaidIn());
                    param.put("paidIn", refundGoodsAmt);
                    refundNum = refundNum.add(statisticsByCodes.getRefundNum());
                    param.put("refundNum", refundNum);
                    this.logger.error("-----SubAndStatisticsThread----\u4fee\u6539---\u9000\u5355\u7edf\u8ba1----", (Object)JsonUtil.buildNormalBinder().toJson(param));
                    this.statisticsService.updateStatisticsAmount(param);
                    continue;
                }
                DaStatisticsDomain statisticsDomain = new DaStatisticsDomain();
                statisticsDomain.setMemberMcode(memberMcode);
                statisticsDomain.setMemberMname(or.getGoodsName());
                statisticsDomain.setMemberBcode(or.getSkuNo());
                statisticsDomain.setMemberCode(memberCode);
                statisticsDomain.setMemberName(or.getMemberCname());
                statisticsDomain.setTenantCode(tenantCode);
                statisticsDomain.setSellingPrice(BigDecimal.valueOf(0L));
                statisticsDomain.setGoodsCost(BigDecimal.valueOf(0L));
                statisticsDomain.setDiscountCount(pricesetRefrice);
                statisticsDomain.setPaidIn(refundGoodsAmt);
                statisticsDomain.setGoodsNum(BigDecimal.valueOf(0L));
                statisticsDomain.setRefundNum(refundNum);
                this.logger.error("-----SubAndStatisticsThread---\u65b0\u589e---\u9000\u5355\u7edf\u8ba1----", (Object)JsonUtil.buildNormalBinder().toJson((Object)statisticsDomain));
                this.statisticsService.saveStatistics(statisticsDomain);
            }
            DaOrderLog log = this.orderLogService.getOrderLogByCode(this.orderLogDomain.getTenantCode(), this.orderLogDomain.getLogCode());
            if (null != log) {
                DaOrderLogDomain dld = new DaOrderLogDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)dld, (Object)log);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dld.setLogStat(false);
                this.orderLogService.updateOrderLog(dld);
            }
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

