/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmPushLogMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmPushLoglistMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmPushRuleMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushLogDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushLogReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushLoglistDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushLoglistReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushRuleDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPushRuleReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.OcReorderDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmPushLog;
import com.yqbsoft.laser.service.esb.appmanage.model.AmPushLoglist;
import com.yqbsoft.laser.service.esb.appmanage.model.AmPushRule;
import com.yqbsoft.laser.service.esb.appmanage.service.AmPushRuleService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmPushRuleServiceImpl
extends BaseServiceImpl
implements AmPushRuleService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmPushRuleServiceImpl";
    private AmPushRuleMapper amPushRuleMapper;
    private AmPushLogMapper amPushLogMapper;
    private AmPushLoglistMapper amPushLoglistMapper;

    public void setAmPushRuleMapper(AmPushRuleMapper amPushRuleMapper) {
        this.amPushRuleMapper = amPushRuleMapper;
    }

    public void setAmPushLogMapper(AmPushLogMapper amPushLogMapper) {
        this.amPushLogMapper = amPushLogMapper;
    }

    public void setAmPushLoglistMapper(AmPushLoglistMapper amPushLoglistMapper) {
        this.amPushLoglistMapper = amPushLoglistMapper;
    }

    private Date getSysDate() {
        try {
            return this.amPushRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPushRule(AmPushRuleDomain amPushRuleDomain) {
        if (null == amPushRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amPushRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPushRuleDefault(AmPushRule amPushRule) {
        if (null == amPushRule) {
            return;
        }
        if (null == amPushRule.getDataState()) {
            amPushRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amPushRule.getGmtCreate()) {
            amPushRule.setGmtCreate(date);
        }
        amPushRule.setGmtModified(date);
        if (StringUtils.isBlank((String)amPushRule.getPushRuleCode())) {
            amPushRule.setPushRuleCode(this.createUUIDString());
        }
    }

    private int getPushRuleMaxCode() {
        int code = 0;
        try {
            return this.amPushRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPushRuleUpdataDefault(AmPushRule amPushRule) {
        if (null == amPushRule) {
            return;
        }
        amPushRule.setGmtModified(this.getSysDate());
    }

    private void savePushRuleModel(AmPushRule amPushRule) throws ApiException {
        if (null == amPushRule) {
            return;
        }
        try {
            this.amPushRuleMapper.insert(amPushRule);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushRuleModel.ex", (Throwable)e);
        }
    }

    private void savePushRuleBatchModel(List<AmPushRule> amPushRuleList) throws ApiException {
        if (null == amPushRuleList || amPushRuleList.isEmpty()) {
            return;
        }
        try {
            this.amPushRuleMapper.insertBatch(amPushRuleList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushRuleBatchModel.ex", (Throwable)e);
        }
    }

    private AmPushRule getPushRuleModelById(Integer pushRuleId) {
        if (null == pushRuleId) {
            return null;
        }
        try {
            return this.amPushRuleMapper.selectByPrimaryKey(pushRuleId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushRuleModelById", (Throwable)e);
            return null;
        }
    }

    private AmPushRule getPushRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amPushRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private AmPushRule getPushRuleModelByappapiCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amPushRuleMapper.getByappapiCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPushRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushRuleModelByCode.num");
        }
    }

    private void deletePushRuleModel(Integer pushRuleId) throws ApiException {
        if (null == pushRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushRuleMapper.deleteByPrimaryKey(pushRuleId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushRuleModel.num");
        }
    }

    private void updatePushRuleModel(AmPushRule amPushRule) throws ApiException {
        if (null == amPushRule) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushRuleMapper.updateByPrimaryKey(amPushRule);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushRuleModel.num");
        }
    }

    private void updateStatePushRuleModel(Integer pushRuleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pushRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushRuleId", pushRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushRuleModel.null");
        }
    }

    private void updateStatePushRuleModelByCode(String tenantCode, String pushRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pushRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushRuleCode", pushRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushRuleModelByCode.null");
        }
    }

    private AmPushRule makePushRule(AmPushRuleDomain amPushRuleDomain, AmPushRule amPushRule) {
        if (null == amPushRuleDomain) {
            return null;
        }
        if (null == amPushRule) {
            amPushRule = new AmPushRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amPushRule, (Object)amPushRuleDomain);
            return amPushRule;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makePushRule", (Throwable)e);
            return null;
        }
    }

    private AmPushRuleReDomain makeAmPushRuleReDomain(AmPushRule amPushRule) {
        if (null == amPushRule) {
            return null;
        }
        AmPushRuleReDomain amPushRuleReDomain = new AmPushRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amPushRuleReDomain, (Object)amPushRule);
            return amPushRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makeAmPushRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmPushRule> queryPushRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.amPushRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.queryPushRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countPushRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amPushRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.countPushRule", (Throwable)e);
        }
        return i;
    }

    private AmPushRule createAmPushRule(AmPushRuleDomain amPushRuleDomain) {
        String msg = this.checkPushRule(amPushRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushRule.checkPushRule", msg);
        }
        AmPushRule amPushRule = this.makePushRule(amPushRuleDomain, null);
        this.setPushRuleDefault(amPushRule);
        return amPushRule;
    }

    private String checkPushLog(AmPushLogDomain amPushLogDomain) {
        if (null == amPushLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amPushLogDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amPushLogDomain.getPushLogType())) {
            msg = msg + "pushLogType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPushLogDefault(AmPushLog amPushLog) {
        if (null == amPushLog) {
            return;
        }
        if (null == amPushLog.getDataState()) {
            amPushLog.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amPushLog.getGmtCreate()) {
            amPushLog.setGmtCreate(date);
        }
        amPushLog.setGmtModified(date);
        if (StringUtils.isBlank((String)amPushLog.getPushLogCode())) {
            amPushLog.setPushLogCode(this.createUUIDString());
        }
        if (null != amPushLog.getPushLogNum() && StringUtils.isNotBlank((String)amPushLog.getPushLogFrequency())) {
            Date nextTime = AmPushRuleServiceImpl.calculateNextTime(date, amPushLog.getPushLogNum(), amPushLog.getPushLogFrequency());
            amPushLog.setPushLogTime(nextTime);
        }
        if (StringUtils.isBlank((String)amPushLog.getPushRuleCode())) {
            amPushLog.setDataState(-1);
        }
    }

    private int getPushLogMaxCode() {
        int code = 0;
        try {
            return this.amPushLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLogMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPushLogUpdataDefault(AmPushLog amPushLog) {
        if (null == amPushLog) {
            return;
        }
        Date date = this.getSysDate();
        amPushLog.setGmtModified(date);
        if (null != amPushLog.getPushLogNum() && StringUtils.isNotBlank((String)amPushLog.getPushLogFrequency())) {
            Date nextTime = AmPushRuleServiceImpl.calculateNextTime(date, amPushLog.getPushLogNum(), amPushLog.getPushLogFrequency());
            amPushLog.setPushLogTime(nextTime);
        }
    }

    private void savePushLogModel(AmPushLog amPushLog) throws ApiException {
        if (null == amPushLog) {
            return;
        }
        try {
            this.amPushLogMapper.insert(amPushLog);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLogModel.ex", (Throwable)e);
        }
    }

    private void savePushLogBatchModel(List<AmPushLog> amPushLogList) throws ApiException {
        if (null == amPushLogList || amPushLogList.isEmpty()) {
            return;
        }
        try {
            this.amPushLogMapper.insertBatch(amPushLogList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLogBatchModel.ex", (Throwable)e);
        }
    }

    private AmPushLog getPushLogModelById(Integer pushLogId) {
        if (null == pushLogId) {
            return null;
        }
        try {
            return this.amPushLogMapper.selectByPrimaryKey(pushLogId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLogModelById", (Throwable)e);
            return null;
        }
    }

    private AmPushLog getPushLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amPushLogMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLogModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPushLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLogMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushLogModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushLogModelByCode.num");
        }
    }

    private void deletePushLogModel(Integer pushLogId) throws ApiException {
        if (null == pushLogId) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLogMapper.deleteByPrimaryKey(pushLogId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushLogModel.num");
        }
    }

    private void updatePushLogModel(AmPushLog amPushLog) throws ApiException {
        if (null == amPushLog) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLogMapper.updateByPrimaryKey(amPushLog);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLogModel.num");
        }
    }

    private void updateStatePushLogModel(Integer pushLogId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pushLogId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushLogId", pushLogId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLogModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLogModel.null");
        }
    }

    private void updateStatePushLogModelByCode(String tenantCode, String pushLogCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pushLogCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLogCode", pushLogCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushLogMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLogModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLogModelByCode.null");
        }
    }

    private AmPushLog makePushLog(AmPushLogDomain amPushLogDomain, AmPushLog amPushLog) {
        if (null == amPushLogDomain) {
            return null;
        }
        if (null == amPushLog) {
            amPushLog = new AmPushLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amPushLog, (Object)amPushLogDomain);
            return amPushLog;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makePushLog", (Throwable)e);
            return null;
        }
    }

    private AmPushLogDomain makePushLogByList(AmPushLoglist amPushLogDomain) {
        if (null == amPushLogDomain) {
            return null;
        }
        AmPushLogDomain amPushLog = new AmPushLogDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amPushLog, (Object)amPushLogDomain);
            amPushLog.setPushLogType(amPushLogDomain.getPushType());
            return amPushLog;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makePushLog", (Throwable)e);
            return null;
        }
    }

    private AmPushLogReDomain makeAmPushLogReDomain(AmPushLog amPushLog) {
        if (null == amPushLog) {
            return null;
        }
        AmPushLogReDomain amPushLogReDomain = new AmPushLogReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amPushLogReDomain, (Object)amPushLog);
            return amPushLogReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makeAmPushLogReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmPushLog> queryPushLogModelPage(Map<String, Object> parammap) {
        try {
            return this.amPushLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.queryPushLogModel", (Throwable)e);
            return null;
        }
    }

    private int countPushLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amPushLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.countPushLog", (Throwable)e);
        }
        return i;
    }

    private AmPushLog createAmPushLog(AmPushLogDomain amPushLogDomain) {
        String msg = this.checkPushLog(amPushLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLog.checkPushLog", msg);
        }
        AmPushLog amPushLog = this.makePushLog(amPushLogDomain, null);
        this.setPushLogDefault(amPushLog);
        return amPushLog;
    }

    private String checkPushLoglist(AmPushLoglistDomain amPushLoglistDomain) {
        if (null == amPushLoglistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amPushLoglistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amPushLoglistDomain.getPushType())) {
            msg = msg + "pushType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amPushLoglistDomain.getPushLogOcode())) {
            msg = msg + "pushLogOcode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPushLoglistDefault(AmPushLoglist amPushLoglist) {
        if (null == amPushLoglist) {
            return;
        }
        if (null == amPushLoglist.getDataState()) {
            amPushLoglist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amPushLoglist.getGmtCreate()) {
            amPushLoglist.setGmtCreate(date);
        }
        amPushLoglist.setGmtModified(date);
        if (StringUtils.isBlank((String)amPushLoglist.getPushLoglistCode())) {
            amPushLoglist.setPushLoglistCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)amPushLoglist.getPushLogCode())) {
            amPushLoglist.setPushLogCode(amPushLoglist.getPushType() + "_" + amPushLoglist.getAppapiCode() + "_" + amPushLoglist.getPushLogOcode());
        }
    }

    private int getPushLoglistMaxCode() {
        int code = 0;
        try {
            return this.amPushLoglistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLoglistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPushLoglistUpdataDefault(AmPushLoglist amPushLoglist) {
        if (null == amPushLoglist) {
            return;
        }
        amPushLoglist.setGmtModified(this.getSysDate());
    }

    private void savePushLoglistModel(AmPushLoglist amPushLoglist) throws ApiException {
        if (null == amPushLoglist) {
            return;
        }
        try {
            this.amPushLoglistMapper.insert(amPushLoglist);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLoglistModel.ex", (Throwable)e);
        }
    }

    private void savePushLoglistBatchModel(List<AmPushLoglist> amPushLoglistList) throws ApiException {
        if (null == amPushLoglistList || amPushLoglistList.isEmpty()) {
            return;
        }
        try {
            this.amPushLoglistMapper.insertBatch(amPushLoglistList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLoglistBatchModel.ex", (Throwable)e);
        }
    }

    private AmPushLoglist getPushLoglistModelById(Integer pushLoglistId) {
        if (null == pushLoglistId) {
            return null;
        }
        try {
            return this.amPushLoglistMapper.selectByPrimaryKey(pushLoglistId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLoglistModelById", (Throwable)e);
            return null;
        }
    }

    private AmPushLoglist getPushLoglistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amPushLoglistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.getPushLoglistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPushLoglistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLoglistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushLoglistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.delPushLoglistModelByCode.num");
        }
    }

    private void deletePushLoglistModel(Integer pushLoglistId) throws ApiException {
        if (null == pushLoglistId) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLoglistMapper.deleteByPrimaryKey(pushLoglistId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushLoglistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.deletePushLoglistModel.num");
        }
    }

    private void updatePushLoglistModel(AmPushLoglist amPushLoglist) throws ApiException {
        if (null == amPushLoglist) {
            return;
        }
        int i = 0;
        try {
            i = this.amPushLoglistMapper.updateByPrimaryKey(amPushLoglist);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLoglistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLoglistModel.num");
        }
    }

    private void updateStatePushLoglistModel(Integer pushLoglistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pushLoglistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushLoglistId", pushLoglistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushLoglistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLoglistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLoglistModel.null");
        }
    }

    private void updateStatePushLoglistModelByCode(String tenantCode, String pushLoglistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pushLoglistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLoglistCode", pushLoglistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amPushLoglistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLoglistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updateStatePushLoglistModelByCode.null");
        }
    }

    private AmPushLoglist makePushLoglist(AmPushLoglistDomain amPushLoglistDomain, AmPushLoglist amPushLoglist) {
        if (null == amPushLoglistDomain) {
            return null;
        }
        if (null == amPushLoglist) {
            amPushLoglist = new AmPushLoglist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amPushLoglist, (Object)amPushLoglistDomain);
            return amPushLoglist;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makePushLoglist", (Throwable)e);
            return null;
        }
    }

    private AmPushLoglistReDomain makeAmPushLoglistReDomain(AmPushLoglist amPushLoglist) {
        if (null == amPushLoglist) {
            return null;
        }
        AmPushLoglistReDomain amPushLoglistReDomain = new AmPushLoglistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amPushLoglistReDomain, (Object)amPushLoglist);
            return amPushLoglistReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.makeAmPushLoglistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmPushLoglist> queryPushLoglistModelPage(Map<String, Object> parammap) {
        try {
            return this.amPushLoglistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.queryPushLoglistModel", (Throwable)e);
            return null;
        }
    }

    private int countPushLoglist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amPushLoglistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.countPushLoglist", (Throwable)e);
        }
        return i;
    }

    private AmPushLoglist createAmPushLoglist(AmPushLoglistDomain amPushLoglistDomain) {
        String msg = this.checkPushLoglist(amPushLoglistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.savePushLoglist.checkPushLoglist", msg);
        }
        AmPushLoglist amPushLoglist = this.makePushLoglist(amPushLoglistDomain, null);
        this.setPushLoglistDefault(amPushLoglist);
        return amPushLoglist;
    }

    @Override
    public String savePushRule(AmPushRuleDomain amPushRuleDomain) throws ApiException {
        AmPushRule amPushRule = this.createAmPushRule(amPushRuleDomain);
        this.savePushRuleModel(amPushRule);
        return amPushRule.getPushRuleCode();
    }

    @Override
    public String savePushRuleBatch(List<AmPushRuleDomain> amPushRuleDomainList) throws ApiException {
        if (null == amPushRuleDomainList || amPushRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmPushRule> amPushRuleList = new ArrayList<AmPushRule>();
        String code = "";
        for (AmPushRuleDomain amPushRuleDomain : amPushRuleDomainList) {
            AmPushRule amPushRule = this.createAmPushRule(amPushRuleDomain);
            code = amPushRule.getPushRuleCode();
            amPushRuleList.add(amPushRule);
        }
        this.savePushRuleBatchModel(amPushRuleList);
        return code;
    }

    @Override
    public void updatePushRuleState(Integer pushRuleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pushRuleId) {
            return;
        }
        this.updateStatePushRuleModel(pushRuleId, dataState, oldDataState, map);
    }

    @Override
    public void updatePushRuleStateByCode(String tenantCode, String pushRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pushRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePushRuleModelByCode(tenantCode, pushRuleCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePushRule(AmPushRuleDomain amPushRuleDomain) throws ApiException {
        String msg = this.checkPushRule(amPushRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushRule.checkPushRule", msg);
        }
        AmPushRule oldAmPushRule = this.getPushRuleModelById(amPushRuleDomain.getPushRuleId());
        if (null == oldAmPushRule) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmPushRule amPushRule = this.makePushRule(amPushRuleDomain, oldAmPushRule);
        this.setPushRuleUpdataDefault(amPushRule);
        this.updatePushRuleModel(amPushRule);
    }

    @Override
    public AmPushRule getPushRule(Integer pushRuleId) {
        if (null == pushRuleId) {
            return null;
        }
        return this.getPushRuleModelById(pushRuleId);
    }

    @Override
    public void deletePushRule(Integer pushRuleId) throws ApiException {
        if (null == pushRuleId) {
            return;
        }
        this.deletePushRuleModel(pushRuleId);
    }

    @Override
    public QueryResult<AmPushRule> queryPushRulePage(Map<String, Object> map) {
        List<AmPushRule> amPushRuleList = this.queryPushRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPushRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amPushRuleList);
        return queryResult;
    }

    @Override
    public AmPushRule getPushRuleByCode(String tenantCode, String pushRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pushRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushRuleCode", pushRuleCode);
        return this.getPushRuleModelByCode(map);
    }

    @Override
    public AmPushRule getPushRuleByappapiCode(String tenantCode, String appapiCode) throws ApiException {
        if (StringUtils.isBlank((String)appapiCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appapiCode", appapiCode);
        return this.getPushRuleModelByappapiCode(map);
    }

    @Override
    public void deletePushRuleByCode(String tenantCode, String pushRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pushRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushRuleCode", pushRuleCode);
        this.delPushRuleModelByCode(map);
    }

    @Override
    public String savePushLog(AmPushLogDomain amPushLogDomain) throws ApiException {
        AmPushLog amPushLog = this.createAmPushLog(amPushLogDomain);
        this.savePushLogModel(amPushLog);
        return amPushLog.getPushLogCode();
    }

    @Override
    public String savePushLogBatch(List<AmPushLogDomain> amPushLogDomainList) throws ApiException {
        if (null == amPushLogDomainList || amPushLogDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmPushLog> amPushLogList = new ArrayList<AmPushLog>();
        String code = "";
        for (AmPushLogDomain amPushLogDomain : amPushLogDomainList) {
            AmPushLog amPushLog = this.createAmPushLog(amPushLogDomain);
            code = amPushLog.getPushLogCode();
            amPushLogList.add(amPushLog);
        }
        this.savePushLogBatchModel(amPushLogList);
        return code;
    }

    @Override
    public void updatePushLogState(Integer pushLogId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pushLogId) {
            return;
        }
        this.updateStatePushLogModel(pushLogId, dataState, oldDataState, map);
    }

    @Override
    public void updatePushLogStateByCode(String tenantCode, String pushLogCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pushLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePushLogModelByCode(tenantCode, pushLogCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePushLog(AmPushLogDomain amPushLogDomain) throws ApiException {
        String msg = this.checkPushLog(amPushLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLog.checkPushLog", msg);
        }
        AmPushLog oldAmPushLog = this.getPushLogModelById(amPushLogDomain.getPushLogId());
        if (null == oldAmPushLog) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmPushLog amPushLog = this.makePushLog(amPushLogDomain, oldAmPushLog);
        this.setPushLogUpdataDefault(amPushLog);
        this.updatePushLogModel(amPushLog);
    }

    @Override
    public AmPushLog getPushLog(Integer pushLogId) {
        if (null == pushLogId) {
            return null;
        }
        return this.getPushLogModelById(pushLogId);
    }

    @Override
    public void deletePushLog(Integer pushLogId) throws ApiException {
        if (null == pushLogId) {
            return;
        }
        this.deletePushLogModel(pushLogId);
    }

    @Override
    public QueryResult<AmPushLog> queryPushLogPage(Map<String, Object> map) {
        List<AmPushLog> amPushLogList = this.queryPushLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPushLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amPushLogList);
        return queryResult;
    }

    @Override
    public AmPushLog getPushLogByCode(String tenantCode, String pushLogCode) throws ApiException {
        if (StringUtils.isBlank((String)pushLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLogCode", pushLogCode);
        return this.getPushLogModelByCode(map);
    }

    @Override
    public void deletePushLogByCode(String tenantCode, String pushLogCode) throws ApiException {
        if (StringUtils.isBlank((String)pushLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLogCode", pushLogCode);
        this.delPushLogModelByCode(map);
    }

    @Override
    public String savePushLoglist(AmPushLoglistDomain amPushLoglistDomain) throws ApiException {
        AmPushLoglist amPushLoglist = this.createAmPushLoglist(amPushLoglistDomain);
        AmPushLog amPushLog = this.getPushLogByCode(amPushLoglist.getTenantCode(), amPushLoglist.getPushLogCode());
        if (null == amPushLog) {
            AmPushLogDomain amPushLogDomain = this.makePushLogByList(amPushLoglist);
            amPushLogDomain.setPushLogNum(0);
            AmPushRule pushRule = this.getPushRuleByappapiCode(amPushLoglist.getTenantCode(), amPushLoglist.getAppapiCode());
            if (null != pushRule) {
                amPushLogDomain.setPushLogFrequency(pushRule.getPushRuleFrequency());
                amPushLogDomain.setPushRuleCode(pushRule.getPushRuleCode());
            }
            this.savePushLog(amPushLogDomain);
        } else {
            amPushLog.setPushLogNum(amPushLog.getPushLogNum() + 1);
            this.setPushLogUpdataDefault(amPushLog);
            this.updatePushLogModel(amPushLog);
        }
        this.savePushLoglistModel(amPushLoglist);
        return amPushLoglist.getPushLoglistCode();
    }

    public static void main(String[] args) {
        int times = 15;
        String json = "15s/15s/30s/3m/10m";
        String[] split = json.split("/");
        System.out.println(split.length);
    }

    public static Date calculateNextTime(Date currentTime, int times, String json) {
        if (0 == times) {
            times = 1;
        }
        long currentMillis = currentTime.getTime();
        String[] frequencies = json.split("/");
        String frequency = frequencies[times - 1];
        long interval = AmPushRuleServiceImpl.parseFrequency(frequency);
        return new Date(currentMillis += interval);
    }

    public static long parseFrequency(String frequency) {
        long multiplier;
        if (frequency.endsWith("s")) {
            multiplier = 1000L;
        } else if (frequency.endsWith("m")) {
            multiplier = 60000L;
        } else if (frequency.endsWith("h")) {
            multiplier = 3600000L;
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u5355\u4f4d: " + frequency);
        }
        int value = Integer.parseInt(frequency.substring(0, frequency.length() - 1));
        return (long)value * multiplier;
    }

    @Override
    public String savePushLoglistBatch(List<AmPushLoglistDomain> amPushLoglistDomainList) throws ApiException {
        if (null == amPushLoglistDomainList || amPushLoglistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmPushLoglist> amPushLoglistList = new ArrayList<AmPushLoglist>();
        String code = "";
        for (AmPushLoglistDomain amPushLoglistDomain : amPushLoglistDomainList) {
            AmPushLoglist amPushLoglist = this.createAmPushLoglist(amPushLoglistDomain);
            code = amPushLoglist.getPushLoglistCode();
            amPushLoglistList.add(amPushLoglist);
        }
        this.savePushLoglistBatchModel(amPushLoglistList);
        return code;
    }

    @Override
    public void updatePushLoglistState(Integer pushLoglistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pushLoglistId) {
            return;
        }
        this.updateStatePushLoglistModel(pushLoglistId, dataState, oldDataState, map);
    }

    @Override
    public void updatePushLoglistStateByCode(String tenantCode, String pushLoglistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pushLoglistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePushLoglistModelByCode(tenantCode, pushLoglistCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePushLoglist(AmPushLoglistDomain amPushLoglistDomain) throws ApiException {
        String msg = this.checkPushLoglist(amPushLoglistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLoglist.checkPushLoglist", msg);
        }
        AmPushLoglist oldAmPushLoglist = this.getPushLoglistModelById(amPushLoglistDomain.getPushLoglistId());
        if (null == oldAmPushLoglist) {
            throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.updatePushLoglist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmPushLoglist amPushLoglist = this.makePushLoglist(amPushLoglistDomain, oldAmPushLoglist);
        this.setPushLoglistUpdataDefault(amPushLoglist);
        this.updatePushLoglistModel(amPushLoglist);
    }

    @Override
    public AmPushLoglist getPushLoglist(Integer pushLoglistId) {
        if (null == pushLoglistId) {
            return null;
        }
        return this.getPushLoglistModelById(pushLoglistId);
    }

    @Override
    public void deletePushLoglist(Integer pushLoglistId) throws ApiException {
        if (null == pushLoglistId) {
            return;
        }
        this.deletePushLoglistModel(pushLoglistId);
    }

    @Override
    public QueryResult<AmPushLoglist> queryPushLoglistPage(Map<String, Object> map) {
        List<AmPushLoglist> amPushLoglistList = this.queryPushLoglistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPushLoglist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amPushLoglistList);
        return queryResult;
    }

    @Override
    public AmPushLoglist getPushLoglistByCode(String tenantCode, String pushLoglistCode) throws ApiException {
        if (StringUtils.isBlank((String)pushLoglistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLoglistCode", pushLoglistCode);
        return this.getPushLoglistModelByCode(map);
    }

    @Override
    public void deletePushLoglistByCode(String tenantCode, String pushLoglistCode) throws ApiException {
        if (StringUtils.isBlank((String)pushLoglistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pushLoglistCode", pushLoglistCode);
        this.delPushLoglistModelByCode(map);
    }

    @Override
    public void sendPushLog() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 0);
        params.put("pushLogTimeQend", this.getSysDate());
        QueryResult<AmPushLog> amPushLogQueryResult = this.queryPushLogPage(params);
        for (AmPushLog amPushLog : amPushLogQueryResult.getList()) {
            this.updatePushLogState(amPushLog.getPushLogId(), 1, amPushLog.getDataState(), null);
            boolean state = this.sendApi(amPushLog);
            if (state) {
                this.updatePushLogState(amPushLog.getPushLogId(), 2, 1, null);
                continue;
            }
            String[] split = amPushLog.getPushLogFrequency().split("/");
            int length = split.length - 1;
            AmPushLoglistDomain amPushLoglistDomain = new AmPushLoglistDomain();
            amPushLoglistDomain.setAppapiCode(amPushLog.getAppapiCode());
            amPushLoglistDomain.setDataParam(amPushLog.getDataParam());
            amPushLoglistDomain.setTenantCode(amPushLog.getTenantCode());
            amPushLoglistDomain.setPushType(amPushLog.getPushLogType());
            amPushLoglistDomain.setPushLogOcode(amPushLog.getPushLogOcode());
            String code = this.savePushLoglist(amPushLoglistDomain);
            if (amPushLog.getPushLogNum() == length) {
                this.updatePushLogState(amPushLog.getPushLogId(), -1, 1, null);
                AmPushRule pushRuleByCode = this.getPushRuleByCode(amPushLog.getTenantCode(), amPushLog.getPushRuleCode());
                if (!StringUtils.isNotBlank((String)pushRuleByCode.getErrorCode())) continue;
                Object api = UddiUtil.invokeUrl((String)"API", (String)pushRuleByCode.getErrorCode(), (String)amPushLog.getDataParam(), null);
                this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.sendPushLog.pushRuleByCode.getErrorCode()" + pushRuleByCode.getErrorCode(), api);
                continue;
            }
            this.updatePushLogState(amPushLog.getPushLogId(), 0, 1, null);
        }
    }

    private boolean sendApi(AmPushLog amPushLog) {
        String res;
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)"API", (String)amPushLog.getAppapiCode(), (String)amPushLog.getDataParam(), null);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.callService.error.param", (Object)amPushLog.getDataParam());
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.callService.error.e", (Object)amPushLog.getAppapiCode(), (Throwable)e);
            return false;
        }
        OutMessage outMessage = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError() || null == outMessage.getReObj()) {
                throw new ApiException("am.ESB.APPMANAGE.AmPushRuleServiceImpl.sendApi.error", amPushLog.getAppapiCode());
            }
            res = outMessage.getReObj().toString();
        } else {
            res = (String)obj;
        }
        if (StringUtils.isBlank((String)res) && StringUtils.isBlank((String)amPushLog.getDataFlag())) {
            return true;
        }
        if (StringUtils.isBlank((String)res) || StringUtils.isBlank((String)amPushLog.getDataFlag())) {
            this.logger.error("am.ESB.APPMANAGE.AmPushRuleServiceImpl.sendApi.res." + amPushLog.getAppapiCode(), (Object)amPushLog.getDataParam());
            return false;
        }
        if (res.equals(amPushLog.getDataFlag())) {
            return true;
        }
        if (res.indexOf("{") >= 0) {
            OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(res, OcReorderDomain.class);
            if (ocReorderDomain.isError()) {
                this.logger.error(amPushLog.getDataParam());
                return false;
            }
            if (ocReorderDomain.isSuccess()) {
                return true;
            }
        }
        return false;
    }
}

