/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpdisMapper;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpdisDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpdisReDomain;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpdis;
import com.yqbsoft.laser.service.logistics.service.WlFreightExpdisService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlFreightExpdisServiceImpl
extends BaseServiceImpl
implements WlFreightExpdisService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlFreightExpdisServiceImpl";
    private WlFreightExpdisMapper wlFreightExpdisMapper;

    public void setWlFreightExpdisMapper(WlFreightExpdisMapper wlFreightExpdisMapper) {
        this.wlFreightExpdisMapper = wlFreightExpdisMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlFreightExpdisMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFreightExpdis(WlFreightExpdisDomain wlFreightExpdisDomain) {
        if (null == wlFreightExpdisDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpdisDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpdisDefault(WlFreightExpdis wlFreightExpdis) {
        if (null == wlFreightExpdis) {
            return;
        }
        if (null == wlFreightExpdis.getDataState()) {
            wlFreightExpdis.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == wlFreightExpdis.getGmtCreate()) {
            wlFreightExpdis.setGmtCreate(date);
        }
        wlFreightExpdis.setGmtModified(date);
        if (StringUtils.isBlank((String)wlFreightExpdis.getFreightExpdisCode())) {
            wlFreightExpdis.setFreightExpdisCode(this.getNo(null, "WlFreightExpdis", "wlFreightExpdis", wlFreightExpdis.getTenantCode()));
        }
    }

    private int getFreightExpdisMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpdisMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.getFreightExpdisMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpdisUpdataDefault(WlFreightExpdis wlFreightExpdis) {
        if (null == wlFreightExpdis) {
            return;
        }
        wlFreightExpdis.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpdisModel(WlFreightExpdis wlFreightExpdis) throws ApiException {
        if (null == wlFreightExpdis) {
            return;
        }
        try {
            this.wlFreightExpdisMapper.insert(wlFreightExpdis);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.saveFreightExpdisModel.ex", (Throwable)e);
        }
    }

    private void saveFreightExpdisBatchModel(List<WlFreightExpdis> wlFreightExpdisList) throws ApiException {
        if (null == wlFreightExpdisList || wlFreightExpdisList.isEmpty()) {
            return;
        }
        try {
            this.wlFreightExpdisMapper.insertBatch(wlFreightExpdisList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.saveFreightExpdisBatchModel.ex", (Throwable)e);
        }
    }

    private WlFreightExpdis getFreightExpdisModelById(Integer freightExpdisId) {
        if (null == freightExpdisId) {
            return null;
        }
        try {
            return this.wlFreightExpdisMapper.selectByPrimaryKey(freightExpdisId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.getFreightExpdisModelById", (Throwable)e);
            return null;
        }
    }

    private WlFreightExpdis getFreightExpdisModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpdisMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.getFreightExpdisModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFreightExpdisModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.delFreightExpdisModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.delFreightExpdisModelByCode.num");
        }
    }

    private void deleteFreightExpdisModel(Integer freightExpdisId) throws ApiException {
        if (null == freightExpdisId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.deleteByPrimaryKey(freightExpdisId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.deleteFreightExpdisModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.deleteFreightExpdisModel.num");
        }
    }

    private void updateFreightExpdisModel(WlFreightExpdis wlFreightExpdis) throws ApiException {
        if (null == wlFreightExpdis) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.updateByPrimaryKey(wlFreightExpdis);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateFreightExpdisModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateFreightExpdisModel.num");
        }
    }

    private void updateStateFreightExpdisModel(Integer freightExpdisId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == freightExpdisId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpdisId", freightExpdisId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateStateFreightExpdisModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateStateFreightExpdisModel.null");
        }
    }

    private void updateStateFreightExpdisModelByCode(String tenantCode, String freightExpdisCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)freightExpdisCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpdisCode", freightExpdisCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateStateFreightExpdisModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateStateFreightExpdisModelByCode.null");
        }
    }

    private WlFreightExpdis makeFreightExpdis(WlFreightExpdisDomain wlFreightExpdisDomain, WlFreightExpdis wlFreightExpdis) {
        if (null == wlFreightExpdisDomain) {
            return null;
        }
        if (null == wlFreightExpdis) {
            wlFreightExpdis = new WlFreightExpdis();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpdis, (Object)wlFreightExpdisDomain);
            return wlFreightExpdis;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.makeFreightExpdis", (Throwable)e);
            return null;
        }
    }

    private WlFreightExpdisReDomain makeWlFreightExpdisReDomain(WlFreightExpdis wlFreightExpdis) {
        if (null == wlFreightExpdis) {
            return null;
        }
        WlFreightExpdisReDomain wlFreightExpdisReDomain = new WlFreightExpdisReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpdisReDomain, (Object)wlFreightExpdis);
            return wlFreightExpdisReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.makeWlFreightExpdisReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpdis> queryFreightExpdisModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpdisMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.queryFreightExpdisModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightExpdis(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpdisMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpdisServiceImpl.countFreightExpdis", (Throwable)e);
        }
        return i;
    }

    private WlFreightExpdis createWlFreightExpdis(WlFreightExpdisDomain wlFreightExpdisDomain) {
        String msg = this.checkFreightExpdis(wlFreightExpdisDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.saveFreightExpdis.checkFreightExpdis", msg);
        }
        WlFreightExpdis wlFreightExpdis = this.makeFreightExpdis(wlFreightExpdisDomain, null);
        this.setFreightExpdisDefault(wlFreightExpdis);
        return wlFreightExpdis;
    }

    @Override
    public String saveFreightExpdis(WlFreightExpdisDomain wlFreightExpdisDomain) throws ApiException {
        WlFreightExpdis wlFreightExpdis = this.createWlFreightExpdis(wlFreightExpdisDomain);
        this.saveFreightExpdisModel(wlFreightExpdis);
        return wlFreightExpdis.getFreightExpdisCode();
    }

    @Override
    public String saveFreightExpdisBatch(List<WlFreightExpdisDomain> wlFreightExpdisDomainList) throws ApiException {
        if (null == wlFreightExpdisDomainList || wlFreightExpdisDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlFreightExpdis> wlFreightExpdisList = new ArrayList<WlFreightExpdis>();
        String code = "";
        for (WlFreightExpdisDomain wlFreightExpdisDomain : wlFreightExpdisDomainList) {
            WlFreightExpdis wlFreightExpdis = this.createWlFreightExpdis(wlFreightExpdisDomain);
            code = wlFreightExpdis.getFreightExpdisCode();
            wlFreightExpdisList.add(wlFreightExpdis);
        }
        this.saveFreightExpdisBatchModel(wlFreightExpdisList);
        return code;
    }

    @Override
    public void updateFreightExpdisState(Integer freightExpdisId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == freightExpdisId) {
            return;
        }
        this.updateStateFreightExpdisModel(freightExpdisId, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExpdisStateByCode(String tenantCode, String freightExpdisCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)freightExpdisCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFreightExpdisModelByCode(tenantCode, freightExpdisCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExpdis(WlFreightExpdisDomain wlFreightExpdisDomain) throws ApiException {
        String msg = this.checkFreightExpdis(wlFreightExpdisDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateFreightExpdis.checkFreightExpdis", msg);
        }
        WlFreightExpdis oldWlFreightExpdis = this.getFreightExpdisModelById(wlFreightExpdisDomain.getFreightExpdisId());
        if (null == oldWlFreightExpdis) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpdisServiceImpl.updateFreightExpdis.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExpdis wlFreightExpdis = this.makeFreightExpdis(wlFreightExpdisDomain, oldWlFreightExpdis);
        this.setFreightExpdisUpdataDefault(wlFreightExpdis);
        this.updateFreightExpdisModel(wlFreightExpdis);
    }

    @Override
    public WlFreightExpdis getFreightExpdis(Integer freightExpdisId) {
        if (null == freightExpdisId) {
            return null;
        }
        return this.getFreightExpdisModelById(freightExpdisId);
    }

    @Override
    public void deleteFreightExpdis(Integer freightExpdisId) throws ApiException {
        if (null == freightExpdisId) {
            return;
        }
        this.deleteFreightExpdisModel(freightExpdisId);
    }

    @Override
    public QueryResult<WlFreightExpdis> queryFreightExpdisPage(Map<String, Object> map) {
        List<WlFreightExpdis> wlFreightExpdisList = this.queryFreightExpdisModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExpdis(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpdisList);
        return queryResult;
    }

    @Override
    public WlFreightExpdis getFreightExpdisByCode(String tenantCode, String freightExpdisCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExpdisCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpdisCode", freightExpdisCode);
        return this.getFreightExpdisModelByCode(map);
    }

    @Override
    public void deleteFreightExpdisByCode(String tenantCode, String freightExpdisCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExpdisCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpdisCode", freightExpdisCode);
        this.delFreightExpdisModelByCode(map);
    }
}

