/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceGoodsServiceImpl
extends BaseServiceImpl
implements RsResourceGoodsService {
    public static final String SYS_CODE = "rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl";
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsSkuService rsSkuService;
    private RsSpecValueService rsSpecValueService;
    private RsPropertiesValueService rsPropertiesValueService;

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsPropertiesValueService(RsPropertiesValueService rsPropertiesValueService) {
        this.rsPropertiesValueService = rsPropertiesValueService;
    }

    private Date getSysDate() {
        try {
            return this.rsResourceGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCode())) {
            msg = msg + "memberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberName())) {
            msg = msg + "memberName\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a";
        }
        return msg;
    }

    private void setResourceGoodsDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        if (null == rsResourceGoods.getDataState()) {
            rsResourceGoods.setDataState(0);
        }
        if (null == rsResourceGoods.getGmtCreate()) {
            rsResourceGoods.setGmtCreate(this.getSysDate());
        }
        rsResourceGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsCode())) {
            rsResourceGoods.setGoodsCode(this.getNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", rsResourceGoods.getTenantCode()));
        }
    }

    private int getResourceGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsResourceGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.getResourceGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setResourceGoodsUpdataDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        rsResourceGoods.setGmtModified(this.getSysDate());
    }

    private void saveResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.insert(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.saveResourceGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveResourceGoodsModelList(List<RsResourceGoods> rsResourceGoodsList) throws ApiException {
        if (null == rsResourceGoodsList || rsResourceGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.insertBatch(rsResourceGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.saveResourceGoodsModelList.ex", (Throwable)e);
        }
    }

    private RsResourceGoods getResourceGoodsModelById(Integer goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.getResourceGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public RsResourceGoods getResourceGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.getResourceGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delResourceGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.delResourceGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.delResourceGoodsModelByCode.num");
        }
    }

    private void deleteResourceGoodsModel(Integer goodsId) throws ApiException {
        if (null == goodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.deleteByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.deleteResourceGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.deleteResourceGoodsModel.num");
        }
    }

    private void updateResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.updateByPrimaryKeySelective(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateResourceGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateResourceGoodsModel(Integer goodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == goodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsId", goodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    private RsResourceGoods makeResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoodsDomain) {
            return null;
        }
        if (null == rsResourceGoods) {
            rsResourceGoods = new RsResourceGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceGoods, (Object)rsResourceGoodsDomain);
            return rsResourceGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.makeResourceGoods", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGoods> queryResourceGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countResourceGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.countResourceGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.saveResourceGoods.checkResourceGoods", msg);
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
        this.setResourceGoodsDefault(rsResourceGoods);
        this.saveResourceGoodsModel(rsResourceGoods);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spuCode", rsResourceGoodsDomain.getSpuCode());
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        this.rsSpecValueService.deleteSpecValueBySpu(map);
        if (rsResourceGoodsDomain.getRsSpecValueList() != null) {
            for (RsSpecValueDomain specValue : rsResourceGoodsDomain.getRsSpecValueList()) {
                specValue.setSpecValueBillno(rsResourceGoods.getGoodsCode());
            }
            this.rsSpecValueService.saveSpecValueList(rsResourceGoodsDomain.getRsSpecValueList());
        }
        rsResourceGoodsDomain.getSku().setGoodsCode(rsResourceGoods.getGoodsCode());
        String skuCode = this.rsSkuService.saveSku(rsResourceGoodsDomain.getSku());
        if (rsResourceGoodsDomain.getPropertiesValueList() != null) {
            for (RsPropertiesValueDomain propertiesValue : rsResourceGoodsDomain.getPropertiesValueList()) {
                propertiesValue.setSkuCode(skuCode);
            }
            this.rsPropertiesValueService.savePropertiesValueList(rsResourceGoodsDomain.getPropertiesValueList());
        }
        return rsResourceGoods.getGoodsCode();
    }

    @Override
    public void updateResourceGoodsState(Integer goodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateResourceGoodsModel(goodsId, dataState, oldDataState);
    }

    @Override
    public void updateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        RsResourceGoods oldRsResourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        if (null == oldRsResourceGoods) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateResourceGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, oldRsResourceGoods);
        this.setResourceGoodsUpdataDefault(rsResourceGoods);
        this.updateResourceGoodsModel(rsResourceGoods);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spuCode", rsResourceGoodsDomain.getSpuCode());
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        this.rsSpecValueService.deleteSpecValueBySpu(map);
        if (rsResourceGoodsDomain.getRsSpecValueList() != null) {
            for (RsSpecValueDomain specValue : rsResourceGoodsDomain.getRsSpecValueList()) {
                specValue.setSpecValueBillno(rsResourceGoods.getGoodsCode());
            }
            this.rsSpecValueService.saveSpecValueList(rsResourceGoodsDomain.getRsSpecValueList());
        }
        rsResourceGoodsDomain.getSku().setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
        this.rsSkuService.updateSku(rsResourceGoodsDomain.getSku());
        map.put("skuCode", rsResourceGoodsDomain.getSku().getSkuCode());
        this.rsPropertiesValueService.deletePropertiesValueBySku(map);
        if (rsResourceGoodsDomain.getPropertiesValueList() != null) {
            for (RsPropertiesValueDomain propertiesValue : rsResourceGoodsDomain.getPropertiesValueList()) {
                propertiesValue.setSkuCode(rsResourceGoodsDomain.getSku().getSkuCode());
            }
            this.rsPropertiesValueService.savePropertiesValueList(rsResourceGoodsDomain.getPropertiesValueList());
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("Goods");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inInvoke("es.searchengine.store", paramMap);
    }

    @Override
    public RsResourceGoods getResourceGoods(Integer goodsId) {
        return this.getResourceGoodsModelById(goodsId);
    }

    @Override
    public void deleteResourceGoods(Integer goodsId) throws ApiException {
        this.deleteResourceGoodsModel(goodsId);
    }

    @Override
    public QueryResult<RsResourceGoods> queryResourceGoodsPage(Map<String, Object> map) {
        List<RsResourceGoods> rsResourceGoodsList = this.queryResourceGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGoodsList);
        return queryResult;
    }

    @Override
    public RsResourceGoods getResourceGoodsByCode(Map<String, Object> map) {
        return this.getResourceGoodsModelByCode(map);
    }

    @Override
    public void delResourceGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delResourceGoodsModelByCode(map);
    }

    @Override
    public String saveResourceGoodsList(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        String codeStr;
        String[] goodsCodes;
        if (goodsList == null || goodsList.isEmpty()) {
            return null;
        }
        ArrayList<RsResourceGoods> rsResourceGoodsList = new ArrayList<RsResourceGoods>();
        String goodsBillbatch = goodsList.get(0).getGoodsBillbatch();
        if (StringUtils.isBlank((String)goodsBillbatch)) {
            goodsBillbatch = this.createUUIDString();
        }
        if ((goodsCodes = (codeStr = this.getBatchNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", goodsList.size(), goodsList.get(0).getTenantCode())).split(",")).length != goodsList.size()) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.saveResourceGoods.getBatchNo", "\u8d44\u6e90\u4ee3\u7801\u751f\u6210\u5931\u8d25");
        }
        int i = 0;
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            String msg = this.checkResourceGoods(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.saveResourceGoods.checkResourceGoods", msg);
            }
            RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
            rsResourceGoods.setGoodsCode(goodsCodes[i]);
            this.setResourceGoodsDefault(rsResourceGoods);
            rsResourceGoods.setGoodsBillbatch(goodsBillbatch);
            rsResourceGoodsList.add(rsResourceGoods);
            ++i;
        }
        this.saveResourceGoodsModelList(rsResourceGoodsList);
        return goodsBillbatch;
    }

    @Override
    public void updateAhResourceList(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        if (goodsList == null || goodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            this.updateAhResource(rsResourceGoodsDomain);
        }
    }

    @Override
    public void updateAhResource(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateAhResource.checkResourceGoods", msg);
        }
        RsResourceGoods oldRsResourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        if (null == oldRsResourceGoods) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateAhResource.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsResourceGoods.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, oldRsResourceGoods);
        this.setResourceGoodsUpdataDefault(rsResourceGoods);
        rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        this.updateResourceGoodsModel(rsResourceGoods);
    }

    @Override
    public void updateResourceStock(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        for (ResourceStockDomain resourceStockDomain : resourceGoodsList) {
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)resourceStockDomain), String.class, Object.class);
            this.updateStateResourceGoodsModel(map);
        }
    }

    private void updateStateResourceGoodsModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateResourceStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    @Override
    public void deleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        if (goodsIds == null || goodsIds.isEmpty()) {
            return;
        }
        for (Integer goodsId : goodsIds) {
            this.deleteResourceGoods(goodsId);
        }
    }

    @Override
    public void updateAuditResourcePass(List<Integer> goodsIds) {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
            rsResourceGoods.setGoodsSupplynum(rsResourceGoods.getGoodsSupplynum().add(goodsAhnum));
            rsResourceGoods.setGoodsSupplyweight(rsResourceGoods.getGoodsSupplyweight().add(goodsAhweight));
            rsResourceGoods.setGoodsHangnum(rsResourceGoods.getGoodsHangnum().add(goodsAhnum));
            rsResourceGoods.setGoodsHangweight(rsResourceGoods.getGoodsHangweight().add(goodsAhweight));
            rsResourceGoods.setGoodsAhnum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsAhweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
            rsResourceGoods.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
            rsResourceGoods.setGoodsHdate(this.getSysDate());
            this.updateResourceGoodsModel(rsResourceGoods);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("Goods");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(resourceGoodsList));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inInvoke("es.searchengine.store", paramMap);
    }

    @Override
    public void updateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
            rsResourceGoods.setGoodsNum(rsResourceGoods.getGoodsNum().add(goodsAhnum));
            rsResourceGoods.setGoodsWeight(rsResourceGoods.getGoodsWeight().add(goodsAhweight));
            rsResourceGoods.setGoodsAhnum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsAhweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
            this.updateResourceGoodsModel(rsResourceGoods);
        }
    }

    @Override
    public void updateCannelResourceList(List<Integer> goodsIds) throws ApiException {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        ArrayList<String> goodsCodeList = new ArrayList<String>();
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
            rsResourceGoods.setGoodsNum(rsResourceGoods.getGoodsNum().add(goodsSupplynum));
            rsResourceGoods.setGoodsWeight(rsResourceGoods.getGoodsWeight().add(goodsSupplyweight));
            rsResourceGoods.setGoodsHangnum(rsResourceGoods.getGoodsHangnum().subtract(goodsSupplynum));
            rsResourceGoods.setGoodsHangweight(rsResourceGoods.getGoodsHangweight().subtract(goodsSupplyweight));
            rsResourceGoods.setGoodsSupplynum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsSupplyweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            rsResourceGoods.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
            this.updateResourceGoodsModel(rsResourceGoods);
            goodsCodeList.add(rsResourceGoods.getGoodsCode());
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("delete");
        storeDomain.setBizType("Goods");
        storeDomain.setStoreObj(goodsCodeList);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inInvoke("es.searchengine.store", paramMap);
    }

    private List<RsResourceGoods> checkAuditResource(List<Integer> goodsIds) {
        if (goodsIds == null || goodsIds.isEmpty()) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.checkAuditResource.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsResourceGoods> resourceGoodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.getResourceGoodsModelById(goodsId);
            if (rsResourceGoods == null) {
                throw new ApiException("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.getResourceGoodsModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
            BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsWeight();
            BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
            BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
            rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            resourceGoodsList.add(rsResourceGoods);
        }
        return resourceGoodsList;
    }

    @Override
    public QueryResult<RsResourceGoods> queryRsGoodsSkuPage(Map<String, Object> map) throws ApiException {
        if (null == map || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            return null;
        }
        List<RsResourceGoods> rsResourceGoodsList = this.getRsGoodsSkuByCode(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.getRsGoodsSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGoodsList);
        return queryResult;
    }

    private List<RsResourceGoods> getRsGoodsSkuByCode(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.getRsGoodsSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int getRsGoodsSkuCount(Map<String, Object> parammap) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.getRsGoodsSkuCount(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
        }
        return i;
    }
}

