/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsLaundryGoodsMapper;
import com.yqbsoft.laser.service.resources.domain.RsLaundryGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsLaundryGoodsReDomain;
import com.yqbsoft.laser.service.resources.model.RsLaundryGoods;
import com.yqbsoft.laser.service.resources.service.RsLaundryGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsLaundryGoodsServiceImpl
extends BaseServiceImpl
implements RsLaundryGoodsService {
    private static final String SYS_CODE = "rs.RsLaundryGoodsServiceImpl";
    private RsLaundryGoodsMapper rsLaundryGoodsMapper;

    public void setRsLaundryGoodsMapper(RsLaundryGoodsMapper rsLaundryGoodsMapper) {
        this.rsLaundryGoodsMapper = rsLaundryGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsLaundryGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLaundryGoods(RsLaundryGoodsDomain rsLaundryGoodsDomain) {
        if (null == rsLaundryGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsLaundryGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLaundryGoodsDefault(RsLaundryGoods rsLaundryGoods) {
        if (null == rsLaundryGoods) {
            return;
        }
        if (null == rsLaundryGoods.getDataState()) {
            rsLaundryGoods.setDataState(0);
        }
        if (null == rsLaundryGoods.getGmtCreate()) {
            rsLaundryGoods.setGmtCreate(this.getSysDate());
        }
        rsLaundryGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsLaundryGoods.getLaundryCode())) {
            rsLaundryGoods.setLaundryCode(this.getNo(null, "RsLaundryGoods", "rsLaundryGoods", rsLaundryGoods.getTenantCode()));
        }
    }

    private int getLaundryGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsLaundryGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.getLaundryGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLaundryGoodsUpdataDefault(RsLaundryGoods rsLaundryGoods) {
        if (null == rsLaundryGoods) {
            return;
        }
        rsLaundryGoods.setGmtModified(this.getSysDate());
    }

    private void saveLaundryGoodsModel(RsLaundryGoods rsLaundryGoods) throws ApiException {
        if (null == rsLaundryGoods) {
            return;
        }
        try {
            this.rsLaundryGoodsMapper.insert(rsLaundryGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.saveLaundryGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveLaundryGoodsBatchModel(List<RsLaundryGoods> rsLaundryGoodsList) throws ApiException {
        if (null == rsLaundryGoodsList || rsLaundryGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsLaundryGoodsMapper.insertBatch(rsLaundryGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.saveLaundryGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private RsLaundryGoods getLaundryGoodsModelById(Integer laundryId) {
        if (null == laundryId) {
            return null;
        }
        try {
            return this.rsLaundryGoodsMapper.selectByPrimaryKey(laundryId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.getLaundryGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private RsLaundryGoods getLaundryGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsLaundryGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.getLaundryGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLaundryGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.delLaundryGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.delLaundryGoodsModelByCode.num");
        }
    }

    private void deleteLaundryGoodsModel(Integer laundryId) throws ApiException {
        if (null == laundryId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.deleteByPrimaryKey(laundryId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.deleteLaundryGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.deleteLaundryGoodsModel.num");
        }
    }

    private void updateLaundryGoodsModel(RsLaundryGoods rsLaundryGoods) throws ApiException {
        if (null == rsLaundryGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.updateByPrimaryKey(rsLaundryGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoodsModel.num");
        }
    }

    private void updateStateLaundryGoodsModel(Integer laundryId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == laundryId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("laundryId", laundryId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateStateLaundryGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateStateLaundryGoodsModel.null");
        }
    }

    private void updateStateLaundryGoodsModelByCode(String tenantCode, String laundryCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)laundryCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("laundryCode", laundryCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateStateLaundryGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateStateLaundryGoodsModelByCode.null");
        }
    }

    private RsLaundryGoods makeLaundryGoods(RsLaundryGoodsDomain rsLaundryGoodsDomain, RsLaundryGoods rsLaundryGoods) {
        if (null == rsLaundryGoodsDomain) {
            return null;
        }
        if (null == rsLaundryGoods) {
            rsLaundryGoods = new RsLaundryGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsLaundryGoods, (Object)rsLaundryGoodsDomain);
            return rsLaundryGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.makeLaundryGoods", (Throwable)e);
            return null;
        }
    }

    private RsLaundryGoodsReDomain makeRsLaundryGoodsReDomain(RsLaundryGoods rsLaundryGoods) {
        if (null == rsLaundryGoods) {
            return null;
        }
        RsLaundryGoodsReDomain rsLaundryGoodsReDomain = new RsLaundryGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsLaundryGoodsReDomain, (Object)rsLaundryGoods);
            return rsLaundryGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.makeRsLaundryGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsLaundryGoods> queryLaundryGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsLaundryGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.queryLaundryGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countLaundryGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsLaundryGoodsServiceImpl.countLaundryGoods", (Throwable)e);
        }
        return i;
    }

    private RsLaundryGoods createRsLaundryGoods(RsLaundryGoodsDomain rsLaundryGoodsDomain) {
        String msg = this.checkLaundryGoods(rsLaundryGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.saveLaundryGoods.checkLaundryGoods", msg);
        }
        RsLaundryGoods rsLaundryGoods = this.makeLaundryGoods(rsLaundryGoodsDomain, null);
        this.setLaundryGoodsDefault(rsLaundryGoods);
        return rsLaundryGoods;
    }

    @Override
    public String saveLaundryGoods(RsLaundryGoodsDomain rsLaundryGoodsDomain) throws ApiException {
        RsLaundryGoods rsLaundryGoods = this.createRsLaundryGoods(rsLaundryGoodsDomain);
        this.saveLaundryGoodsModel(rsLaundryGoods);
        return rsLaundryGoods.getLaundryCode();
    }

    @Override
    public String saveLaundryGoodsBatch(List<RsLaundryGoodsDomain> rsLaundryGoodsDomainList) throws ApiException {
        if (null == rsLaundryGoodsDomainList || rsLaundryGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsLaundryGoods> rsLaundryGoodsList = new ArrayList<RsLaundryGoods>();
        String code = "";
        for (RsLaundryGoodsDomain rsLaundryGoodsDomain : rsLaundryGoodsDomainList) {
            RsLaundryGoods rsLaundryGoods = this.createRsLaundryGoods(rsLaundryGoodsDomain);
            code = rsLaundryGoods.getLaundryCode();
            rsLaundryGoodsList.add(rsLaundryGoods);
        }
        this.saveLaundryGoodsBatchModel(rsLaundryGoodsList);
        return code;
    }

    @Override
    public void updateLaundryGoodsState(Integer laundryId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLaundryGoodsModel(laundryId, dataState, oldDataState, map);
    }

    @Override
    public void updateLaundryGoodsStateByCode(String tenantCode, String laundryCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLaundryGoodsModelByCode(tenantCode, laundryCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLaundryGoods(RsLaundryGoodsDomain rsLaundryGoodsDomain) throws ApiException {
        String msg = this.checkLaundryGoods(rsLaundryGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoods.checkLaundryGoods", msg);
        }
        RsLaundryGoods oldRsLaundryGoods = this.getLaundryGoodsModelById(rsLaundryGoodsDomain.getLaundryId());
        if (null == oldRsLaundryGoods) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsLaundryGoods rsLaundryGoods = this.makeLaundryGoods(rsLaundryGoodsDomain, oldRsLaundryGoods);
        this.setLaundryGoodsUpdataDefault(rsLaundryGoods);
        this.updateLaundryGoodsModel(rsLaundryGoods);
    }

    @Override
    public RsLaundryGoods getLaundryGoods(Integer laundryId) {
        return this.getLaundryGoodsModelById(laundryId);
    }

    @Override
    public void deleteLaundryGoods(Integer laundryId) throws ApiException {
        this.deleteLaundryGoodsModel(laundryId);
    }

    @Override
    public QueryResult<RsLaundryGoods> queryLaundryGoodsPage(Map<String, Object> map) {
        List<RsLaundryGoods> rsLaundryGoodsList = this.queryLaundryGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLaundryGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsLaundryGoodsList);
        return queryResult;
    }

    @Override
    public RsLaundryGoods getLaundryGoodsByCode(String tenantCode, String laundryCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("laundryCode", laundryCode);
        return this.getLaundryGoodsModelByCode(map);
    }

    @Override
    public void deleteLaundryGoodsByCode(String tenantCode, String laundryCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("laundryCode", laundryCode);
        this.delLaundryGoodsModelByCode(map);
    }

    @Override
    public void updateLaundryGoodsPrice(String skuCode, String tenantCode, String provinceCode, String cityCode, String areaCode, String subMoney, String memberCode, String remark, Map<String, Object> map) throws ApiException {
        if (StringUtils.isEmpty((String)subMoney)) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoodsState", "\u4ef7\u683c\u4e3a\u7a7a\uff01");
        }
        BigDecimal updateMoney = new BigDecimal(subMoney);
        this.updateLaundryGoodsPriceStr(skuCode, tenantCode, provinceCode, cityCode, areaCode, updateMoney, memberCode, remark, map);
    }

    private void updateLaundryGoodsPriceStr(String skuCode, String tenantCode, String provinceCode, String cityCode, String areaCode, BigDecimal updateMoney, String memberCode, String remark, Map<String, Object> expmap) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        map.put("provinceCode", provinceCode);
        map.put("cityCode", cityCode);
        map.put("areaCode", areaCode);
        map.put("updateMoney", updateMoney);
        map.put("memberCode", memberCode);
        map.put("remark", remark);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsLaundryGoodsMapper.updateLaundryGoodsPrice(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoodsPriceStr.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsLaundryGoodsServiceImpl.updateLaundryGoodsPriceStr.null" + map);
        }
    }
}

