/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import java.util.List;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    @Override
    public OcReorderDomain updateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode());
    }

    private OcReorderDomain saveResources(List<ResourceStockDomain> resourceGoodsList, String type) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        try {
            this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            return ocReorderDomain;
        }
        catch (Exception e) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain updateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode());
    }

    @Override
    public OcReorderDomain updateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode());
    }
}

