/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsFlowDataMapper;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsFlowDataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = ".RsFlowDataServiceImpl";
    private RsFlowDataMapper rsFlowDataMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private RsGoodsOtherService rsGoodsOtherService;
    private static EsEngineService esEngineService;
    private static Object lock;

    public void setRsFlowDataMapper(RsFlowDataMapper rsFlowDataMapper) {
        this.rsFlowDataMapper = rsFlowDataMapper;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    private void saveRsFlowDataModel(RsFlowData rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowData(rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowDataFinishModel(RsFlowDataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowDataFinish(rsFlowDataFinish);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowData> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        try {
            this.rsFlowDataMapper.deleteByCode(fdCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowData> rsFlowDataList) {
        if (null != rsFlowDataList && rsFlowDataList.size() > 0) {
            this.insertBatchFlowDataModel(rsFlowDataList);
            this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((RsFlowDataService)SpringApplicationContextUtil.getBean((String)"rsFlowDataService"));
                for (int i = 0; i < 10; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            List<RsFlowData> rsFlowDataList = this.rsFlowDataMapper.query(map);
            if (null != rsFlowDataList && rsFlowDataList.size() > 0) {
                this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
            }
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public boolean processRsToEsAndStatic(RsFlowData rsFlowData) {
        String tenantCode;
        HashMap<String, Object> map;
        String result = "";
        if (rsFlowData.getFdBizType() == 1) {
            map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null != rsResourceGoods) {
                if (!"delete".equals(rsFlowData.getEsRequestType())) {
                    HtmlRelease htmlRelease = new HtmlRelease();
                    htmlRelease.setTenantCode(rsResourceGoods.getTenantCode());
                    htmlRelease.setHtmldataCode("RsResourceGoods");
                    htmlRelease.setHtmldataFilename(rsResourceGoods.getGoodsCode() + ".html");
                    htmlRelease.setHtmldataFilepath("goods");
                    htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods));
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
                    this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
                }
                StoreDomain storeDomain = new StoreDomain();
                storeDomain.setRequestType(rsFlowData.getEsRequestType());
                storeDomain.setBizType("goods");
                storeDomain.setBizId(rsResourceGoods.getGoodsId() + "");
                storeDomain.setTenantCode(rsFlowData.getTenantCode());
                rsResourceGoods.setRsPropertiesValueDomainList(null);
                rsResourceGoods.setRsSpecValueDomainList(null);
                rsResourceGoods.setRsSkuDomainList(null);
                rsResourceGoods.setRsGoodsRelDomainList(null);
                rsResourceGoods.setRsGoodsFileDomainList(null);
                String s = JsonUtil.buildNonNullBinder().toJson((Object)rsResourceGoods);
                storeDomain.setStoreObj((Object)s);
                HashMap<String, String> paramMap1 = new HashMap<String, String>();
                paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
                result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
            }
        } else if (rsFlowData.getFdBizType() == 2) {
            map = new HashMap();
            map.put("skuCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsSku rsSku = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null != rsSku) {
                map.put("goodsCode", rsSku.getGoodsCode());
                map.put("tenantCode", rsFlowData.getTenantCode());
                RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
                if (!"delete".equals(rsFlowData.getEsRequestType())) {
                    HtmlRelease htmlRelease = new HtmlRelease();
                    htmlRelease.setTenantCode(rsSku.getTenantCode());
                    htmlRelease.setHtmldataCode("RsSku");
                    htmlRelease.setHtmldataFilename(rsSku.getSkuCode() + ".html");
                    htmlRelease.setHtmldataFilepath("sku");
                    HashMap<String, Object> htmlMap = new HashMap<String, Object>();
                    htmlMap.put("goods", rsResourceGoods);
                    HashMap<String, Object> svMap = new HashMap<String, Object>();
                    svMap.put("specValueBillno", rsSku.getGoodsCode());
                    svMap.put("tenantCode", rsSku.getTenantCode());
                    QueryResult<RsSpecValue> rsSpecValueListResult = this.rsSpecValueService.querySpecValuePage(svMap);
                    if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                        HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
                        List rsSpecValueList = rsSpecValueListResult.getList();
                        for (RsSpecValue rsSpecValue : rsSpecValueList) {
                            String specName = rsSpecValue.getSpecName();
                            ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                            if (null == specValueList || specValueList.size() == 0) {
                                specValueList = new ArrayList<String>();
                            }
                            specValueList.add(rsSpecValue.getSpecValueValue());
                            if (!StringUtils.isNotBlank((String)specName)) continue;
                            specValueMap.put(specName, specValueList);
                        }
                        htmlMap.put("spec", specValueMap);
                    }
                    htmlMap.put("rsSku", rsSku);
                    QueryResult<RsGoodsRel> rsGoodsRelList = this.rsGoodsOtherService.queryGoodsRelPage(map);
                    rsResourceGoods.setRsGoodsRelDomainList(rsGoodsRelList.getList());
                    ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
                    if (null != rsGoodsRelList.getList() && rsGoodsRelList.getList().size() > 0) {
                        List rsGoodsRelList1 = rsGoodsRelList.getList();
                        for (RsGoodsRel rsGoodsRel : rsGoodsRelList1) {
                            QueryResult<RsSku> rsSkuList1;
                            HashMap<String, Object> map1 = new HashMap<String, Object>();
                            map1.put("goodsCode", rsGoodsRel.getGoodsRelGcode());
                            map1.put("tenantCode", rsGoodsRel.getTenantCode());
                            RsResourceGoods rsResourceGoods1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map1);
                            if (null == rsResourceGoods1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(map1)).getList() || rsSkuList1.getList().size() <= 0) continue;
                            RsSku rsSku1 = (RsSku)rsSkuList1.getList().get(0);
                            rsSku1.setGoodsName(rsResourceGoods1.getGoodsName());
                            rsSkuList.add(rsSku1);
                        }
                    }
                    htmlMap.put("rsSkuRel", rsSkuList);
                    htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
                    this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
                }
                StoreDomain storeDomain = new StoreDomain();
                storeDomain.setRequestType(rsFlowData.getEsRequestType());
                storeDomain.setBizType("sku");
                storeDomain.setTenantCode(rsFlowData.getTenantCode());
                storeDomain.setBizId(rsSku.getSkuId() + "");
                rsSku.setRsGoodsFileDomainList(null);
                EsSku esSku = new EsSku();
                try {
                    BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSku);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                esSku.setGoodsNo(rsResourceGoods.getGoodsNo());
                esSku.setPntreeCode(rsResourceGoods.getPntreeCode());
                esSku.setMemberName(rsResourceGoods.getMemberName());
                esSku.setClasstreeName(rsResourceGoods.getClasstreeName());
                esSku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                esSku.setPntreeName(rsResourceGoods.getPntreeName());
                esSku.setGoodsName(rsResourceGoods.getGoodsName());
                esSku.setGoodsProperty(rsResourceGoods.getGoodsProperty());
                String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
                storeDomain.setStoreObj((Object)esSkuStr);
                HashMap<String, String> paramMap1 = new HashMap<String, String>();
                paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
                result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
            }
        } else if (rsFlowData.getFdBizType() == 3) {
            tenantCode = rsFlowData.getTenantCode();
            HashMap<String, List<RsClasstree>> classtreeMap = new HashMap<String, List<RsClasstree>>();
            List<RsClasstree> rsClasstreeList = this.rsFlowDataAssistService.queryAllClasstreeAssist(tenantCode);
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(tenantCode);
            htmlRelease.setHtmldataCode("RsClasstree");
            htmlRelease.setHtmldataFilename("classtree.html");
            htmlRelease.setHtmldataFilepath("classtree");
            classtreeMap.put("rsClasstree", rsClasstreeList);
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(classtreeMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            result = "true";
        } else if (rsFlowData.getFdBizType() == 4) {
            tenantCode = rsFlowData.getTenantCode();
            HashMap<String, List<RsGoodsClass>> goodsClassMap = new HashMap<String, List<RsGoodsClass>>();
            List<RsGoodsClass> rsGoodsClassList = this.rsFlowDataAssistService.queryAllGoodsClassAssist(tenantCode);
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(tenantCode);
            htmlRelease.setHtmldataCode("RsGoodsClass");
            htmlRelease.setHtmldataFilename("goodsclass.html");
            htmlRelease.setHtmldataFilepath("goodsclass");
            goodsClassMap.put("rsGoodsClass", rsGoodsClassList);
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(goodsClassMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            result = "true";
        }
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            return false;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowDataFinish rsFlowDataFinish = new RsFlowDataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveRsFlowDataFinishModel(rsFlowDataFinish);
        return true;
    }

    static {
        lock = new Object();
    }
}

