/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceListDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpuDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsDisGoods;
import com.yqbsoft.laser.service.resources.model.RsDisSku;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsPntree;
import com.yqbsoft.laser.service.resources.model.RsProperties;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpec;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.model.RsSpu;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsDisGoodsService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsPntreeService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.resources.service.RsSpuService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceGoodsServiceImpl
extends BaseServiceImpl
implements RsResourceGoodsService {
    public static final String SYS_CODE = "rs.RsResourceGoodsServiceImpl";
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsSkuMapper rsSkuMapper;
    private RsResourceListService rsResourceListService;
    private RsSpuService rsSpuService;
    private RsPntreeService rsPntreeService;
    private RsSkuService rsSkuService;
    private RsPropertiesService rsPropertiesService;
    private RsSpecValueService rsSpecValueService;
    private RsDisGoodsService rsDisGoodsService;
    private RsPropertiesValueService rsPropertiesValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsFlowDataService rsFlowDataService;
    private RsClasstreeService rsClasstreeService;
    private RsSpecService rsSpecService;

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public void setRsSpecService(RsSpecService rsSpecService) {
        this.rsSpecService = rsSpecService;
    }

    public RsClasstreeService getRsClasstreeService() {
        return this.rsClasstreeService;
    }

    public void setRsClasstreeService(RsClasstreeService rsClasstreeService) {
        this.rsClasstreeService = rsClasstreeService;
    }

    public void setRsFlowDataService(RsFlowDataService rsFlowDataService) {
        this.rsFlowDataService = rsFlowDataService;
    }

    public void setRsPntreeService(RsPntreeService rsPntreeService) {
        this.rsPntreeService = rsPntreeService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsPropertiesValueService(RsPropertiesValueService rsPropertiesValueService) {
        this.rsPropertiesValueService = rsPropertiesValueService;
    }

    public void setRsDisGoodsService(RsDisGoodsService rsDisGoodsService) {
        this.rsDisGoodsService = rsDisGoodsService;
    }

    public void setRsSpuService(RsSpuService rsSpuService) {
        this.rsSpuService = rsSpuService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public void setRsPropertiesService(RsPropertiesService rsPropertiesService) {
        this.rsPropertiesService = rsPropertiesService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    private Date getSysDate() {
        try {
            return this.rsResourceGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCode())) {
            msg = msg + "memberCode\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberName())) {
            msg = msg + "memberName\u4e3a\u7a7a";
        }
        return msg;
    }

    private void setResourceGoodsDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        if (null == rsResourceGoods.getDataState()) {
            rsResourceGoods.setDataState(0);
        }
        if (null == rsResourceGoods.getGmtCreate()) {
            rsResourceGoods.setGmtCreate(this.getSysDate());
        }
        rsResourceGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsCode())) {
            rsResourceGoods.setGoodsCode(this.getNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", rsResourceGoods.getTenantCode()));
        }
    }

    private int getResourceGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsResourceGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.getResourceGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setResourceGoodsUpdataDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        rsResourceGoods.setGmtModified(this.getSysDate());
    }

    private void saveResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.insert(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveResourceGoodsModelList(List<RsResourceGoods> rsResourceGoodsList) throws ApiException {
        if (null == rsResourceGoodsList || rsResourceGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.insertBatch(rsResourceGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoodsModelList.ex", (Throwable)e);
        }
    }

    private RsResourceGoods getResourceGoodsModelById(Integer goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.getResourceGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public RsResourceGoods getResourceGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.getResourceGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delResourceGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.delResourceGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.delResourceGoodsModelByCode.num");
        }
    }

    private void deleteResourceGoodsModel(Integer goodsId) throws ApiException {
        if (null == goodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.deleteByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.deleteResourceGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.deleteResourceGoodsModel.num");
        }
    }

    private void updateResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.updateByPrimaryKeySelective(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateResourceGoodsModelWithNull(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.updateByPrimaryKey(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoodsModelWithNull.ex", (Throwable)e);
        }
    }

    private void updateStateResourceGoodsModel(Integer goodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == goodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsId", goodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    private RsResourceGoods makeResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoodsDomain) {
            return null;
        }
        if (null == rsResourceGoods) {
            rsResourceGoods = new RsResourceGoods();
        }
        if (null != rsResourceGoodsDomain.getRsSkuDomainList() && !rsResourceGoodsDomain.getRsSkuDomainList().isEmpty()) {
            rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsSupplynum(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsSupplyweight(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsAhnum(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsAhweight(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsHangnum(BigDecimal.ZERO);
            rsResourceGoodsDomain.setGoodsHangweight(BigDecimal.ZERO);
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                rsResourceGoodsDomain.setGoodsNum(rsResourceGoodsDomain.getGoodsNum().add(null == rsSkuDomain.getGoodsNum() ? BigDecimal.ZERO : rsSkuDomain.getGoodsNum()));
                rsResourceGoodsDomain.setGoodsWeight(rsResourceGoodsDomain.getGoodsWeight().add(null == rsSkuDomain.getGoodsWeight() ? BigDecimal.ZERO : rsSkuDomain.getGoodsWeight()));
                rsResourceGoodsDomain.setGoodsSupplynum(rsResourceGoodsDomain.getGoodsSupplynum().add(null == rsSkuDomain.getGoodsSupplynum() ? BigDecimal.ZERO : rsSkuDomain.getGoodsSupplynum()));
                rsResourceGoodsDomain.setGoodsSupplyweight(rsResourceGoodsDomain.getGoodsSupplyweight().add(null == rsSkuDomain.getGoodsSupplyweight() ? BigDecimal.ZERO : rsSkuDomain.getGoodsSupplyweight()));
                rsResourceGoodsDomain.setGoodsAhnum(rsResourceGoodsDomain.getGoodsAhnum().add(null == rsSkuDomain.getGoodsAhnum() ? BigDecimal.ZERO : rsSkuDomain.getGoodsAhnum()));
                rsResourceGoodsDomain.setGoodsAhweight(rsResourceGoodsDomain.getGoodsAhweight().add(null == rsSkuDomain.getGoodsAhweight() ? BigDecimal.ZERO : rsSkuDomain.getGoodsAhweight()));
                rsResourceGoodsDomain.setGoodsHangnum(rsResourceGoodsDomain.getGoodsHangnum().add(null == rsSkuDomain.getGoodsHangnum() ? BigDecimal.ZERO : rsSkuDomain.getGoodsHangnum()));
                rsResourceGoodsDomain.setGoodsHangweight(rsResourceGoodsDomain.getGoodsHangweight().add(null == rsSkuDomain.getGoodsHangweight() ? BigDecimal.ZERO : rsSkuDomain.getGoodsHangweight()));
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceGoods, (Object)rsResourceGoodsDomain);
            return rsResourceGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.makeResourceGoods", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGoods> queryResourceGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countResourceGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.countResourceGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        RsPntree rsPntree = this.rsPntreeService.getPntreeByCode(map);
        if (null == rsPntree) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.getPntreeByCode", "\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.checkResourceGoods", msg);
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
        this.setResourceGoodsDefault(rsResourceGoods);
        String spuCode = rsResourceGoodsDomain.getSpuCode();
        if (StringUtils.isBlank((String)spuCode)) {
            spuCode = this.saveSpu(rsResourceGoods);
            if (StringUtils.isBlank((String)spuCode)) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.spuCode", "null");
            }
            rsResourceGoodsDomain.setSpuCode(spuCode);
            rsResourceGoods.setSpuCode(spuCode);
        }
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsResourceGoodsDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        if (null != rsGoodsFileDomainList && rsGoodsFileDomainList.size() > 0) {
            dataPic = rsResourceGoodsDomain.getRsGoodsFileDomainList().get(0).getGoodsFileUrl();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                break;
            }
        }
        rsResourceGoods.setDataPic(dataPic);
        this.saveResourceGoodsModel(rsResourceGoods);
        if (null != rsResourceGoodsDomain.getRsSpecValueDomainList() && rsResourceGoodsDomain.getRsSpecValueDomainList().size() > 0) {
            this.processSpecValue(rsResourceGoodsDomain.getRsSpecValueDomainList(), spuCode, rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
            this.rsSpecValueService.saveSpecValueList(rsResourceGoodsDomain.getRsSpecValueDomainList());
        }
        if (null != rsResourceGoodsDomain.getRsPropertiesValueDomainList() && rsResourceGoodsDomain.getRsPropertiesValueDomainList().size() > 0) {
            this.savePropertiesList(rsResourceGoodsDomain.getRsPropertiesValueDomainList(), rsResourceGoodsDomain.getSpuCode(), rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
        }
        if (null != rsResourceGoodsDomain.getRsGoodsRelDomainList() && rsResourceGoodsDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                rsGoodsRelDomain.setTenantCode(rsResourceGoods.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsResourceGoods.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsResourceGoods.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsResourceGoodsDomain.getRsGoodsRelDomainList());
        }
        if (null != rsGoodsFileDomainList && rsGoodsFileDomainList.size() > 0) {
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                rsGoodsFileDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                rsGoodsFileDomain.setTenantCode(rsResourceGoods.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsResourceGoods.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsResourceGoods.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        }
        if (rsResourceGoodsDomain.getRsSkuDomainList() != null && rsResourceGoodsDomain.getRsSkuDomainList().size() > 0) {
            for (RsSkuDomain sku : rsResourceGoodsDomain.getRsSkuDomainList()) {
                sku.setGoodsCode(rsResourceGoods.getGoodsCode());
                sku.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
                sku.setTenantCode(rsResourceGoods.getTenantCode());
                sku.setSpuCode(rsResourceGoods.getSpuCode());
                sku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                sku.setFreightTemCode(rsResourceGoods.getFreightTemCode());
            }
            this.rsSkuService.saveSkuList(rsResourceGoodsDomain.getRsSkuDomainList());
        }
        return rsResourceGoods.getGoodsCode();
    }

    private void processSpecValue(List<RsSpecValueDomain> rsSpecValueDomainList, String spuCode, String goodsCode, String tenantCode) {
        HashMap<String, String> specNameMap = new HashMap<String, String>();
        for (RsSpecValueDomain specValue : rsSpecValueDomainList) {
            RsSpec rsSpec;
            specValue.setSpecValueBillno(goodsCode);
            specValue.setSpuCode(spuCode);
            specValue.setSpecValueType("0");
            specValue.setSpecValueFlag("1");
            specValue.setTenantCode(tenantCode);
            if (!StringUtils.isBlank((String)specValue.getSpecName())) continue;
            String specCode = specValue.getSpecCode();
            String specName = (String)specNameMap.get(specCode);
            if (StringUtils.isBlank((String)specName) && null != (rsSpec = this.rsSpecService.getSpecByCode(this.getQueryParamMap("specCode,tenantCode", new Object[]{specCode, tenantCode})))) {
                specName = rsSpec.getSpecName();
                specNameMap.put(specCode, specName);
            }
            specValue.setSpecName(specName);
        }
    }

    private void delGoodsData(String spuCode, String goodsCode, String tenantCode, List<Integer> delSkuId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spuCode", spuCode);
        map.put("goodsCode", goodsCode);
        map.put("specValueBillno", goodsCode);
        map.put("tenantCode", tenantCode);
        if (null != delSkuId && delSkuId.size() > 0) {
            this.rsSkuService.deleteSkuList(delSkuId);
        }
        this.rsSpecValueService.deleteSpecValueBySpu(map);
        this.rsPropertiesValueService.deletePropertiesValueByGoods(goodsCode, tenantCode);
        this.rsGoodsOtherService.delGoodsFileByGoodsCode(map);
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    private String saveSpu(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsSpuDomain rsSpuDomain = new RsSpuDomain();
        rsSpuDomain.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
        rsSpuDomain.setBrandCode(rsResourceGoods.getBrandCode());
        rsSpuDomain.setPntreeCode(rsResourceGoods.getPntreeCode());
        rsSpuDomain.setSpuName(rsResourceGoods.getPntreeName() + " " + rsResourceGoods.getBrandName());
        rsSpuDomain.setTenantCode(rsResourceGoods.getTenantCode());
        return this.rsSpuService.saveSpu(rsSpuDomain);
    }

    private void savePropertiesList(List<RsPropertiesValueDomain> valueList, String spuCode, String goodsCode, String tenantCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsPropertiesValueDomain rsPropertiesValueDomain : valueList) {
            rsPropertiesValueDomain.setSpuCode(spuCode);
            rsPropertiesValueDomain.setGoodsCode(goodsCode);
            rsPropertiesValueDomain.setTenantCode(tenantCode);
        }
        this.rsPropertiesValueService.savePropertiesValueList(valueList);
    }

    @Override
    public void updateResourceGoodsState(Integer goodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (dataState == -1) {
            RsResourceGoods rsResourceGoods = this.getResourceGoods(goodsId);
            this.processFLowDataForEsAndHtml(rsResourceGoods, "delete");
        }
        this.updateStateResourceGoodsModel(goodsId, dataState, oldDataState);
    }

    @Override
    public void updateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        RsPntree rsPntree = this.rsPntreeService.getPntreeByCode(map);
        if (null == rsPntree) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.getPntreeByCode", "\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        RsResourceGoods oldRsResourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        if (null == oldRsResourceGoods) {
            oldRsResourceGoods = this.getResourceGoodsModelByCode(this.getQueryParamMap("tenantCode,goodsCode", new Object[]{rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getGoodsCode()}));
            if (oldRsResourceGoods == null) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoods.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsResourceGoodsDomain.setGoodsId(oldRsResourceGoods.getGoodsId());
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, oldRsResourceGoods);
        this.setResourceGoodsUpdataDefault(rsResourceGoods);
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsResourceGoodsDomain.getRsGoodsFileDomainList();
        String dataPic = rsResourceGoods.getDataPic();
        if (null != rsGoodsFileDomainList && rsGoodsFileDomainList.size() > 0) {
            dataPic = rsResourceGoodsDomain.getRsGoodsFileDomainList().get(0).getGoodsFileUrl();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                break;
            }
        }
        rsResourceGoods.setDataPic(dataPic);
        this.updateResourceGoodsModel(rsResourceGoods);
        this.delGoodsData(rsResourceGoodsDomain.getSpuCode(), rsResourceGoodsDomain.getGoodsCode(), rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getDelSkuId());
        if (null != rsResourceGoodsDomain.getRsSpecValueDomainList() && rsResourceGoodsDomain.getRsSpecValueDomainList().size() > 0) {
            this.processSpecValue(rsResourceGoodsDomain.getRsSpecValueDomainList(), rsResourceGoodsDomain.getSpuCode(), rsResourceGoodsDomain.getGoodsCode(), rsResourceGoodsDomain.getTenantCode());
            this.rsSpecValueService.saveSpecValueList(rsResourceGoodsDomain.getRsSpecValueDomainList());
        }
        if (null != rsResourceGoodsDomain.getRsPropertiesValueDomainList() && rsResourceGoodsDomain.getRsPropertiesValueDomainList().size() > 0) {
            this.savePropertiesList(rsResourceGoodsDomain.getRsPropertiesValueDomainList(), rsResourceGoodsDomain.getSpuCode(), rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
        }
        if (null != rsResourceGoodsDomain.getRsSkuDomainList() && rsResourceGoodsDomain.getRsSkuDomainList().size() > 0) {
            ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
            for (RsSkuDomain sku : rsResourceGoodsDomain.getRsSkuDomainList()) {
                sku.setGoodsCode(rsResourceGoods.getGoodsCode());
                sku.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
                sku.setTenantCode(rsResourceGoods.getTenantCode());
                sku.setSpuCode(rsResourceGoods.getSpuCode());
                sku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                sku.setFreightTemCode(rsResourceGoods.getFreightTemCode());
                if (null != sku.getSkuId()) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("skuCode", sku.getSkuCode());
                    map1.put("tenantCode", sku.getTenantCode());
                    this.rsGoodsOtherService.delGoodsFileBySkuCode(map1);
                    List<RsGoodsFileDomain> rsGoodsSkuFileDomainList = sku.getRsGoodsFileDomainList();
                    if (null != rsGoodsSkuFileDomainList && rsGoodsSkuFileDomainList.size() > 0) {
                        dataPic = sku.getDataPic();
                        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsSkuFileDomainList) {
                            if (rsGoodsFileDomain.getDefaultState() != null && rsGoodsFileDomain.getDefaultState() == 1) {
                                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                            }
                            rsGoodsFileDomain.setSkuCode(sku.getSkuCode());
                        }
                        sku.setDataPic(dataPic);
                        this.rsGoodsOtherService.saveGoodsFileList(sku.getRsGoodsFileDomainList());
                    }
                    this.rsSkuService.updateSku(sku);
                    continue;
                }
                rsSkuList.add(sku);
            }
            if (null != rsSkuList && !rsSkuList.isEmpty()) {
                this.rsSkuService.saveSkuList(rsSkuList);
            }
        }
        if (null != rsResourceGoodsDomain.getRsGoodsRelDomainList() && rsResourceGoodsDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                rsGoodsRelDomain.setTenantCode(rsResourceGoods.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsResourceGoods.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsResourceGoods.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsResourceGoodsDomain.getRsGoodsRelDomainList());
        }
        if (null != rsResourceGoodsDomain.getRsGoodsFileDomainList() && rsResourceGoodsDomain.getRsGoodsFileDomainList().size() > 0) {
            for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsDomain.getRsGoodsFileDomainList()) {
                rsGoodsFileDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                rsGoodsFileDomain.setTenantCode(rsResourceGoods.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsResourceGoods.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsResourceGoods.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsResourceGoodsDomain.getRsGoodsFileDomainList());
        }
        this.updateChannelGoods(rsResourceGoods);
        this.processFLowDataForEsAndHtml(rsResourceGoods, "update");
    }

    @Override
    public RsResourceGoods getResourceGoods(Integer goodsId) {
        RsResourceGoods rsResourceGoods = this.getResourceGoodsModelById(goodsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsResourceGoods.getGoodsCode());
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        this.setClasstreeFullName(rsResourceGoods);
        this.getGoodsRelationInfo(rsResourceGoods, map);
        return rsResourceGoods;
    }

    private void setClasstreeFullName(RsResourceGoods rsResourceGoods) {
        String classtreeCode = rsResourceGoods.getClasstreeCode();
        HashMap<String, Object> classMap = new HashMap<String, Object>();
        classMap.put("tenantCode", rsResourceGoods.getTenantCode());
        StringBuilder classtreeFullName = new StringBuilder();
        while (!"-1".equals(classtreeCode)) {
            classMap.put("classtreeCode", classtreeCode);
            RsClasstree classtree = this.rsClasstreeService.getClasstreeByCode(classMap);
            classtreeFullName.insert(0, "/" + classtree.getClasstreeName());
            classtreeCode = classtree.getClasstreeParentcode();
        }
        String fullName = classtreeFullName.toString();
        rsResourceGoods.setClasstreeFullName(fullName.substring(1, fullName.length()));
    }

    private void getGoodsRelationInfo(RsResourceGoods rsResourceGoods, Map<String, Object> map) {
        QueryResult<RsPropertiesValue> rsPropertiesValueList;
        QueryResult<RsGoodsFile> rsGoodsFileList = this.rsGoodsOtherService.queryGoodsFilePage(map);
        rsResourceGoods.setRsGoodsFileDomainList(rsGoodsFileList.getList());
        QueryResult<RsGoodsRel> rsGoodsRelList = this.rsGoodsOtherService.queryGoodsRelPage(map);
        List rsGoodsRelList1 = rsGoodsRelList.getList();
        if (null != rsGoodsRelList1 && rsGoodsRelList1.size() > 0) {
            for (RsGoodsRel rsGoodsRel : rsGoodsRelList1) {
                RsResourceGoods rsResourceGoods1 = this.getResourceGoodsModelByCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsGoodsRel.getTenantCode()}));
                if (null == rsResourceGoods1) continue;
                rsGoodsRel.setRsResourceGoods(rsResourceGoods1);
            }
        }
        rsResourceGoods.setRsGoodsRelDomainList(rsGoodsRelList1);
        QueryResult<RsSku> rsSkuList = this.rsSkuService.querySkuPage(map);
        if (null != rsSkuList.getList() && rsSkuList.getList().size() > 0) {
            List rsSkuList1 = rsSkuList.getList();
            for (RsSku rsSku : rsSkuList1) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("skuCode", rsSku.getSkuCode());
                map1.put("tenantCode", rsSku.getTenantCode());
                QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
                rsSku.setRsGoodsFileDomainList(rsSkuFileList.getList());
            }
            rsResourceGoods.setRsSkuDomainList(rsSkuList1);
        }
        if (null != (rsPropertiesValueList = this.rsPropertiesValueService.queryPropertiesValuePage(map)) && !rsPropertiesValueList.getRows().isEmpty()) {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            for (RsPropertiesValue rsPropertiesValue : rsPropertiesValueList.getList()) {
                pmap.put("propertiesCode", rsPropertiesValue.getPropertiesCode());
                pmap.put("tenantCode", rsPropertiesValue.getTenantCode());
                RsProperties rsProperties = this.rsPropertiesService.getPropertiesByCode(pmap);
                if (null == rsProperties) continue;
                rsPropertiesValue.setPropertiesName(rsProperties.getPropertiesName());
            }
            rsResourceGoods.setRsPropertiesValueDomainList(rsPropertiesValueList.getList());
        }
        map.put("specValueBillno", rsResourceGoods.getGoodsCode());
        QueryResult<RsSpecValue> rsSpecValueList = this.rsSpecValueService.querySpecValuePage(map);
        rsResourceGoods.setRsSpecValueDomainList(rsSpecValueList.getList());
    }

    @Override
    public void deleteResourceGoods(Integer goodsId) throws ApiException {
        RsResourceGoods resourceGoods = this.getResourceGoodsModelById(goodsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", resourceGoods.getGoodsCode());
        map.put("tenantCode", resourceGoods.getTenantCode());
        List skuList = this.rsSkuService.querySkuPage(map).getList();
        ArrayList<Integer> skuIds = new ArrayList<Integer>();
        for (RsSku rsSku : skuList) {
            skuIds.add(rsSku.getSkuId());
        }
        this.rsSkuService.deleteSkuList(skuIds);
        this.delGoodsData(resourceGoods.getSpuCode(), resourceGoods.getGoodsCode(), resourceGoods.getTenantCode(), null);
        this.deleteResourceGoodsModel(goodsId);
    }

    @Override
    public QueryResult<RsResourceGoods> queryResourceGoodsPage(Map<String, Object> map) {
        List<RsResourceGoods> rsResourceGoodsList = this.queryResourceGoodsModelPage(map);
        if (map.get("children") != null) {
            this.querySkuByGoodsCode(rsResourceGoodsList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGoodsList);
        return queryResult;
    }

    private void querySkuByGoodsCode(List<RsResourceGoods> rsResourceGoodsList) {
        if (rsResourceGoodsList == null || rsResourceGoodsList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (RsResourceGoods rsResourceGoods : rsResourceGoodsList) {
            map.put("goodsCode", rsResourceGoods.getGoodsCode());
            map.put("tenantCode", rsResourceGoods.getTenantCode());
            List skuList = this.rsSkuService.querySkuPage(map).getList();
            rsResourceGoods.setSkuList(skuList);
            map.clear();
        }
    }

    @Override
    public RsResourceGoods getResourceGoodsByCode(Map<String, Object> map) {
        RsResourceGoods rsResourceGoods = this.getResourceGoodsModelByCode(map);
        if (null != rsResourceGoods && null == map.get("unwantedRelatedData")) {
            this.getGoodsRelationInfo(rsResourceGoods, map);
        }
        return rsResourceGoods;
    }

    @Override
    public void delResourceGoodsByCode(Map<String, Object> map) throws ApiException {
        RsResourceGoods resourceGoods = this.getResourceGoodsByCode(map);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("goodsCode", resourceGoods.getGoodsCode());
        map1.put("tenantCode", resourceGoods.getTenantCode());
        List skuList = this.rsSkuService.querySkuPage(map1).getList();
        ArrayList<Integer> skuIds = new ArrayList<Integer>();
        for (RsSku rsSku : skuList) {
            skuIds.add(rsSku.getSkuId());
        }
        this.rsSkuService.deleteSkuList(skuIds);
        this.delGoodsData(resourceGoods.getSpuCode(), resourceGoods.getGoodsCode(), resourceGoods.getTenantCode(), null);
        this.delResourceGoodsModelByCode(map1);
    }

    @Override
    public String saveResourceGoodsList(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        String codeStr;
        String[] goodsCodes;
        if (goodsList == null || goodsList.isEmpty()) {
            return null;
        }
        ArrayList<RsResourceGoods> rsResourceGoodsList = new ArrayList<RsResourceGoods>();
        String goodsBillbatch = goodsList.get(0).getGoodsBillbatch();
        if (StringUtils.isBlank((String)goodsBillbatch)) {
            goodsBillbatch = this.createUUIDString();
        }
        if ((goodsCodes = (codeStr = this.getBatchNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", goodsList.size(), goodsList.get(0).getTenantCode())).split(",")).length != goodsList.size()) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.getBatchNo", "\u8d44\u6e90\u4ee3\u7801\u751f\u6210\u5931\u8d25");
        }
        int i = 0;
        ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            String msg = this.checkResourceGoods(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.checkResourceGoods", msg);
            }
            RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
            rsResourceGoods.setGoodsCode(goodsCodes[i]);
            this.setResourceGoodsDefault(rsResourceGoods);
            rsResourceGoods.setGoodsBillbatch(goodsBillbatch);
            rsResourceGoods.getSku().setGoodsCode(rsResourceGoods.getGoodsCode());
            rsResourceGoods.getSku().setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
            rsResourceGoods.getSku().setTenantCode(rsResourceGoods.getTenantCode());
            skuList.add(rsResourceGoods.getSku());
            rsResourceGoodsList.add(rsResourceGoods);
            ++i;
        }
        this.saveResourceGoodsModelList(rsResourceGoodsList);
        this.rsSkuService.saveSkuList(skuList);
        return goodsBillbatch;
    }

    @Override
    public void updateAhResourceList(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        if (goodsList == null || goodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            this.updateAhResource(rsResourceGoodsDomain);
        }
    }

    @Override
    public void updateAhResource(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateAhResource.checkResourceGoods", msg);
        }
        RsResourceGoods oldRsResourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        if (null == oldRsResourceGoods) {
            oldRsResourceGoods = this.getResourceGoodsModelByCode(this.getQueryParamMap("tenantCode,goodsCode", new Object[]{rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getGoodsCode()}));
            if (oldRsResourceGoods == null) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.updateAhResource.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsResourceGoodsDomain.setGoodsId(oldRsResourceGoods.getGoodsId());
        }
        if (oldRsResourceGoods.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, oldRsResourceGoods);
        this.setResourceGoodsUpdataDefault(rsResourceGoods);
        BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
        BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
        goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
        rsResourceGoods.setGoodsAhnum(goodsNum);
        rsResourceGoods.setGoodsAhweight(goodsWeight);
        rsResourceGoods.setGoodsNum(goodsNum.subtract(goodsNum));
        rsResourceGoods.setGoodsWeight(goodsWeight.subtract(goodsWeight));
        rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
        rsResourceGoods.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
        rsResourceGoods.setGoodsSort(null);
        rsResourceGoods.setGoodsHdate(this.getSysDate());
        this.updateResourceGoodsModelWithNull(rsResourceGoods);
        this.rsSkuService.updateAhSkuListByGoodsCode(rsResourceGoodsDomain.getGoodsCode(), rsResourceGoodsDomain.getTenantCode());
    }

    @Override
    public void updateResourceStock(List<ResourceStockDomain> resourceGoodsList, String type) throws ApiException {
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        ArrayList<RsResourceListDomain> rsResourceListDomainList = new ArrayList<RsResourceListDomain>();
        String bn = this.createUUIDString();
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        for (ResourceStockDomain resourceStockDomain : resourceGoodsList) {
            resourceStockDomain.setType(type);
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)resourceStockDomain), String.class, Object.class);
            rsResourceListDomainList.add(this.makeResourceStockDomain(resourceStockDomain, bn));
            this.updateStateResourceGoodsModel(map);
            this.rsSkuService.updateSkuStock(map);
            if (!type.equals("2")) continue;
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("skuCode", resourceStockDomain.getSkuCode());
            skuMap.put("goodsCode", resourceStockDomain.getGoodsCode());
            skuMap.put("tenantCode", resourceStockDomain.getTenantCode());
            RsSku rsSku = this.rsSkuMapper.getByCode(skuMap);
            if (null == rsSku) continue;
            RsFlowData rsFlowData1 = new RsFlowData();
            if (rsSku.getGoodsSupplynum().intValue() <= 0) {
                rsFlowData1.setEsRequestType("delete");
            } else {
                rsFlowData1.setEsRequestType("update");
            }
            rsFlowData1.setTenantCode(resourceStockDomain.getTenantCode());
            rsFlowData1.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsFlowData1.setFdBizCode(rsSku.getSkuCode());
            rsFlowData1.setFdBizType(2);
            rsFlowData1.setDataState(1);
            rsFlowData1.setGmtCreate(new Date());
            String fdCode1 = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsSku.getTenantCode());
            rsFlowData1.setFdCode(fdCode1);
            rsFlowDataList.add(rsFlowData1);
        }
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
        this.rsResourceListService.saveResourceListBatch(rsResourceListDomainList);
    }

    private RsResourceListDomain makeResourceStockDomain(ResourceStockDomain resourceStockDomain, String batchNo) {
        if (null == resourceStockDomain) {
            return null;
        }
        RsResourceListDomain rsResourceListDomain = new RsResourceListDomain();
        rsResourceListDomain.setCflowPprocessCode(resourceStockDomain.getCflowPprocessCode());
        rsResourceListDomain.setContractBbillcode(resourceStockDomain.getContractBbillcode());
        rsResourceListDomain.setContractBillcode(resourceStockDomain.getContractBillcode());
        rsResourceListDomain.setContractCtrlSeqno(resourceStockDomain.getContractCtrlSeqno());
        rsResourceListDomain.setGoodsCode(resourceStockDomain.getGoodsCode());
        rsResourceListDomain.setGoodsNum(resourceStockDomain.getGoodsNum());
        rsResourceListDomain.setGoodsWeight(resourceStockDomain.getGoodsWeight());
        rsResourceListDomain.setTenantCode(resourceStockDomain.getTenantCode());
        rsResourceListDomain.setResourceListBillbatch(batchNo);
        return rsResourceListDomain;
    }

    private void updateStateResourceGoodsModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateResourceStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.map.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.map.null.param", map);
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateStateResourceGoodsModel.map.null");
        }
    }

    @Override
    public void deleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        if (goodsIds == null || goodsIds.isEmpty()) {
            return;
        }
        for (Integer goodsId : goodsIds) {
            this.deleteResourceGoods(goodsId);
        }
    }

    @Override
    public void updateAuditResourcePass(List<Integer> goodsIds) {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
            rsResourceGoods.setGoodsSupplynum(rsResourceGoods.getGoodsSupplynum().add(goodsAhnum));
            rsResourceGoods.setGoodsSupplyweight(rsResourceGoods.getGoodsSupplyweight().add(goodsAhweight));
            rsResourceGoods.setGoodsHangnum(rsResourceGoods.getGoodsHangnum().add(goodsAhnum));
            rsResourceGoods.setGoodsHangweight(rsResourceGoods.getGoodsHangweight().add(goodsAhweight));
            rsResourceGoods.setGoodsAhnum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsAhweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
            rsResourceGoods.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
            rsResourceGoods.setGoodsHdate(this.getSysDate());
            this.updateResourceGoodsModel(rsResourceGoods);
            this.rsSkuService.updateAuditSkuPassByGoodsCode(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
            this.processFLowDataForEsAndHtml(rsResourceGoods, "insert");
        }
    }

    public void processFLowDataForEsAndHtml(RsResourceGoods rsResourceGoods, String requestType) {
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData = new RsFlowData();
        rsFlowData.setEsRequestType(requestType);
        rsFlowData.setTenantCode(rsResourceGoods.getTenantCode());
        rsFlowData.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
        rsFlowData.setFdBizCode(rsResourceGoods.getGoodsCode());
        rsFlowData.setFdBizType(1);
        rsFlowData.setDataState(1);
        rsFlowData.setGmtCreate(new Date());
        String fdCode = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsResourceGoods.getTenantCode());
        rsFlowData.setFdCode(fdCode);
        rsFlowDataList.add(rsFlowData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsResourceGoods.getGoodsCode());
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        map.put("dataState", 2);
        List<RsSku> esSkuList = this.rsSkuMapper.query(map);
        if (null != esSkuList) {
            for (RsSku rsSku : esSkuList) {
                RsFlowData rsFlowData1 = new RsFlowData();
                rsFlowData1.setEsRequestType(requestType);
                rsFlowData1.setTenantCode(rsResourceGoods.getTenantCode());
                rsFlowData1.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
                rsFlowData1.setFdBizCode(rsSku.getSkuCode());
                rsFlowData1.setFdBizType(2);
                rsFlowData1.setDataState(1);
                rsFlowData1.setGmtCreate(new Date());
                String fdCode1 = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsResourceGoods.getTenantCode());
                rsFlowData1.setFdCode(fdCode1);
                rsFlowDataList.add(rsFlowData1);
            }
        }
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    private void insertGoodsSearch(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("goods");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    @Override
    public void updateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
            rsResourceGoods.setGoodsNum(rsResourceGoods.getGoodsNum().add(goodsAhnum));
            rsResourceGoods.setGoodsWeight(rsResourceGoods.getGoodsWeight().add(goodsAhweight));
            rsResourceGoods.setGoodsAhnum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsAhweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
            this.updateResourceGoodsModel(rsResourceGoods);
        }
    }

    @Override
    public void updateCannelResourceList(List<Integer> goodsIds) throws ApiException {
        List<RsResourceGoods> resourceGoodsList = this.checkAuditResource(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return;
        }
        this.updateCannelResourceByList(resourceGoodsList);
    }

    private void updateCannelResourceByList(List<RsResourceGoods> resourceGoodsList) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (RsResourceGoods rsResourceGoods : resourceGoodsList) {
            BigDecimal goodsSupplyweight;
            BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum() != null ? rsResourceGoods.getGoodsSupplynum() : BigDecimal.ZERO;
            BigDecimal bigDecimal = goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight() != null ? rsResourceGoods.getGoodsSupplyweight() : BigDecimal.ZERO;
            if (rsResourceGoods.getGoodsNum() != null) {
                rsResourceGoods.setGoodsNum(rsResourceGoods.getGoodsNum().add(goodsSupplynum));
            }
            if (rsResourceGoods.getGoodsWeight() != null) {
                rsResourceGoods.setGoodsWeight(rsResourceGoods.getGoodsWeight().add(goodsSupplyweight));
            }
            if (rsResourceGoods.getGoodsHangnum() != null) {
                rsResourceGoods.setGoodsHangnum(rsResourceGoods.getGoodsHangnum().subtract(goodsSupplynum));
            }
            if (rsResourceGoods.getGoodsHangweight() != null) {
                rsResourceGoods.setGoodsHangweight(rsResourceGoods.getGoodsHangweight().subtract(goodsSupplyweight));
            }
            rsResourceGoods.setGoodsSupplynum(BigDecimal.ZERO);
            rsResourceGoods.setGoodsSupplyweight(BigDecimal.ZERO);
            rsResourceGoods.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            rsResourceGoods.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
            this.updateResourceGoodsModel(rsResourceGoods);
            ArrayList<Integer> skuIds = new ArrayList<Integer>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoods.getGoodsCode());
            map.put("tenantCode", rsResourceGoods.getTenantCode());
            map.put("dataState", 2);
            List skuList = this.rsSkuService.querySkuPage(map).getList();
            for (RsSku rsSku : skuList) {
                skuIds.add(rsSku.getSkuId());
                skuCodeList.add(rsSku.getSkuCode());
            }
            this.rsSkuService.updateCannelSkuList(skuIds);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("delete");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj(skuCodeList);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<RsResourceGoods> checkAuditResource(List<Integer> goodsIds) {
        if (goodsIds == null || goodsIds.isEmpty()) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.checkAuditResource.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsResourceGoods> resourceGoodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.getResourceGoodsModelById(goodsId);
            if (rsResourceGoods == null) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.getResourceGoodsModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
            BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
            BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
            BigDecimal goodsAhweight = rsResourceGoods.getGoodsWeight();
            BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
            BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
            rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            resourceGoodsList.add(rsResourceGoods);
        }
        return resourceGoodsList;
    }

    @Override
    public QueryResult<RsResourceGoods> queryRsGoodsSkuPage(Map<String, Object> map) throws ApiException {
        if (null == map || StringUtils.isBlank((String)map.get("tenantCode").toString())) {
            return null;
        }
        List<RsResourceGoods> rsResourceGoodsList = this.getRsGoodsSkuByCode(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.getRsGoodsSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGoodsList);
        return queryResult;
    }

    private List<RsResourceGoods> getRsGoodsSkuByCode(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.getRsGoodsSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int getRsGoodsSkuCount(Map<String, Object> parammap) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.getRsGoodsSkuCount(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateCannelResource(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        RsResourceGoods oldRsResourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        if (null == oldRsResourceGoods && (oldRsResourceGoods = this.getResourceGoodsModelByCode(this.getQueryParamMap("tenantCode,goodsCode", new Object[]{rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getGoodsCode()}))) == null) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsResourceGoods> resourceList = new ArrayList<RsResourceGoods>();
        resourceList.add(oldRsResourceGoods);
        this.updateCannelResourceByList(resourceList);
    }

    @Override
    public void updateResourceGoodsList(List<RsResourceGoodsDomain> goodsList) {
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            this.updateResourceGoods(rsResourceGoodsDomain);
        }
    }

    @Override
    public List<String> saveResourceGoodsListReCode(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        String codeStr;
        String[] goodsCodes;
        if (goodsList == null || goodsList.isEmpty()) {
            return null;
        }
        ArrayList<RsResourceGoods> rsResourceGoodsList = new ArrayList<RsResourceGoods>();
        String goodsBillbatch = goodsList.get(0).getGoodsBillbatch();
        ArrayList<String> goodsCode = new ArrayList<String>();
        if (StringUtils.isBlank((String)goodsBillbatch)) {
            goodsBillbatch = this.createUUIDString();
        }
        if ((goodsCodes = (codeStr = this.getBatchNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", goodsList.size(), goodsList.get(0).getTenantCode())).split(",")).length != goodsList.size()) {
            throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.getBatchNo", "\u8d44\u6e90\u4ee3\u7801\u751f\u6210\u5931\u8d25");
        }
        int i = 0;
        ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            String msg = this.checkResourceGoods(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.saveResourceGoods.checkResourceGoods", msg);
            }
            RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
            rsResourceGoods.setGoodsCode(goodsCodes[i]);
            this.setResourceGoodsDefault(rsResourceGoods);
            rsResourceGoods.setGoodsBillbatch(goodsBillbatch);
            rsResourceGoods.getSku().setGoodsCode(rsResourceGoods.getGoodsCode());
            rsResourceGoods.getSku().setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
            rsResourceGoods.getSku().setTenantCode(rsResourceGoods.getTenantCode());
            skuList.add(rsResourceGoods.getSku());
            rsResourceGoodsList.add(rsResourceGoods);
            goodsCode.add(rsResourceGoods.getGoodsCode());
            ++i;
        }
        this.saveResourceGoodsModelList(rsResourceGoodsList);
        this.rsSkuService.saveSkuList(skuList);
        return goodsCode;
    }

    @Override
    public void updateResourceGoodsListByPntree(String pntreeCodeFor, String pntreeCodeTo, String pntreeNameTo, String tenantCode) {
        if (StringUtils.isNotBlank((String)pntreeCodeFor) && StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)pntreeCodeTo)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pntreeCode", pntreeCodeFor);
            map.put("tenantCode", tenantCode);
            List<RsResourceGoods> goodslList = this.queryResourceGoodsModelPage(map);
            ArrayList<String> skuCodeList = new ArrayList<String>();
            if (ListUtil.isNotEmpty(goodslList)) {
                for (RsResourceGoods rsResourceGoods : goodslList) {
                    rsResourceGoods.setPntreeCode(pntreeCodeTo);
                    rsResourceGoods.setPntreeName(pntreeNameTo);
                    this.setResourceGoodsUpdataDefault(rsResourceGoods);
                    this.updateResourceGoodsModel(rsResourceGoods);
                    skuCodeList.add(rsResourceGoods.getGoodsCode());
                }
            }
            StoreDomain storeDomain = new StoreDomain();
            storeDomain.setRequestType("delete");
            storeDomain.setBizType("sku");
            storeDomain.setStoreObj(skuCodeList);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
            this.getInternalRouter().inInvoke("es.searchengine.store", paramMap);
            goodslList = this.queryResourceGoodsModelPage(this.getQueryMapParam("pntreeCode,tenantCode", new Object[]{pntreeCodeTo, tenantCode}));
            for (RsResourceGoods rsResourceGoods : goodslList) {
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                nmap.put("goodsCode", rsResourceGoods.getGoodsCode());
                nmap.put("tenantCode", rsResourceGoods.getTenantCode());
                nmap.put("dataState", 2);
                this.rsSkuService.querySkuAll(nmap);
            }
            QueryResult<RsSpu> qlist = this.rsSpuService.querySpuPage(map);
            if (null != qlist && null != qlist.getList()) {
                List spuList = qlist.getList();
                for (RsSpu rsSpu : spuList) {
                    rsSpu.setPntreeCode(pntreeCodeTo);
                    RsSpuDomain rsSpuDomain = new RsSpuDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)rsSpuDomain, (Object)rsSpu);
                    }
                    catch (Exception e) {
                        throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoodsListByPntree.cp", (Throwable)e);
                    }
                    this.rsSpuService.updateSpu(rsSpuDomain);
                }
            }
            QueryResult<RsProperties> qplist = this.rsPropertiesService.queryPropertiesPage(map);
            if (null != qlist && null != qplist.getList()) {
                List propertieList = qplist.getList();
                for (RsProperties rsProperties : propertieList) {
                    RsPropertiesDomain rsPropertiesDomain = new RsPropertiesDomain();
                    rsProperties.setPntreeCode(pntreeCodeTo);
                    try {
                        BeanUtils.copyAllPropertys((Object)rsPropertiesDomain, (Object)rsProperties);
                    }
                    catch (Exception e) {
                        throw new ApiException("rs.RsResourceGoodsServiceImpl.updateResourceGoodsListByPntree.cp1", (Throwable)e);
                    }
                    this.rsPropertiesService.updateProperties(rsPropertiesDomain);
                }
            }
        }
    }

    @Override
    public void saveSkuManager(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        String skuCodes = (String)map.get("skuCodes");
        String goodsNums = (String)map.get("goodsNums");
        String memberBcode = (String)map.get("memberBcode");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)skuCodes) || StringUtils.isBlank((String)goodsNums) || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String[] skuCodeArry = skuCodes.split(",");
        String[] goodsNumArry = goodsNums.split(",");
        for (int i = 0; i < skuCodeArry.length; ++i) {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("tenantCode", tenantCode);
            pmap.put("skuCode", skuCodeArry[i]);
            RsSku sku = this.rsSkuService.getSkuByCode(pmap);
            if (sku == null) {
                throw new ApiException("rs.RsResourceGoodsServiceImpl.saveSkuManager.null", "\u672a\u67e5\u8be2\u5230sku");
            }
            pmap.put("goodsCode", sku.getGoodsCode());
            RsResourceGoods rsgoods = this.getResourceGoodsByCode(pmap);
            sku.setGoodsOrdnum(sku.getGoodsOrdnum().subtract(new BigDecimal(goodsNumArry[i])));
            sku.setGoodsSalesvolume(sku.getGoodsSalesvolume() == null ? new BigDecimal(goodsNumArry[i]) : sku.getGoodsSalesvolume().add(new BigDecimal(goodsNumArry[i])));
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)sku);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rsSkuService.updateSku(rsSkuDomain);
            pmap.clear();
            pmap.put("tenantCode", tenantCode);
            pmap.put("memberCode", memberBcode);
            pmap.put("skuBarcode", sku.getSkuBarcode());
            List<RsResourceGoods> list = this.getRsGoodsSkuByCode(pmap);
            if (list == null || list.size() == 0) {
                RsResourceGoodsDomain rsgoodsdomain = new RsResourceGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)rsgoodsdomain, (Object)rsgoods);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                rsgoodsdomain.setGoodsCode(null);
                rsgoodsdomain.setGoodsId(null);
                rsgoodsdomain.setMemberCode(memberBcode);
                rsSkuDomain.setSkuId(null);
                rsSkuDomain.setSkuCode(null);
                rsSkuDomain.setGoodsOrdnum(BigDecimal.ZERO);
                rsSkuDomain.setGoodsSalesvolume(BigDecimal.ZERO);
                rsSkuDomain.setGoodsSupplynum(new BigDecimal(goodsNumArry[i]));
                rsSkuDomain.setGoodsNum(BigDecimal.ZERO);
                rsSkuDomain.setGoodsHangnum(new BigDecimal(goodsNumArry[i]));
                ArrayList<RsSkuDomain> rslist = new ArrayList<RsSkuDomain>();
                rslist.add(rsSkuDomain);
                rsgoodsdomain.setRsSkuDomainList(rslist);
                this.saveResourceGoods(rsgoodsdomain);
                continue;
            }
            pmap.put("tenantCode", tenantCode);
            pmap.put("skuCode", list.get(0).getGoodsCode());
            sku = this.rsSkuService.getSkuByCode(pmap);
            try {
                BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)sku);
                rsSkuDomain.setGoodsSupplynum(rsSkuDomain.getGoodsSupplynum() == null ? new BigDecimal(goodsNumArry[i]) : rsSkuDomain.getGoodsSupplynum().add(new BigDecimal(goodsNumArry[i])));
                rsSkuDomain.setGoodsHangnum(rsSkuDomain.getGoodsHangnum() == null ? new BigDecimal(goodsNumArry[i]) : rsSkuDomain.getGoodsHangnum().add(new BigDecimal(goodsNumArry[i])));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rsSkuService.updateSku(rsSkuDomain);
        }
    }

    @Override
    public void saveResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        if (ListUtil.isEmpty(goodsList)) {
            return;
        }
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            this.saveResourceGoods(rsResourceGoodsDomain);
        }
    }

    @Override
    public QueryResult<RsResourceGoods> queryDisSkuPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<RsResourceGoods> list = this.queryDisgoods(map);
        queryResult.setList(list);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisgoodsCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        for (RsResourceGoods rsgoods : list) {
            map.put("goodsCode", rsgoods.getGoodsCode());
            QueryResult<RsSku> rs = this.rsSkuService.queryDisSkuPage(map);
            if (rs != null && rs.getList() != null) {
                List rsSkuList = rs.getList();
                rsgoods.setSkuList(rsSkuList);
                for (RsSku sku : rsSkuList) {
                    HashMap<String, Object> pmap = new HashMap<String, Object>();
                    pmap.put("skuCode", sku.getSkuCode());
                    pmap.put("tenantCode", sku.getTenantCode());
                    QueryResult<RsDisSku> dissku = this.rsDisGoodsService.queryDisSkuPage(pmap);
                    if (dissku == null) continue;
                    sku.setDisSkuList(dissku.getList());
                }
            }
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("goodsCode", rsgoods.getGoodsCode());
            pmap.put("tenantCode", rsgoods.getTenantCode());
            QueryResult<RsDisGoods> disGoodsList = this.rsDisGoodsService.queryDisGoodsPage(pmap);
            if (disGoodsList == null) continue;
            rsgoods.setDisGoodsList(disGoodsList.getList());
        }
        return queryResult;
    }

    private List<RsResourceGoods> queryDisgoods(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.queryDisgoods(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryDisgoods", (Throwable)e);
            return null;
        }
    }

    private int queryDisgoodsCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.queryDisgoodsCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryDisgoodsCount", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<RsResourceGoods> queryPntreeBySaleList(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return this.queryPntreeBySale(map);
    }

    private List<RsResourceGoods> queryPntreeBySale(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.queryPntreeBySale(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveStoreByCode(String rsAllocationCode, String tenantCode) {
    }

    @Override
    public void updateGoodsSortNo(Integer goodsId, Integer sortNo) {
        if (goodsId == null) {
            return;
        }
        RsResourceGoods rsResourceGoods = this.getResourceGoods(goodsId);
        if (rsResourceGoods == null) {
            return;
        }
        rsResourceGoods.setGoodsSort(sortNo);
        this.setResourceGoodsUpdataDefault(rsResourceGoods);
        this.updateResourceGoodsModelWithNull(rsResourceGoods);
        this.rsSkuService.updateSkuSortNo(rsResourceGoods.getTenantCode(), rsResourceGoods.getGoodsCode(), null, sortNo);
    }

    @Override
    public void deleteGoodsIndexByTenantCode(String tenantCode) {
        List<RsResourceGoods> goodsList;
        if (StringUtils.isNotBlank((String)tenantCode) && ListUtil.isNotEmpty(goodsList = this.queryResourceGoodsModelPage(this.getQueryMapParam("dataState,tenantCode", new Object[]{2, tenantCode})))) {
            ArrayList<String> skuCodeList = new ArrayList<String>();
            for (RsResourceGoods rsResourceGoods : goodsList) {
                skuCodeList.add(rsResourceGoods.getGoodsCode());
            }
            StoreDomain storeDomain = new StoreDomain();
            storeDomain.setRequestType("delete");
            storeDomain.setBizType("sku");
            storeDomain.setStoreObj(skuCodeList);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
            this.getInternalRouter().inInvoke("es.searchengine.store", paramMap);
        }
    }

    private void updateChannelGoods(RsResourceGoods rsResourceGoods) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        map.put("goodsCodeOld", rsResourceGoods.getGoodsCode());
        List<RsResourceGoods> goodsList = this.queryResourceGoodsModelPage(map);
        if (goodsList == null) {
            return;
        }
        for (RsResourceGoods goods : goodsList) {
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)rsResourceGoodsDomain, (Object)rsResourceGoods);
            }
            catch (Exception e) {
                this.logger.error("updateChannelGoods", (Throwable)e);
            }
            rsResourceGoodsDomain.setGoodsId(goods.getGoodsId());
            rsResourceGoodsDomain.setGoodsCode(goods.getGoodsCode());
            rsResourceGoodsDomain.setChannelCode(goods.getChannelCode());
            rsResourceGoodsDomain.setGoodsNum(goods.getGoodsNum());
            rsResourceGoodsDomain.setGoodsSupplynum(goods.getGoodsSupplynum());
            rsResourceGoodsDomain.setMemberCode(goods.getMemberCode());
            rsResourceGoodsDomain.setMemberName(goods.getMemberName());
            rsResourceGoodsDomain.setPricesetAsprice(goods.getPricesetAsprice());
            rsResourceGoodsDomain.setPricesetBaseprice(goods.getPricesetBaseprice());
            rsResourceGoodsDomain.setPricesetNprice(goods.getPricesetNprice());
            rsResourceGoodsDomain.setPricesetMakeprice(goods.getPricesetMakeprice());
            rsResourceGoodsDomain.setDataOpbillstate(goods.getDataOpbillstate());
            rsResourceGoodsDomain.setRsSkuDomainList(null);
            this.updateResourceGoods(rsResourceGoodsDomain);
        }
    }
}

