/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsClasstreeServiceImpl
extends BaseServiceImpl
implements RsClasstreeService {
    private static final String SYS_CODE = "rs.RsClasstreeServiceImpl";
    private RsClasstreeMapper rsClasstreeMapper;
    private RsFlowDataService rsFlowDataService;

    public void setRsClasstreeMapper(RsClasstreeMapper rsClasstreeMapper) {
        this.rsClasstreeMapper = rsClasstreeMapper;
    }

    public void setRsFlowDataService(RsFlowDataService rsFlowDataService) {
        this.rsFlowDataService = rsFlowDataService;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClasstree(RsClasstreeDomain rsClasstreeDomain) {
        if (null == rsClasstreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeDomain.getClasstreeName())) {
            msg = msg + "ClasstreeName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsClasstreeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClasstreeDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        if (null == rsClasstree.getDataState()) {
            rsClasstree.setDataState(0);
        }
        if (null == rsClasstree.getGmtCreate()) {
            rsClasstree.setGmtCreate(this.getSysDate());
        }
        rsClasstree.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsClasstree.getClasstreeCode())) {
            rsClasstree.setClasstreeCode(this.createUUIDString());
        }
    }

    private int getClasstreeMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClasstreeUpdataDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        rsClasstree.setGmtModified(this.getSysDate());
    }

    private void saveClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.insert(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeModel.ex", (Throwable)e);
        }
    }

    private RsClasstree getClasstreeModelById(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.selectByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelById", (Throwable)e);
            return null;
        }
    }

    public RsClasstree getClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.num");
        }
    }

    private void deleteClasstreeModel(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.deleteByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.num");
        }
    }

    private void updateClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.updateByPrimaryKeySelective(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstreeModel.ex", (Throwable)e);
        }
    }

    private void updateStateClasstreeModel(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == classtreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeId", classtreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsClasstreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.null");
        }
    }

    private RsClasstree makeClasstree(RsClasstreeDomain rsClasstreeDomain, RsClasstree rsClasstree) {
        if (null == rsClasstreeDomain) {
            return null;
        }
        if (null == rsClasstree) {
            rsClasstree = new RsClasstree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstree, (Object)rsClasstreeDomain);
            return rsClasstree;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClasstree", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstree> queryClasstreeModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeModel", (Throwable)e);
            return null;
        }
    }

    private int countClasstree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.countClasstree", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstree.checkClasstree", msg);
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
        this.setClasstreeDefault(rsClasstree);
        this.saveClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstreeDomain.getTenantCode());
        return rsClasstree.getClasstreeCode();
    }

    @Override
    public void updateClasstreeState(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClasstreeModel(classtreeId, dataState, oldDataState);
    }

    @Override
    public void updateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.checkClasstree", msg);
        }
        RsClasstree oldRsClasstree = this.getClasstreeModelById(rsClasstreeDomain.getClasstreeId());
        if (null == oldRsClasstree) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, oldRsClasstree);
        this.setClasstreeUpdataDefault(rsClasstree);
        this.updateClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstreeDomain.getTenantCode());
    }

    @Override
    public RsClasstree getClasstree(Integer classtreeId) {
        return this.getClasstreeModelById(classtreeId);
    }

    @Override
    public void deleteClasstree(Integer classtreeId) throws ApiException {
        RsClasstree rsClasstree = this.getClasstree(classtreeId);
        this.deleteClasstreeModel(classtreeId);
        this.processFLowDataForHtml(rsClasstree.getTenantCode());
    }

    @Override
    public QueryResult<RsClasstree> queryClasstreePage(Map<String, Object> map) {
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClasstree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeList);
        return queryResult;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstree(String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", "-1");
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    private RsClasstreeReDomain makeRsClasstreeReDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeReDomain rsClasstreeReDomain = new RsClasstreeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeReDomain, (Object)rsClasstree);
            rsClasstreeReDomain.setChildList(this.queryClasstreeParent(rsClasstree.getMemberCode(), rsClasstree.getTenantCode(), rsClasstree.getClasstreeCode()));
        }
        catch (Exception e) {
            return null;
        }
        return rsClasstreeReDomain;
    }

    private List<RsClasstreeReDomain> queryClasstreeParent(String memberCode, String tenantCode, String classtreeParentcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", classtreeParentcode);
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree getClasstreeByCode(Map<String, Object> map) {
        return this.getClasstreeModelByCode(map);
    }

    @Override
    public void delClasstreeByCode(Map<String, Object> map) throws ApiException {
        RsClasstree rsClasstree = this.getClasstreeByCode(map);
        this.delClasstreeModelByCode(map);
        this.processFLowDataForHtml(rsClasstree.getTenantCode());
    }

    public void processFLowDataForHtml(String tenantCode) {
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData = new RsFlowData();
        rsFlowData.setEsRequestType("update");
        rsFlowData.setTenantCode(tenantCode);
        rsFlowData.setFdBizCode("");
        rsFlowData.setFdBizType(3);
        rsFlowData.setDataState(1);
        rsFlowData.setGmtCreate(new Date());
        String fdCode = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", tenantCode);
        rsFlowData.setFdCode(fdCode);
        rsFlowDataList.add(rsFlowData);
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }
}

