/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.domain.client.oc.mode.OcContract;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsAllocationMapper;
import com.yqbsoft.laser.service.resources.domain.RsAllocationDomain;
import com.yqbsoft.laser.service.resources.domain.RsStoreGoodsDomain;
import com.yqbsoft.laser.service.resources.model.RsAllocation;
import com.yqbsoft.laser.service.resources.service.RsAllocationService;
import com.yqbsoft.laser.service.resources.service.RsStoreGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsAllocationServiceImpl
extends BaseServiceImpl
implements RsAllocationService {
    private static final String SYS_CODE = "rs.RESOURCE_GOODS.RsAllocationServiceImpl";
    private RsAllocationMapper rsAllocationMapper;
    private RsStoreGoodsService rsStoreGoodsService;

    public void setRsAllocationMapper(RsAllocationMapper rsAllocationMapper) {
        this.rsAllocationMapper = rsAllocationMapper;
    }

    public void setRsStoreGoodsService(RsStoreGoodsService rsStoreGoodsService) {
        this.rsStoreGoodsService = rsStoreGoodsService;
    }

    private Date getSysDate() {
        try {
            return this.rsAllocationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAllocation(RsAllocationDomain rsAllocationDomain) {
        if (rsAllocationDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAllocationDefault(RsAllocation rsAllocation) {
        if (rsAllocation == null) {
            return;
        }
        if (rsAllocation.getDataState() == null) {
            rsAllocation.setDataState(0);
        }
        if (rsAllocation.getGmtCreate() == null) {
            rsAllocation.setGmtCreate(this.getSysDate());
        }
        rsAllocation.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsAllocation.getRsAllocationCode())) {
            rsAllocation.setRsAllocationCode(this.createUUIDString());
        }
    }

    private int getAllocationMaxCode() {
        int code = 0;
        try {
            return this.rsAllocationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.getAllocationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAllocationUpdataDefault(RsAllocation rsAllocation) {
        if (rsAllocation == null) {
            return;
        }
        rsAllocation.setGmtModified(this.getSysDate());
    }

    private void saveAllocationModel(RsAllocation rsAllocation) throws ApiException {
        if (rsAllocation == null) {
            return;
        }
        try {
            this.rsAllocationMapper.insert(rsAllocation);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.saveAllocationModel.ex", (Throwable)e);
        }
    }

    private RsAllocation getAllocationModelById(Integer rsAllocationId) {
        if (rsAllocationId == null) {
            return null;
        }
        try {
            return this.rsAllocationMapper.selectByPrimaryKey(rsAllocationId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.getAllocationModelById", (Throwable)e);
            return null;
        }
    }

    public RsAllocation getAllocationModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsAllocationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.getAllocationModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAllocationModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsAllocationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.delAllocationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.delAllocationModelByCode.num");
        }
    }

    private void deleteAllocationModel(Integer rsAllocationId) throws ApiException {
        if (rsAllocationId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsAllocationMapper.deleteByPrimaryKey(rsAllocationId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.deleteAllocationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.deleteAllocationModel.num");
        }
    }

    private void updateAllocationModel(RsAllocation rsAllocation) throws ApiException {
        if (rsAllocation == null) {
            return;
        }
        try {
            this.rsAllocationMapper.updateByPrimaryKeySelective(rsAllocation);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.updateAllocationModel.ex", (Throwable)e);
        }
    }

    private void updateStateAllocationModel(Integer rsAllocationId, Integer dataState, Integer oldDataState) throws ApiException {
        if (rsAllocationId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsAllocationId", rsAllocationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsAllocationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.updateStateAllocationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.updateStateAllocationModel.null");
        }
    }

    private RsAllocation makeAllocation(RsAllocationDomain rsAllocationDomain, RsAllocation rsAllocation) {
        if (rsAllocationDomain == null) {
            return null;
        }
        if (rsAllocation == null) {
            rsAllocation = new RsAllocation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsAllocation, (Object)rsAllocationDomain);
            return rsAllocation;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.makeAllocation", (Throwable)e);
            return null;
        }
    }

    private List<RsAllocation> queryAllocationModelPage(Map<String, Object> parammap) {
        try {
            return this.rsAllocationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.queryAllocationModel", (Throwable)e);
            return null;
        }
    }

    private int countAllocation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsAllocationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.countAllocation", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveAllocation(RsAllocationDomain rsAllocationDomain) throws ApiException {
        HashMap<String, Object> map;
        String msg = this.checkAllocation(rsAllocationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.saveAllocation.checkAllocation", msg);
        }
        RsAllocation rsAllocation = this.makeAllocation(rsAllocationDomain, null);
        this.setAllocationDefault(rsAllocation);
        this.saveAllocationModel(rsAllocation);
        if (rsAllocationDomain.getRsStoreGoodsList() != null && rsAllocationDomain.getRsStoreGoodsList().size() > 0) {
            for (RsStoreGoodsDomain rsStoreGoodsDomain : rsAllocationDomain.getRsStoreGoodsList()) {
                rsStoreGoodsDomain.setRsAllocationCode(rsAllocation.getRsAllocationCode());
                this.rsStoreGoodsService.saveStoreGoods(rsStoreGoodsDomain);
            }
            map = new HashMap();
            map.put("tenantCode", rsAllocation.getTenantCode());
            map.put("rsAllocationCode", rsAllocation.getRsAllocationCode());
            map.put("dataState", 1);
            this.rsStoreGoodsService.updateStoreSkuStateByCode(map);
        }
        map = new HashMap<String, Object>();
        Map querymap = this.getQueryMapParam("tenantCode,contractBillcode", new Object[]{rsAllocationDomain.getTenantCode(), rsAllocationDomain.getContractBillcode()});
        map.put("map", JsonUtil.buildNormalBinder().toJson((Object)querymap));
        String strContract = this.internalInvoke("oc.contract.getContractByCode", map);
        if (StringUtils.isBlank((String)strContract)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.saveAllocation.checkAllocation", "\u672a\u67e5\u8be2\u5230\u4ea4\u6613\u4fe1\u606f:" + rsAllocationDomain.getContractBillcode());
        }
        OcContract ocContract = (OcContract)JsonUtil.buildNormalBinder().getJsonToObject(strContract, OcContract.class);
        this.internalInvoke("oc.contract.updateContractState", this.getQueryMapParam("contractId,dataState,oldDataState", new Object[]{ocContract.getContractId(), 10, ocContract.getDataState()}));
        return rsAllocation.getRsAllocationCode();
    }

    @Override
    public void updateAllocationState(Integer rsAllocationId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAllocationModel(rsAllocationId, dataState, oldDataState);
    }

    @Override
    public void updateAllocation(RsAllocationDomain rsAllocationDomain) throws ApiException {
        String msg = this.checkAllocation(rsAllocationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.updateAllocation.checkAllocation", msg);
        }
        RsAllocation oldRsAllocation = this.getAllocationModelById(rsAllocationDomain.getRsAllocationId());
        if (oldRsAllocation == null) {
            throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.updateAllocation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsAllocation rsAllocation = this.makeAllocation(rsAllocationDomain, oldRsAllocation);
        this.setAllocationUpdataDefault(rsAllocation);
        this.updateAllocationModel(rsAllocation);
    }

    @Override
    public RsAllocation getAllocation(Integer rsAllocationId) {
        return this.getAllocationModelById(rsAllocationId);
    }

    @Override
    public void deleteAllocation(Integer rsAllocationId) throws ApiException {
        this.deleteAllocationModel(rsAllocationId);
    }

    @Override
    public QueryResult<RsAllocation> queryAllocationPage(Map<String, Object> map) {
        List<RsAllocation> rsAllocationList = this.queryAllocationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAllocation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsAllocationList);
        return queryResult;
    }

    @Override
    public RsAllocation getAllocationByCode(Map<String, Object> map) {
        return this.getAllocationModelByCode(map);
    }

    @Override
    public void delAllocationByCode(Map<String, Object> map) throws ApiException {
        this.delAllocationModelByCode(map);
    }

    @Override
    public QueryResult<RsAllocation> queryAllocationAndStore(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<RsAllocation> list = this.queryAllocationAndStoreList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryAllocationAndStoreListCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private List<RsAllocation> queryAllocationAndStoreList(Map<String, Object> parammap) {
        try {
            return this.rsAllocationMapper.queryAllocationAndStore(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.queryAllocationModel", (Throwable)e);
            return null;
        }
    }

    private int queryAllocationAndStoreListCount(Map<String, Object> parammap) {
        int i = 0;
        try {
            i = this.rsAllocationMapper.queryAllocationAndStoreCount(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsAllocationServiceImpl.countAllocation", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateStoreSkuState(String tenantCode, String rsAllocationCode, String memberCode, String channelCode, Integer dateState) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)rsAllocationCode) || dateState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsAllocationCode", rsAllocationCode);
        map.put("dataState", dateState);
        if (StringUtils.isNotBlank((String)memberCode)) {
            map.put("memberBcode", memberCode);
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            map.put("channelCode", channelCode);
        }
        this.rsStoreGoodsService.updateStoreSkuStateByCode(map);
        RsAllocation rsallocation = this.getAllocationByCode(this.getQueryMapParam("tenantCode,rsAllocationCode", new Object[]{tenantCode, rsAllocationCode}));
        if (rsallocation.getDataState() == 0) {
            Integer alloDataState = 1;
            if (dateState != 2) {
                if (dateState == 9) {
                    alloDataState = 9;
                    map.clear();
                    Map querymap = this.getQueryMapParam("tenantCode,contractBillcode", new Object[]{rsallocation.getTenantCode(), rsallocation.getContractBillcode()});
                    map.put("map", JsonUtil.buildNormalBinder().toJson((Object)querymap));
                    String strContract = this.internalInvoke("oc.contract.getContractByCode", map);
                    if (StringUtils.isBlank((String)strContract)) {
                        throw new ApiException("rs.RESOURCE_GOODS.RsAllocationServiceImpl.saveAllocation.checkAllocation", "\u672a\u67e5\u8be2\u5230\u4ea4\u6613\u4fe1\u606f:" + rsallocation.getContractBillcode());
                    }
                    OcContract ocContract = (OcContract)JsonUtil.buildNormalBinder().getJsonToObject(strContract, OcContract.class);
                    this.internalInvoke("oc.contract.updateContractState", this.getQueryMapParam("contractId,dataState,oldDataState", new Object[]{ocContract.getContractId(), 9, 10}));
                } else {
                    return;
                }
            }
            this.updateAllocationState(rsallocation.getRsAllocationId(), alloDataState, 0);
        }
    }
}

