/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.domain.SkuStockDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.util.CollectionUtils;

public class RsSkuServiceImpl
extends BaseServiceImpl
implements RsSkuService {
    public static final String SYS_CODE = "rs.RESOURCE_GOODS.RsSkuServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsPropertiesValueService rsPropertiesValueService;
    private RsSpecValueService rsSpecValueService;

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public void setRsPropertiesValueService(RsPropertiesValueService rsPropertiesValueService) {
        this.rsPropertiesValueService = rsPropertiesValueService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = String.valueOf(msg) + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSpuCode())) {
            msg = String.valueOf(msg) + "spu\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = String.valueOf(msg) + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = String.valueOf(msg) + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (rsSkuDomain.getGoodsNum() == null) {
            msg = String.valueOf(msg) + "\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a;";
        }
        if (rsSkuDomain.getPricesetNprice() == null) {
            msg = String.valueOf(msg) + "\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuDefault(RsSku rsSku) {
        if (rsSku == null) {
            return;
        }
        if (rsSku.getDataState() == null) {
            rsSku.setDataState(0);
        }
        if (rsSku.getGmtCreate() == null) {
            rsSku.setGmtCreate(this.getSysDate());
        }
        rsSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            rsSku.setSkuCode(this.createUUIDString());
        }
    }

    private int getSkuMaxCode() {
        int code = 0;
        try {
            return this.rsSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuUpdataDefault(RsSku rsSku) {
        if (rsSku == null) {
            return;
        }
        rsSku.setGmtModified(this.getSysDate());
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (rsSku == null) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private RsSku getSkuModelById(Integer skuId) {
        if (skuId == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSkuModelById", (Throwable)e);
            return null;
        }
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSkuModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.delSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.delSkuModelByCode.num");
        }
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (skuId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.deleteSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.deleteSkuModel.num");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (rsSku == null) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateSkuModelWithNull(RsSku rsSku) throws ApiException {
        if (rsSku == null) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKey(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (skuId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateSkuModel.null");
        }
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (rsSkuDomain == null) {
            return null;
        }
        if (rsSku == null) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.makeSku", (Throwable)e);
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSku(RsSkuDomain rsSkuDomain) throws ApiException {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        this.setSkuDefault(rsSku);
        this.saveSkuModel(rsSku);
        this.savePropertiesList(rsSkuDomain.getPropertiesList(), rsSku.getSkuCode(), rsSku.getGoodsCode());
        return rsSku.getSkuCode();
    }

    @Override
    public void saveSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.saveSkuList.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.saveSku(rsSkuDomain);
        }
    }

    private void savePropertiesList(List<RsPropertiesValueDomain> valueList, String skuCode, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsPropertiesValueDomain rsPropertiesValueDomain : valueList) {
            rsPropertiesValueDomain.setSkuCode(skuCode);
            rsPropertiesValueDomain.setGoodsCode(goodsCode);
        }
        this.rsPropertiesValueService.savePropertiesValueList(valueList);
    }

    private void saveSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : valueList) {
            rsSpecValueDomain.setSpecValueBillno(goodsCode);
        }
        this.rsSpecValueService.saveSpecValueList(valueList);
    }

    @Override
    public void updateSkuState(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSkuModel(skuId, dataState, oldDataState);
    }

    @Override
    public void updateSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (oldRsSku == null) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        this.updateSkuModel(rsSku);
        this.deltaUpdatePropertiesList(rsSkuDomain.getPropertiesList(), rsSku.getSkuCode(), rsSku.getGoodsCode());
        this.deltaUpdateSpecList(rsSkuDomain.getSpecList(), rsSku.getGoodsCode());
    }

    private void deltaUpdateSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (CollectionUtils.isEmpty(valueList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsSpecValueDomain> i = valueList.iterator();
        while (i.hasNext()) {
            RsSpecValueDomain valueDomain = i.next();
            valueDomain.setSpecValueBillno(goodsCode);
            params.put("tenantCode", valueDomain.getTenantCode());
            params.put("specValueCode", valueDomain.getSpecValueCode());
            RsSpecValue exist = this.rsSpecValueService.getSpecValueByCode(params);
            if (exist == null) continue;
            this.rsSpecValueService.updateSpecValue(valueDomain);
            i.remove();
        }
        this.saveSpecList(valueList, goodsCode);
    }

    private void deltaUpdatePropertiesList(List<RsPropertiesValueDomain> propertiesValueDomains, String skuCode, String goodsCode) {
        if (CollectionUtils.isEmpty(propertiesValueDomains)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsPropertiesValueDomain> i = propertiesValueDomains.iterator();
        while (i.hasNext()) {
            RsPropertiesValueDomain valueDomain = i.next();
            params.put("propertiesCode", valueDomain.getPropertiesCode());
            params.put("skuCode", skuCode);
            QueryResult<RsPropertiesValue> rsPropertiesValue = this.rsPropertiesValueService.queryPropertiesValuePage(params);
            valueDomain.setSkuCode(skuCode);
            if (rsPropertiesValue == null || CollectionUtils.isEmpty((Collection)rsPropertiesValue.getList())) continue;
            valueDomain.setPropertiesValueId(((RsPropertiesValue)rsPropertiesValue.getList().get(0)).getPropertiesValueId());
            valueDomain.setPropertiesValueCode(((RsPropertiesValue)rsPropertiesValue.getList().get(0)).getPropertiesValueCode());
            this.rsPropertiesValueService.updatePropertiesValue(valueDomain);
            i.remove();
        }
        this.savePropertiesList(propertiesValueDomains, skuCode, goodsCode);
    }

    @Override
    public RsSku getSku(Integer skuId) {
        return this.getSkuModelById(skuId);
    }

    @Override
    public void deleteSku(Integer skuId) throws ApiException {
        RsSku sku = this.getSku(skuId);
        if (sku != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsCode", sku.getGoodsCode());
            map.put("tenantCode", sku.getTenantCode());
        }
        this.deleteSkuModel(skuId);
    }

    @Override
    public QueryResult<RsSku> querySkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public RsSku getSkuByCode(Map<String, Object> map) {
        return this.getSkuModelByCode(map);
    }

    @Override
    public void delSkuByCode(Map<String, Object> map) throws ApiException {
        this.delSkuModelByCode(map);
    }

    private void updateStateSkuModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    private void updateStateResourceGoodsModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateResourceStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    @Override
    public void updateSkuStock(List<SkuStockDomain> skuList) throws ApiException {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (SkuStockDomain skuStockDomain : skuList) {
            if (StringUtils.isBlank((String)skuStockDomain.getSkuCode())) continue;
            BigDecimal goodsWeight = skuStockDomain.getGoodsWeight();
            if (goodsWeight == null) {
                skuStockDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)skuStockDomain), String.class, Object.class);
            this.updateStateSkuModel(map);
            String skuCode = skuStockDomain.getSkuCode();
            String tenantCode = skuStockDomain.getTenantCode();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("skuCode", skuCode);
            param.put("tenantCode", tenantCode);
            RsSku rsSku = this.getSkuModelByCode(param);
            if (rsSku == null) continue;
            String goodsCode = rsSku.getGoodsCode();
            map.put("goodsCode", goodsCode);
            this.updateStateResourceGoodsModel(map);
        }
    }

    @Override
    public void deleteSkuList(List<Integer> skuIds) throws ApiException {
        if (skuIds == null || skuIds.isEmpty()) {
            return;
        }
        for (Integer skuId : skuIds) {
            RsSku sku = this.getSku(skuId);
            if (sku != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("goodsCode", sku.getGoodsCode());
                map.put("tenantCode", sku.getTenantCode());
            }
            this.deleteSku(skuId);
        }
    }

    @Override
    public void updateAhSkuList(List<RsSkuDomain> goodsList) {
        if (goodsList == null || goodsList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : goodsList) {
            this.updateAhSku(rsSkuDomain);
        }
    }

    public void updateAhSku(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateAhSku.checkSku", msg);
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (oldRsSku == null) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateAhSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        rsSku.setSortNo(null);
        this.updateSkuModelWithNull(rsSku);
    }

    @Override
    public void updateCannelSkuList(List<Integer> skuIds) throws ApiException {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsSupplynum));
            if (goodsSupplyweight != null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsSupplyweight));
            }
            rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().subtract(goodsSupplynum));
            if (goodsSupplyweight != null) {
                rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().subtract(goodsSupplyweight));
            }
            rsSku.setGoodsSupplynum(BigDecimal.ZERO);
            rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
            this.updateSkuModel(rsSku);
        }
    }

    @Override
    public void updateAuditSkuPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsSupplynum(rsSku.getGoodsSupplynum().add(goodsAhnum));
            rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().add(goodsAhnum));
            if (goodsAhweight != null) {
                rsSku.setGoodsSupplyweight(rsSku.getGoodsSupplyweight().add(goodsAhweight));
                rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
            rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
            rsSku.setSkuHdate(this.getSysDate());
            this.updateSkuModel(rsSku);
        }
    }

    @Override
    public void updateAuditSkuNoPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsAhnum));
            if (goodsAhweight == null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
            this.updateSkuModel(rsSku);
        }
    }

    private List<RsSku> checkAuditSku(List<Integer> skuIds) {
        if (skuIds == null || skuIds.isEmpty()) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.getSkuModelById(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsWeight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            skuList.add(rsSku);
        }
        return skuList;
    }

    private List<RsSku> checkAuditSku(String goodsCode, String tenantCode) {
        if (goodsCode == null || goodsCode.isEmpty()) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 1);
        List<RsSku> skuList = this.rsSkuMapper.query(map);
        if (ListUtil.isEmpty(skuList)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        for (RsSku rsSku : skuList) {
            if (rsSku == null) {
                throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsWeight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
        }
        return skuList;
    }

    @Override
    public void querySkuAll(Map<String, Object> map) {
        if (map != null) {
            map.put("saleChannel", "1");
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(this.queryforEs(map)));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<EsSku> queryforEs(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.queryForEs(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.queryforEs.error", e.getMessage());
        }
    }

    @Override
    public void updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("goodsCode", goodsCode);
        parammap.put("dataState", 0);
        List<RsSku> skuList = this.querySkuModelPage(parammap);
        if (skuList != null && !skuList.isEmpty()) {
            List skuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(skuList), RsSkuDomain.class);
            for (RsSkuDomain rsSkuDomain : skuDomainList) {
                BigDecimal goodsHangnum = rsSkuDomain.getGoodsHangnum();
                BigDecimal goodsHangweight = rsSkuDomain.getGoodsHangweight();
                BigDecimal goodsNum = rsSkuDomain.getGoodsNum();
                BigDecimal goodsWeight = rsSkuDomain.getGoodsWeight();
                goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
                goodsHangnum = goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum;
                goodsHangweight = goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight;
                rsSkuDomain.setGoodsAhnum(goodsNum);
                rsSkuDomain.setGoodsAhweight(goodsWeight);
                rsSkuDomain.setGoodsNum(goodsNum.subtract(goodsNum));
                rsSkuDomain.setGoodsWeight(goodsWeight.subtract(goodsWeight));
                this.updateAhSku(rsSkuDomain);
            }
        }
    }

    @Override
    public void updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsSupplynum(rsSku.getGoodsSupplynum().add(goodsAhnum));
            rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().add(goodsAhnum));
            if (goodsAhweight != null) {
                rsSku.setGoodsSupplyweight(rsSku.getGoodsSupplyweight().add(goodsAhweight));
                rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
            rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
            rsSku.setSkuHdate(this.getSysDate());
            this.updateSkuModel(rsSku);
        }
    }

    @Override
    public void updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSkuByGoodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsSkuMapper.updateByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSkuByGoodsCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String goodsCode, String tenantCode) {
        if (goodsNum == null || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", "param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsNum", goodsNum);
        map.put("skuCode", goodsCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuGoodsNumByGoodsCode(map);
    }

    private void updateSkuGoodsNumByGoodsCode(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuGoodsNumByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateStateResourceGoodsModel.null");
        }
    }

    private List<RsSku> queryDisSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countDisSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countDisSku(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<RsSku> queryDisSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryDisSku(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDisSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> queryDisAndSkuPage(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisAndSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.queryDisAndSku(map));
        return queryResult;
    }

    private List<RsSku> queryDisAndSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisAndSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int queryDisAndSkuCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.queryDisAndSkuCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.updateSku(rsSkuDomain);
        }
    }

    @Override
    public List<RsSku> querySkuByPntreeCode(Map<String, Object> map) {
        try {
            return this.rsSkuMapper.querySkuByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSkuServiceImpl.querySkuByPntreeCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        this.updateSortNoSkuModel(tenantCode, goodsCode, skuCode, sortNo);
    }

    private void updateSortNoSkuModel(String tenantCode, String goodsCode, String skuCode, Integer sortNo) throws ApiException {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode) && StringUtil.isBlank((String)skuCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        map.put("skuCode", skuCode);
        map.put("gmtModified", this.getSysDate());
        map.put("sortNo", sortNo);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSortNoSku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSortNoSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSkuServiceImpl.updateSortNoSkuModel.null");
        }
    }
}

