/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSpuMapper;
import com.yqbsoft.laser.service.resources.domain.RsSpecDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpuDomain;
import com.yqbsoft.laser.service.resources.model.RsSpu;
import com.yqbsoft.laser.service.resources.service.RsSpecRelationService;
import com.yqbsoft.laser.service.resources.service.RsSpuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSpuServiceImpl
extends BaseServiceImpl
implements RsSpuService {
    public static final String SYS_CODE = "rs.RESOURCE_GOODS.RsSpuServiceImpl";
    private RsSpuMapper rsSpuMapper;
    private RsSpecRelationService rsSpecRelationService;

    public void setRsSpecRelationService(RsSpecRelationService rsSpecRelationService) {
        this.rsSpecRelationService = rsSpecRelationService;
    }

    public void setRsSpuMapper(RsSpuMapper rsSpuMapper) {
        this.rsSpuMapper = rsSpuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSpuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSpu(RsSpuDomain rsSpuDomain) {
        if (rsSpuDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setSpuDefault(RsSpu rsSpu) {
        if (rsSpu == null) {
            return;
        }
        if (rsSpu.getDataState() == null) {
            rsSpu.setDataState(0);
        }
        if (rsSpu.getGmtCreate() == null) {
            rsSpu.setGmtCreate(this.getSysDate());
        }
        rsSpu.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSpu.getSpuCode())) {
            rsSpu.setSpuCode(this.createUUIDString());
        }
    }

    private int getSpuMaxCode() {
        int code = 0;
        try {
            return this.rsSpuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.getSpuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSpuUpdataDefault(RsSpu rsSpu) {
        if (rsSpu == null) {
            return;
        }
        rsSpu.setGmtModified(this.getSysDate());
    }

    private void saveSpuModel(RsSpu rsSpu) throws ApiException {
        if (rsSpu == null) {
            return;
        }
        try {
            this.rsSpuMapper.insert(rsSpu);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.saveSpuModel.ex", (Throwable)e);
        }
    }

    private RsSpu getSpuModelById(Integer spuId) {
        if (spuId == null) {
            return null;
        }
        try {
            return this.rsSpuMapper.selectByPrimaryKey(spuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.getSpuModelById", (Throwable)e);
            return null;
        }
    }

    public RsSpu getSpuModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSpuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.getSpuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSpuModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.delSpuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.delSpuModelByCode.num");
        }
    }

    private void deleteSpuModel(Integer spuId) throws ApiException {
        if (spuId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpuMapper.deleteByPrimaryKey(spuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.deleteSpuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.deleteSpuModel.num");
        }
    }

    private void updateSpuModel(RsSpu rsSpu) throws ApiException {
        if (rsSpu == null) {
            return;
        }
        try {
            this.rsSpuMapper.updateByPrimaryKeySelective(rsSpu);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.updateSpuModel.ex", (Throwable)e);
        }
    }

    private void updateStateSpuModel(Integer spuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (spuId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spuId", spuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSpuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.updateStateSpuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.updateStateSpuModel.null");
        }
    }

    private RsSpu makeSpu(RsSpuDomain rsSpuDomain, RsSpu rsSpu) {
        if (rsSpuDomain == null) {
            return null;
        }
        if (rsSpu == null) {
            rsSpu = new RsSpu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpu, (Object)rsSpuDomain);
            return rsSpu;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.makeSpu", (Throwable)e);
            return null;
        }
    }

    private List<RsSpu> querySpuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSpuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.querySpuModel", (Throwable)e);
            return null;
        }
    }

    private int countSpu(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSpuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.countSpu", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveSpu(RsSpuDomain rsSpuDomain) throws ApiException {
        String msg = this.checkSpu(rsSpuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.saveSpu.checkSpu", msg);
        }
        RsSpu rsSpu = this.makeSpu(rsSpuDomain, null);
        this.setSpuDefault(rsSpu);
        this.saveSpuModel(rsSpu);
    }

    @Override
    public void updateSpuState(Integer spuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSpuModel(spuId, dataState, oldDataState);
    }

    @Override
    public void updateSpu(RsSpuDomain rsSpuDomain) throws ApiException {
        String msg = this.checkSpu(rsSpuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.updateSpu.checkSpu", msg);
        }
        RsSpu oldRsSpu = this.getSpuModelById(rsSpuDomain.getSpuId());
        if (oldRsSpu == null) {
            throw new ApiException("rs.RESOURCE_GOODS.RsSpuServiceImpl.updateSpu.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSpu rsSpu = this.makeSpu(rsSpuDomain, oldRsSpu);
        this.setSpuUpdataDefault(rsSpu);
        this.updateSpuModel(rsSpu);
    }

    @Override
    public RsSpu getSpu(Integer spuId) {
        return this.getSpuModelById(spuId);
    }

    @Override
    public void deleteSpu(Integer spuId) throws ApiException {
        this.deleteSpuModel(spuId);
    }

    @Override
    public QueryResult<RsSpu> querySpuPage(Map<String, Object> map) {
        List<RsSpu> rsSpuList = this.querySpuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSpu(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSpuList);
        return queryResult;
    }

    @Override
    public RsSpu getSpuByCode(Map<String, Object> map) {
        return this.getSpuModelByCode(map);
    }

    @Override
    public void delSpuByCode(Map<String, Object> map) throws ApiException {
        this.delSpuModelByCode(map);
    }

    @Override
    public RsSpuDomain getSpuContainChild(Map<String, Object> map) {
        RsSpuDomain rsSpuDomain = this.getRsSpuByPntreeAndBrand(map);
        if (rsSpuDomain == null) {
            return null;
        }
        map.put("spuCode", rsSpuDomain.getSpuCode());
        List<RsSpecDomain> specList = this.rsSpecRelationService.querySpecRelation(map);
        rsSpuDomain.setSpecList(specList);
        return rsSpuDomain;
    }

    private RsSpuDomain getRsSpuByPntreeAndBrand(Map<String, Object> map) {
        RsSpu rsSpu;
        RsSpuDomain rsSpuDomain;
        block3: {
            rsSpuDomain = null;
            rsSpu = this.getSpuModelByCode(map);
            if (rsSpu != null) break block3;
            return null;
        }
        try {
            rsSpuDomain = new RsSpuDomain();
            BeanUtils.copyAllPropertys((Object)rsSpuDomain, (Object)rsSpu);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsSpuServiceImpl.getRsSpuByPntreeAndBrand", (Object)e.getMessage());
        }
        return rsSpuDomain;
    }
}

