/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGinfoMapper;
import com.yqbsoft.laser.service.resources.domain.RsResourceGinfoDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGinfolistDomain;
import com.yqbsoft.laser.service.resources.model.RsResourceGinfo;
import com.yqbsoft.laser.service.resources.model.RsResourceGinfolist;
import com.yqbsoft.laser.service.resources.service.RsResourceGinfoService;
import com.yqbsoft.laser.service.resources.service.RsResourceGinfolistService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceGinfoServiceImpl
extends BaseServiceImpl
implements RsResourceGinfoService {
    public static final String SYS_CODE = "rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl";
    private RsResourceGinfoMapper rsResourceGinfoMapper;
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceGinfolistService rsResourceGinfolistService;

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public void setRsResourceGinfoMapper(RsResourceGinfoMapper rsResourceGinfoMapper) {
        this.rsResourceGinfoMapper = rsResourceGinfoMapper;
    }

    public void setRsResourceGinfolistService(RsResourceGinfolistService rsResourceGinfolistService) {
        this.rsResourceGinfolistService = rsResourceGinfolistService;
    }

    private Date getSysDate() {
        try {
            return this.rsResourceGinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) {
        if (null == rsResourceGinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setResourceGinfoDefault(RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfo) {
            return;
        }
        if (null == rsResourceGinfo.getDataState()) {
            rsResourceGinfo.setDataState(0);
        }
        if (null == rsResourceGinfo.getGmtCreate()) {
            rsResourceGinfo.setGmtCreate(this.getSysDate());
        }
        rsResourceGinfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsResourceGinfo.getGinfoCode())) {
            rsResourceGinfo.setGinfoCode(this.createUUIDString());
        }
    }

    private int getResourceGinfoMaxCode() {
        int code = 0;
        try {
            return this.rsResourceGinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setResourceGinfoUpdataDefault(RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfo) {
            return;
        }
        rsResourceGinfo.setGmtModified(this.getSysDate());
    }

    private void saveResourceGinfoModel(RsResourceGinfo rsResourceGinfo) throws ApiException {
        if (null == rsResourceGinfo) {
            return;
        }
        try {
            this.rsResourceGinfoMapper.insert(rsResourceGinfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.saveResourceGinfoModel.ex", (Throwable)e);
        }
    }

    private RsResourceGinfo getResourceGinfoModelById(Integer ginfoId) {
        if (null == ginfoId) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.selectByPrimaryKey(ginfoId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoModelById", (Throwable)e);
            return null;
        }
    }

    public RsResourceGinfo getResourceGinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delResourceGinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.delResourceGinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.delResourceGinfoModelByCode.num");
        }
    }

    private void deleteResourceGinfoModel(Integer ginfoId) throws ApiException {
        if (null == ginfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.deleteByPrimaryKey(ginfoId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.deleteResourceGinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.deleteResourceGinfoModel.num");
        }
    }

    private void updateResourceGinfoModel(RsResourceGinfo rsResourceGinfo) throws ApiException {
        if (null == rsResourceGinfo) {
            return;
        }
        try {
            this.rsResourceGinfoMapper.updateByPrimaryKeySelective(rsResourceGinfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateResourceGinfoModel(Integer ginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ginfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ginfoId", ginfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateStateResourceGinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateStateResourceGinfoModel.null");
        }
    }

    private RsResourceGinfo makeResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain, RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfoDomain) {
            return null;
        }
        if (null == rsResourceGinfo) {
            rsResourceGinfo = new RsResourceGinfo();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsResourceGinfo, (Object)rsResourceGinfoDomain);
            return rsResourceGinfo;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.makeResourceGinfo", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGinfo> queryResourceGinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countResourceGinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) throws ApiException {
        String msg = this.checkResourceGinfo(rsResourceGinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.saveResourceGinfo.checkResourceGinfo", msg);
        }
        RsResourceGinfo rsResourceGinfo = this.makeResourceGinfo(rsResourceGinfoDomain, null);
        this.setResourceGinfoDefault(rsResourceGinfo);
        this.saveResourceGinfoModel(rsResourceGinfo);
        if (ListUtil.isNotEmpty(rsResourceGinfoDomain.getGoodsList())) {
            this.rsResourceGoodsService.saveResourceGoodsBatch(rsResourceGinfoDomain.getGoodsList());
        }
        return rsResourceGinfo.getGinfoCode();
    }

    @Override
    public void updateResourceGinfoState(Integer ginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateResourceGinfoModel(ginfoId, dataState, oldDataState);
    }

    @Override
    public void updateResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) throws ApiException {
        String msg = this.checkResourceGinfo(rsResourceGinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfo.checkResourceGinfo", msg);
        }
        RsResourceGinfo oldRsResourceGinfo = this.getResourceGinfoModelById(rsResourceGinfoDomain.getGinfoId());
        if (null == oldRsResourceGinfo) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsResourceGinfo rsResourceGinfo = this.makeResourceGinfo(rsResourceGinfoDomain, oldRsResourceGinfo);
        this.setResourceGinfoUpdataDefault(rsResourceGinfo);
        this.updateResourceGinfoModel(rsResourceGinfo);
    }

    @Override
    public RsResourceGinfo getResourceGinfo(Integer ginfoId) {
        return this.getResourceGinfoModelById(ginfoId);
    }

    @Override
    public void deleteResourceGinfo(Integer ginfoId) throws ApiException {
        this.deleteResourceGinfoModel(ginfoId);
    }

    @Override
    public QueryResult<RsResourceGinfo> queryResourceGinfoPage(Map<String, Object> map) {
        List<RsResourceGinfo> rsResourceGinfoList = this.queryResourceGinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceGinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGinfoList);
        return queryResult;
    }

    @Override
    public RsResourceGinfo getResourceGinfoByCode(Map<String, Object> map) {
        return this.getResourceGinfoModelByCode(map);
    }

    @Override
    public void delResourceGinfoByCode(Map<String, Object> map) throws ApiException {
        this.delResourceGinfoModelByCode(map);
    }

    @Override
    public QueryResult<RsResourceGinfo> queryResourceGinfoByDateStatePage(Map<String, Object> map) {
        List<RsResourceGinfo> rsResourceGinfoList = this.queryResourceGinfoByDateStateList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countByDataState(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGinfoList);
        return queryResult;
    }

    private List<RsResourceGinfo> queryResourceGinfoByDateStateList(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.queryByDataState(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoByDateStateList.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> getResourceGinfoCountByDateState(Map<String, Object> map) {
        return this.countGroupByDataState(map);
    }

    private List<Map<String, Object>> countGroupByDataState(Map<String, Object> map) {
        try {
            return this.rsResourceGinfoMapper.countGroupByDataState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
            return null;
        }
    }

    private int countByDataState(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.countByDataState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateGinfoAnum(String ginfoCode, String tenantCode) {
        if (ginfoCode == null || tenantCode == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ginfoCode", ginfoCode);
        map.put("tenantCode", tenantCode);
        this.updateGinfoAnumByCode(map);
    }

    private int updateGinfoAnumByCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateGinfoAnum(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateGinfoAnumByID", (Throwable)e);
        }
        return i;
    }

    private int updateGinfoAnumByCodeByGinfoMnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateGinfoAnumByMnum(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateGinfoAnumByID", (Throwable)e);
        }
        return i;
    }

    private int updateGinfoAnumSubByCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateGinfoAnumSub(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateGinfoAnumByID", (Throwable)e);
        }
        return i;
    }

    @Override
    public void validateGinfoDate() {
        List<RsResourceGinfo> ginfoList1;
        Date vaildEdate;
        List<RsResourceGinfo> ginfoList = this.queryResourceGinfoModelPage(this.getQueryMapParam("dataState", new Object[]{1}));
        if (!ListUtil.isEmpty(ginfoList)) {
            for (RsResourceGinfo rsResourceGinfo : ginfoList) {
                Date nowDate = this.getSysDate();
                Date vaildSdate = rsResourceGinfo.getGinfoSdate();
                vaildEdate = rsResourceGinfo.getGinfoEdate();
                if (vaildSdate.getTime() > nowDate.getTime() || nowDate.getTime() > vaildEdate.getTime()) continue;
                this.updateStateResourceGinfoModel(rsResourceGinfo.getGinfoId(), ResourcesConstants.GINFO_DATA_STATE_2, rsResourceGinfo.getDataState());
            }
        }
        if (ListUtil.isEmpty(ginfoList1 = this.queryResourceGinfoModelPage(this.getQueryMapParam("dataState", new Object[]{2})))) {
            return;
        }
        for (RsResourceGinfo rsResourceGinfo : ginfoList1) {
            Date nowDate = this.getSysDate();
            vaildEdate = rsResourceGinfo.getGinfoEdate();
            if (nowDate.getTime() < vaildEdate.getTime()) continue;
            if ("5".equals(rsResourceGinfo.getGinfoType())) {
                QueryResult<RsResourceGinfolist> result = this.rsResourceGinfolistService.queryResourceGinfolistPage(this.getQueryMapParam("ginfoCode,tenantCode,ginfolistState", new Object[]{rsResourceGinfo.getGinfoCode(), rsResourceGinfo.getTenantCode(), "1"}));
                if (result != null && !ListUtil.isEmpty((Collection)result.getList()) && result.getList().size() >= rsResourceGinfo.getGinfoMnum()) continue;
                this.updateStateResourceGinfoModel(rsResourceGinfo.getGinfoId(), ResourcesConstants.GINFO_DATA_STATE_4, rsResourceGinfo.getDataState());
                if (!ListUtil.isNotEmpty((Collection)result.getList())) continue;
                for (RsResourceGinfolist ginfoLister : result.getList()) {
                    RsResourceGinfolistDomain resourceGinfolistDomain = new RsResourceGinfolistDomain();
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)resourceGinfolistDomain, (Object)ginfoLister);
                        resourceGinfolistDomain.setGinfolistState("0");
                        this.rsResourceGinfolistService.updateResourceGinfolist(resourceGinfolistDomain);
                    }
                    catch (Exception e) {
                        this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.validateGinfoDate", (Throwable)e);
                    }
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("contractNbillcode", rsResourceGinfo.getGinfoCode());
                param.put("tenantCode", rsResourceGinfo.getTenantCode());
                param.put("type", "fail");
                this.internalInvoke("oc.contract.updateContractStateForGroupbuy", param);
                continue;
            }
            this.updateStateResourceGinfoModel(rsResourceGinfo.getGinfoId(), ResourcesConstants.GINFO_DATA_STATE_4, rsResourceGinfo.getDataState());
        }
    }

    @Override
    public List<RsResourceGinfo> queryResourceGinfoAndGoods(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoAndGoods", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.queryResourceGinfoAndGoods(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoAndGoods", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateGinfolistAndGinfoAnum(RsResourceGinfolistDomain ginfolist) {
        if (ginfolist == null || StringUtils.isEmpty((String)ginfolist.getGinfoCode()) || StringUtils.isEmpty((String)ginfolist.getTenantCode()) || StringUtils.isEmpty((String)ginfolist.getGinfolistState()) || StringUtils.isEmpty((String)ginfolist.getMemberCode())) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", "\u53c2\u6570\u4e3a\u7a7a!");
        }
        try {
            QueryResult<RsResourceGinfolist> res;
            RsResourceGinfo ginfo = this.getResourceGinfoModelByCode(this.getQueryMapParam("ginfoCode,tenantCode", new Object[]{ginfolist.getGinfoCode(), ginfolist.getTenantCode()}));
            if (ginfo == null) {
                throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", "ginfo\u4e3a\u7a7a!");
            }
            if ("1".equals(ginfolist.getGinfolistState()) && ginfolist.getGoodsNum() != null) {
                for (int i = 0; i < ginfolist.getGoodsNum().intValue(); ++i) {
                    if (ginfo.getGinfoMnum() != 0 && ginfo.getGinfoMnum() < ginfo.getGinfoAnum() + 1) {
                        throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", "\u4eba\u6570\u5df2\u6ee1!");
                    }
                    RsResourceGinfolistDomain newginfolist = new RsResourceGinfolistDomain();
                    BeanUtils.copyAllPropertys((Object)newginfolist, (Object)ginfolist);
                    this.rsResourceGinfolistService.saveResourceGinfolist(newginfolist);
                    if (ginfo.getGinfoMnum() == 0) {
                        this.updateGinfoAnum(ginfolist.getGinfoCode(), ginfolist.getTenantCode());
                        continue;
                    }
                    this.updateGinfoAnumByCodeByGinfoMnum(this.getQueryMapParam("ginfoCode,tenantCode", new Object[]{ginfolist.getGinfoCode(), ginfolist.getTenantCode()}));
                    this.checkGinfoIsSuccess(ginfo);
                }
            }
            if ("0".equals(ginfolist.getGinfolistState()) && (res = this.rsResourceGinfolistService.queryResourceGinfolistPage(this.getQueryMapParam("ginfoCode,tenantCode,memberCode", new Object[]{ginfolist.getGinfoCode(), ginfolist.getTenantCode(), ginfolist.getMemberCode()}))) != null && !ListUtil.isNotEmpty((Collection)res.getList())) {
                for (RsResourceGinfolist resourceGinfolist : res.getList()) {
                    BeanUtils.copyAllPropertys((Object)ginfolist, (Object)resourceGinfolist);
                    this.rsResourceGinfolistService.updateResourceGinfolist(ginfolist);
                    this.updateGinfoAnumSubByCode(this.getQueryMapParam("ginfoCode,tenantCode", new Object[]{ginfolist.getGinfoCode(), ginfolist.getTenantCode()}));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", (Throwable)e);
        }
    }

    private void checkGinfoIsSuccess(RsResourceGinfo ginfo) {
        if (ginfo == null) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", "ginfo\u4e3a\u7a7a!");
        }
        if (!ResourcesConstants.GINFO_DATA_STATE_2.equals(ginfo.getDataState())) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImplsaveResourceGinfolistAndUpdateGinfoAnum", "\u56e2\u8d2d\u5df2\u7ed3\u675f!");
        }
        QueryResult<RsResourceGinfolist> result = this.rsResourceGinfolistService.queryResourceGinfolistPage(this.getQueryMapParam("ginfoCode,tenantCode", new Object[]{ginfo.getGinfoCode(), ginfo.getTenantCode()}));
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList()) && result.getList().size() == ginfo.getGinfoMnum().intValue()) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("contractNbillcode", ginfo.getGinfoCode());
            param.put("tenantCode", ginfo.getTenantCode());
            param.put("type", "success");
            this.internalInvoke("oc.contract.updateContractStateForGroupbuy", param);
            this.updateStateResourceGinfoModel(ginfo.getGinfoId(), ResourcesConstants.GINFO_DATA_STATE_5, ginfo.getDataState());
        }
    }
}

