/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsStoreGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsStoreSkuMapper;
import com.yqbsoft.laser.service.resources.domain.RsStoreGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsStoreSkuDomain;
import com.yqbsoft.laser.service.resources.model.RsStoreGoods;
import com.yqbsoft.laser.service.resources.model.RsStoreSku;
import com.yqbsoft.laser.service.resources.service.RsStoreGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsStoreGoodsServiceImpl
extends BaseServiceImpl
implements RsStoreGoodsService {
    private static final String SYS_CODE = "rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl";
    private RsStoreGoodsMapper rsStoreGoodsMapper;
    private RsStoreSkuMapper rsStoreSkuMapper;

    public void setRsStoreGoodsMapper(RsStoreGoodsMapper rsStoreGoodsMapper) {
        this.rsStoreGoodsMapper = rsStoreGoodsMapper;
    }

    public void setRsStoreSkuMapper(RsStoreSkuMapper rsStoreSkuMapper) {
        this.rsStoreSkuMapper = rsStoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsStoreGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) {
        if (null == rsStoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreGoodsDefault(RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoods) {
            return;
        }
        if (null == rsStoreGoods.getDataState()) {
            rsStoreGoods.setDataState(0);
        }
        if (null == rsStoreGoods.getGmtCreate()) {
            rsStoreGoods.setGmtCreate(this.getSysDate());
        }
        rsStoreGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsStoreGoods.getStoreGoodsCode())) {
            rsStoreGoods.setStoreGoodsCode(this.createUUIDString());
        }
    }

    private int getStoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsStoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreGoodsUpdataDefault(RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoods) {
            return;
        }
        rsStoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveStoreGoodsModel(RsStoreGoods rsStoreGoods) throws ApiException {
        if (null == rsStoreGoods) {
            return;
        }
        try {
            this.rsStoreGoodsMapper.insert(rsStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.saveStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private RsStoreGoods getStoreGoodsModelById(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        try {
            return this.rsStoreGoodsMapper.selectByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public RsStoreGoods getStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsStoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.delStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.delStoreGoodsModelByCode.num");
        }
    }

    private void deleteStoreGoodsModel(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.deleteByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.deleteStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.deleteStoreGoodsModel.num");
        }
    }

    private void updateStoreGoodsModel(RsStoreGoods rsStoreGoods) throws ApiException {
        if (null == rsStoreGoods) {
            return;
        }
        try {
            this.rsStoreGoodsMapper.updateByPrimaryKeySelective(rsStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreGoodsModel(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeGoodsId", storeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.null");
        }
    }

    private RsStoreGoods makeStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain, RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoodsDomain) {
            return null;
        }
        if (null == rsStoreGoods) {
            rsStoreGoods = new RsStoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreGoods, (Object)rsStoreGoodsDomain);
            return rsStoreGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.makeStoreGoods", (Throwable)e);
            return null;
        }
    }

    private List<RsStoreGoods> queryStoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private String checkStoreSku(RsStoreSkuDomain rsStoreSkuDomain) {
        if (null == rsStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreSkuDefault(RsStoreSku rsStoreSku) {
        if (null == rsStoreSku) {
            return;
        }
        if (null == rsStoreSku.getDataState()) {
            rsStoreSku.setDataState(0);
        }
        if (null == rsStoreSku.getGmtCreate()) {
            rsStoreSku.setGmtCreate(this.getSysDate());
        }
        rsStoreSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsStoreSku.getStoreSkuCode())) {
            rsStoreSku.setStoreSkuCode(this.createUUIDString());
        }
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.rsStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(RsStoreSku rsStoreSku) {
        if (null == rsStoreSku) {
            return;
        }
        rsStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(RsStoreSku rsStoreSku) throws ApiException {
        if (null == rsStoreSku) {
            return;
        }
        try {
            this.rsStoreSkuMapper.insert(rsStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private RsStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.rsStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    public RsStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.delStoreSkuModelByCode.num");
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(RsStoreSku rsStoreSku) throws ApiException {
        if (null == rsStoreSku) {
            return;
        }
        try {
            this.rsStoreSkuMapper.updateByPrimaryKeySelective(rsStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreSkuModel.null");
        }
    }

    private RsStoreSku makeStoreSku(RsStoreSkuDomain rsStoreSkuDomain, RsStoreSku rsStoreSku) {
        if (null == rsStoreSkuDomain) {
            return null;
        }
        if (null == rsStoreSku) {
            rsStoreSku = new RsStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreSku, (Object)rsStoreSkuDomain);
            return rsStoreSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private List<RsStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.countStoreSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(rsStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.saveStoreGoods.checkStoreGoods", msg);
        }
        RsStoreGoods rsStoreGoods = this.makeStoreGoods(rsStoreGoodsDomain, null);
        this.setStoreGoodsDefault(rsStoreGoods);
        this.saveStoreGoodsModel(rsStoreGoods);
        if (rsStoreGoodsDomain.getStockSkulist() != null && rsStoreGoodsDomain.getStockSkulist().size() != 0) {
            for (RsStoreSkuDomain rsStoreSkuDomain : rsStoreGoodsDomain.getStockSkulist()) {
                rsStoreSkuDomain.setStoreGoodsCode(rsStoreGoods.getStoreGoodsCode());
                rsStoreSkuDomain.setRsAllocationCode(rsStoreGoods.getRsAllocationCode());
                this.saveStoreSku(rsStoreSkuDomain);
            }
        }
        return rsStoreGoods.getStoreGoodsCode();
    }

    @Override
    public void updateStoreGoodsState(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreGoodsModel(storeGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(rsStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreGoods.checkStoreGoods", msg);
        }
        RsStoreGoods oldRsStoreGoods = this.getStoreGoodsModelById(rsStoreGoodsDomain.getStoreGoodsId());
        if (null == oldRsStoreGoods) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsStoreGoods rsStoreGoods = this.makeStoreGoods(rsStoreGoodsDomain, oldRsStoreGoods);
        this.setStoreGoodsUpdataDefault(rsStoreGoods);
        this.updateStoreGoodsModel(rsStoreGoods);
    }

    @Override
    public RsStoreGoods getStoreGoods(Integer storeGoodsId) {
        return this.getStoreGoodsModelById(storeGoodsId);
    }

    @Override
    public void deleteStoreGoods(Integer storeGoodsId) throws ApiException {
        this.deleteStoreGoodsModel(storeGoodsId);
    }

    @Override
    public QueryResult<RsStoreGoods> queryStoreGoodsPage(Map<String, Object> map) {
        List<RsStoreGoods> rsStoreGoodsList = this.queryStoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsStoreGoodsList);
        return queryResult;
    }

    @Override
    public RsStoreGoods getStoreGoodsByCode(Map<String, Object> map) {
        return this.getStoreGoodsModelByCode(map);
    }

    @Override
    public void delStoreGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delStoreGoodsModelByCode(map);
    }

    @Override
    public String saveStoreSku(RsStoreSkuDomain rsStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(rsStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.saveStoreSku.checkStoreSku", msg);
        }
        RsStoreSku rsStoreSku = this.makeStoreSku(rsStoreSkuDomain, null);
        this.setStoreSkuDefault(rsStoreSku);
        this.saveStoreSkuModel(rsStoreSku);
        return rsStoreSku.getStoreSkuCode();
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState);
    }

    @Override
    public void updateStoreSku(RsStoreSkuDomain rsStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(rsStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreSku.checkStoreSku", msg);
        }
        RsStoreSku oldRsStoreSku = this.getStoreSkuModelById(rsStoreSkuDomain.getStoreSkuId());
        if (null == oldRsStoreSku && null == (oldRsStoreSku = this.getStoreSkuModelByCode(this.getQueryMapParam("storeSkuCode,tenantCode", new Object[]{rsStoreSkuDomain.getStoreSkuCode(), rsStoreSkuDomain.getTenantCode()})))) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsStoreSku rsStoreSku = this.makeStoreSku(rsStoreSkuDomain, oldRsStoreSku);
        this.setStoreSkuUpdataDefault(rsStoreSku);
        this.updateStoreSkuModel(rsStoreSku);
    }

    @Override
    public RsStoreSku getStoreSku(Integer storeSkuId) {
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<RsStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<RsStoreSku> rsStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsStoreSkuList);
        return queryResult;
    }

    @Override
    public RsStoreSku getStoreSkuByCode(Map<String, Object> map) {
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void delStoreSkuByCode(Map<String, Object> map) throws ApiException {
        this.delStoreSkuModelByCode(map);
    }

    @Override
    public void updateStoreSkuStateByCode(Map<String, Object> map) {
        this.updateStateByCode(map);
    }

    private void updateStateByCode(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.null");
        }
    }
}

