/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsFlowDataMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsFlowDataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = ".RsFlowDataServiceImpl";
    private RsFlowDataMapper rsFlowDataMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private RsGoodsOtherService rsGoodsOtherService;
    private static EsEngineService esEngineService;
    private static Object lock;

    public void setRsFlowDataMapper(RsFlowDataMapper rsFlowDataMapper) {
        this.rsFlowDataMapper = rsFlowDataMapper;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    private void saveRsFlowDataModel(RsFlowData rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowData(rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowDataFinishModel(RsFlowDataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowDataFinish(rsFlowDataFinish);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowData> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        try {
            this.rsFlowDataMapper.deleteByCode(fdCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowData> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        for (RsFlowData rsFlowData : rsFlowDataList) {
            rsFlowData.setDataState(1);
            rsFlowData.setGmtCreate(new Date());
            String fdCode1 = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsFlowData.getTenantCode());
            rsFlowData.setFdCode(fdCode1);
        }
        this.insertBatchFlowDataModel(rsFlowDataList);
        this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((RsFlowDataService)SpringApplicationContextUtil.getBean((String)"rsFlowDataService"));
                for (int i = 0; i < 10; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            List<RsFlowData> rsFlowDataList = this.rsFlowDataMapper.query(map);
            if (null != rsFlowDataList && rsFlowDataList.size() > 0) {
                this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
            }
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public boolean processRsToEsAndStatic(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return true;
        }
        if (rsFlowData.getFdBizType() == 1 ? !this.sendGoods(rsFlowData) : (rsFlowData.getFdBizType() == 2 ? !this.sendSku(rsFlowData) : (rsFlowData.getFdBizType() == 3 ? !this.sendClass(rsFlowData) : (rsFlowData.getFdBizType() == 4 ? !this.sendGoodsClass(rsFlowData) : (rsFlowData.getFdBizType() == 5 ? !this.sendDisGoods(rsFlowData) : rsFlowData.getFdBizType() == 6 && !this.sendDisSku(rsFlowData)))))) {
            return false;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowDataFinish rsFlowDataFinish = new RsFlowDataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveRsFlowDataFinishModel(rsFlowDataFinish);
        return true;
    }

    private boolean sendGoodsClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsGoodsClass>> goodsClassMap = new HashMap<String, List<RsGoodsClass>>();
        List<RsGoodsClass> rsGoodsClassList = this.rsFlowDataAssistService.queryAllGoodsClassAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsGoodsClass");
        htmlRelease.setHtmldataFilename("goodsclass.html");
        htmlRelease.setHtmldataFilepath("goodsclass");
        goodsClassMap.put("rsGoodsClass", rsGoodsClassList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(goodsClassMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        return true;
    }

    private boolean sendClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsClasstree>> classtreeMap = new HashMap<String, List<RsClasstree>>();
        List<RsClasstree> rsClasstreeList = this.rsFlowDataAssistService.queryAllClasstreeAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsClasstree");
        htmlRelease.setHtmldataFilename("classtree.html");
        htmlRelease.setHtmldataFilepath("classtree");
        classtreeMap.put("rsClasstree", rsClasstreeList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(classtreeMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        return true;
    }

    private boolean sendSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSku rsSku = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        if (null == rsSku) {
            return false;
        }
        RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), rsFlowData.getTenantCode()}));
        if (!"delete".equals(rsFlowData.getEsRequestType())) {
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(rsSku.getTenantCode());
            htmlRelease.setHtmldataCode("RsSku");
            htmlRelease.setHtmldataFilename(rsSku.getSkuCode() + ".html");
            htmlRelease.setHtmldataFilepath("sku");
            HashMap<String, Object> htmlMap = new HashMap<String, Object>();
            htmlMap.put("goods", rsResourceGoods);
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSku.getGoodsCode());
            svMap.put("tenantCode", rsSku.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.rsSpecValueService.querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
                List rsSpecValueList = rsSpecValueListResult.getList();
                for (RsSpecValue rsSpecValue : rsSpecValueList) {
                    String specName = rsSpecValue.getSpecName();
                    ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                    if (null == specValueList || specValueList.size() == 0) {
                        specValueList = new ArrayList<String>();
                    }
                    specValueList.add(rsSpecValue.getSpecValueValue());
                    if (!StringUtils.isNotBlank((String)specName)) continue;
                    specValueMap.put(specName, specValueList);
                }
                htmlMap.put("spec", specValueMap);
            }
            htmlMap.put("rsSku", rsSku);
            QueryResult<RsGoodsRel> rsGoodsRelList = this.rsGoodsOtherService.queryGoodsRelPage(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), rsFlowData.getTenantCode()}));
            rsResourceGoods.setRsGoodsRelDomainList(rsGoodsRelList.getList());
            ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
            if (null != rsGoodsRelList.getList() && rsGoodsRelList.getList().size() > 0) {
                List rsGoodsRelList1 = rsGoodsRelList.getList();
                for (RsGoodsRel rsGoodsRel : rsGoodsRelList1) {
                    QueryResult<RsSku> rsSkuList1;
                    RsResourceGoods rsResourceGoods1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                    if (null == rsResourceGoods1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                    RsSku rsSku1 = (RsSku)rsSkuList1.getList().get(0);
                    rsSku1.setGoodsName(rsResourceGoods1.getGoodsName());
                    rsSkuList.add(rsSku1);
                }
            }
            htmlMap.put("rsSkuRel", rsSkuList);
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("sku");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        storeDomain.setBizId(rsSku.getSkuId() + "");
        EsSku esSku = new EsSku();
        try {
            BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSku);
        }
        catch (Exception e) {
            // empty catch block
        }
        esSku.setRsGoodsFileDomainList(rsSku.getRsGoodsFileDomainList());
        esSku.setRsSpecValueMap(rsSku.getRsSpecValueMap());
        esSku.setGoodsNo(rsResourceGoods.getGoodsNo());
        esSku.setPntreeCode(rsResourceGoods.getPntreeCode());
        esSku.setMemberName(rsResourceGoods.getMemberName());
        esSku.setClasstreeName(rsResourceGoods.getClasstreeName());
        esSku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
        esSku.setPntreeName(rsResourceGoods.getPntreeName());
        esSku.setGoodsName(rsResourceGoods.getGoodsName());
        esSku.setGoodsProperty(rsResourceGoods.getGoodsProperty());
        esSku.setBrandCode(rsResourceGoods.getBrandCode());
        esSku.setBrandName(rsResourceGoods.getBrandName());
        if (null == esSku.getGoodsSalesvolume()) {
            esSku.setGoodsSalesvolume(BigDecimal.ZERO);
        }
        esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
        String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
        storeDomain.setStoreObj((Object)esSkuStr);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    private boolean sendDisSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String channelListStr = DisUtil.getMap((String)"DisChannel-memberMcode", (String)(rsFlowData.getMemberCode() + "-" + rsFlowData.getTenantCode()));
        if (StringUtils.isBlank((String)channelListStr)) {
            return true;
        }
        List channelList = (List)JsonUtil.buildNormalBinder().getJsonToList(channelListStr, DisChannel.class);
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String skuOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisSku(skuOldcode, null, tenantCode);
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoods) {
                return false;
            }
            map.put("skuCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsSku rsSku = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSku) {
                return false;
            }
            List<DisRsSkuDomain> disRsSkuList = this.makeDisSku(rsResourceGoods, rsSku, channelList);
            if (!ListUtil.isEmpty(disRsSkuList)) {
                this.rsFlowDataAssistService.saveDisSku(disRsSkuList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelSku(skuOldcode, null, tenantCode);
        }
        return true;
    }

    private boolean sendDisGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String channelListStr = DisUtil.getMap((String)"DisChannel-memberMcode", (String)(rsFlowData.getMemberCode() + "-" + rsFlowData.getTenantCode()));
        if (StringUtils.isBlank((String)channelListStr)) {
            return true;
        }
        List channelList = (List)JsonUtil.buildNormalBinder().getJsonToList(channelListStr, DisChannel.class);
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String goodsOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            map.put("unwantedRelatedData", "unwantedRelatedData");
            RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoods) {
                return false;
            }
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList = this.makeDisGoods(rsResourceGoods, channelList);
            if (!ListUtil.isEmpty(disRsResourceGoodsList)) {
                this.rsFlowDataAssistService.saveDisResourceGoods(disRsResourceGoodsList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelGoods(goodsOldcode, null, tenantCode);
        }
        return true;
    }

    private List<DisRsSkuDomain> makeDisSku(RsResourceGoods rsResourceGoods, RsSku rsSku, List<DisChannel> channelList) {
        if (null == rsResourceGoods || null == rsSku || ListUtil.isEmpty(channelList)) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disList = new ArrayList<DisRsSkuDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoods, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(this.makeDisSku(rsResourceGoods, rsSku, disChannel));
        }
        return disList;
    }

    private DisRsSkuDomain makeDisSku(RsResourceGoods rsResourceGoods, RsSku rsSku, DisChannel disChannel) {
        if (null == rsResourceGoods || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoods);
            disRsSkuDomain.setSkuCodeOld(rsSku.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSku.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoods.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private List<DisRsResourceGoodsDomain> makeDisGoods(RsResourceGoods rsResourceGoods, List<DisChannel> channelList) {
        if (null == rsResourceGoods || ListUtil.isEmpty(channelList)) {
            return null;
        }
        ArrayList<DisRsResourceGoodsDomain> disList = new ArrayList<DisRsResourceGoodsDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoods, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(disRsResourceGoodsDomain);
        }
        return disList;
    }

    private DisRsResourceGoodsDomain makeDisGoods(RsResourceGoods rsResourceGoods, DisChannel disChannel) {
        if (null == rsResourceGoods || null == disChannel) {
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = new DisRsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoods);
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoods.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoods.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            disRsResourceGoodsDomain.setDisRsSkuDomainList(this.makeDisSkuList(rsResourceGoods.getRsSkuDomainList(), disChannel));
        }
        catch (Exception e) {
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<DisRsSkuDomain> makeDisSkuList(List<RsSku> rsSkuDomainList, DisChannel disChannel) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disRsSkuDomainList = new ArrayList<DisRsSkuDomain>();
        for (RsSku rsSku : rsSkuDomainList) {
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsSku, disChannel);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomainList.add(disRsSkuDomain);
        }
        return disRsSkuDomainList;
    }

    private DisRsSkuDomain makeDisSku(RsSku rsSku, DisChannel disChannel) {
        if (null == rsSku || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSku);
            disRsSkuDomain.setSkuCodeOld(rsSku.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSku.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsSku.getGoodsOldcode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private DisRsResourceGoodsDomain checkDisGoods(RsResourceGoods rsResourceGoods, DisChannel disChannel) {
        DisRsResourceGoodsDomain disRsResourceGoodsDomain;
        if (null == rsResourceGoods || null == disChannel) {
            return null;
        }
        String goodsStr = DisUtil.getMap((String)"DisDgoods-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)JsonUtil.buildNormalBinder().getJsonToObject(goodsStr, DisDgoods.class);
        if (null == disDgoods) {
            return null;
        }
        goodsStr = DisUtil.getMap((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return null;
        }
        List disDgoodsScopelistList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsStr, DisDgoodsScopelist.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopelistList)) {
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoods, disChannel);
        } else {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return null;
            }
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)rsResourceGoods, (String)key);
                if (null == objValue) {
                    return null;
                }
                if (map.get(key).contains(objValue)) continue;
                return null;
            }
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoods, disChannel);
        }
        this.makePice(disRsResourceGoodsDomain, disChannel);
        if ("1".equals(disDgoods.getDgoodsPut())) {
            disRsResourceGoodsDomain.setDataOpbillstate(1);
        }
        return disRsResourceGoodsDomain;
    }

    private void makePice(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel) {
            return;
        }
        String goodsStr = DisUtil.getMap((String)"DisDpriceConf-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return;
        }
        List disDpriceList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsStr, DisDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            return;
        }
        for (DisDpriceDomain disDpriceDomain : disDpriceList) {
            Map<String, List<String>> map = this.makeDpeicelist(disDpriceDomain.getDisDpriceConfList());
            if (null == map || map.isEmpty()) continue;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)disRsResourceGoodsDomain, (String)key);
                if (null != objValue && map.get(key).contains(objValue)) continue;
            }
            this.setPrice(disDpriceDomain, disRsResourceGoodsDomain);
            return;
        }
    }

    private void setPrice(DisDpriceDomain disDpriceDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == disDpriceDomain || null == disRsResourceGoodsDomain) {
            return;
        }
        String pro = disDpriceDomain.getDpricePro();
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal money = disRsResourceGoodsDomain.getPricesetNprice();
        if ("0".equals(pro)) {
            rmoney = disDpriceDomain.getDpricePrice();
        } else if ("1".equals(pro)) {
            rmoney = money.subtract(disDpriceDomain.getDpricePrice().divide(new BigDecimal("100")).multiply(money));
        } else if ("1".equals(pro)) {
            rmoney = BigDecimal.ZERO;
        }
        disRsResourceGoodsDomain.setPricesetNprice(disRsResourceGoodsDomain.getPricesetNprice().subtract(rmoney));
    }

    private Map<String, List<String>> makeDpeicelist(List<DisDpriceConf> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDpriceConf disDpriceConf : disDpriceConfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDpriceConf.getDpriceConfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDpriceConfType(), list);
            }
            list.add(disDpriceConf.getDpriceConfValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelist> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelist disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    private boolean sendGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoods rsResourceGoods = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        if (null == rsResourceGoods) {
            return false;
        }
        if (!"delete".equals(rsFlowData.getEsRequestType())) {
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(rsResourceGoods.getTenantCode());
            htmlRelease.setHtmldataCode("RsResourceGoods");
            htmlRelease.setHtmldataFilename(rsResourceGoods.getGoodsCode() + ".html");
            htmlRelease.setHtmldataFilepath("goods");
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("goods");
        storeDomain.setBizId(rsResourceGoods.getGoodsId() + "");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        rsResourceGoods.setRsPropertiesValueDomainList(null);
        rsResourceGoods.setRsSpecValueDomainList(null);
        rsResourceGoods.setRsSkuDomainList(null);
        rsResourceGoods.setRsGoodsRelDomainList(null);
        rsResourceGoods.setRsGoodsFileDomainList(null);
        String s = JsonUtil.buildNonNullBinder().toJson((Object)rsResourceGoods);
        storeDomain.setStoreObj((Object)s);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    static {
        lock = new Object();
    }
}

