/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.util.CollectionUtils;

public class RsSkuServiceImpl
extends BaseServiceImpl
implements RsSkuService {
    public static final String SYS_CODE = "rs.RsSkuServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsSpecValueService rsSpecValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsFlowDataService rsFlowDataService;

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    public void setRsFlowDataService(RsFlowDataService rsFlowDataService) {
        this.rsFlowDataService = rsFlowDataService;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSpuCode())) {
            msg = msg + "spu\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = msg + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = msg + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (rsSkuDomain.getGoodsNum() == null) {
            msg = msg + "\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a;";
        }
        if (rsSkuDomain.getPricesetNprice() == null) {
            msg = msg + "\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        if (null == rsSku.getDataState()) {
            rsSku.setDataState(0);
        }
        if (null == rsSku.getDataOpbillstate()) {
            rsSku.setDataOpbillstate(0);
        }
        if (null == rsSku.getGmtCreate()) {
            rsSku.setGmtCreate(this.getSysDate());
        }
        rsSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            rsSku.setSkuCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)rsSku.getSkuShowno())) {
            rsSku.setSkuShowno(rsSku.getSkuNo());
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_1 == rsSku.getDataOpbillstate()) {
            this.setAuditModel(rsSku, false);
        }
    }

    private int getSkuMaxCode() {
        int code = 0;
        try {
            return this.rsSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuUpdataDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        rsSku.setGmtModified(this.getSysDate());
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private RsSku getSkuModelById(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        try {
            return this.rsSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelById", (Throwable)e);
            return null;
        }
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.num");
        }
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.num");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
            rsSku.setGmtModified(this.getSysDate());
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateSkuModelWithNull(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
            this.rsSkuMapper.updateByPrimaryKey(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    @Override
    public boolean updateNum(String skuNo, String tenantCode, BigDecimal num) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode) || null == num) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        boolean flag = false;
        Map map = this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode});
        List<RsSku> skus = this.rsSkuMapper.query(map);
        if (null == skus || ListUtil.isEmpty(skus)) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u65e0\u6570\u636e");
            return false;
        }
        Integer dataOpbillstate = skus.get(0).getDataOpbillstate();
        if (dataOpbillstate == 1) {
            map.put("goodsSupplynum", num);
        } else {
            map.put("goodsNum", num);
        }
        map.put("dataOpbillstate", dataOpbillstate);
        int i = this.rsSkuMapper.updateNum(map);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.null");
        }
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsSku) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeSku", (Throwable)e);
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
        if (null != rsSku) {
            return rsSku.getSkuCode();
        }
        return null;
    }

    private RsSku saveSkuMode(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        this.setSkuDefault(rsSku);
        rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
        this.saveSkuModel(rsSku);
        this.saveSpecList(rsSkuDomain.getSpecList(), rsSkuDomain.getGoodsCode());
        return rsSku;
    }

    @Override
    public void saveSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuList.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
            if (ResourcesConstants.DATA_OPBILLSTATE_1 != rsSkuDomain.getDataOpbillstate()) continue;
            skuList.add(rsSku);
        }
        this.saveFlowData(skuList, "insert");
    }

    private RsSku saveSkuDomain(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsSkuDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        this.makePic(rsSkuDomain, rsGoodsFileDomainList, dataPic);
        RsSku rsSku = this.saveSkuMode(rsSkuDomain);
        if (!ListUtil.isEmpty(rsSkuDomain.getRsGoodsFileDomainList())) {
            ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsFileDomain.setGoodsFileCode(null);
                rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsskuGoodsFileDomainList);
        }
        rsSkuDomain.setSkuCode(rsSku.getSkuCode());
        this.saveSkuRel(rsSkuDomain);
        return rsSku;
    }

    private void makePic(RsSkuDomain rsSkuDomain, List<RsGoodsFileDomain> rsGoodsFileDomainList, String dataPic) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSkuDomain.setDataPic(dataPic);
    }

    private String sortSkuName(String skuName) {
        if (StringUtils.isBlank((String)skuName)) {
            return null;
        }
        List<String> spcList = Arrays.asList(skuName.split("\\/"));
        return this.sortSpcList(spcList);
    }

    private String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }

    private void saveSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : valueList) {
            rsSpecValueDomain.setSpecValueBillno(goodsCode);
        }
        this.rsSpecValueService.saveSpecValueList(valueList);
    }

    @Override
    public void updateSkuState(RsSku rsSku, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rsSku || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"\u6570\u636e\u4e3a\u7a7a");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuState", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateSkuModel(rsSku.getSkuId(), dataState, oldDataState);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"rsSkuDomain is null");
            return;
        }
        if (ResourcesConstants.GOODS_DATA_STATE_NO.equals(dataState)) {
            this.processFLowSkuData(rsSku, rsSkuDomain, "deleteop", 8);
        }
        if (ResourcesConstants.GOODS_DATA_STATE_0.equals(dataState)) {
            this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 8);
        }
    }

    @Override
    public void updateSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
        }
        int oldDataOpbillstate = null == oldRsSku.getDataOpbillstate() ? 0 : oldRsSku.getDataOpbillstate();
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        this.updateSkuModel(rsSku);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsRelType", "3");
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
        this.saveSkuRel(rsSkuDomain);
        int newDataOpbillstate = rsSku.getDataOpbillstate();
        if (oldDataOpbillstate != newDataOpbillstate) {
            if (newDataOpbillstate == ResourcesConstants.DATA_OPBILLSTATE_0) {
                ArrayList<Integer> skuIds = new ArrayList<Integer>();
                skuIds.add(rsSku.getSkuId());
                this.updateCannelSkuList(skuIds);
                this.processFLowSkuData(rsSku, null, "delete", 2);
            } else if (newDataOpbillstate == ResourcesConstants.DATA_OPBILLSTATE_1) {
                this.setSkuUpdataDefault(rsSku);
                rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
                rsSku.setSkuSort(null);
                this.updateSkuModelWithNull(rsSku);
                ArrayList<Integer> skuIds = new ArrayList<Integer>();
                skuIds.add(rsSku.getSkuId());
                this.updateAuditSkuPass(skuIds);
                this.processFLowSkuData(rsSku, null, "insert", 2);
            }
        }
        this.deltaUpdateSpecList(rsSkuDomain.getSpecList(), rsSku.getGoodsCode());
    }

    private void saveSkuRel(RsSkuDomain rsSkuDomain) {
        if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode("");
                rsGoodsRelDomain.setGoodsSkuCode(rsSkuDomain.getSkuCode());
                rsGoodsRelDomain.setGoodsRelType("3");
                rsGoodsRelDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsSkuDomain.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsSkuDomain.getRsGoodsRelDomainList());
        }
    }

    @Override
    public void updateSkuFile(String skuCode, String tenantCode, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || CollectionUtils.isEmpty(rsGoodsFileDomainList)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile param null");
            return;
        }
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode});
        RsSku rsSku = this.getSkuModelByCode(paramMap);
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile rsSku null");
            return;
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (null == rsGoodsFileDomain.getDefaultState() || rsGoodsFileDomain.getDefaultState() != ResourcesConstants.FILE_DEFAULTSTATE_1 || !FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSku.setDataPic(dataPic);
        this.updateSkuModel(rsSku);
    }

    private void deltaUpdateSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (CollectionUtils.isEmpty(valueList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsSpecValueDomain> i = valueList.iterator();
        while (i.hasNext()) {
            RsSpecValueDomain valueDomain = i.next();
            valueDomain.setSpecValueBillno(goodsCode);
            params.put("tenantCode", valueDomain.getTenantCode());
            params.put("specValueCode", valueDomain.getSpecValueCode());
            RsSpecValue exist = this.rsSpecValueService.getSpecValueByCode(params);
            if (exist == null) continue;
            this.rsSpecValueService.updateSpecValue(valueDomain);
            i.remove();
        }
        this.saveSpecList(valueList, goodsCode);
    }

    @Override
    public RsSku getSku(Integer skuId) {
        return this.getSkuModelById(skuId);
    }

    @Override
    public void deleteSkuSyn(Integer skuId) {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsSku.getSkuCode());
        map.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        this.processFLowSkuData(rsSku, rsSkuDomain, "deleteop", 2);
        this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 6);
        this.processFLowSkuData(rsSku, rsSkuDomain, "deleteop", 8);
    }

    @Override
    public void deleteSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsSku.getSkuCode());
        map.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        this.processFLowSkuData(rsSku, rsSkuDomain, "deleteop", 2);
        this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 6);
        this.processFLowSkuData(rsSku, rsSkuDomain, "deleteop", 8);
        this.deleteSkuModel(skuId);
    }

    private RsSkuDomain makeRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("skuCode", rsSku.getSkuCode());
        map1.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
        if (null != rsSkuFileList) {
            rsSkuDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsSkuFileList.getList()));
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("goodsSkuCode", rsSku.getSkuCode());
        map2.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsRel> rsSkuRelList = this.rsGoodsOtherService.queryGoodsRelPage(map2);
        if (null != rsSkuRelList) {
            rsSkuDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsSkuRelList.getList()));
        }
        return rsSkuDomain;
    }

    private List<RsSkuDomain> makeRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception e) {
            // empty catch block
        }
        RsSku rsSku = this.rsSkuMapper.getByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRelDomain.getSkuCode(), rsGoodsRelDomain.getTenantCode()}));
        if (null != rsSku) {
            RsResourceGoods rsResourceGoods = this.rsResourceGoodsMapper.getByCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), rsSku.getTenantCode()}));
            if (null != rsResourceGoods) {
                rsGoodsRelDomain.setGoodsName(rsResourceGoods.getGoodsName());
            }
            rsGoodsRelDomain.setSkuNo(rsSku.getSkuNo());
        }
        return rsGoodsRelDomain;
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuPage(Map<String, Object> map) {
        if (null != map && !map.isEmpty()) {
            String goodsName = (String)map.get("goodsName");
            StringBuilder goodsCodes = new StringBuilder();
            if (null != goodsName) {
                HashMap<String, Object> mapGoods = new HashMap<String, Object>();
                mapGoods.put("fuzzy", true);
                mapGoods.put("goodsName", goodsName);
                mapGoods.put("tenantCode", map.get("tenantCode"));
                List<RsResourceGoods> GoodsList = this.rsResourceGoodsMapper.query(mapGoods);
                for (RsResourceGoods rsResourceGoods : GoodsList) {
                    goodsCodes.append("'").append(rsResourceGoods.getGoodsCode()).append("'").append(",");
                }
            }
            if (StringUtils.isNotBlank((String)goodsCodes.toString())) {
                String goodsCodesNew = goodsCodes.substring(0, goodsCodes.lastIndexOf(","));
                map.put("goodsCodes", goodsCodesNew);
            }
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> querySkuOnePage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            throw new ApiException("rs.RsSkuServiceImpl.querySkuOnePage.param is null or tenantCode is null ");
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public RsSku getSkuBySpec(List<String> spcList, String goodsCode, String tenantCode) {
        if (null == spcList || spcList.isEmpty() || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String skuName = this.sortSpcList(spcList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public RsSku getSkuByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return rsSku;
    }

    @Override
    public RsSkuDomain getSkuDomainByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return this.makeRsSkuDomain(rsSku);
    }

    @Override
    public List<RsSku> checkSkuNo(String skuNo, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkSkuNo.param.null");
        }
        return this.rsSkuMapper.query(this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode}));
    }

    @Override
    public void delSkuByCode(Map<String, Object> map) throws ApiException {
        RsSku rsSku = this.getSkuModelByCode(map);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuByCode.rsSku");
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData1 = new RsFlowData();
        rsFlowData1.setEsRequestType("delete");
        rsFlowData1.setTenantCode(rsSku.getTenantCode());
        rsFlowData1.setAppmanageIcode(rsSku.getAppmanageIcode());
        rsFlowData1.setFdBizCode(rsSku.getSkuCode());
        rsFlowData1.setFdBizId(rsSku.getSkuId());
        rsFlowData1.setChannelCode(rsSku.getChannelCode());
        rsFlowData1.setMemberCode(rsSku.getMemberCode());
        rsFlowData1.setFdBizType(2);
        rsFlowDataList.add(rsFlowData1);
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
        this.delSkuModelByCode(map);
    }

    @Override
    public void deleteSkuList(List<Integer> skuIds) throws ApiException {
        if (skuIds == null || skuIds.isEmpty()) {
            return;
        }
        for (Integer skuId : skuIds) {
            this.deleteSku(skuId);
        }
    }

    @Override
    public void updateAhSkuList(List<RsSkuDomain> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        for (RsSkuDomain rsSkuDomain : skuList) {
            RsSku rsSku = new RsSku();
            this.makeSku(rsSkuDomain, rsSku);
            rsSkus.add(rsSku);
        }
        this.updateAh(rsSkus);
    }

    public void updateAhSku(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.checkSku", msg);
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_3) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        rsSku.setSkuSort(null);
        this.updateSkuModelWithNull(rsSku);
    }

    @Override
    public void updateCannelSkuList(List<Integer> skuIds) throws ApiException {
        if (ListUtil.isEmpty(skuIds)) {
            this.logger.error("rs.RsSkuServiceImpl.updateCannelSkuList", (Object)"skuIds is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "skuIds is null");
        }
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (ListUtil.isEmpty(skuList)) {
            return;
        }
        this.updateCannel(skuList);
        for (RsSku rsSku : skuList) {
            RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
            this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 8);
        }
    }

    private void saveFlowData(List<RsSku> skuList, String esRequestType) {
        if (null == skuList || skuList.isEmpty()) {
            return;
        }
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        for (RsSku rsSku : skuList) {
            RsFlowData rsFlowData1 = new RsFlowData();
            rsFlowData1.setEsRequestType(esRequestType);
            rsFlowData1.setTenantCode(rsSku.getTenantCode());
            rsFlowData1.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsFlowData1.setFdBizCode(rsSku.getSkuCode());
            rsFlowData1.setChannelCode(rsSku.getChannelCode());
            rsFlowData1.setMemberCode(rsSku.getMemberCode());
            rsFlowData1.setFdBizType(6);
            rsFlowDataList.add(rsFlowData1);
        }
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    public RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsResourceGoodsReDomain;
    }

    private void updateCannel(List<RsSku> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, false);
        }
    }

    private void updateCannelMode(RsSku rsSku, boolean dataState) {
        if (null == rsSku) {
            return;
        }
        BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
        rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsSupplyweight));
        }
        rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().subtract(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().subtract(goodsSupplyweight));
        }
        rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
        if (dataState) {
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
        }
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
        this.updateSkuModel(rsSku);
    }

    @Override
    public void updateAuditSkuPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
        for (RsSku rsSku : skuList) {
            RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
            this.processFLowSkuData(rsSku, rsSkuDomain, "insert", 8);
        }
        this.saveFlowData(skuList, "insert");
    }

    private void updateAuditPass(List<RsSku> skuList, boolean put) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
    }

    @Override
    public void updateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSku> skuList;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (skuList = this.querySkuModelPage(parammap)) || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, true);
            RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
            this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 8);
            this.processFLowSkuData(rsSku, rsSkuDomain, "delete", 2);
            this.processFLowSkuData(rsSku, rsSkuDomain, "update", 6);
        }
    }

    public void processFLowDataForEsAndHtml(RsResourceGoods rsResourceGoods, List<RsSku> skuList, String requestType) {
        if (null == skuList || null == rsResourceGoods) {
            return;
        }
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        for (RsSku rsSku : skuList) {
            RsFlowData rsFlowData1 = new RsFlowData();
            rsFlowData1.setEsRequestType(requestType);
            rsFlowData1.setTenantCode(rsResourceGoods.getTenantCode());
            rsFlowData1.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
            rsFlowData1.setFdBizCode(rsSku.getSkuCode());
            rsFlowData1.setFdBizId(rsSku.getSkuId());
            rsFlowData1.setChannelCode(rsResourceGoods.getChannelCode());
            rsFlowData1.setMemberCode(rsResourceGoods.getMemberCode());
            rsFlowData1.setFdBizType(2);
            rsFlowDataList.add(rsFlowData1);
        }
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    private void updateAuditModel(RsSku rsSku, boolean put) {
        this.setAuditModel(rsSku, put);
        this.updateSkuModel(rsSku);
    }

    private void setAuditModel(RsSku rsSku, boolean put) {
        if (null == rsSku) {
            return;
        }
        BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
        BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
        if (null == goodsAhnum) {
            goodsAhnum = BigDecimal.ZERO;
        }
        if (null == goodsAhweight) {
            goodsAhweight = BigDecimal.ZERO;
        }
        if (put) {
            goodsAhnum = rsSku.getGoodsNum();
            goodsAhweight = rsSku.getGoodsWeight();
            rsSku.setGoodsNum(BigDecimal.ZERO);
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsSupplynum()) {
            rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsHangnum()) {
            rsSku.setGoodsHangnum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsSupplyweight()) {
            rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsHangweight()) {
            rsSku.setGoodsHangweight(BigDecimal.ZERO);
        }
        rsSku.setGoodsSupplynum(rsSku.getGoodsSupplynum().add(goodsAhnum));
        rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().add(goodsAhnum));
        if (goodsAhweight != null) {
            rsSku.setGoodsSupplyweight(rsSku.getGoodsSupplyweight().add(goodsAhweight));
            rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().add(goodsAhweight));
        }
        rsSku.setGoodsAhnum(BigDecimal.ZERO);
        rsSku.setGoodsAhweight(BigDecimal.ZERO);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
        rsSku.setSkuHdate(this.getSysDate());
    }

    @Override
    public void updateAuditSkuNoPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsAhnum));
            if (goodsAhweight == null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            this.updateSkuModel(rsSku);
        }
    }

    private List<RsSku> checkAuditSku(List<Integer> skuIds) {
        if (skuIds == null || skuIds.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.getSkuModelById(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            skuList.add(rsSku);
        }
        return skuList;
    }

    private List<RsSku> checkAuditSku(String goodsCode, String tenantCode) {
        if (goodsCode == null || goodsCode.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.goodsCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", 0);
        List<RsSku> skuList = this.rsSkuMapper.query(map);
        if (ListUtil.isEmpty(skuList)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.skuList", "\u6570\u636e\u4e3a\u7a7a:" + ((Object)map).toString());
        }
        String mschannelName = null;
        String mschannelCode = null;
        map.remove("dataOpbillstate");
        List<RsResourceGoods> resourceGoods = this.rsResourceGoodsMapper.query(map);
        if (null != resourceGoods && resourceGoods.size() > 0) {
            mschannelName = resourceGoods.get(0).getMschannelName();
            mschannelCode = resourceGoods.get(0).getMschannelCode();
        }
        for (RsSku rsSku : skuList) {
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.rsSku", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            rsSku.setMschannelCode(mschannelCode);
            rsSku.setMschannelName(mschannelName);
        }
        return skuList;
    }

    @Override
    public void querySkuAll(Map<String, Object> map) {
        if (map != null) {
            map.put("dataOpbillstate", 1);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(this.queryforEs(map)));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<EsSku> queryforEs(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.queryForEs(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.queryforEs.error", e.getMessage());
        }
    }

    @Override
    public void updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("goodsCode", goodsCode);
        parammap.put("dataState", 0);
        List<RsSku> skuList = this.querySkuModelPage(parammap);
        this.updateAh(skuList);
    }

    private void updateAh(List<RsSku> skuList) {
        if (null == skuList || skuList.isEmpty()) {
            return;
        }
        List skuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(skuList), RsSkuDomain.class);
        for (RsSkuDomain rsSkuDomain : skuDomainList) {
            this.updateAhModel(rsSkuDomain);
        }
    }

    protected void updateAhModel(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return;
        }
        BigDecimal goodsNum = rsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = rsSkuDomain.getGoodsWeight();
        goodsNum = goodsNum == null ? BigDecimal.ZERO : goodsNum;
        goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
        rsSkuDomain.setGoodsAhnum(goodsNum);
        rsSkuDomain.setGoodsAhweight(goodsWeight);
        rsSkuDomain.setGoodsNum(goodsNum.subtract(goodsNum));
        rsSkuDomain.setGoodsWeight(goodsWeight.subtract(goodsWeight));
        this.updateAhSku(rsSkuDomain);
    }

    @Override
    public void updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
        for (RsSku rsSku : skuList) {
            RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
            this.processFLowSkuData(rsSku, rsSkuDomain, "insert", 8);
        }
    }

    @Override
    public void updatetSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, true);
        for (RsSku rsSku : skuList) {
            RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
            this.processFLowSkuData(rsSku, rsSkuDomain, "insert", 8);
        }
    }

    @Override
    public void updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsSkuMapper.updateByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String goodsCode, String tenantCode) {
        if (goodsNum == null || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", "param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsNum", goodsNum);
        map.put("skuCode", goodsCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuGoodsNumByGoodsCode(map);
    }

    private void updateSkuGoodsNumByGoodsCode(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuGoodsNumByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.null");
        }
    }

    private List<RsSku> queryDisSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countDisSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countDisSku(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<RsSku> queryDisSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryDisSku(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDisSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> queryDisAndSkuPage(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisAndSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.queryDisAndSku(map));
        return queryResult;
    }

    private List<RsSku> queryDisAndSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisAndSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int queryDisAndSkuCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.queryDisAndSkuCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.updateSku(rsSkuDomain);
        }
    }

    @Override
    public List<RsSku> querySkuByPntreeCode(Map<String, Object> map) {
        try {
            return this.rsSkuMapper.querySkuByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByPntreeCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        this.updateSortNoSkuModel(tenantCode, goodsCode, skuCode, sortNo);
    }

    private void updateSortNoSkuModel(String tenantCode, String goodsCode, String skuCode, Integer sortNo) throws ApiException {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode) && StringUtil.isBlank((String)skuCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        map.put("skuCode", skuCode);
        map.put("gmtModified", this.getSysDate());
        map.put("sortNo", sortNo);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSortNoSku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.null");
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.null", map.toString());
        }
    }

    @Override
    public void updateSkuStock(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModel(map);
    }

    @Override
    public List<RsSku> querySkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        return this.querySkuModelPage(map);
    }

    @Override
    public void updateSkuEdit(EditSkuDomain editSkuDomain, RsSku oldRsSku) {
        if (null == editSkuDomain || null == oldRsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit", "editSkuDomain/oldRsSku is null");
        }
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("rs.RsSkuServiceImplupdateSkuEdit.checkSkuEdit", (Object)msg);
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.checkSku", msg);
        }
        this.updateEditSku(editSkuDomain);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(oldRsSku, null);
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)editSkuDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeRsSkuDomain", (Throwable)e);
        }
        if (editSkuDomain.getDataOpbillstate() == ResourcesConstants.DATA_OPBILLSTATE_1) {
            this.processFLowSkuData(oldRsSku, rsSkuDomain, "edit", 8);
            this.processFLowSkuData(oldRsSku, rsSkuDomain, "edit", 6);
            this.processFLowSkuData(oldRsSku, rsSkuDomain, "update", 2);
        } else {
            this.processFLowSkuData(oldRsSku, rsSkuDomain, "delete", 2);
        }
    }

    private RsSkuDomain makeSkuDomain(RsSku oldRsSku, RsSkuDomain rsSkuDomain) {
        if (null == oldRsSku) {
            return null;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = new RsSkuDomain();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)oldRsSku);
            return rsSkuDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeSkuDomain", (Throwable)e);
            return rsSkuDomain;
        }
    }

    private void processFLowSkuData(RsSku rsSku, RsSkuDomain rsSkuDomain, String esRequestType, Integer fdBizType) {
        if (StringUtils.isBlank((String)esRequestType) || null == fdBizType || null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.processFLowSkuData", (Object)"\u53c2\u6570\u9519\u8bef");
            throw new ApiException("rs.RsSkuServiceImpl.processFLowSkuData", "\u53c2\u6570\u9519\u8bef");
        }
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData = new RsFlowData();
        rsFlowData.setEsRequestType(esRequestType);
        rsFlowData.setTenantCode(rsSku.getTenantCode());
        rsFlowData.setChannelCode(rsSku.getChannelCode());
        rsFlowData.setMemberCode(rsSku.getMemberCode());
        rsFlowData.setAppmanageIcode(rsSku.getAppmanageIcode());
        rsFlowData.setFdBizCode(rsSku.getSkuCode());
        rsFlowData.setFdBizId(rsSku.getSkuId());
        rsFlowData.setFdBizType(fdBizType);
        rsFlowData.setRsSkuDomain(rsSkuDomain);
        rsFlowDataList.add(rsFlowData);
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    private void updateEditSku(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            return;
        }
        try {
            this.rsSkuMapper.updateNumAndPriceByGoodsCode(editSkuDomain);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private String checkSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)editSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getSkuCode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (editSkuDomain.getDataOpbillstate() == ResourcesConstants.DATA_OPBILLSTATE_1 && (editSkuDomain.getGoodsSupplynum() == null || editSkuDomain.getGoodsSupplynum().intValue() < 0)) {
            msg = msg + "GoodsSupplynum\u53c2\u6570\u9519\u8bef";
        }
        if (editSkuDomain.getPricesetNprice() == null || editSkuDomain.getPricesetNprice().intValue() < 0) {
            msg = msg + "PricesetNprice\u53c2\u6570\u9519\u8bef;";
        }
        if (editSkuDomain.getPricesetAsprice() == null || editSkuDomain.getPricesetAsprice().intValue() < 0) {
            msg = msg + "PricesetAsprice\u53c2\u6570\u9519\u8bef;";
        }
        return msg;
    }

    @Override
    public RsSku getRsSkuModelByOldCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByOldCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getRsSkuModelByOldCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateDisAuditSku(RsSkuDomain rsSkuDomain) throws ApiException {
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null", (Object)"rsSkuDomain is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCode", rsSkuDomain.getSkuCode());
        paramMap.put("tenantCode", rsSkuDomain.getTenantCode());
        RsSku rsSku = this.getSkuModelByCode(paramMap);
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku rsSku null");
            return;
        }
        this.makeSku(rsSkuDomain, rsSku);
        this.setSkuFile(rsSkuDomain.getRsGoodsFileDomainList(), paramMap, rsSku);
        this.updateSkuModel(rsSku);
        this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku======================", (Object)rsSkuDomain.toString());
        if (ResourcesConstants.DATA_OPBILLSTATE_1 == rsSkuDomain.getDataOpbillstate()) {
            this.updateAuditModel(rsSku, true);
            this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku======================", (Object)rsSkuDomain.toString());
            this.processFLowSkuData(rsSku, this.makeSkuDomain(rsSku, null), "insert", 8);
            this.processFLowSkuData(rsSku, this.makeRsSkuDomain(rsSku), "insert", 6);
        }
    }

    private void setSkuFile(List<RsGoodsFileDomain> rsGoodsFileDomainList, Map<String, Object> paramMap, RsSku rsSku) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList) || null == paramMap || paramMap.isEmpty() || null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.setSkuFile param null");
            throw new ApiException("rs.RsSkuServiceImpl.setSkuFile.param.null");
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (null != rsGoodsFileDomainList && rsGoodsFileDomainList.size() > 0) {
            String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
            boolean picflag = false;
            if (!FileType.fileTypepic((String)dataPic)) {
                picflag = true;
            }
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                    dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                    picflag = false;
                }
                rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsFileCode(this.createUUIDString());
                if (rsGoodsFileDomain.getDefaultState() != null && rsGoodsFileDomain.getDefaultState() == 1) {
                    dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                }
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
            }
            rsSku.setDataPic(dataPic);
            this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        }
    }
}

