/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecGroupMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecOptionMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecValueMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsSpec;
import com.yqbsoft.laser.service.resources.model.RsSpecGroup;
import com.yqbsoft.laser.service.resources.model.RsSpecOption;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsSpecService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsClasstreeServiceImpl
extends BaseServiceImpl
implements RsClasstreeService {
    private static final String SYS_CODE = "rs.RsClasstreeServiceImpl";
    private RsClasstreeMapper rsClasstreeMapper;
    private RsFlowDataService rsFlowDataService;
    private RsSpecValueService rsSpecValueService;
    private RsSpecMapper rsSpecMapper;
    private RsSpecOptionMapper rsSpecOptionMapper;
    private RsSpecValueMapper rsSpecValueMapper;
    private RsSpecGroupMapper rsSpecGroupMapper;
    private RsSpecService rsSpecService;

    public RsSpecValueService getRsSpecValueService() {
        return this.rsSpecValueService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public RsSpecValueMapper getRsSpecValueMapper() {
        return this.rsSpecValueMapper;
    }

    public void setRsSpecValueMapper(RsSpecValueMapper rsSpecValueMapper) {
        this.rsSpecValueMapper = rsSpecValueMapper;
    }

    public RsSpecOptionMapper getRsSpecOptionMapper() {
        return this.rsSpecOptionMapper;
    }

    public void setRsSpecOptionMapper(RsSpecOptionMapper rsSpecOptionMapper) {
        this.rsSpecOptionMapper = rsSpecOptionMapper;
    }

    public RsSpecGroupMapper getRsSpecGroupMapper() {
        return this.rsSpecGroupMapper;
    }

    public void setRsSpecGroupMapper(RsSpecGroupMapper rsSpecGroupMapper) {
        this.rsSpecGroupMapper = rsSpecGroupMapper;
    }

    public RsSpecService getRsSpecService() {
        return this.rsSpecService;
    }

    public void setRsSpecService(RsSpecService rsSpecService) {
        this.rsSpecService = rsSpecService;
    }

    public RsClasstreeMapper getRsClasstreeMapper() {
        return this.rsClasstreeMapper;
    }

    public RsFlowDataService getRsFlowDataService() {
        return this.rsFlowDataService;
    }

    public RsSpecMapper getRsSpecMapper() {
        return this.rsSpecMapper;
    }

    public void setRsSpecMapper(RsSpecMapper rsSpecMapper) {
        this.rsSpecMapper = rsSpecMapper;
    }

    public void setRsClasstreeMapper(RsClasstreeMapper rsClasstreeMapper) {
        this.rsClasstreeMapper = rsClasstreeMapper;
    }

    public void setRsFlowDataService(RsFlowDataService rsFlowDataService) {
        this.rsFlowDataService = rsFlowDataService;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClasstree(RsClasstreeDomain rsClasstreeDomain) {
        if (null == rsClasstreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeDomain.getClasstreeName())) {
            msg = msg + "ClasstreeName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsClasstreeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClasstreeDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        if (null == rsClasstree.getDataState()) {
            rsClasstree.setDataState(0);
        }
        if (null == rsClasstree.getGmtCreate()) {
            rsClasstree.setGmtCreate(this.getSysDate());
        }
        rsClasstree.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsClasstree.getClasstreeCode())) {
            rsClasstree.setClasstreeCode(this.createUUIDString());
        }
    }

    private int getClasstreeMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClasstreeUpdataDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        rsClasstree.setGmtModified(this.getSysDate());
    }

    private void saveClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.insert(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeModel.ex", (Throwable)e);
        }
    }

    private void saveClasstreeListModel(List<RsClasstree> rsClasstrees) throws ApiException {
        if (ListUtil.isEmpty(rsClasstrees)) {
            return;
        }
        try {
            this.rsClasstreeMapper.insertBatch(rsClasstrees);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeListModel.ex", (Throwable)e);
        }
    }

    private RsClasstree getClasstreeModelById(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.selectByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelById", (Throwable)e);
            return null;
        }
    }

    public RsClasstree getClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.num");
        }
    }

    private void deleteClasstreeModel(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.deleteByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.num");
        }
    }

    private void updateClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.updateByPrimaryKeySelective(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstreeModel.ex", (Throwable)e);
        }
    }

    private void updateStateClasstreeModel(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == classtreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeId", classtreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsClasstreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.null");
        }
    }

    private RsClasstree makeClasstree(RsClasstreeDomain rsClasstreeDomain, RsClasstree rsClasstree) {
        if (null == rsClasstreeDomain) {
            return null;
        }
        if (null == rsClasstree) {
            rsClasstree = new RsClasstree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstree, (Object)rsClasstreeDomain);
            return rsClasstree;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClasstree", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstree> queryClasstreeModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeModel", (Throwable)e);
            return null;
        }
    }

    private int countClasstree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.countClasstree", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstree.checkClasstree", msg);
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
        this.setClasstreeDefault(rsClasstree);
        this.saveClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstreeDomain.getTenantCode());
        return rsClasstree.getClasstreeCode();
    }

    @Override
    public void saveClasstreeList(List<RsClasstreeDomain> rsClasstreeDomains) throws ApiException {
        if (ListUtil.isEmpty(rsClasstreeDomains)) {
            this.logger.error("rs.RsClasstreeServiceImpl.saveClasstreeList", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        ArrayList<RsClasstree> rsClasstrees = new ArrayList<RsClasstree>();
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeDomains) {
            String msg = this.checkClasstree(rsClasstreeDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeList.checkClasstree", msg);
            }
            RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
            this.setClasstreeDefault(rsClasstree);
            rsClasstrees.add(rsClasstree);
        }
        if (ListUtil.isNotEmpty(rsClasstrees)) {
            this.saveClasstreeListModel(rsClasstrees);
            this.processFLowDataForHtml(((RsClasstree)rsClasstrees.get(0)).getTenantCode());
        }
    }

    @Override
    public void updateClasstreeState(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClasstreeModel(classtreeId, dataState, oldDataState);
    }

    @Override
    public void updateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.checkClasstree", msg);
        }
        RsClasstree oldRsClasstree = this.getClasstreeModelById(rsClasstreeDomain.getClasstreeId());
        if (null == oldRsClasstree) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, oldRsClasstree);
        this.setClasstreeUpdataDefault(rsClasstree);
        this.updateClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstreeDomain.getTenantCode());
    }

    @Override
    public RsClasstree getClasstree(Integer classtreeId) {
        return this.getClasstreeModelById(classtreeId);
    }

    @Override
    public void deleteClasstree(Integer classtreeId) throws ApiException {
        RsClasstree rsClasstree = this.getClasstree(classtreeId);
        this.deleteClasstreeModel(classtreeId);
        this.processFLowDataForHtml(rsClasstree.getTenantCode());
    }

    @Override
    public QueryResult<RsClasstree> queryClasstreePage(Map<String, Object> map) {
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClasstree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeList);
        return queryResult;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstree(String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", "-1");
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree checkClasstreeName(String classtreeName, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeName) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String classtreeLast = "0";
        List<RsClasstree> classtrees = this.rsClasstreeMapper.query(this.getQueryMapParam("classtreeName,tenantCode,classtreeLast", new Object[]{classtreeName, tenantCode, classtreeLast}));
        if (ListUtil.isEmpty(classtrees)) {
            return null;
        }
        return classtrees.get(0);
    }

    private RsClasstreeReDomain makeRsClasstreeReDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeReDomain rsClasstreeReDomain = new RsClasstreeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeReDomain, (Object)rsClasstree);
            rsClasstreeReDomain.setChildList(this.queryClasstreeParent(rsClasstree.getMemberCode(), rsClasstree.getTenantCode(), rsClasstree.getClasstreeCode()));
        }
        catch (Exception e) {
            return null;
        }
        return rsClasstreeReDomain;
    }

    private List<RsClasstreeReDomain> queryClasstreeParent(String memberCode, String tenantCode, String classtreeParentcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", classtreeParentcode);
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree getClasstreeByCode(Map<String, Object> map) {
        return this.getClasstreeModelByCode(map);
    }

    @Override
    public void delClasstreeByCode(Map<String, Object> map) throws ApiException {
        RsClasstree rsClasstree = this.getClasstreeByCode(map);
        this.delClasstreeModelByCode(map);
        this.processFLowDataForHtml(rsClasstree.getTenantCode());
    }

    @Override
    public List<RsClasstree> queryClasstreeByCodeList(Map<String, Object> parammap) {
        if (null == parammap) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeByCodeList", (Object)"param is null\uff01");
            return null;
        }
        return this.queryClasstreeModelByCodeList(parammap);
    }

    private List<RsClasstree> queryClasstreeModelByCodeList(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.queryClasstreeByCodeList(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeByCodeList", (Throwable)e);
            return null;
        }
    }

    public void processFLowDataForHtml(String tenantCode) {
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData = new RsFlowData();
        rsFlowData.setEsRequestType("update");
        rsFlowData.setTenantCode(tenantCode);
        rsFlowData.setFdBizCode("");
        rsFlowData.setFdBizType(3);
        rsFlowData.setDataState(1);
        rsFlowData.setGmtCreate(new Date());
        String fdCode = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", tenantCode);
        rsFlowData.setFdCode(fdCode);
        rsFlowDataList.add(rsFlowData);
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    @Override
    public void saveResourceInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        List<RsClasstree> list = this.queryrsClasstreePage(map);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        for (RsClasstree rsClasstree : list) {
            List<RsClasstree> oldList = this.queryrsClasstreePage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
            if (ListUtil.isNotEmpty(oldList)) continue;
            RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
            rsClasstreeDomain.setClasstreeId(null);
            rsClasstreeDomain.setTenantCode(tenantCode);
            this.saveClasstree(rsClasstreeDomain);
        }
        List<RsSpec> rsSpecsList = this.queryrsRsSpecPage(map);
        if (ListUtil.isEmpty(rsSpecsList)) {
            return;
        }
        for (RsSpec rsSpec : rsSpecsList) {
            List<RsSpec> oldrsSpecList = this.queryrsRsSpecPage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
            if (ListUtil.isNotEmpty(oldrsSpecList)) continue;
            RsSpecDomain rsSpecDomain = this.makeRsSpecDomain(rsSpec);
            rsSpecDomain.setSpecId(null);
            rsSpecDomain.setTenantCode(tenantCode);
            this.rsSpecService.saveSpec(rsSpecDomain);
        }
        List<RsSpecGroup> rsSpecGroupList = this.queryrsRsSpecGroupPage(map);
        if (ListUtil.isEmpty(rsSpecGroupList)) {
            return;
        }
        for (RsSpecGroup rsSpecGroup : rsSpecGroupList) {
            List<RsSpecGroup> oldrsSpecGroupList = this.queryrsRsSpecGroupPage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
            if (ListUtil.isNotEmpty(oldrsSpecGroupList)) continue;
            RsSpecGroupDomain rsSpecGroupDomain = this.makeRsSpecGroupDomain(rsSpecGroup);
            rsSpecGroupDomain.setSpecGroupId(null);
            rsSpecGroupDomain.setTenantCode(tenantCode);
            this.rsSpecService.saveSpecGroup(rsSpecGroupDomain);
        }
        List<RsSpecOption> rsSpecOptions = this.queryrsRsSpecOptionPage(map);
        if (ListUtil.isEmpty(rsSpecOptions)) {
            return;
        }
        for (RsSpecOption rsSpecOption : rsSpecOptions) {
            List<RsSpecOption> oldrsSpecOptionList = this.queryrsRsSpecOptionPage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
            if (ListUtil.isNotEmpty(oldrsSpecOptionList)) continue;
            RsSpecOptionDomain rsSpecOptionDomain = this.makeRsSpecOptionDomain(rsSpecOption);
            rsSpecOptionDomain.setSpecOptionId(null);
            rsSpecOptionDomain.setTenantCode(tenantCode);
            this.rsSpecService.saveSpecOption(rsSpecOptionDomain);
        }
        List<RsSpecValue> rsSpecValueList = this.queryrsRsSpecValuePage(map);
        if (ListUtil.isEmpty(rsSpecValueList)) {
            return;
        }
        for (RsSpecValue rsSpecValue : rsSpecValueList) {
            List<RsSpecValue> oldrsSpecValueList = this.queryrsRsSpecValuePage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
            if (ListUtil.isNotEmpty(oldrsSpecValueList)) continue;
            RsSpecValueDomain rsSpecValueDomain = this.makeRsSpecValueDomain(rsSpecValue);
            rsSpecValueDomain.setSpecValueId(null);
            rsSpecValueDomain.setTenantCode(tenantCode);
            this.rsSpecValueService.saveSpecValue(rsSpecValueDomain);
        }
    }

    private List<RsSpecValue> queryrsRsSpecValuePage(Map<String, Object> parammap) {
        try {
            return this.rsSpecValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryrsRsSpecValuePage", (Throwable)e);
            return null;
        }
    }

    private List<RsSpecOption> queryrsRsSpecOptionPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecOptionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryrsRsSpecOptionPage", (Throwable)e);
            return null;
        }
    }

    private List<RsSpecGroup> queryrsRsSpecGroupPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryrsRsSpecGroupPage", (Throwable)e);
            return null;
        }
    }

    private List<RsSpec> queryrsRsSpecPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryrsClasstreePage", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstree> queryrsClasstreePage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryrsClasstreePage", (Throwable)e);
            return null;
        }
    }

    private RsClasstreeDomain makeClassTreeDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeDomain, (Object)rsClasstree);
            return rsClasstreeDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClassTreeDomain", (Throwable)e);
            return null;
        }
    }

    private RsSpecValueDomain makeRsSpecValueDomain(RsSpecValue rsSpecValue) {
        if (null == rsSpecValue) {
            return null;
        }
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValueDomain, (Object)rsSpecValue);
            return rsSpecValueDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeRsSpecValueDomain", (Throwable)e);
            return null;
        }
    }

    private RsSpecOptionDomain makeRsSpecOptionDomain(RsSpecOption rsSpecOption) {
        if (null == rsSpecOption) {
            return null;
        }
        RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecOptionDomain, (Object)rsSpecOption);
            return rsSpecOptionDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeRsSpecOptionDomain", (Throwable)e);
            return null;
        }
    }

    private RsSpecGroupDomain makeRsSpecGroupDomain(RsSpecGroup rsSpecGroup) {
        if (null == rsSpecGroup) {
            return null;
        }
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecGroupDomain, (Object)rsSpecGroup);
            return rsSpecGroupDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeRsSpecGroupDomain", (Throwable)e);
            return null;
        }
    }

    private RsSpecDomain makeRsSpecDomain(RsSpec rsSpec) {
        if (null == rsSpec) {
            return null;
        }
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecDomain, (Object)rsSpec);
            return rsSpecDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeRsSpecDomain", (Throwable)e);
            return null;
        }
    }
}

