/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsClassMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassconfDomain;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassconfService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsClassServiceImpl
extends BaseServiceImpl
implements RsGoodsClassService {
    private static final String SYS_CODE = "rs.RsGoodsClassServiceImpl";
    private RsGoodsClassMapper rsGoodsClassMapper;
    private RsFlowDataService rsFlowDataService;
    private RsGoodsClassconfService rsGoodsClassconfService;

    public void setRsGoodsClassconfService(RsGoodsClassconfService rsGoodsClassconfService) {
        this.rsGoodsClassconfService = rsGoodsClassconfService;
    }

    public void setRsGoodsClassMapper(RsGoodsClassMapper rsGoodsClassMapper) {
        this.rsGoodsClassMapper = rsGoodsClassMapper;
    }

    public void setRsFlowDataService(RsFlowDataService rsFlowDataService) {
        this.rsFlowDataService = rsFlowDataService;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsClassMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        if (null == rsGoodsClassDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setGoodsClassDefault(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return;
        }
        if (null == rsGoodsClass.getDataState()) {
            rsGoodsClass.setDataState(0);
        }
        if (null == rsGoodsClass.getGmtCreate()) {
            rsGoodsClass.setGmtCreate(this.getSysDate());
        }
        rsGoodsClass.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsGoodsClass.getGoodsClassCode())) {
            rsGoodsClass.setGoodsClassCode(this.createUUIDString());
        }
    }

    private int getGoodsClassMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsClassMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsClassUpdataDefault(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return;
        }
        rsGoodsClass.setGmtModified(this.getSysDate());
    }

    private void saveGoodsClassModel(RsGoodsClass rsGoodsClass) throws ApiException {
        if (null == rsGoodsClass) {
            return;
        }
        try {
            this.rsGoodsClassMapper.insert(rsGoodsClass);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveGoodsClassModel.ex", (Throwable)e);
        }
    }

    private void saveBatchGoodsClassModel(List<RsGoodsClass> rsGoodsClassList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassList)) {
            return;
        }
        try {
            this.rsGoodsClassMapper.insertBatch(rsGoodsClassList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveBatchGoodsClassModel.ex", (Throwable)e);
        }
    }

    private RsGoodsClass getGoodsClassModelById(Integer goodsClassId) {
        if (null == goodsClassId) {
            return null;
        }
        try {
            return this.rsGoodsClassMapper.selectByPrimaryKey(goodsClassId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassModelById", (Throwable)e);
            return null;
        }
    }

    public RsGoodsClass getGoodsClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsClassMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delGoodsClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.delGoodsClassModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.delGoodsClassModelByCode.num");
        }
    }

    private void deleteGoodsClassModel(Integer goodsClassId) throws ApiException {
        if (null == goodsClassId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.deleteByPrimaryKey(goodsClassId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.deleteGoodsClassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.deleteGoodsClassModel.num");
        }
    }

    private void updateGoodsClassModel(RsGoodsClass rsGoodsClass) throws ApiException {
        if (null == rsGoodsClass) {
            return;
        }
        try {
            this.rsGoodsClassMapper.updateByPrimaryKeySelective(rsGoodsClass);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClassModel.ex", (Throwable)e);
        }
    }

    private void updateStateGoodsClassModel(Integer goodsClassId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == goodsClassId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsClassId", goodsClassId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateGoodsClassModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateGoodsClassModel.null");
        }
    }

    private RsGoodsClass makeGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClassDomain) {
            return null;
        }
        if (null == rsGoodsClass) {
            rsGoodsClass = new RsGoodsClass();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClass, (Object)rsGoodsClassDomain);
            return rsGoodsClass;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.makeGoodsClass", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsClass> queryGoodsClassModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsClassMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.queryGoodsClassModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsClass(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.countGoodsClass", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        RsGoodsClass rsGoodsClass = this.saveGoods(rsGoodsClassDomain);
        this.processFLowDataForHtml(rsGoodsClass.getTenantCode());
        return rsGoodsClass.getGoodsClassCode();
    }

    private RsGoodsClass saveGoods(RsGoodsClassDomain rsGoodsClassDomain) {
        RsGoodsClass rsGoodsClass = this.makeModel(rsGoodsClassDomain);
        this.saveGoodsClassModel(rsGoodsClass);
        this.saveConfList(rsGoodsClass, rsGoodsClassDomain.getRsGoodsClassconfDomainList());
        return rsGoodsClass;
    }

    private RsGoodsClass makeModel(RsGoodsClassDomain rsGoodsClassDomain) {
        String msg = this.checkGoodsClass(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveGoodsClass.checkGoodsClass", msg);
        }
        RsGoodsClass rsGoodsClass = this.makeGoodsClass(rsGoodsClassDomain, null);
        this.setGoodsClassDefault(rsGoodsClass);
        return rsGoodsClass;
    }

    @Override
    public void saveGoodsClassList(List<RsGoodsClassDomain> rsGoodsClassDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomainList)) {
            this.logger.error("rs.RsGoodsClassServiceImpl.saveGoodsClassList", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        ArrayList<RsGoodsClass> rsGoodsClassList = new ArrayList<RsGoodsClass>();
        for (RsGoodsClassDomain rsGoodsClassDomain : rsGoodsClassDomainList) {
            RsGoodsClass rsGoodsClass = this.makeModel(rsGoodsClassDomain);
            if (null == rsGoodsClass) continue;
            rsGoodsClassList.add(rsGoodsClass);
            this.saveConfList(rsGoodsClass, rsGoodsClassDomain.getRsGoodsClassconfDomainList());
            if (rsGoodsClassList.size() != 100) continue;
            this.saveBatchGoodsClassModel(rsGoodsClassList);
            rsGoodsClassList = new ArrayList();
        }
        if (ListUtil.isNotEmpty(rsGoodsClassList)) {
            this.saveBatchGoodsClassModel(rsGoodsClassList);
        }
    }

    private void saveConfList(RsGoodsClass rsGoodsClass, List<RsGoodsClassconfDomain> rsGoodsClassconfDomainList) {
        if (null == rsGoodsClass || ListUtil.isEmpty(rsGoodsClassconfDomainList)) {
            return;
        }
        for (RsGoodsClassconfDomain rsGoodsClassconfDomain : rsGoodsClassconfDomainList) {
            rsGoodsClassconfDomain.setGoodsClassCode(rsGoodsClass.getGoodsClassCode());
            rsGoodsClassconfDomain.setTenantCode(rsGoodsClass.getTenantCode());
            rsGoodsClassconfDomain.setMemberCode(rsGoodsClass.getMemberCode());
            rsGoodsClassconfDomain.setMemberName(rsGoodsClass.getMemberName());
        }
        this.rsGoodsClassconfService.saveGoodsClassconfBatch(rsGoodsClassconfDomainList);
    }

    @Override
    public void updateGoodsClassState(Integer goodsClassId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGoodsClassModel(goodsClassId, dataState, oldDataState);
    }

    @Override
    public void updateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        String msg = this.checkGoodsClass(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClass.checkGoodsClass", msg);
        }
        RsGoodsClass oldRsGoodsClass = this.getGoodsClassModelById(rsGoodsClassDomain.getGoodsClassId());
        if (null == oldRsGoodsClass) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClass.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsClass rsGoodsClass = this.makeGoodsClass(rsGoodsClassDomain, oldRsGoodsClass);
        this.setGoodsClassUpdataDefault(rsGoodsClass);
        this.updateGoodsClassModel(rsGoodsClass);
        this.processFLowDataForHtml(rsGoodsClass.getTenantCode());
    }

    @Override
    public RsGoodsClassReDomain getGoodsClass(Integer goodsClassId) {
        return this.makeReDomain(this.getGoodsClassModelById(goodsClassId));
    }

    @Override
    public void deleteGoodsClass(Integer goodsClassId) throws ApiException {
        RsGoodsClass rsGoodsClass = this.getGoodsClassModelById(goodsClassId);
        this.deleteGoodsClassModel(goodsClassId);
        this.processFLowDataForHtml(rsGoodsClass.getTenantCode());
    }

    @Override
    public QueryResult<RsGoodsClass> queryGoodsClassPage(Map<String, Object> map) {
        List<RsGoodsClass> rsGoodsClassList = this.queryGoodsClassModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsClass(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsClassList);
        return queryResult;
    }

    @Override
    public RsGoodsClassReDomain getGoodsClassByCode(Map<String, Object> map) {
        return this.makeReDomain(this.getGoodsClassModelByCode(map));
    }

    private RsGoodsClassReDomain makeReDomain(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassReDomain = new RsGoodsClassReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClassReDomain, (Object)rsGoodsClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConf(rsGoodsClassReDomain);
        return rsGoodsClassReDomain;
    }

    private void setConf(RsGoodsClassReDomain rsGoodsClassReDomain) {
        if (null == rsGoodsClassReDomain) {
            return;
        }
        List<RsGoodsClassconfDomain> list = this.rsGoodsClassconfService.queryGoodsClassconfByClasscode(rsGoodsClassReDomain.getTenantCode(), rsGoodsClassReDomain.getGoodsClassCode());
        rsGoodsClassReDomain.setRsGoodsClassconfDomainList(list);
    }

    @Override
    public void delGoodsClassByCode(Map<String, Object> map) throws ApiException {
        RsGoodsClass rsGoodsClass = this.getGoodsClassModelByCode(map);
        this.delGoodsClassModelByCode(map);
        this.processFLowDataForHtml(rsGoodsClass.getTenantCode());
    }

    @Override
    public void processFLowDataForHtml(String tenantCode) {
        ArrayList<RsFlowData> rsFlowDataList = new ArrayList<RsFlowData>();
        RsFlowData rsFlowData = new RsFlowData();
        rsFlowData.setEsRequestType("update");
        rsFlowData.setTenantCode(tenantCode);
        rsFlowData.setFdBizCode("");
        rsFlowData.setFdBizType(4);
        rsFlowDataList.add(rsFlowData);
        this.logger.error("rs.RsGoodsClassServiceImpl.processFLowDataForHtml", (Object)tenantCode);
        this.rsFlowDataService.sendBatchFlowDataModel(rsFlowDataList);
    }

    @Override
    public void updateStateList(String tenantCode, Integer dataState, Integer oldDataState, String goodsClassHide) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || null == dataState || null == oldDataState || StringUtils.isBlank((String)goodsClassHide)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("goodsClassHide", goodsClassHide);
        this.updateStateListModel(map);
    }

    private void updateStateListModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsClassMapper.updateStateBatch(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateListModel.ex", (Throwable)e);
        }
    }

    @Override
    public void saveGoodsClassInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        QueryResult<RsGoodsClass> rsGoodsClassQueryResult = this.queryGoodsClassPage(this.getQueryMapParam("tenantCode", new Object[]{"00000000"}));
        if (null == rsGoodsClassQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassQueryResult.getList())) {
            return;
        }
        List rsGoodsClassList = rsGoodsClassQueryResult.getList();
        ArrayList<RsGoodsClassDomain> rsGoodsClassDomainList = new ArrayList<RsGoodsClassDomain>();
        for (RsGoodsClass rsGoodsClass : rsGoodsClassList) {
            RsGoodsClass oldRsGoodsClass = this.getGoodsClassModelByCode(this.getQueryMapParam("goodsClassCode,tenantCode", new Object[]{rsGoodsClass.getGoodsClassCode(), tenantCode}));
            if (null != oldRsGoodsClass) continue;
            RsGoodsClassDomain rsGoodsClassDomain = this.makeRsGoodsClassDomain(rsGoodsClass);
            rsGoodsClassDomain.setGoodsClassId(null);
            rsGoodsClassDomain.setTenantCode(tenantCode);
            rsGoodsClassDomainList.add(rsGoodsClassDomain);
        }
        this.saveGoodsClassList(rsGoodsClassDomainList);
    }

    private RsGoodsClassDomain makeRsGoodsClassDomain(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return null;
        }
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClassDomain, (Object)rsGoodsClass);
            return rsGoodsClassDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.makeRsGoodsClassDomain", (Throwable)e);
            return null;
        }
    }
}

