/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.BaseDomain;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataFinishMapper;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueBean;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.model.RsFlowdataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsProperties;
import com.yqbsoft.laser.service.resources.model.RsPropertiesOption;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.model.RsRessendApi;
import com.yqbsoft.laser.service.resources.model.RsRessendApiconf;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsRessendApiService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = "rs.RsFlowdataServiceImpl";
    private static EsEngineService esEngineService;
    private static Object lock;
    public static String DISCHANNEL_TYPE_ONLINE;
    public static String DISCHANNEL_TYPE_THRID;
    public static String DISCHANNEL_TYPE_STORE;
    public static String DISCHANNEL_SALE;
    public static String DISCHANNEL_CON;
    public static String DISCHANNEL_BUS;
    private RsFlowdataMapper rsFlowdataMapper;
    private RsFlowdataFinishMapper rsFlowdataFinishMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private RsRessendApiService rsRessendApiService;
    private RsGoodsClassService rsGoodsClassService;
    private RsPropertiesService rsPropertiesService;
    private RsPropertiesValueService rsPropertiesValueService;
    private RsResourceGoodsService rsResourceGoodsService;

    public RsFlowdataFinishMapper getRsFlowdataFinishMapper() {
        return this.rsFlowdataFinishMapper;
    }

    public void setRsFlowdataFinishMapper(RsFlowdataFinishMapper rsFlowdataFinishMapper) {
        this.rsFlowdataFinishMapper = rsFlowdataFinishMapper;
    }

    public RsSpecValueService getRsSpecValueService() {
        if (null == this.rsSpecValueService) {
            this.rsSpecValueService = (RsSpecValueService)ApplicationContextUtil.getService((String)"rsSpecValueService");
        }
        return this.rsSpecValueService;
    }

    public RsPropertiesService getRsPropertiesService() {
        if (null == this.rsPropertiesService) {
            this.rsPropertiesService = (RsPropertiesService)ApplicationContextUtil.getService((String)"rsPropertiesService");
        }
        return this.rsPropertiesService;
    }

    public RsPropertiesValueService getRsPropertiesValueService() {
        if (null == this.rsPropertiesValueService) {
            this.rsPropertiesValueService = (RsPropertiesValueService)ApplicationContextUtil.getService((String)"rsPropertiesValueService");
        }
        return this.rsPropertiesValueService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        if (null == this.rsResourceGoodsService) {
            this.rsResourceGoodsService = (RsResourceGoodsService)ApplicationContextUtil.getService((String)"rsResourceGoodsService");
        }
        return this.rsResourceGoodsService;
    }

    public void setRsRessendApiService(RsRessendApiService rsRessendApiService) {
        this.rsRessendApiService = rsRessendApiService;
    }

    public void setRsFlowdataMapper(RsFlowdataMapper rsFlowdataMapper) {
        this.rsFlowdataMapper = rsFlowdataMapper;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    public RsGoodsClassService getRsGoodsClassService() {
        if (null == this.rsGoodsClassService) {
            this.rsGoodsClassService = (RsGoodsClassService)ApplicationContextUtil.getService((String)"rsGoodsClassService");
        }
        return this.rsGoodsClassService;
    }

    private void saveRsFlowdataModel(RsFlowdata rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowdataMapper.insert(rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException("rs.RsFlowdataServiceImpl.saveRsFlowdataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowdataFinishModel(RsFlowdataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowdataFinishMapper.insert(rsFlowDataFinish);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException("rs.RsFlowdataServiceImpl.saveRsFlowdataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowdataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fdCode", fdCode);
        map.put("tenantCode", tenantCode);
        try {
            this.rsFlowdataMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        rsFlowDataList = this.saveBatchFlowDataList(rsFlowDataList);
        RsFlowDataServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(RsFlowDataServiceImpl.getEsEngineService(), rsFlowDataList));
    }

    private List<RsFlowdata> saveBatchFlowDataList(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return null;
        }
        for (RsFlowdata rsFlowData : rsFlowDataList) {
            rsFlowData.setDataState(1);
            rsFlowData.setGmtCreate(new Date());
            String fdCode1 = this.getNo(null, RsFlowdata.class.getSimpleName(), "fdCode", rsFlowData.getTenantCode());
            rsFlowData.setFdCode(fdCode1);
            if (!StringUtils.isNotBlank((String)rsFlowData.getSenddataCode())) continue;
        }
        this.insertBatchFlowDataModel(rsFlowDataList);
        return rsFlowDataList;
    }

    @Override
    public List<RsFlowdata> saveBatchFlowDataModel(List<RsFlowdata> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return null;
        }
        return this.saveBatchFlowDataList(rsFlowDataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((RsSenddataBaseService)SpringApplicationContextUtil.getBean((String)"rsSenddataBaseService"));
                for (int i = 0; i < 100; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private int countChannelsend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsFlowdataMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.countChannelsend", (Throwable)e);
        }
        return i;
    }

    public QueryResult<RsFlowdata> queryRsFlowdataPage(Map<String, Object> map) {
        List<RsFlowdata> disChannelsendList = this.rsFlowdataMapper.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelsend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelsendList);
        return queryResult;
    }

    private void loadDb() {
        try {
            this.logger.info("rs.RsFlowdataServiceImpl.loadDb.start");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<RsFlowdata> result = null;
            do {
                startRow = RsFlowDataServiceImpl.getEsEngineService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", RsFlowDataServiceImpl.getEsEngineService().getPage());
                result = this.queryRsFlowdataPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    RsFlowDataServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(RsFlowDataServiceImpl.getEsEngineService(), result.getRows()));
                    if (result.getRows().size() != RsFlowDataServiceImpl.getEsEngineService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            RsFlowDataServiceImpl.getEsEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("rs.RsFlowdataServiceImpl.loadDb.an.e", (Throwable)e);
        }
        this.logger.info("rs.RsFlowdataServiceImpl.loadDb.end");
    }

    @Override
    public List<RsSenddata> saveRsToEsAndStatic(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        if (null == rsFlowData.getChannelsendApiApicode()) {
            rsFlowData.setChannelsendApiApicode("");
        }
        if (rsFlowData.getChannelsendApiApicode().equals("RsResourceGoods") ? !this.sendGoods(rsFlowData, rsSenddataList) : (rsFlowData.getChannelsendApiApicode().equals("RsSku") ? !this.sendSku(rsFlowData) : (rsFlowData.getChannelsendApiApicode().equals("RsClasstree") ? !this.sendClass(rsFlowData) : (rsFlowData.getChannelsendApiApicode().equals("RsGoodsClass") ? !this.sendGoodsClass(rsFlowData) : (rsFlowData.getChannelsendApiApicode().equals("DisRsGoodsClass") ? !this.sendDisGoodsClass(rsFlowData) : (rsFlowData.getChannelsendApiApicode().equals("DisRsResourceGoods") ? !this.sendDisGoods(rsFlowData, rsSenddataList) : (rsFlowData.getChannelsendApiApicode().equals("DisRsSku") ? !this.sendDisSku(rsFlowData, rsSenddataList) : (rsFlowData.getChannelsendApiApicode().equals("CentDisRsResourceGoods") ? !this.sendCentDisGoods(rsFlowData, rsSenddataList) : (rsFlowData.getChannelsendApiApicode().equals("CentDisRsSku") ? !this.sendCentDisSku(rsFlowData, rsSenddataList) : (rsFlowData.getChannelsendApiApicode().equals("outGoods") ? !this.sendOutGoods(rsFlowData) : rsFlowData.getChannelsendApiApicode().equals("dataUpdate") && !this.sendDataUpdateGoods(rsFlowData))))))))))) {
            return null;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowdataFinish rsFlowDataFinish = new RsFlowdataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
            rsFlowDataFinish.setFdId(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.saveRsFlowdataFinishModel(rsFlowDataFinish);
        return rsSenddataList;
    }

    private boolean sendDataUpdateGoods(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        RsResourceGoodsDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            return false;
        }
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        if (ListUtil.isEmpty(rsSkuDomainList)) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
            if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
            rsSkuDomain = rsSkuDomain2;
            break;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        if (null == rsSkuDomain) {
            return false;
        }
        Integer dataState = 0;
        if (null == rsSkuDomain || rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") || rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop")) {
            dataState = rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") ? 2 : 3;
        } else if (!"add".equals(rsFlowData.getEsrequestType())) {
            if (rsSkuDomain.getGoodsSupplynum().intValue() <= 0) {
                dataState = 1;
            }
            map.put("dataState", dataState);
            if (rsFlowData.getEsrequestType().equals("edit")) {
                map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
                map.put("partsnameNumunit", rsSkuDomain.getPartsnameNumunit());
                map.put("partsnameWeightunit", rsSkuDomain.getPartsnameWeightunit());
                map.put("goodsMinnum", rsSkuDomain.getGoodsMinnum());
                map.put("goodsOneweight", rsSkuDomain.getGoodsOneweight());
            } else if (rsFlowData.getEsrequestType().equals("insert")) {
                String goodsName = rsSkuDomain.getGoodsName();
                if (StringUtils.isBlank((String)goodsName)) {
                    return false;
                }
                map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
                map.put("goodsSupplyweight", rsSkuDomain.getGoodsSupplyweight());
                map.put("dataPic", rsSkuDomain.getDataPic());
                map.put("goodsName", goodsName);
                map.put("partsnameNumunit", rsSkuDomain.getPartsnameNumunit());
                map.put("partsnameWeightunit", rsSkuDomain.getPartsnameWeightunit());
                map.put("goodsMinnum", rsSkuDomain.getGoodsMinnum());
                map.put("goodsOneweight", rsSkuDomain.getGoodsOneweight());
            } else {
                map.put("goodsSupplynum", rsSkuDomain.getGoodsSupplynum());
            }
        }
        map.put("dataState", dataState);
        if (!this.sendDataUpdateGood(map, "um.collect.updateCollectByOpCode").booleanValue()) {
            return false;
        }
        if (!this.sendDataUpdateGood(map, "um.footprint.updateFootprintByOpCode").booleanValue()) {
            return false;
        }
        return this.sendDataUpdateGood(map, "oc.shopping.updateShopGoodsBySkuCode") != false;
    }

    private Boolean sendDataUpdateGood(Map<String, Object> paramMap, String api) {
        if (null == paramMap || null == api) {
            return false;
        }
        HashMap<String, String> paramMapStr = new HashMap<String, String>();
        paramMapStr.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        try {
            this.getInternalRouter().inInvoke(api, paramMapStr);
            return true;
        }
        catch (ApiException e) {
            this.logger.error("rsFlowDataServiceImpl.sendDataUpdateGood.ex", (Throwable)e);
            return false;
        }
    }

    private boolean sendOutGoods(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        if (null == rsResourceGoodsReDomain) {
            return false;
        }
        Map paramMap = this.getQueryParamMap("tenantCode", new Object[]{rsFlowData.getTenantCode()});
        if (null != paramMap) {
            QueryResult<RsRessendApi> ressendApiResult = this.rsRessendApiService.queryRessendApiPage(paramMap);
            if (null == ressendApiResult || ListUtil.isEmpty((Collection)ressendApiResult.getList())) {
                return true;
            }
            List<RsRessendApi> listRessendApi = this.structureApi(ressendApiResult.getList(), rsResourceGoodsReDomain);
            if (ListUtil.isEmpty(listRessendApi)) {
                return true;
            }
            for (RsRessendApi rsRessendApi : listRessendApi) {
                HashMap<String, String> paramMap1 = new HashMap<String, String>();
                paramMap1.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
                String result = (String)this.getInternalRouter().inInvoke(rsRessendApi.getRessendApiApicode(), "1.0", "0", paramMap1);
                if (!StringUtils.isEmpty((String)result) && !"false".equals(result)) continue;
                this.logger.error("\u672a\u6210\u529f\u5904\u7406\u7684api *****" + rsRessendApi.getRessendApiCode() + "*****" + rsFlowData.getFdBizcode());
                return false;
            }
        }
        return true;
    }

    private List<RsRessendApi> structureApi(List<RsRessendApi> ressendApiList, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        ArrayList<RsRessendApi> sendApiList = new ArrayList<RsRessendApi>();
        for (RsRessendApi rsRessendApi : ressendApiList) {
            List apiconfList;
            Map<String, List<String>> map;
            HashMap<String, Object> apiconfMap = new HashMap<String, Object>();
            apiconfMap.put("ressendApiApicode", rsRessendApi.getRessendApiApicode());
            apiconfMap.put("tenantCode", rsRessendApi.getTenantCode());
            QueryResult<RsRessendApiconf> apiconf = this.rsRessendApiService.queryRessendApiconfPage(apiconfMap);
            if (null == apiconf || apiconf.getList().size() <= 0) {
                sendApiList.add(rsRessendApi);
            }
            if (null == (map = this.makeRessendScopelist(apiconfList = apiconf.getList())) || map.isEmpty()) continue;
            boolean flag = true;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                if (null == objValue) {
                    flag = false;
                    break;
                }
                if (map.get(key).contains(objValue.toString())) continue;
                flag = false;
                break;
            }
            if (!flag || sendApiList.contains(rsRessendApi)) continue;
            sendApiList.add(rsRessendApi);
        }
        return sendApiList;
    }

    private Map<String, List<String>> makeRessendScopelist(List<RsRessendApiconf> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RsRessendApiconf rsRessendApiconf : apiconfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(rsRessendApiconf.getRessendApiconfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(rsRessendApiconf.getRessendApiconfType(), list);
            }
            list.add(rsRessendApiconf.getRessendApiconfOp());
        }
        return map;
    }

    private boolean sendDisGoodsClass(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return true;
        }
        RsGoodsClass rsGoodsClass = (RsGoodsClass)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsGoodsClass.class);
        if (null == rsGoodsClass) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoodsClass.rsGoodsClass", (Object)(rsFlowData.getFdCode() + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return false;
        }
        List<DisChannel> disChannelList = this.queryThirdChannel(rsGoodsClass.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isEmpty(disChannelList)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoodsClass.disChannelList", (Object)(rsGoodsClass.getMemberCode() + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
            return true;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        for (DisChannel disChannel : disChannelList) {
            DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
            disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
            disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
            disChannelsendDomain.setChannelsendTxt(rsFlowData.getFdBizcodestr());
            disChannelsendDomain.setChannelsendType("RsGoodsClass");
            disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
            disChannelsendDomainList.add(disChannelsendDomain);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendGoodsClass(RsFlowdata rsFlowData) {
        String memberCode;
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "";
        }
        if (StringUtils.isBlank((String)(memberCode = rsFlowData.getFdBizcode()))) {
            memberCode = "";
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsGoodsClass");
        htmlRelease.setHtmldataFilename("goodsclass.html");
        htmlRelease.setHtmldataFilepath("goodsclass");
        htmlRelease.setHtmldataMenu(channelCode);
        htmlRelease.setHtmlcontOpparam(rsFlowData.getFdBizcodestr());
        return this.sendHtml(htmlRelease);
    }

    private boolean sendClass(RsFlowdata rsFlowData) {
        String memberCode;
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "";
        }
        if (StringUtils.isBlank((String)(memberCode = rsFlowData.getFdBizcode()))) {
            memberCode = "";
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsClasstree");
        htmlRelease.setHtmldataFilename("classtree.html");
        htmlRelease.setHtmldataFilepath("classtree");
        htmlRelease.setHtmldataMenu(channelCode);
        htmlRelease.setHtmlcontOpparam(rsFlowData.getFdBizcodestr());
        return this.sendHtml(htmlRelease);
    }

    private List<RsGoodsClass> queryByClasstreeCode(String classtreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rsFlowDataServiceImpl.queryByClasstreeCode", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", tenantCode);
        QueryResult<RsGoodsClass> queryResult = this.getRsGoodsClassService().queryGoodsClassPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("rsFlowDataServiceImpl.queryByClasstreeCode", (Object)"return is null");
            return null;
        }
        ArrayList<RsGoodsClass> reGoodsClassList = new ArrayList<RsGoodsClass>();
        for (RsGoodsClass rsGoodsClass : queryResult.getList()) {
            reGoodsClassList.add(this.makeRsRsGoodsClass(rsGoodsClass));
        }
        return reGoodsClassList;
    }

    private RsGoodsClass makeRsRsGoodsClass(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass || rsGoodsClass.getGoodsClassParentcode().equals("-1")) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsClassCode", rsGoodsClass.getGoodsClassParentcode());
        map.put("tenantCode", rsGoodsClass.getTenantCode());
        QueryResult<RsGoodsClass> queryResult = this.getRsGoodsClassService().queryGoodsClassPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("rsFlowDataServiceImpl.makeRsRsGoodsClass", (Object)"return is null");
            return null;
        }
        RsGoodsClass rsGoodsClass1 = (RsGoodsClass)queryResult.getList().get(0);
        ArrayList<RsGoodsClass> childList = new ArrayList<RsGoodsClass>();
        childList.add(rsGoodsClass);
        rsGoodsClass1.setChildList(childList);
        if (!rsGoodsClass1.getGoodsClassParentcode().equals("-1")) {
            ArrayList<RsGoodsClass> rsGoodsClasses = new ArrayList<RsGoodsClass>();
            RsGoodsClass rsGoodsClass2 = this.makeRsRsGoodsClass(rsGoodsClass1);
            if (null == rsGoodsClass2) {
                return rsGoodsClass1;
            }
            rsGoodsClasses.add(rsGoodsClass1);
            rsGoodsClass2.setChildList(rsGoodsClasses);
            return rsGoodsClass2;
        }
        return rsGoodsClass1;
    }

    private boolean sendSku(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(rsFlowData.getTenantCode());
        htmlRelease.setHtmldataCode("RsSku");
        htmlRelease.setHtmldataFilename(rsFlowData.getFdBizcode() + ".html");
        htmlRelease.setHtmldataFilepath("sku");
        HashMap<String, Object> htmlMap = new HashMap<String, Object>();
        htmlMap.put("esRequestType", rsFlowData.getEsrequestType());
        htmlMap.put("channelCode", rsFlowData.getChannelCode());
        htmlMap.put("memberCode", rsFlowData.getMemberCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (!"delete".equals(rsFlowData.getEsrequestType()) && !"skudelete".equals(rsFlowData.getEsrequestType())) {
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.rsResourceGoodsReDomain", (Object)rsFlowData.getFdCode());
                return false;
            }
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isEmpty(rsSkuDomainList)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.rsSkuDomainList", (Object)rsFlowData.getFdCode());
                return false;
            }
            if (null == rsSkuDomain) {
                for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                    if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                    rsSkuDomain = rsSkuDomain2;
                    break;
                }
            }
            if (null == rsSkuDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            }
            if (!this.makeHtml(rsFlowData, rsSkuDomain, htmlMap, rsResourceGoodsReDomain)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendSku.makeHtml", (Object)rsFlowData.getFdCode());
                return false;
            }
        }
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
        if (!this.sendHtml(htmlRelease)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendSku.sendHtml", (Object)rsFlowData.getFdCode());
            return false;
        }
        StoreDomain storeDomain = new StoreDomain();
        if (!(rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop") || "skudelete".equals(rsFlowData.getEsrequestType()) || "skudeleteop".equals(rsFlowData.getEsrequestType()))) {
            this.makeEsSku(rsResourceGoodsReDomain, storeDomain, rsSkuDomain);
        }
        storeDomain.setRequestType(rsFlowData.getEsrequestType());
        storeDomain.setBizType("sku");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsFlowData.getFdBizcode());
        return this.sendEs(storeDomain);
    }

    private boolean sendEs(StoreDomain storeDomain) {
        if (null == storeDomain) {
            return false;
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendEs.result", (Object)result);
            return false;
        }
        return true;
    }

    private boolean sendHtml(HtmlRelease htmlRelease) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        try {
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            return true;
        }
        catch (Exception e) {
            this.logger.error("rsFlowDataServiceImpl.sendHtml.ex", (Throwable)e);
            return false;
        }
    }

    private List<RsPropertiesValueBean> makeRsPropertiesValue(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        List propertiesValueList = rsResourceGoodsReDomain.getRsPropertiesValueDomainList();
        if (ListUtil.isEmpty(propertiesValueList)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            map.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
            QueryResult<RsPropertiesValue> qlist = this.getRsPropertiesValueService().queryPropertiesValuePage(map);
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                propertiesValueList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)qlist.getList()), RsPropertiesValueDomain.class);
            }
        }
        if (ListUtil.isEmpty(propertiesValueList)) {
            return null;
        }
        ArrayList<RsPropertiesValueBean> rsPropertiesValueBeanList = new ArrayList<RsPropertiesValueBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (RsPropertiesValueDomain rsPropertiesValueDomain : propertiesValueList) {
            RsPropertiesValueBean rsPropertiesValueBean = new RsPropertiesValueBean();
            rsPropertiesValueBeanList.add(rsPropertiesValueBean);
            try {
                BeanUtils.copyAllPropertys((Object)rsPropertiesValueBean, (Object)rsPropertiesValueDomain);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (StringUtils.isBlank((String)rsPropertiesValueBean.getPropertiesName())) {
                map.put("propertiesCode", rsPropertiesValueBean.getPropertiesCode());
                map.put("tenantCode", rsPropertiesValueBean.getTenantCode());
                RsProperties rsProperties = this.getRsPropertiesService().getPropertiesByCode(map);
                if (null != rsProperties) {
                    rsPropertiesValueBean.setPropertiesName(rsProperties.getPropertiesName());
                }
            }
            rsPropertiesValueBean.setPropertiesValueName(rsPropertiesValueBean.getPropertiesValueValue());
            if (!"0".equals(rsPropertiesValueBean.getPropertiesValueType())) continue;
            map.put("propertiesOptionCode", rsPropertiesValueBean.getPropertiesValueValue());
            map.put("tenantCode", rsPropertiesValueBean.getTenantCode());
            RsPropertiesOption rsPropertiesOption = this.getRsPropertiesService().getPropertiesOptionByCode(map);
            if (null == rsPropertiesOption) continue;
            rsPropertiesValueBean.setPropertiesValueName(rsPropertiesOption.getPropertiesOptionName());
        }
        return rsPropertiesValueBeanList;
    }

    private boolean makeHtml(RsFlowdata rsFlowData, RsSkuDomain rsSkuDomain, Map<String, Object> htmlMap, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsFlowData || null == rsSkuDomain || null == rsResourceGoodsReDomain || null == htmlMap) {
            return false;
        }
        htmlMap.put("goods", rsResourceGoodsReDomain);
        htmlMap.put("goodsClassList", this.queryByClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode(), rsResourceGoodsReDomain.getTenantCode()));
        List<RsPropertiesValueBean> rsPropertiesValueBeanList = this.makeRsPropertiesValue(rsResourceGoodsReDomain);
        htmlMap.put("propertiesList", rsPropertiesValueBeanList);
        List<RsSpecValueDomain> rsSpecValueDomainList = rsResourceGoodsReDomain.getRsSpecValueDomainList();
        HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
        if (ListUtil.isEmpty(rsSpecValueDomainList)) {
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
            svMap.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.getRsSpecValueService().querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                for (RsSpecValue rsSpecValue : rsSpecValueListResult.getList()) {
                    String specName = rsSpecValue.getSpecName();
                    ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                    if (null == specValueList || specValueList.size() == 0) {
                        specValueList = new ArrayList<String>();
                    }
                    specValueList.add(rsSpecValue.getSpecValueValue());
                    if (!StringUtils.isNotBlank((String)specName)) continue;
                    specValueMap.put(specName, specValueList);
                }
            } else {
                this.logger.error("rs.RsFlowdataServiceImpl.makeHtml.RsSpecValue", (Object)rsFlowData.getFdCode());
            }
        } else {
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                String specName = rsSpecValueDomain.getSpecName();
                ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                if (null == specValueList || specValueList.size() == 0) {
                    specValueList = new ArrayList<String>();
                }
                specValueList.add(rsSpecValueDomain.getSpecValueValue());
                if (!StringUtils.isNotBlank((String)specName)) continue;
                specValueMap.put(specName, specValueList);
            }
        }
        htmlMap.put("spec", specValueMap);
        htmlMap.put("rsSku", rsSkuDomain);
        List<RsGoodsRelDomain> rsGoodsRelList = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
        ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
        if (ListUtil.isNotEmpty(rsGoodsRelList)) {
            for (RsGoodsRelDomain rsGoodsRel : rsGoodsRelList) {
                QueryResult<RsSkuDomain> rsSkuList1;
                RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                if (null == rsResourceGoodsReDomain1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                RsSkuDomain rsSku1 = (RsSkuDomain)rsSkuList1.getList().get(0);
                rsSku1.setGoodsName(rsResourceGoodsReDomain1.getGoodsName());
                rsSkuList.add(rsSku1);
            }
        }
        htmlMap.put("rsSkuRel", rsSkuList);
        return true;
    }

    private boolean sendCentDisSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData) {
            return false;
        }
        List<DisChannel> centchannelList = this.queryCenterChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isNotEmpty(centchannelList)) {
            for (DisChannel disChannel : centchannelList) {
                this.sendDisSku(rsFlowData, disChannel);
            }
        }
        return true;
    }

    private boolean sendDisSku(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<DisChannel> channelList;
        if (null == rsFlowData) {
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            DisChannel disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisSku(rsFlowData, disChannel);
            }
        }
        if (ListUtil.isEmpty(channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode()))) {
            return true;
        }
        String skuOldcode = rsFlowData.getFdBizcode();
        String tenantCode = rsFlowData.getTenantCode();
        List<RsSenddata> skursSenddataList = null;
        if ("skudelete".equals(rsFlowData.getEsrequestType())) {
            skursSenddataList = this.getRsResourceGoodsService().deleteDisSku(skuOldcode, null, tenantCode);
        } else if ("skuinsert".equals(rsFlowData.getEsrequestType())) {
            List<DisRsSkuDomain> disRsSkuList = this.getDisRsSkuList(rsFlowData, channelList);
            if (ListUtil.isEmpty(disRsSkuList)) {
                return null != disRsSkuList;
            }
            skursSenddataList = this.getRsResourceGoodsService().saveDisSku(disRsSkuList);
        } else if ("edit".equals(rsFlowData.getEsrequestType())) {
            List<DisRsSkuDomain> disRsSkuList = this.getDisRsSkuList(rsFlowData, channelList);
            if (ListUtil.isEmpty(disRsSkuList)) {
                return null != disRsSkuList;
            }
            skursSenddataList = this.getRsResourceGoodsService().saveDisSkuEdit(disRsSkuList);
        } else if ("skudeleteop".equals(rsFlowData.getEsrequestType()) || "skuadd".equals(rsFlowData.getEsrequestType())) {
            List<RsSkuDomain> rsSkuDomainList;
            RsResourceGoodsDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (ListUtil.isEmpty(rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList())) {
                return false;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", skuOldcode);
            map.put("tenantCode", tenantCode);
            RsSkuDomain rsSkuDomain = null;
            for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
                rsSkuDomain = rsSkuDomain2;
                break;
            }
            if (null == rsSkuDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            }
            map.put("dataState", rsFlowData.getFdState());
            skursSenddataList = this.getRsResourceGoodsService().updateDisCannelSkuState(map);
        } else if ("skudown".equals(rsFlowData.getEsrequestType())) {
            skursSenddataList = this.getRsResourceGoodsService().updateDisCannelSku(skuOldcode, null, tenantCode);
        }
        if (ListUtil.isNotEmpty(skursSenddataList)) {
            rsSenddataList.addAll(skursSenddataList);
        }
        return true;
    }

    private List<DisRsSkuDomain> getDisRsSkuList(RsFlowdata rsFlowData, List<DisChannel> channelList) {
        RsResourceGoodsDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        if (ListUtil.isEmpty(rsSkuDomainList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
            if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizcode())) continue;
            rsSkuDomain = rsSkuDomain2;
            break;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        }
        List<DisRsSkuDomain> disRsSkuList = this.makeDisSku((RsResourceGoodsReDomain)rsResourceGoodsReDomain, rsSkuDomain, channelList);
        return disRsSkuList;
    }

    private List<DisChannel> queryCenterChannel(String memberCode, String tenantCode) {
        return DisUtil.getMapListJson((String)"DisChannel-channelMemcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class);
    }

    private List<DisChannel> queryThirdChannel(String memberCode, String tenantCode) {
        return DisUtil.getMapListJson((String)"DisChannel-thirdmemberCode", (String)(memberCode + "-" + DISCHANNEL_TYPE_THRID + "-" + tenantCode), DisChannel.class);
    }

    private List<DisChannel> queryChannel(String memberCode, String tenantCode) {
        List memchannelList1;
        DisChannel memchannel;
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        List memchannelList = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class);
        if (ListUtil.isNotEmpty((Collection)memchannelList)) {
            channelList.addAll(memchannelList);
        }
        if (null != (memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-memberCcode", (String)(memberCode + "-" + DISCHANNEL_CON + "-" + tenantCode), DisChannel.class))) {
            channelList.add(memchannel);
        }
        if (ListUtil.isNotEmpty((Collection)(memchannelList1 = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_BUS + "-" + tenantCode), DisChannel.class)))) {
            channelList.addAll(memchannelList1);
        }
        return channelList;
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private boolean sendDisSku(RsFlowdata rsFlowData, DisChannel disChannel) {
        if (null == rsFlowData || null == disChannel) {
            return false;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        String channelsendTxt = "";
        HashMap<String, BaseDomain> datamap = new HashMap<String, BaseDomain>();
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            channelsendTxt = rsFlowData.getFdBizcodestr();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsSkuDomain rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.rsSkuDomain", (Object)((Object)map).toString());
                return false;
            }
            datamap.put("rsSku", rsSkuDomain);
            map.put("goodsCode", rsSkuDomain.getGoodsCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDis.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            DisDgoods disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, disChannel);
            if (null == disDgoods) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisSku.disDgoods", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                return false;
            }
            datamap.put("rsResourceGoods", rsResourceGoodsReDomain);
            channelsendTxt = JsonUtil.buildNormalBinder().toJson(datamap);
        }
        disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
        disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
        disChannelsendDomain.setChannelsendTxt(channelsendTxt);
        disChannelsendDomain.setChannelsendType("RsSku");
        disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendDisGoods(RsFlowdata rsFlowData, DisChannel disChannel) {
        if (null == rsFlowData || null == disChannel) {
            return false;
        }
        String apiCode = "dis.channelsendBase.sendChannelsendBatch";
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        String channelsendTxt = rsFlowData.getFdBizcodestr();
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            channelsendTxt = rsFlowData.getFdBizcodestr();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            DisDgoods disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, disChannel);
            if (null == disDgoods) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.disDgoods", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
                return false;
            }
            channelsendTxt = JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain);
        }
        disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
        disChannelsendDomain.setChannelsendDir(rsFlowData.getEsrequestType());
        disChannelsendDomain.setChannelsendTxt(channelsendTxt);
        disChannelsendDomain.setChannelsendType("RsResourceGoods");
        disChannelsendDomain.setTenantCode(rsFlowData.getTenantCode());
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
        return true;
    }

    private boolean sendCentDisGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        List<DisChannel> centchannelList = this.queryCenterChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (ListUtil.isNotEmpty(centchannelList)) {
            for (DisChannel disChannel : centchannelList) {
                this.sendDisGoods(rsFlowData, disChannel);
            }
        }
        return true;
    }

    private boolean sendDisGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        List<DisChannel> channelList;
        if (null == rsFlowData || null == rsSenddataList) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        String channelCode = rsFlowData.getChannelCode();
        if (StringUtils.isNotBlank((String)channelCode)) {
            DisChannel disChannel = this.getChannel(channelCode, rsFlowData.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.disChannel", (Object)(channelCode + "-" + rsFlowData.getTenantCode() + "-" + rsFlowData.getFdCode()));
                return false;
            }
            if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                return this.sendDisGoods(rsFlowData, disChannel);
            }
        }
        if (ListUtil.isEmpty(channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode()))) {
            return true;
        }
        String goodsOldcode = rsFlowData.getFdBizcode();
        String tenantCode = rsFlowData.getTenantCode();
        List<RsSenddata> goodsrsSenddataList = null;
        if ("delete".equals(rsFlowData.getEsrequestType())) {
            goodsrsSenddataList = this.getRsResourceGoodsService().deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsrequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList = this.makeDisGoods(rsResourceGoodsReDomain, channelList);
            if (!ListUtil.isEmpty(disRsResourceGoodsList)) {
                goodsrsSenddataList = this.getRsResourceGoodsService().saveDisResourceGoods(disRsResourceGoodsList);
            }
        } else if ("deleteop".equals(rsFlowData.getEsrequestType()) || "add".equals(rsFlowData.getEsrequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizcode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
            if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
                rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
            }
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            }
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            map.put("dataState", rsFlowData.getFdState());
            goodsrsSenddataList = this.getRsResourceGoodsService().updateDisCannelGoodsState(map);
        } else if ("down".equals(rsFlowData.getEsrequestType())) {
            goodsrsSenddataList = this.getRsResourceGoodsService().updateDisCannelGoods(goodsOldcode, null, tenantCode);
        }
        if (ListUtil.isNotEmpty(goodsrsSenddataList)) {
            rsSenddataList.addAll(goodsrsSenddataList);
        }
        return true;
    }

    private boolean checkChannelEnd(String channelCode, String tenantCode, List<DisChannel> channelList) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(channelList)) {
            return true;
        }
        DisChannel oldDisChannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (null != oldDisChannel && "0".equals(oldDisChannel.getChannelType()) && "2".equals(oldDisChannel.getChannelSort())) {
            return false;
        }
        for (DisChannel toDisChannel : channelList) {
            if ("1".equals(oldDisChannel.getChannelType()) && "1".equals(toDisChannel.getChannelSort()) && oldDisChannel.getMemberMcode().equals(toDisChannel.getMemberCode()) && oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) {
                return false;
            }
            if (!"0".equals(oldDisChannel.getChannelType()) || !"1".equals(toDisChannel.getChannelSort()) && !"2".equals(toDisChannel.getChannelSort()) || !oldDisChannel.getMemberCode().equals(toDisChannel.getMemberCode()) || !oldDisChannel.getMemberCcode().equals(toDisChannel.getMemberCcode())) continue;
            return false;
        }
        return true;
    }

    private List<DisRsSkuDomain> makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || null == rsSkuDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode(), channelList)) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disList = new ArrayList<DisRsSkuDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel, disRsResourceGoodsDomain.getDgoodsPut());
            disList.add(disRsSkuDomain);
            this.makePice(disRsResourceGoodsDomain, disRsSkuDomain, disChannel);
            this.makeNum(disRsResourceGoodsDomain, disRsSkuDomain, disChannel);
        }
        return disList;
    }

    private DisRsSkuDomain makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel, String dgoodsPut) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        rsSkuDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberCcode());
        rsSkuDomain.setMemberCname(rsResourceGoodsReDomain.getMemberCname());
        rsSkuDomain.setGoodsOrigin(rsResourceGoodsReDomain.getGoodsOrigin());
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            if (StringUtils.isNotBlank((String)dgoodsPut)) {
                disRsSkuDomain.setDgoodsPut(dgoodsPut);
            }
            disRsSkuDomain.setPricesetOldMakeprice(rsSkuDomain.getPricesetMakeprice());
            disRsSkuDomain.setPricesetOldNprice(rsSkuDomain.getPricesetNprice());
            disRsSkuDomain.setPricesetOldRefrice(rsSkuDomain.getPricesetRefrice());
            disRsSkuDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsSkuDomain.setSkuShowno(rsSkuDomain.getSkuNo());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private List<DisRsResourceGoodsDomain> makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode(), channelList)) {
            return null;
        }
        ArrayList<DisRsResourceGoodsDomain> disList = new ArrayList<DisRsResourceGoodsDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(disRsResourceGoodsDomain);
        }
        return disList;
    }

    private DisRsResourceGoodsDomain makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, String dgoodsPut) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        String nowChannelCode = rsResourceGoodsReDomain.getChannelCode();
        if (null == nowChannelCode) {
            nowChannelCode = "";
        }
        if (nowChannelCode.equals(disChannel.getChannelCode())) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisGoods.nowChannelCode", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = new DisRsResourceGoodsDomain();
        try {
            QueryResult<RsGoodsClass> qglist;
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoodsReDomain);
            disRsResourceGoodsDomain.setGoodsShowname(rsResourceGoodsReDomain.getGoodsName());
            disRsResourceGoodsDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            disRsResourceGoodsDomain.setPricesetOldNprice(rsResourceGoodsReDomain.getPricesetNprice());
            disRsResourceGoodsDomain.setPricesetOldMakeprice(rsResourceGoodsReDomain.getPricesetMakeprice());
            disRsResourceGoodsDomain.setPricesetOldRefrice(rsResourceGoodsReDomain.getPricesetRefrice());
            if (DISCHANNEL_TYPE_STORE.equals(disChannel.getChannelType())) {
                disRsResourceGoodsDomain.setGoodsOrigin("17");
            } else if (DISCHANNEL_TYPE_THRID.equals(disChannel.getChannelType())) {
                disRsResourceGoodsDomain.setGoodsOrigin("18");
            } else if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("12");
                disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            } else if (DISCHANNEL_SALE.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("11");
            } else if (DISCHANNEL_BUS.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("13");
            }
            if (StringUtils.isBlank((String)disRsResourceGoodsDomain.getClasstreeShopcode()) && null != (qglist = this.rsGoodsClassService.queryGoodsClassPage(this.getQueryMapParam("classtreeCode,tenantCode", new Object[]{disRsResourceGoodsDomain.getClasstreeCode(), disRsResourceGoodsDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qglist.getList()) && qglist.getList().size() == 1) {
                disRsResourceGoodsDomain.setClasstreeShopcode(((RsGoodsClass)qglist.getList().get(0)).getGoodsClassCode());
                disRsResourceGoodsDomain.setClasstreeShopname(((RsGoodsClass)qglist.getList().get(0)).getGoodsClassName());
            }
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            if (null != rsResourceGoodsReDomain.getRsSpecValueDomainList() && rsResourceGoodsReDomain.getRsSpecValueDomainList().size() > 0) {
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomainList.add(rsSpecValueDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
            if (null != rsResourceGoodsReDomain.getRsGoodsFileDomainList() && rsResourceGoodsReDomain.getRsGoodsFileDomainList().size() > 0) {
                for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
            if (null != rsResourceGoodsReDomain.getRsGoodsRelDomainList() && rsResourceGoodsReDomain.getRsGoodsRelDomainList().size() > 0) {
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
            if (null != rsResourceGoodsReDomain.getRsPropertiesValueDomainList() && rsResourceGoodsReDomain.getRsPropertiesValueDomainList().size() > 0) {
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsPropertiesValueDomainList(rsPropertiesValueDomains);
            disRsResourceGoodsDomain.setPricesetAsprice(disRsResourceGoodsDomain.getPricesetNprice());
            disRsResourceGoodsDomain.setPricesetInsideprice(disRsResourceGoodsDomain.getPricesetRefrice());
            if ("1".equals(dgoodsPut)) {
                disRsResourceGoodsDomain.setDataOpbillstate(1);
                disRsResourceGoodsDomain.setDgoodsPut(dgoodsPut);
            } else if ("0".equals(dgoodsPut)) {
                disRsResourceGoodsDomain.setDataOpbillstate(0);
                disRsResourceGoodsDomain.setDgoodsPut(dgoodsPut);
            }
            disRsResourceGoodsDomain.setDisRsSkuDomainList(this.makeDisSkuList(rsResourceGoodsReDomain.getRsSkuDomainList(), rsResourceGoodsReDomain, disChannel, dgoodsPut));
        }
        catch (Exception e) {
            this.logger.error("rs.RsFlowdataServiceImpl.makeDisGoods.e", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<DisRsSkuDomain> makeDisSkuList(List<RsSkuDomain> rsSkuDomainList, RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, String dgoodsPut) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disRsSkuDomainList = new ArrayList<DisRsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel, dgoodsPut);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomain.setPricesetAsprice(disRsSkuDomain.getPricesetNprice());
            disRsSkuDomain.setPricesetInsideprice(disRsSkuDomain.getPricesetRefrice());
            try {
                ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
                if (null != rsSkuDomain.getPropertiesList() && rsSkuDomain.getPropertiesList().size() > 0) {
                    for (RsPropertiesValueDomain rsPropertiesValueDomain : rsSkuDomain.getPropertiesList()) {
                        RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                        BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                        rsPropertiesValueDomain1.setPropertiesValueId(null);
                        rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                        rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                    }
                }
                disRsSkuDomain.setPropertiesList(rsPropertiesValueDomains);
                ArrayList<RsSpecValueDomain> rsSpecValueDomains = new ArrayList<RsSpecValueDomain>();
                if (null != rsSkuDomain.getSpecList() && rsSkuDomain.getSpecList().size() > 0) {
                    for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
                        RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                        BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                        rsSpecValueDomain1.setSpecValueId(null);
                        rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                        rsSpecValueDomains.add(rsSpecValueDomain1);
                    }
                }
                disRsSkuDomain.setSpecList(rsSpecValueDomains);
                ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
                if (null != rsSkuDomain.getRsGoodsFileDomainList() && rsSkuDomain.getRsGoodsFileDomainList().size() > 0) {
                    for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                        RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                        BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                        rsGoodsFileDomain1.setGoodsFileId(null);
                        rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                        rsGoodsFileDomains.add(rsGoodsFileDomain1);
                    }
                }
                disRsSkuDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
                ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
                if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
                    for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                        RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                        BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                        rsGoodsRelDomain1.setGoodsRelId(null);
                        rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                        rsGoodsRelDomains.add(rsGoodsRelDomain1);
                    }
                }
                disRsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
                disRsSkuDomainList.add(disRsSkuDomain);
            }
            catch (Exception e) {
                return null;
            }
        }
        return disRsSkuDomainList;
    }

    private DisDgoods checkDgoods(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoods.class);
        if (null == disDgoods) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.disDgoods", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        if (!"1".equals(disDgoods.getDgoodsSync())) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.dgoodsSync", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disDgoods;
    }

    private DisDgoods checkDisGoodsChannel(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisDgoods disDgoods = this.checkDgoods(disChannel.getChannelCode(), disChannel.getTenantCode());
        if (null == disDgoods) {
            return null;
        }
        List disDgoodsScopelistList = DisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()), DisDgoodsScopelist.class);
        boolean flag = true;
        if (!ListUtil.isEmpty((Collection)disDgoodsScopelistList)) {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return null;
            }
            String term = "";
            String key = "";
            for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs;
                    for (String o : otrs = objValue.toString().split("\\,")) {
                        if (this.cond(valueList, term, o)) break;
                    }
                    continue;
                }
                if (this.cond(valueList, term, objValue)) continue;
                flag = false;
                break;
            }
        }
        if (!flag) {
            return null;
        }
        return disDgoods;
    }

    private DisRsResourceGoodsDomain checkDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisDgoods disDgoods = this.checkDisGoodsChannel(rsResourceGoodsReDomain, disChannel);
        if (null == disDgoods) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.flag", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel, disDgoods.getDgoodsPut());
        if (null == disRsResourceGoodsDomain) {
            this.logger.error("rs.RsFlowdataServiceImpl.checkDisGoods.null", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()));
            return null;
        }
        this.makePice(disRsResourceGoodsDomain, null, disChannel);
        this.makeNum(disRsResourceGoodsDomain, disChannel);
        return disRsResourceGoodsDomain;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean makeNum(List<DisDgnumDomain> disDpriceList, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(disDpriceList) || null == disRsResourceGoodsDomain || ListUtil.isEmpty(disRsResourceGoodsDomain.getDisRsSkuDomainList())) {
            return false;
        }
        for (DisDgnumDomain disDgnumDomain : disDpriceList) {
            for (DisRsSkuDomain disRsSkuDomain : disRsResourceGoodsDomain.getDisRsSkuDomainList()) {
                if (!this.makeDisDgnumDomain(disDgnumDomain, disRsSkuDomain, disRsResourceGoodsDomain)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean makeNum(List<DisDgnumDomain> disDpriceList, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(disDpriceList) || null == disRsSkuDomain || null == disRsResourceGoodsDomain) {
            return false;
        }
        for (DisDgnumDomain disDgnumDomain : disDpriceList) {
            if (!this.makeDisDgnumDomain(disDgnumDomain, disRsSkuDomain, disRsResourceGoodsDomain)) continue;
            return true;
        }
        return false;
    }

    private boolean makeDisDgnumDomain(DisDgnumDomain disDgnumDomain, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == disDgnumDomain) {
            return false;
        }
        Map<String, List<String>> map = this.makeDgnumlist(disDgnumDomain.getDisDgnumListList());
        if (!this.checkConf(map, disRsSkuDomain)) {
            return false;
        }
        this.setNum(disDgnumDomain, disRsResourceGoodsDomain, disRsSkuDomain);
        return true;
    }

    private void makeNum(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel || null == disRsSkuDomain) {
            return;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        }
        if (this.makeNum(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain)) {
            return;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
            this.makeNum(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain);
        }
    }

    private void makeNum(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel) {
            return;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        }
        if (this.makeNum(disDpriceList, disRsResourceGoodsDomain)) {
            return;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
            this.makeNum(disDpriceList, disRsResourceGoodsDomain);
        }
    }

    private boolean makePric(List<DisDpriceDomain> disDpriceList, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(disDpriceList)) {
            return false;
        }
        BaseDomain obj = disRsResourceGoodsDomain;
        if (null != disRsSkuDomain) {
            obj = disRsSkuDomain;
        }
        for (DisDpriceDomain disDpriceDomain : disDpriceList) {
            Map<String, List<String>> map = this.makeDpeicelist(disDpriceDomain.getDisDpriceConfList());
            if (!this.checkConf(map, obj)) continue;
            if ("2".equals(disDpriceDomain.getDpricePro())) {
                for (DisDpriceConf disDpriceConf : disDpriceDomain.getDisDpriceConfList()) {
                    Object objValue = BeanUtils.forceGetProperty((Object)obj, (String)disDpriceConf.getDpriceConfType());
                    ArrayList<String> relist = new ArrayList<String>();
                    relist.add(disDpriceConf.getDpriceConfValue());
                    if (!this.cond(relist, disDpriceConf.getDpriceConfTerm(), objValue)) continue;
                    disDpriceDomain.setDpricePrice(disDpriceConf.getDpriceConfPrice());
                    disDpriceDomain.setDpriceMprice(disDpriceConf.getDpriceConfMprice());
                    disDpriceDomain.setDpricePricedef(disDpriceConf.getDpriceConfPricedef());
                    disDpriceDomain.setDpriceMpricedef(disDpriceConf.getDpriceConfMpricedef());
                    break;
                }
            }
            this.setPrice(disDpriceDomain, disRsSkuDomain, disRsResourceGoodsDomain);
            return true;
        }
        return false;
    }

    private void makePice(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel) {
            return;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDpriceDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDpriceDomain.class);
        }
        if (this.makePric(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain)) {
            return;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDpriceDomain.class);
            this.makePric(disDpriceList, disRsSkuDomain, disRsResourceGoodsDomain);
        }
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.forceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private void setNum(DisDgnumDomain disDgnumDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisRsSkuDomain disRsSkuDomain) {
        if (null == disDgnumDomain || null == disRsResourceGoodsDomain || null == disRsSkuDomain) {
            return;
        }
        String pro = disDgnumDomain.getDgnumPro();
        BigDecimal rnum = BigDecimal.ZERO;
        BigDecimal rweight = BigDecimal.ZERO;
        if (null == disRsResourceGoodsDomain.getGoodsNum()) {
            disRsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == disRsResourceGoodsDomain.getGoodsWeight()) {
            disRsResourceGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == disRsSkuDomain.getGoodsNum()) {
            disRsSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == disRsSkuDomain.getGoodsWeight()) {
            disRsSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == disDgnumDomain.getDgnumPrice()) {
            disDgnumDomain.setDgnumPrice(BigDecimal.ZERO);
        }
        BigDecimal goodsNum = disRsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = disRsSkuDomain.getGoodsWeight();
        if ("0".equals(pro)) {
            rnum = goodsNum.subtract(disDgnumDomain.getDgnumPrice());
            rweight = goodsWeight.subtract(disDgnumDomain.getDgnumPrice());
        } else if ("1".equals(pro)) {
            rnum = disDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 2, 4).multiply(goodsNum);
            rweight = disDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 2, 4).multiply(goodsWeight);
        } else if ("2".equals(pro)) {
            rnum = disDgnumDomain.getDgnumPrice();
            rweight = disDgnumDomain.getDgnumPrice();
        }
        if (null == disDgnumDomain.getDgnumMin()) {
            disDgnumDomain.setDgnumMin(BigDecimal.ZERO);
        }
        if (rnum.compareTo(disDgnumDomain.getDgnumMin()) <= 0) {
            disRsSkuDomain.setDgoodsPut("0");
        }
        disRsSkuDomain.setGoodsNum(rnum);
        disRsSkuDomain.setGoodsWeight(rweight);
        disRsSkuDomain.setGoodsSupplynum(rnum);
        disRsSkuDomain.setGoodsSupplyweight(rweight);
        disRsResourceGoodsDomain.setGoodsNum(disRsResourceGoodsDomain.getGoodsNum().subtract(goodsNum).add(rnum));
        disRsResourceGoodsDomain.setGoodsWeight(disRsResourceGoodsDomain.getGoodsWeight().subtract(goodsWeight).add(rweight));
        disRsResourceGoodsDomain.setGoodsSupplynum(disRsResourceGoodsDomain.getGoodsNum());
        disRsResourceGoodsDomain.setGoodsSupplyweight(disRsResourceGoodsDomain.getGoodsWeight());
    }

    private void setPrice(DisDpriceDomain disDpriceDomain, DisRsSkuDomain disRsSkuDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        Integer ver;
        if (null == disDpriceDomain || null == disRsResourceGoodsDomain) {
            return;
        }
        String pro = disDpriceDomain.getDpricePro();
        String dpriceSync = disDpriceDomain.getDpriceSync();
        if (StringUtils.isBlank((String)dpriceSync)) {
            dpriceSync = "1";
        }
        if (null == (ver = disDpriceDomain.getDpriceVer())) {
            ver = 0;
        }
        if (null == disRsResourceGoodsDomain.getPricesetMakeprice()) {
            disRsResourceGoodsDomain.setPricesetMakeprice(BigDecimal.ZERO);
        }
        if (null == disRsResourceGoodsDomain.getPricesetNprice()) {
            disRsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == disRsResourceGoodsDomain.getPricesetRefrice()) {
            disRsResourceGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        if (null != disRsSkuDomain) {
            if (null == disRsSkuDomain.getPricesetMakeprice()) {
                disRsSkuDomain.setPricesetMakeprice(BigDecimal.ZERO);
            }
            if (null == disRsSkuDomain.getPricesetNprice()) {
                disRsSkuDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == disRsSkuDomain.getPricesetRefrice()) {
                disRsSkuDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            disRsSkuDomain.setDpriceSync(dpriceSync);
        }
        disRsResourceGoodsDomain.setDpriceSync(dpriceSync);
        if (null == disDpriceDomain.getDpricePrice()) {
            disDpriceDomain.setDpricePrice(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpriceMprice()) {
            disDpriceDomain.setDpriceMprice(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpricePricedef()) {
            disDpriceDomain.setDpricePricedef(BigDecimal.ZERO);
        }
        if (null == disDpriceDomain.getDpriceMpricedef()) {
            disDpriceDomain.setDpriceMpricedef(BigDecimal.ZERO);
        }
        if ("0".equals(dpriceSync)) {
            disRsResourceGoodsDomain.setPricesetNprice(disDpriceDomain.getDpricePricedef());
            disRsResourceGoodsDomain.setPricesetMakeprice(disDpriceDomain.getDpriceMpricedef());
            if (null != disRsSkuDomain) {
                disRsSkuDomain.setPricesetMakeprice(disDpriceDomain.getDpricePricedef());
                disRsSkuDomain.setPricesetNprice(disDpriceDomain.getDpriceMpricedef());
            }
        } else {
            BigDecimal rmoney = BigDecimal.ZERO;
            BigDecimal money = disRsResourceGoodsDomain.getPricesetNprice();
            BigDecimal rmmoney = BigDecimal.ZERO;
            BigDecimal mmoney = disRsResourceGoodsDomain.getPricesetMakeprice();
            if (null != disRsSkuDomain) {
                money = disRsSkuDomain.getPricesetNprice();
                mmoney = disRsSkuDomain.getPricesetMakeprice();
            }
            if (null == money) {
                money = BigDecimal.ZERO;
            }
            if (null == mmoney) {
                mmoney = BigDecimal.ZERO;
            }
            if ("0".equals(pro)) {
                rmoney = money.add(disDpriceDomain.getDpricePrice());
                rmmoney = mmoney.add(disDpriceDomain.getDpriceMprice());
            } else if ("1".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(money);
                rmmoney = disDpriceDomain.getDpriceMprice().divide(new BigDecimal("100"), 2, 4).multiply(money);
            } else if ("2".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice();
                rmmoney = disDpriceDomain.getDpriceMprice();
            }
            if (0 == ver) {
                rmoney = rmoney.setScale(2, 4);
                rmmoney = rmmoney.setScale(2, 4);
            } else if (1 == ver) {
                rmoney = rmoney.setScale(1, 4);
                rmmoney = rmmoney.setScale(1, 4);
            } else if (2 == ver) {
                rmoney = rmoney.setScale(0, 4);
                rmmoney = rmmoney.setScale(0, 4);
            } else if (3 == ver) {
                // empty if block
            }
            disRsResourceGoodsDomain.setPricesetNprice(rmoney);
            if (disDpriceDomain.getDpriceMprice().compareTo(BigDecimal.ZERO) != 0) {
                disRsResourceGoodsDomain.setPricesetMakeprice(rmmoney);
                if (null != disRsSkuDomain) {
                    disRsSkuDomain.setPricesetMakeprice(rmoney);
                }
            }
            if (null != disRsSkuDomain) {
                disRsSkuDomain.setPricesetNprice(rmoney);
            }
            rmoney = BigDecimal.ZERO;
            money = disRsResourceGoodsDomain.getPricesetRefrice();
            if (null != disRsSkuDomain) {
                money = disRsSkuDomain.getPricesetRefrice();
            }
            if ("0".equals(pro)) {
                rmoney = money.add(disDpriceDomain.getDpricePrice());
            } else if ("1".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(money);
            } else if ("2".equals(pro)) {
                rmoney = disDpriceDomain.getDpricePrice();
            }
            disRsResourceGoodsDomain.setPricesetRefrice(rmoney);
            if (null != disRsSkuDomain) {
                disRsSkuDomain.setPricesetRefrice(rmoney);
            }
        }
        if (null != disRsSkuDomain) {
            return;
        }
        this.makeSKuNprice(disRsResourceGoodsDomain.getPricesetNprice(), disRsResourceGoodsDomain.getPricesetRefrice(), disRsResourceGoodsDomain.getPricesetMakeprice(), disRsResourceGoodsDomain.getDisRsSkuDomainList(), dpriceSync);
    }

    private void makeSKuNprice(BigDecimal pricesetNprice, BigDecimal pricesetRefrice, BigDecimal pricesetMakeprice, List<DisRsSkuDomain> disRsSkuDomainList, String dpriceSync) {
        if (ListUtil.isEmpty(disRsSkuDomainList)) {
            return;
        }
        for (DisRsSkuDomain disRsSkuDomain : disRsSkuDomainList) {
            disRsSkuDomain.setPricesetNprice(pricesetNprice);
            disRsSkuDomain.setPricesetRefrice(pricesetRefrice);
            disRsSkuDomain.setPricesetMakeprice(pricesetMakeprice);
            disRsSkuDomain.setDpriceSync(dpriceSync);
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<DisDgnumList> disDgnumListList) {
        if (ListUtil.isEmpty(disDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgnumList disDpriceConf : disDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDgnumListTerm())) {
                disDpriceConf.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm(), list);
            }
            list.add(disDpriceConf.getDgnumListValue());
        }
        return map;
    }

    private Map<String, List<String>> makeDpeicelist(List<DisDpriceConf> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDpriceConf disDpriceConf : disDpriceConfList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
                disDpriceConf.setDpriceConfTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDpriceConfType() + "|" + disDpriceConf.getDpriceConfTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDpriceConfType() + "|" + disDpriceConf.getDpriceConfTerm(), list);
            }
            list.add(disDpriceConf.getDpriceConfValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelist> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelist disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDgoodsScopelist.getDgoodsScopelistTerm())) {
                disDgoodsScopelist.setDgoodsScopelistTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm()))) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    private boolean sendGoodsSkuHtml(HtmlRelease htmlRelease, RsFlowdata rsFlowData, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsFlowData || null == htmlRelease) {
            return false;
        }
        HashMap<String, Object> htmlMap = new HashMap<String, Object>();
        htmlMap.put("esRequestType", rsFlowData.getEsrequestType());
        htmlMap.put("channelCode", rsFlowData.getChannelCode());
        htmlMap.put("memberCode", rsFlowData.getMemberCode());
        if (!"delete".equals(rsFlowData.getEsrequestType())) {
            if (null == rsResourceGoodsReDomain) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.rsResourceGoodsReDomain", (Object)rsFlowData.getFdCode());
                return false;
            }
            if (ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.getRsSkuDomainList", (Object)rsFlowData.getFdCode());
                return false;
            }
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
            if (!this.makeHtml(rsFlowData, rsSkuDomain, htmlMap, rsResourceGoodsReDomain)) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoodsSkuHtml.makeHtml", (Object)rsFlowData.getFdCode());
                return false;
            }
        }
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
        return this.sendHtml(htmlRelease);
    }

    private boolean sendGoods(RsFlowdata rsFlowData, List<RsSenddata> rsSenddataList) {
        if (null == rsFlowData || null == rsSenddataList) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (StringUtils.isNotBlank((String)rsFlowData.getFdBizcodestr())) {
            rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsFlowData.getFdBizcodestr(), RsResourceGoodsReDomain.class);
        }
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(rsFlowData.getTenantCode());
        htmlRelease.setHtmldataCode("RsResourceGoods");
        htmlRelease.setHtmldataFilename(rsFlowData.getFdBizcode() + ".html");
        htmlRelease.setHtmldataFilepath("goods");
        if (!this.sendGoodsSkuHtml(htmlRelease, rsFlowData, rsResourceGoodsReDomain)) {
            this.logger.error("rs.RsFlowdataServiceImpl.sendGoods.sendGoodsSkuHtml", (Object)rsFlowData.getFdCode());
            return false;
        }
        StoreDomain storeDomain = new StoreDomain();
        if (!rsFlowData.getEsrequestType().equals("delete") && !rsFlowData.getEsrequestType().equals("deleteop")) {
            if (ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                this.logger.error("rs.RsFlowdataServiceImpl.sendGoods.getRsSkuDomainList", (Object)rsFlowData.getFdCode());
                return false;
            }
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
            this.makeEsSku(rsResourceGoodsReDomain, storeDomain, rsSkuDomain);
        }
        storeDomain.setRequestType(rsFlowData.getEsrequestType());
        storeDomain.setBizType("goods");
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsFlowData.getFdBizcode());
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        return this.sendEs(storeDomain);
    }

    public static void main(String[] args) {
        BigDecimal a = new BigDecimal("100");
        System.out.println(a.divide(new BigDecimal("100"), 2, 5).multiply(new BigDecimal("0.01")));
    }

    private void makeEsSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, StoreDomain storeDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsReDomain || null == storeDomain || null == rsSkuDomain) {
            return;
        }
        EsSku esSku = new EsSku();
        try {
            BeanUtils.copyAllPropertys((Object)esSku, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.error("=========", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
        }
        esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
        esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
        esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
        esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
        esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
        esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
        esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
        esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
        esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
        esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
        esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
        esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
        if (null == esSku.getGoodsSalesvolume()) {
            esSku.setGoodsSalesvolume(BigDecimal.ZERO);
        }
        esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
        String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
        storeDomain.setStoreObj((Object)esSkuStr);
    }

    static {
        lock = new Object();
        DISCHANNEL_TYPE_ONLINE = "0";
        DISCHANNEL_TYPE_THRID = "2";
        DISCHANNEL_TYPE_STORE = "1";
        DISCHANNEL_SALE = "0";
        DISCHANNEL_CON = "1";
        DISCHANNEL_BUS = "2";
    }
}

