/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.util.CollectionUtils;

public class RsSkuServiceImpl
extends BaseServiceImpl
implements RsSkuService {
    public static final String SYS_CODE = "rs.RsSkuServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsSpecValueService rsSpecValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsSenddataBaseService rsSenddataBaseService;
    RsResourceGoodsMapper rsResourceGoodsMapper;

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSpuCode())) {
            msg = msg + "spu\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = msg + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = msg + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        if (null == rsSku.getDataState()) {
            rsSku.setDataState(0);
        }
        if (null == rsSku.getDataOpbillstate()) {
            rsSku.setDataOpbillstate(0);
        }
        Date date = this.getSysDate();
        if (null == rsSku.getGmtCreate()) {
            rsSku.setGmtCreate(date);
        }
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsWeight()) {
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        rsSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            rsSku.setSkuCode(this.getNo(null, RsSku.class.getSimpleName(), "skuCode", rsSku.getTenantCode()));
        }
        if (StringUtils.isBlank((String)rsSku.getSkuShowno())) {
            rsSku.setSkuShowno(rsSku.getSkuNo());
        }
        this.makeDefSku(rsSku);
        if (ResourcesConstants.DATA_OPBILLSTATE_1 == rsSku.getDataOpbillstate()) {
            this.setAuditModel(rsSku, false);
        }
    }

    private int getSkuMaxCode() {
        int code = 0;
        try {
            return this.rsSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuUpdataDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        rsSku.setGmtModified(this.getSysDate());
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private RsSku getSkuModelById(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        try {
            return this.rsSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelById", (Throwable)e);
            return null;
        }
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.num");
        }
    }

    public void updateSkuEocodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuEocode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.num");
        }
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.num");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
            rsSku.setGmtModified(this.getSysDate());
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateSkuModelWithNull(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
            this.rsSkuMapper.updateByPrimaryKey(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    @Override
    public boolean updateNum(String skuNo, String tenantCode, BigDecimal num) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode) || null == num) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        boolean flag = false;
        Map map = this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode});
        List<RsSku> skus = this.rsSkuMapper.query(map);
        if (null == skus || ListUtil.isEmpty(skus)) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u65e0\u6570\u636e");
            return false;
        }
        Integer dataOpbillstate = skus.get(0).getDataOpbillstate();
        if (dataOpbillstate == 1) {
            map.put("goodsSupplynum", num);
        } else {
            map.put("goodsNum", num);
        }
        map.put("dataOpbillstate", dataOpbillstate);
        int i = this.rsSkuMapper.updateNum(map);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.null");
        }
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsSku) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeSku", (Throwable)e);
            if (null == rsSku.getGoodsNum()) {
                rsSku.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsWeight()) {
                rsSku.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplynum()) {
                rsSku.setGoodsSupplynum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplyweight()) {
                rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) != 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsSupplynum(rsSku.getGoodsNum());
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsNum(rsSku.getGoodsSupplynum());
                rsSku.setGoodsWeight(rsSku.getGoodsSupplyweight());
            }
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
        if (null != rsSku) {
            return rsSku.getSkuCode();
        }
        return null;
    }

    private RsSku saveSkuMode(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        this.setSkuDefault(rsSku);
        rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
        this.saveSkuModel(rsSku);
        this.saveSpecList(rsSkuDomain.getSpecList(), rsSkuDomain.getGoodsCode());
        return rsSku;
    }

    @Override
    public List<RsSenddata> saveSkuList(List<RsSkuDomain> rsSkuList, String goodsEocode) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuList.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            List<RsSenddata> skuRsSenddataList;
            RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
            if (ResourcesConstants.DATA_OPBILLSTATE_1 != rsSkuDomain.getDataOpbillstate() || !ListUtil.isNotEmpty(skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.GOODS_DATA_STATE_0, rsSku.getSkuCode(), rsSku.getTenantCode(), goodsEocode))) continue;
            rsSenddataList.addAll(skuRsSenddataList);
        }
        return rsSenddataList;
    }

    private RsSku saveSkuDomain(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsSkuDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        this.makePic(rsSkuDomain, rsGoodsFileDomainList, dataPic);
        RsSku rsSku = this.saveSkuMode(rsSkuDomain);
        if (!ListUtil.isEmpty(rsSkuDomain.getRsGoodsFileDomainList())) {
            ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsFileDomain.setGoodsFileCode(null);
                rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
                rsGoodsFileDomain.setGoodsFileId(null);
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsskuGoodsFileDomainList);
        }
        rsSkuDomain.setSkuCode(rsSku.getSkuCode());
        this.saveSkuRel(rsSkuDomain);
        return rsSku;
    }

    private void makePic(RsSkuDomain rsSkuDomain, List<RsGoodsFileDomain> rsGoodsFileDomainList, String dataPic) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSkuDomain.setDataPic(dataPic);
    }

    private String sortSkuName(String skuName) {
        if (StringUtils.isBlank((String)skuName)) {
            return null;
        }
        List<String> spcList = Arrays.asList(skuName.split("\\/"));
        return this.sortSpcList(spcList);
    }

    private String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }

    private void saveSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : valueList) {
            rsSpecValueDomain.setSpecValueBillno(goodsCode);
        }
        this.rsSpecValueService.saveSpecValueList(valueList);
    }

    @Override
    public void updateSkuState(RsSku rsSku, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rsSku || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"\u6570\u636e\u4e3a\u7a7a");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuState", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateSkuModel(rsSku.getSkuId(), dataState, oldDataState);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"rsSkuDomain is null");
            return;
        }
        if (ResourcesConstants.GOODS_DATA_STATE_NO.equals(dataState)) {
            // empty if block
        }
        if (ResourcesConstants.GOODS_DATA_STATE_0.equals(dataState)) {
            // empty if block
        }
    }

    @Override
    public void updateSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
            rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        }
        this.updateComSku(rsSkuDomain, oldRsSku);
    }

    private void updateComSku(RsSkuDomain rsSkuDomain, RsSku oldRsSku) {
        if (null == rsSkuDomain || null == oldRsSku) {
            return;
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuFile(rsSkuDomain.getRsGoodsFileDomainList(), rsSku);
        this.setSkuUpdataDefault(rsSku);
        this.updateSkuModel(rsSku);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsRelType", "3");
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
        this.saveSkuRel(rsSkuDomain);
        this.deltaUpdateSpecList(rsSkuDomain.getSpecList(), rsSku.getGoodsCode());
    }

    private void saveSkuRel(RsSkuDomain rsSkuDomain) {
        if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode("");
                rsGoodsRelDomain.setGoodsSkuCode(rsSkuDomain.getSkuCode());
                rsGoodsRelDomain.setGoodsRelType("3");
                rsGoodsRelDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsSkuDomain.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsSkuDomain.getRsGoodsRelDomainList());
        }
    }

    @Override
    public void updateSkuFile(String skuCode, String tenantCode, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || CollectionUtils.isEmpty(rsGoodsFileDomainList)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile param null");
            return;
        }
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode});
        RsSku rsSku = this.getSkuModelByCode(paramMap);
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile rsSku null");
            return;
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (null == rsGoodsFileDomain.getDefaultState() || rsGoodsFileDomain.getDefaultState() != ResourcesConstants.FILE_DEFAULTSTATE_1 || !FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSku.setDataPic(dataPic);
        this.updateSkuModel(rsSku);
    }

    private void deltaUpdateSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (CollectionUtils.isEmpty(valueList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsSpecValueDomain> i = valueList.iterator();
        while (i.hasNext()) {
            RsSpecValueDomain valueDomain = i.next();
            valueDomain.setSpecValueBillno(goodsCode);
            params.put("tenantCode", valueDomain.getTenantCode());
            params.put("specValueCode", valueDomain.getSpecValueCode());
            RsSpecValue exist = this.rsSpecValueService.getSpecValueByCode(params);
            if (exist == null) continue;
            this.rsSpecValueService.updateSpecValue(valueDomain);
            i.remove();
        }
        this.saveSpecList(valueList, goodsCode);
    }

    @Override
    public RsSku getSku(Integer skuId) {
        return this.getSkuModelById(skuId);
    }

    @Override
    public void deleteSkuSyn(Integer skuId) {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
    }

    @Override
    public void deleteSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsSku.getSkuCode());
        map.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    private RsSkuDomain makeRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("skuCode", rsSku.getSkuCode());
        map1.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
        if (null != rsSkuFileList) {
            rsSkuDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsSkuFileList.getList()));
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("goodsSkuCode", rsSku.getSkuCode());
        map2.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsRel> rsSkuRelList = this.rsGoodsOtherService.queryGoodsRelPage(map2);
        if (null != rsSkuRelList) {
            rsSkuDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsSkuRelList.getList()));
        }
        return rsSkuDomain;
    }

    private List<RsSkuDomain> makeRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception e) {
            // empty catch block
        }
        RsSku rsSku = this.rsSkuMapper.getByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRelDomain.getSkuCode(), rsGoodsRelDomain.getTenantCode()}));
        rsGoodsRelDomain.setSkuNo(rsSku.getSkuNo());
        return rsGoodsRelDomain;
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> querySkuOnePage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            throw new ApiException("rs.RsSkuServiceImpl.querySkuOnePage.param is null or tenantCode is null ");
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public RsSku getSkuBySpec(List<String> spcList, String goodsCode, String tenantCode) {
        if (null == spcList || spcList.isEmpty() || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String skuName = this.sortSpcList(spcList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public RsSku getSkuByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return rsSku;
    }

    @Override
    public RsSkuDomain getSkuDomainByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return this.makeRsSkuDomain(rsSku);
    }

    @Override
    public List<RsSku> checkSkuNo(String skuNo, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkSkuNo.param.null");
        }
        return this.rsSkuMapper.query(this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode}));
    }

    @Override
    public void delSkuByCode(Map<String, Object> map) throws ApiException {
        RsSku rsSku = this.getSkuModelByCode(map);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuByCode.rsSku");
        }
        this.delSkuModelByCode(map);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public void deleteSkuList(List<Integer> skuIds) throws ApiException {
        if (skuIds == null || skuIds.isEmpty()) {
            return;
        }
        for (Integer skuId : skuIds) {
            this.deleteSku(skuId);
        }
    }

    @Override
    public void updateAhSkuList(List<RsSkuDomain> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        for (RsSkuDomain rsSkuDomain : skuList) {
            RsSku rsSku = new RsSku();
            this.makeSku(rsSkuDomain, rsSku);
            rsSkus.add(rsSku);
        }
        this.updateAh(rsSkus);
    }

    public void updateAhSku(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.checkSku", msg);
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_3) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        rsSku.setSkuSort(null);
        this.updateSkuModelWithNull(rsSku);
    }

    @Override
    public void updateCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, false);
    }

    @Override
    public void updateGoodsCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, true);
    }

    public void updateCannelSkuList(List<Integer> skuIds, boolean disflag) throws ApiException {
        if (ListUtil.isEmpty(skuIds)) {
            this.logger.error("rs.RsSkuServiceImpl.updateCannelSkuList", (Object)"skuIds is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "skuIds is null");
        }
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (ListUtil.isEmpty(skuList)) {
            return;
        }
        this.updateCannel(skuList);
    }

    private Map<String, Object> crateFdMap(String goodsEocode, RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        HashMap<String, Object> flmap = new HashMap<String, Object>();
        flmap.put("goodsEocode", goodsEocode);
        flmap.put("goodsCode", rsSku.getGoodsCode());
        flmap.put("skuCode", rsSku.getSkuCode());
        flmap.put("skuEocode", rsSku.getSkuEocode());
        flmap.put("goodsOldcode", rsSku.getGoodsOldcode());
        flmap.put("memberCcode", rsSku.getMemberCcode());
        return flmap;
    }

    public RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsResourceGoodsReDomain;
    }

    private void updateCannel(List<RsSku> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, false);
        }
    }

    private void updateCannelMode(RsSku rsSku, boolean dataState) {
        if (null == rsSku) {
            return;
        }
        BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
        rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsSupplyweight));
        }
        rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().subtract(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().subtract(goodsSupplyweight));
        }
        rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
        if (dataState) {
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
        }
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
        this.updateSkuModel(rsSku);
    }

    @Override
    public void updateAuditSkuPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    private void updateAuditPass(List<RsSku> skuList, boolean put) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateAuditModel(rsSku, put);
        }
    }

    @Override
    public void updateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSku> skuList;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (skuList = this.querySkuModelPage(parammap)) || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, true);
        }
    }

    private void updateAuditModel(RsSku rsSku, boolean put) {
        this.setAuditModel(rsSku, put);
        this.updateSkuModel(rsSku);
    }

    private void setAuditModel(RsSku rsSku, boolean put) {
        if (null == rsSku) {
            return;
        }
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_2);
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_1);
        rsSku.setSkuHdate(this.getSysDate());
    }

    @Override
    public void updateAuditSkuNoPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsAhnum));
            if (goodsAhweight == null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            this.updateSkuModel(rsSku);
        }
    }

    private List<RsSku> checkAuditSku(List<Integer> skuIds) {
        if (skuIds == null || skuIds.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.getSkuModelById(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            skuList.add(rsSku);
        }
        return skuList;
    }

    private List<RsSku> checkAuditSku(String goodsCode, String tenantCode) {
        if (goodsCode == null || goodsCode.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.goodsCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", 0);
        List<RsSku> skuList = this.rsSkuMapper.query(map);
        if (ListUtil.isEmpty(skuList)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.skuList", "\u6570\u636e\u4e3a\u7a7a:" + ((Object)map).toString());
        }
        String mschannelName = null;
        String mschannelCode = null;
        map.remove("dataOpbillstate");
        for (RsSku rsSku : skuList) {
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.rsSku", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            rsSku.setMschannelCode(mschannelCode);
            rsSku.setMschannelName(mschannelName);
        }
        return skuList;
    }

    @Override
    public void querySkuAll(Map<String, Object> map) {
        if (map != null) {
            map.put("dataOpbillstate", 1);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(this.queryforEs(map)));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<EsSku> queryforEs(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.queryForEs(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.queryforEs.error", e.getMessage());
        }
    }

    @Override
    public void updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("goodsCode", goodsCode);
        parammap.put("dataState", 0);
        List<RsSku> skuList = this.querySkuModelPage(parammap);
        this.updateAh(skuList);
    }

    private void updateAh(List<RsSku> skuList) {
        if (null == skuList || skuList.isEmpty()) {
            return;
        }
        List skuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(skuList), RsSkuDomain.class);
        for (RsSkuDomain rsSkuDomain : skuDomainList) {
            this.updateAhModel(rsSkuDomain);
        }
    }

    protected void updateAhModel(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return;
        }
        BigDecimal goodsNum = rsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = rsSkuDomain.getGoodsWeight();
        goodsNum = goodsNum == null ? BigDecimal.ZERO : goodsNum;
        goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
        rsSkuDomain.setGoodsAhnum(goodsNum);
        rsSkuDomain.setGoodsAhweight(goodsWeight);
        rsSkuDomain.setGoodsNum(goodsNum.subtract(goodsNum));
        rsSkuDomain.setGoodsWeight(goodsWeight.subtract(goodsWeight));
        this.updateAhSku(rsSkuDomain);
    }

    @Override
    public void updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    @Override
    public void updatetSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, true);
    }

    @Override
    public void updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsSkuMapper.updateByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String goodsCode, String tenantCode) {
        if (goodsNum == null || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", "param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsNum", goodsNum);
        map.put("skuCode", goodsCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuGoodsNumByGoodsCode(map);
    }

    private void updateSkuGoodsNumByGoodsCode(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuGoodsNumByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.null");
        }
    }

    private List<RsSku> queryDisSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countDisSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countDisSku(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<RsSku> queryDisSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryDisSku(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDisSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> queryDisAndSkuPage(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisAndSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.queryDisAndSku(map));
        return queryResult;
    }

    private List<RsSku> queryDisAndSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisAndSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int queryDisAndSkuCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.queryDisAndSkuCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.updateSku(rsSkuDomain);
        }
    }

    @Override
    public List<RsSku> querySkuByPntreeCode(Map<String, Object> map) {
        try {
            return this.rsSkuMapper.querySkuByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByPntreeCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        this.updateSortNoSkuModel(tenantCode, goodsCode, skuCode, sortNo);
    }

    private void updateSortNoSkuModel(String tenantCode, String goodsCode, String skuCode, Integer sortNo) throws ApiException {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode) && StringUtil.isBlank((String)skuCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        map.put("skuCode", skuCode);
        map.put("gmtModified", this.getSysDate());
        map.put("sortNo", sortNo);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSortNoSku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.null");
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.null", map.toString());
        }
    }

    @Override
    public void updateSkuStock(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModel(map);
    }

    @Override
    public List<RsSku> querySkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        return this.querySkuModelPage(map);
    }

    @Override
    public List<RsSenddata> updateSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit", "editSkuDomain/oldRsSku is null");
        }
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuEdit.checkSkuEdit", (Object)msg);
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.checkSku", msg);
        }
        this.updateEditSku(editSkuDomain);
        RsSku oldRsSku = this.getSku(editSkuDomain.getSkuId());
        if (oldRsSku == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.RsSku", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(oldRsSku);
        return this.saveSenddata(rsSkuList, "edit", editSkuDomain.getGoodsEocode());
    }

    private RsSkuDomain makeSkuDomain(RsSku oldRsSku, RsSkuDomain rsSkuDomain) {
        if (null == oldRsSku) {
            return null;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = new RsSkuDomain();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)oldRsSku);
            return rsSkuDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeRsSkuDomain", (Throwable)e);
            return rsSkuDomain;
        }
    }

    private void updateEditSku(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            return;
        }
        try {
            this.rsSkuMapper.updateEditSku(editSkuDomain);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private String checkSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)editSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getSkuCode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (editSkuDomain.getPricesetNprice() == null || editSkuDomain.getPricesetNprice().intValue() < 0) {
            msg = msg + "PricesetNprice\u53c2\u6570\u9519\u8bef;";
        }
        return msg;
    }

    @Override
    public RsSku getRsSkuModelByOldCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByOldCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getRsSkuModelByOldCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> updateDisAuditSku(RsSkuDomain rsSkuDomain, String goodsEocode) throws ApiException {
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null", (Object)"rsSkuDomain is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null");
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
            rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        }
        this.updateComSku(rsSkuDomain, oldRsSku);
        List<RsSenddata> skuRsSenddataList = null;
        if (ResourcesConstants.DATA_OPBILLSTATE_1 == rsSkuDomain.getDataOpbillstate()) {
            skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.GOODS_DATA_STATE_0, oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), goodsEocode);
        }
        return skuRsSenddataList;
    }

    private void setSkuFile(List<RsGoodsFileDomain> rsGoodsFileDomainList, RsSku rsSku) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList) || null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.setSkuFile param null");
            throw new ApiException("rs.RsSkuServiceImpl.setSkuFile.param.null");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCode", rsSku.getSkuCode());
        paramMap.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (null != rsGoodsFileDomainList && rsGoodsFileDomainList.size() > 0) {
            String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
            boolean picflag = false;
            if (!FileType.fileTypepic((String)dataPic)) {
                picflag = true;
            }
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                    dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                    picflag = false;
                }
                rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsFileCode(this.createUUIDString());
                if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            }
            rsSku.setDataPic(dataPic);
            this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        }
    }

    @Override
    public void updateSoldOutSku(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSoldOutSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateSoldOutSku.null");
        }
        this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSku(rsSku.getSkuId());
    }

    @Override
    public void updateShelveSku(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
        this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{rsSku.getSkuCode(), rsSku.getTenantCode()}));
        if (rsSku == null) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
    }

    @Override
    public void updateSkuStateBySkuId(RsSku rsSku, Integer dataState, Integer oldState) {
        if (null == rsSku || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuId.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuId.null");
        }
        this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        rsSku.setDataState(dataState);
    }

    @Override
    public void deleteSkuByCode(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.null");
        }
        this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
    }

    @Override
    public List<RsSkuDomain> queryHotSkuList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList", (Object)"map is null");
            return null;
        }
        return this.queryHotGoods(map);
    }

    public List<RsSkuDomain> queryHotGoods(Map<String, Object> map) {
        String rsSkuDomainrList = "";
        try {
            rsSkuDomainrList = (String)this.getInternalRouter().inInvoke("omns.mb.sendqueryGoodsList", map);
            if (StringUtils.isBlank((String)rsSkuDomainrList)) {
                this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter", (Object)("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
            return null;
        }
        List rsSkuDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(rsSkuDomainrList, RsSkuDomain.class);
        return rsSkuDomainList;
    }

    @Override
    public void updatetSkuSoldOutByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updatetSkuShelveByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuShelveByGoodsCode", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updateSkuStateByGoodsCode(Map<String, Object> parammap) {
        if (null == parammap || parammap.isEmpty()) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        Integer dataState = (Integer)parammap.remove("dataState");
        if (null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "dataState is null");
        }
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(parammap);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        }
    }

    @Override
    public void deleteSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuByGoodsCode", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    private void deleteSkuBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuBySkuCode", (Object)"skuCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCode", "skuCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        try {
            this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuBySkuCode", (Throwable)e);
        }
    }

    private void deleteSkuModelByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        try {
            this.rsSkuMapper.delByGoodsCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", (Throwable)e);
        }
    }

    private void updateSkuStateBySkuCode(String skuCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        try {
            this.rsSkuMapper.updateSkuStateBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", (Throwable)e);
        }
    }

    private void updateSkuStateByGoodsCode(String goodsCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        try {
            this.rsSkuMapper.updateSkuStateByGoodsCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Throwable)e);
        }
    }

    private void updatetSkuShelveBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuShelveBySkuCode.null", (Object)"param is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveBySkuCode.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updatetSkuPassBySkuCode(map);
    }

    private void updatetSkuPassBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeMap is null");
        }
        try {
            this.rsSkuMapper.updatetSkuPassBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImplupdatetSkuShelveBySkuCode.", (Throwable)e);
        }
    }

    private void updateCannelSku(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updateCannelSku.null", (Object)"param is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateCannelSku.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updateCannelSkuBySkuCode(map);
    }

    private void updateCannelSkuBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuCannel.map is null");
        }
        try {
            this.rsSkuMapper.updateCannelSkuBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuCannel", (Throwable)e);
        }
    }

    private List<RsSku> querySkuByGoodsCodeAndState(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.querySkuByGoodsCodeAndState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByGoodsCodeAndState", (Throwable)e);
            return null;
        }
    }

    private void makeDefSku(RsSku rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
        BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
        BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
        BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
        BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
        BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
        BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
        rsResourceGoods.setPricesetMakeprice(rsResourceGoods.getPricesetMakeprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetMakeprice());
        rsResourceGoods.setPricesetBaseprice(rsResourceGoods.getPricesetBaseprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetBaseprice());
        rsResourceGoods.setPricesetAsprice(rsResourceGoods.getPricesetAsprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetAsprice());
        rsResourceGoods.setPricesetPrefprice(rsResourceGoods.getPricesetPrefprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetPrefprice());
        rsResourceGoods.setPricesetRefrice(rsResourceGoods.getPricesetRefrice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetRefrice());
        rsResourceGoods.setPricesetInsideprice(rsResourceGoods.getPricesetInsideprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetInsideprice());
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
        rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
        rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
        rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
        rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
        rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
        rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
    }

    @Override
    public RsSku getSkuBySkuNo(String skuNo, String tenantCode) {
        List<RsSku> rsSkuList = this.querySkuModelPage(this.getQueryParamMap("skuNo,tenantCode", new Object[]{skuNo, tenantCode}));
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public void updateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("skuEocode", skuEocode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public List<RsSenddata> deleteSkuByGoodsCodeNew(String goodsCode, String tenantCode, String goodsEocode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return null;
        }
        List<RsSku> rsSkuList = this.querySkuByGoodsCode(goodsCode, tenantCode);
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        this.deleteSkuModelByGoodsCode(goodsCode, tenantCode);
        for (RsSku rsSku : rsSkuList) {
            this.deleteSkuData(rsSku.getSkuCode(), tenantCode);
        }
        return this.saveSenddata(rsSkuList, "delete", goodsEocode);
    }

    @Override
    public void deleteSkuByGoodsCodeNoNew(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        List<RsSku> rsSkuList = this.querySkuByGoodsCode(goodsCode, tenantCode);
        if (ListUtil.isEmpty(rsSkuList)) {
            return;
        }
        this.deleteSkuModelByGoodsCode(goodsCode, tenantCode);
        for (RsSku rsSku : rsSkuList) {
            this.deleteSkuData(rsSku.getSkuCode(), tenantCode);
        }
    }

    @Override
    public List<RsSenddata> deleteSkuBySkuCodeNew(String skuCode, String tenantCode, String goodsEocode) {
        if (StringUtil.isBlank((String)skuCode) || StringUtil.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        RsSku rsSku = this.getSkuModelByCode(map);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCodeNew.rsSku");
        }
        this.deleteSkuBySkuCode(rsSku.getSkuCode(), tenantCode);
        this.deleteSkuData(rsSku.getSkuCode(), tenantCode);
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(rsSku);
        return this.saveSenddata(rsSkuList, "delete", goodsEocode);
    }

    private void deleteSkuData(String skuCode, String tenantCode) {
        if (StringUtil.isBlank((String)skuCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", skuCode);
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public List<RsSenddata> updatetSkuPassByGoodsCodeNew(Integer dataState, Integer oldDataState, String goodsCode, String tenantCode, String goodsEocode) {
        if (null == dataState || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String requestType = "";
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "insert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "down";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue() || oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "deleteop";
        }
        this.updateSkuStateByGoodsCode(goodsCode, tenantCode, dataState, dataOpbillstate, oldDataState);
        if (StringUtils.isNotBlank((String)requestType)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", goodsCode);
            map.put("tenantCode", tenantCode);
            List<RsSku> rsSkuList = this.querySkuModelPage(map);
            return this.saveSenddata(rsSkuList, requestType, goodsEocode);
        }
        return null;
    }

    private List<RsSenddata> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode) {
        if (ListUtil.isEmpty(rsSkuList) || StringUtils.isBlank((String)requestType)) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsSku rsSku : rsSkuList) {
            String fdBizcodestr = JsonUtil.buildNormalBinder().toJson(this.crateFdMap(goodsEocode, rsSku));
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsSku.getMemberCode());
            rsSenddataDomain.setChannelCode(rsSku.getChannelCode());
            rsSenddataDomain.setTenantCode(rsSku.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsSku.getGoodsCode());
            rsSenddataDomain.setFdBiztype("RsSku");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(rsSku.getDataState());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    @Override
    public List<RsSenddata> updatetSkuPassBySkuCodeNew(Integer dataState, Integer oldDataState, String skuCode, String tenantCode, String goodsEocode) {
        if (null == dataState || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String requestType = "";
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "insert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "down";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "deleteop";
        }
        this.updateSkuStateBySkuCode(skuCode, tenantCode, dataState, dataOpbillstate, oldDataState);
        if (StringUtils.isNotBlank((String)requestType)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", skuCode);
            map.put("tenantCode", tenantCode);
            RsSku rsSku = this.getSkuModelByCode(map);
            if (null == rsSku) {
                throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.rsSku");
            }
            ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
            rsSkuList.add(rsSku);
            return this.saveSenddata(rsSkuList, requestType, goodsEocode);
        }
        return null;
    }
}

