/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsClasstreeServiceImpl
extends BaseServiceImpl
implements RsClasstreeService {
    private static final String SYS_CODE = "rs.RsClasstreeServiceImpl";
    private RsClasstreeMapper rsClasstreeMapper;
    RsSenddataBaseService rsSenddataBaseService;

    public RsClasstreeMapper getRsClasstreeMapper() {
        return this.rsClasstreeMapper;
    }

    public void setRsClasstreeMapper(RsClasstreeMapper rsClasstreeMapper) {
        this.rsClasstreeMapper = rsClasstreeMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClasstree(RsClasstreeDomain rsClasstreeDomain) {
        if (null == rsClasstreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeDomain.getClasstreeName())) {
            msg = msg + "ClasstreeName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsClasstreeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClasstreeDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        if (null == rsClasstree.getDataState()) {
            rsClasstree.setDataState(0);
        }
        if (null == rsClasstree.getGmtCreate()) {
            rsClasstree.setGmtCreate(this.getSysDate());
        }
        rsClasstree.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsClasstree.getClasstreeCode())) {
            rsClasstree.setClasstreeCode(this.createUUIDString());
        }
    }

    private int getClasstreeMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClasstreeUpdataDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        rsClasstree.setGmtModified(this.getSysDate());
    }

    private void saveClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.insert(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeModel.ex", (Throwable)e);
        }
    }

    private void saveClasstreeListModel(List<RsClasstree> rsClasstrees) throws ApiException {
        if (ListUtil.isEmpty(rsClasstrees)) {
            return;
        }
        try {
            this.rsClasstreeMapper.insertBatch(rsClasstrees);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeListModel.ex", (Throwable)e);
        }
    }

    private RsClasstree getClasstreeModelById(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.selectByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelById", (Throwable)e);
            return null;
        }
    }

    public RsClasstree getClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.num");
        }
    }

    private void deleteClasstreeModel(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.deleteByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.num");
        }
    }

    private void updateClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.updateByPrimaryKeySelective(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstreeModel.ex", (Throwable)e);
        }
    }

    private void updateStateClasstreeModel(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == classtreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeId", classtreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsClasstreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.null");
        }
    }

    private RsClasstree makeClasstree(RsClasstreeDomain rsClasstreeDomain, RsClasstree rsClasstree) {
        if (null == rsClasstreeDomain) {
            return null;
        }
        if (null == rsClasstree) {
            rsClasstree = new RsClasstree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstree, (Object)rsClasstreeDomain);
            return rsClasstree;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClasstree", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstree> queryClasstreeModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeModel", (Throwable)e);
            return null;
        }
    }

    private int countClasstree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.countClasstree", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstree.checkClasstree", msg);
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
        this.setClasstreeDefault(rsClasstree);
        this.saveClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstree, "update");
        return rsClasstree.getClasstreeCode();
    }

    @Override
    public void saveClasstreeList(List<RsClasstreeDomain> rsClasstreeDomains) throws ApiException {
        if (ListUtil.isEmpty(rsClasstreeDomains)) {
            this.logger.error("rs.RsClasstreeServiceImpl.saveClasstreeList", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        ArrayList<RsClasstree> rsClasstrees = new ArrayList<RsClasstree>();
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeDomains) {
            String msg = this.checkClasstree(rsClasstreeDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeList.checkClasstree", msg);
            }
            RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
            this.setClasstreeDefault(rsClasstree);
            rsClasstrees.add(rsClasstree);
        }
        if (ListUtil.isNotEmpty(rsClasstrees)) {
            this.saveClasstreeListModel(rsClasstrees);
        }
    }

    @Override
    public void updateClasstreeState(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClasstreeModel(classtreeId, dataState, oldDataState);
    }

    @Override
    public void updateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.checkClasstree", msg);
        }
        RsClasstree oldRsClasstree = this.getClasstreeModelById(rsClasstreeDomain.getClasstreeId());
        if (null == oldRsClasstree) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, oldRsClasstree);
        this.setClasstreeUpdataDefault(rsClasstree);
        this.updateClasstreeModel(rsClasstree);
        this.processFLowDataForHtml(rsClasstree, "update");
    }

    @Override
    public RsClasstree getClasstree(Integer classtreeId) {
        return this.getClasstreeModelById(classtreeId);
    }

    @Override
    public void deleteClasstree(Integer classtreeId) throws ApiException {
        RsClasstree rsClasstree = this.getClasstree(classtreeId);
        this.deleteClasstreeModel(classtreeId);
        this.processFLowDataForHtml(rsClasstree, "deleteop");
    }

    @Override
    public QueryResult<RsClasstree> queryClasstreePage(Map<String, Object> map) {
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClasstree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeList);
        return queryResult;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstree(String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", "-1");
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree checkClasstreeName(String classtreeName, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeName) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String classtreeLast = "0";
        List<RsClasstree> classtrees = this.rsClasstreeMapper.query(this.getQueryMapParam("classtreeName,tenantCode,classtreeLast", new Object[]{classtreeName, tenantCode, classtreeLast}));
        if (ListUtil.isEmpty(classtrees)) {
            return null;
        }
        return classtrees.get(0);
    }

    private RsClasstreeReDomain makeRsClasstreeReDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeReDomain rsClasstreeReDomain = new RsClasstreeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeReDomain, (Object)rsClasstree);
            rsClasstreeReDomain.setChildList(this.queryClasstreeParent(rsClasstree.getMemberCode(), rsClasstree.getTenantCode(), rsClasstree.getClasstreeCode()));
        }
        catch (Exception e) {
            return null;
        }
        return rsClasstreeReDomain;
    }

    private List<RsClasstreeReDomain> queryClasstreeParent(String memberCode, String tenantCode, String classtreeParentcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", classtreeParentcode);
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree getClasstreeByCode(Map<String, Object> map) {
        return this.getClasstreeModelByCode(map);
    }

    @Override
    public void delClasstreeByCode(Map<String, Object> map) throws ApiException {
        RsClasstree rsClasstree = this.getClasstreeByCode(map);
        this.delClasstreeModelByCode(map);
        this.processFLowDataForHtml(rsClasstree, "deleteop");
    }

    @Override
    public List<RsClasstree> queryClasstreeByCodeList(Map<String, Object> parammap) {
        if (null == parammap) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeByCodeList", (Object)"param is null\uff01");
            return null;
        }
        return this.queryClasstreeModelByCodeList(parammap);
    }

    private List<RsClasstree> queryClasstreeModelByCodeList(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.queryClasstreeByCodeList(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeByCodeList", (Throwable)e);
            return null;
        }
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public void processFLowDataForHtml(RsClasstree rsClasstree, String esrequestType) {
        if (null == rsClasstree) {
            return;
        }
        ArrayList<RsFlowdata> rsFlowDataList = new ArrayList<RsFlowdata>();
        String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsClasstree);
        RsFlowdata rsFlowData = new RsFlowdata();
        int fdState = 0;
        if (esrequestType.equals("deleteop")) {
            fdState = -1;
        }
        rsFlowData.setFdBizcodestr(fdBizcodestr);
        rsFlowData.setEsrequestType("update");
        rsFlowData.setTenantCode(rsClasstree.getTenantCode());
        rsFlowData.setFdBizcode(rsClasstree.getClasstreeCode());
        rsFlowData.setChannelCode(rsClasstree.getChannelCode());
        rsFlowData.setFdBiztype("RsClasstree");
        rsFlowData.setFdState(fdState);
        rsFlowDataList.add(rsFlowData);
        this.getRsSenddataBaseService().sendFlowdataBatch(rsFlowDataList);
    }

    @Override
    public void saveResourceInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        this.classTreeInit(map, tenantCode);
    }

    private void classTreeInit(Map<String, Object> map, String tenantCode) {
        QueryResult<RsClasstree> rsClasstreeQueryResult = this.queryClasstreePage(map);
        List list = rsClasstreeQueryResult.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<RsClasstreeDomain> rsClasstreeDomains = new ArrayList<RsClasstreeDomain>();
        for (RsClasstree rsClasstree : list) {
            RsClasstree oldRsClasstree = this.getClasstreeByCode(this.getQueryMapParam("classtreeCode,tenantCode", new Object[]{rsClasstree.getClasstreeCode(), tenantCode}));
            if (null != oldRsClasstree) continue;
            RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
            rsClasstreeDomain.setClasstreeId(null);
            rsClasstreeDomain.setTenantCode(tenantCode);
            rsClasstreeDomains.add(rsClasstreeDomain);
            if (rsClasstreeDomains.size() != 100) continue;
            this.saveClasstreeList(rsClasstreeDomains);
            rsClasstreeDomains = new ArrayList();
        }
        if (ListUtil.isNotEmpty(rsClasstreeDomains)) {
            this.saveClasstreeList(rsClasstreeDomains);
        }
    }

    private RsClasstreeDomain makeClassTreeDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeDomain, (Object)rsClasstree);
            return rsClasstreeDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClassTreeDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void processFLowDataForHtml(String tenantCode) {
    }

    @Override
    public void updateclasstreeParentcode(String classtreeCode, String classtreeParentcode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)classtreeParentcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsClasstreeServiceImpl.updateBrandState.param", (Object)("classtreeCode:" + classtreeCode + ",classtreeParentcode:" + classtreeParentcode + ",tenantCode:" + tenantCode));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", tenantCode);
        RsClasstree rsClasstree = this.getClasstreeModelByCode(map);
        RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        this.updateClasstree(rsClasstreeDomain);
    }

    @Override
    public RsClasstree getClasstreeByName(String classtreeName, String tenantCode) {
        return this.getClasstreeModelByName(classtreeName, tenantCode);
    }

    @Override
    public void updateClasstreePtreeCode(String classtreeCode, String ptreeCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)ptreeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsClasstreeServiceImpl.updateBrandState.param", (Object)("classtreeCode:" + classtreeCode + ",ptreeCode:" + ptreeCode + ",tenantCode:" + tenantCode));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", tenantCode);
        RsClasstree rsClasstree = this.getClasstreeModelByCode(map);
        RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
        rsClasstreeDomain.setPntreeCode(ptreeCode);
        this.updateClasstree(rsClasstreeDomain);
    }

    public RsClasstree getClasstreeModelByName(String classtreeName, String tenantCode) {
        if (StringUtils.isEmpty((String)classtreeName) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.getClasstreeByName.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeName", classtreeName);
        map.put("tenantCode", tenantCode);
        try {
            return this.rsClasstreeMapper.selectByName(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeByName", (Throwable)e);
            return null;
        }
    }
}

