/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSensitMapper;
import com.yqbsoft.laser.service.resources.domain.RsSensitDomain;
import com.yqbsoft.laser.service.resources.domain.RsSensitReDomain;
import com.yqbsoft.laser.service.resources.model.RsSensit;
import com.yqbsoft.laser.service.resources.service.RsSensitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSensitServiceImpl
extends BaseServiceImpl
implements RsSensitService {
    private static final String SYS_CODE = "rs.RsSensitServiceImpl";
    private RsSensitMapper rsSensitMapper;

    public void setRsSensitMapper(RsSensitMapper rsSensitMapper) {
        this.rsSensitMapper = rsSensitMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSensitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSensit(RsSensitDomain rsSensitDomain) {
        if (null == rsSensitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSensitDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSensitDefault(RsSensit rsSensit) {
        if (null == rsSensit) {
            return;
        }
        if (null == rsSensit.getDataState()) {
            rsSensit.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSensit.getGmtCreate()) {
            rsSensit.setGmtCreate(date);
        }
        rsSensit.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSensit.getSensitCode())) {
            rsSensit.setSensitCode(this.getNo(null, "RsSensit", "rsSensit", rsSensit.getTenantCode()));
        }
    }

    private int getSensitMaxCode() {
        int code = 0;
        try {
            return this.rsSensitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.getSensitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSensitUpdataDefault(RsSensit rsSensit) {
        if (null == rsSensit) {
            return;
        }
        rsSensit.setGmtModified(this.getSysDate());
    }

    private void saveSensitModel(RsSensit rsSensit) throws ApiException {
        if (null == rsSensit) {
            return;
        }
        try {
            this.rsSensitMapper.insert(rsSensit);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.saveSensitModel.ex", (Throwable)e);
        }
    }

    private void saveSensitBatchModel(List<RsSensit> rsSensitList) throws ApiException {
        if (null == rsSensitList || rsSensitList.isEmpty()) {
            return;
        }
        try {
            this.rsSensitMapper.insertBatch(rsSensitList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.saveSensitBatchModel.ex", (Throwable)e);
        }
    }

    private RsSensit getSensitModelById(Integer sensitId) {
        if (null == sensitId) {
            return null;
        }
        try {
            return this.rsSensitMapper.selectByPrimaryKey(sensitId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.getSensitModelById", (Throwable)e);
            return null;
        }
    }

    private RsSensit getSensitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSensitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.getSensitModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSensitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSensitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.delSensitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSensitServiceImpl.delSensitModelByCode.num");
        }
    }

    private void deleteSensitModel(Integer sensitId) throws ApiException {
        if (null == sensitId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSensitMapper.deleteByPrimaryKey(sensitId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.deleteSensitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSensitServiceImpl.deleteSensitModel.num");
        }
    }

    private void updateSensitModel(RsSensit rsSensit) throws ApiException {
        if (null == rsSensit) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSensitMapper.updateByPrimaryKey(rsSensit);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.updateSensitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSensitServiceImpl.updateSensitModel.num");
        }
    }

    private void updateStateSensitModel(Integer sensitId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sensitId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sensitId", sensitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSensitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.updateStateSensitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSensitServiceImpl.updateStateSensitModel.null");
        }
    }

    private void updateStateSensitModelByCode(String tenantCode, String sensitCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sensitCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sensitCode", sensitCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSensitMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSensitServiceImpl.updateStateSensitModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSensitServiceImpl.updateStateSensitModelByCode.null");
        }
    }

    private RsSensit makeSensit(RsSensitDomain rsSensitDomain, RsSensit rsSensit) {
        if (null == rsSensitDomain) {
            return null;
        }
        if (null == rsSensit) {
            rsSensit = new RsSensit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSensit, (Object)rsSensitDomain);
            return rsSensit;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.makeSensit", (Throwable)e);
            return null;
        }
    }

    private RsSensitReDomain makeRsSensitReDomain(RsSensit rsSensit) {
        if (null == rsSensit) {
            return null;
        }
        RsSensitReDomain rsSensitReDomain = new RsSensitReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSensitReDomain, (Object)rsSensit);
            return rsSensitReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.makeRsSensitReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSensit> querySensitModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSensitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.querySensitModel", (Throwable)e);
            return null;
        }
    }

    private int countSensit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSensitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSensitServiceImpl.countSensit", (Throwable)e);
        }
        return i;
    }

    private RsSensit createRsSensit(RsSensitDomain rsSensitDomain) {
        String msg = this.checkSensit(rsSensitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSensitServiceImpl.saveSensit.checkSensit", msg);
        }
        RsSensit rsSensit = this.makeSensit(rsSensitDomain, null);
        this.setSensitDefault(rsSensit);
        return rsSensit;
    }

    @Override
    public String saveSensit(RsSensitDomain rsSensitDomain) throws ApiException {
        RsSensit rsSensit = this.createRsSensit(rsSensitDomain);
        this.saveSensitModel(rsSensit);
        return rsSensit.getSensitCode();
    }

    @Override
    public String saveSensitBatch(List<RsSensitDomain> rsSensitDomainList) throws ApiException {
        if (null == rsSensitDomainList || rsSensitDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSensit> rsSensitList = new ArrayList<RsSensit>();
        String code = "";
        for (RsSensitDomain rsSensitDomain : rsSensitDomainList) {
            RsSensit rsSensit = this.createRsSensit(rsSensitDomain);
            code = rsSensit.getSensitCode();
            rsSensitList.add(rsSensit);
        }
        this.saveSensitBatchModel(rsSensitList);
        return code;
    }

    @Override
    public void updateSensitState(Integer sensitId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sensitId) {
            return;
        }
        this.updateStateSensitModel(sensitId, dataState, oldDataState, map);
    }

    @Override
    public void updateSensitStateByCode(String tenantCode, String sensitCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sensitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSensitModelByCode(tenantCode, sensitCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSensit(RsSensitDomain rsSensitDomain) throws ApiException {
        String msg = this.checkSensit(rsSensitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSensitServiceImpl.updateSensit.checkSensit", msg);
        }
        RsSensit oldRsSensit = this.getSensitModelById(rsSensitDomain.getSensitId());
        if (null == oldRsSensit) {
            throw new ApiException("rs.RsSensitServiceImpl.updateSensit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSensit rsSensit = this.makeSensit(rsSensitDomain, oldRsSensit);
        this.setSensitUpdataDefault(rsSensit);
        this.updateSensitModel(rsSensit);
    }

    @Override
    public RsSensit getSensit(Integer sensitId) {
        if (null == sensitId) {
            return null;
        }
        return this.getSensitModelById(sensitId);
    }

    @Override
    public void deleteSensit(Integer sensitId) throws ApiException {
        if (null == sensitId) {
            return;
        }
        this.deleteSensitModel(sensitId);
    }

    @Override
    public QueryResult<RsSensit> querySensitPage(Map<String, Object> map) {
        List<RsSensit> rsSensitList = this.querySensitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSensit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSensitList);
        return queryResult;
    }

    @Override
    public RsSensit getSensitByCode(String tenantCode, String sensitCode) throws ApiException {
        if (StringUtils.isBlank((String)sensitCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sensitCode", sensitCode);
        return this.getSensitModelByCode(map);
    }

    @Override
    public void deleteSensitByCode(String tenantCode, String sensitCode) throws ApiException {
        if (StringUtils.isBlank((String)sensitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sensitCode", sensitCode);
        this.delSensitModelByCode(map);
    }
}

