/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.util.CollectionUtils;

public class RsSkuServiceImpl
extends BaseServiceImpl
implements RsSkuService {
    public static final String SYS_CODE = "rs.RsSkuServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsSpecValueService rsSpecValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsSenddataBaseService rsSenddataBaseService;
    RsResourceGoodsService rsResourceGoodsService;

    public RsResourceGoodsService getRsResourceGoodsService() {
        if (null == this.rsResourceGoodsService) {
            this.rsResourceGoodsService = (RsResourceGoodsService)ApplicationContextUtil.getService((String)"rsResourceGoodsService");
        }
        return this.rsResourceGoodsService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSpuCode())) {
            msg = msg + "spu\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = msg + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = msg + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        if (null == rsSku.getDataState()) {
            rsSku.setDataState(0);
        }
        if (null == rsSku.getDataOpbillstate()) {
            rsSku.setDataOpbillstate(0);
        }
        if (null == rsSku.getDataOpnextbillstate()) {
            rsSku.setDataOpnextbillstate(0);
        }
        Date date = this.getSysDate();
        if (null == rsSku.getGmtCreate()) {
            rsSku.setGmtCreate(date);
        }
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsWeight()) {
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        rsSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            String skuCode = this.getNo(null, RsSku.class.getSimpleName(), "skuCode", rsSku.getTenantCode());
            rsSku.setSkuCode(skuCode);
        }
        if (StringUtils.isBlank((String)rsSku.getSkuShowno())) {
            rsSku.setSkuShowno(rsSku.getSkuNo());
        }
        this.makeDefSku(rsSku);
        if (ResourcesConstants.DATA_OPBILLSTATE_1 == rsSku.getDataOpbillstate()) {
            this.setAuditModel(rsSku, false);
        }
    }

    private void makeInfo(RsSkuDomain rsSkuDomain) {
        List disFile;
        String[] skuShownoS;
        if (null == rsSkuDomain) {
            return;
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getChannelCode())) {
            return;
        }
        String showInfo = DisUtil.getMap((String)"DisDgoodsuplist-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()));
        if (StringUtils.isNotBlank((String)showInfo) && null != (skuShownoS = showInfo.split("\\|")) && skuShownoS.length > 0 && StringUtils.isNotBlank((String)skuShownoS[0])) {
            rsSkuDomain.setSkuShowno(skuShownoS[0]);
        }
        if (ListUtil.isNotEmpty((Collection)(disFile = DisUtil.getMapListJson((String)"DisDgoodsuplistFile-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()), RsGoodsFileDomain.class)))) {
            ArrayList<RsGoodsFileDomain> goodsFile = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain1 : disFile) {
                RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFileDomain1);
                    rsGoodsFileDomain.setGoodsFileCode(null);
                    goodsFile.add(rsGoodsFileDomain);
                }
                catch (Exception e) {}
            }
            rsSkuDomain.setRsGoodsFileDomainList(goodsFile);
        }
    }

    private int getSkuMaxCode() {
        int code = 0;
        try {
            return this.rsSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuUpdataDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
        rsSku.setGmtModified(this.getSysDate());
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private RsSku getSkuModelById(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        try {
            return this.rsSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelById", (Throwable)e);
            return null;
        }
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelByCode", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    public void delSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.num");
        }
    }

    public void updateSkuEocodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuEocode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.num");
        }
    }

    private void updateSkuNextModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuNextByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNextModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNextModelByCode.num", map.toString());
        }
    }

    public void updateGoodsEocodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateGoodsEocode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeModelByCode.num");
        }
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.ex", skuId + "", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.num");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateSkuModelWithNull(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
            this.rsSkuMapper.updateByPrimaryKey(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    @Override
    public boolean updateNum(String skuNo, String tenantCode, BigDecimal num) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode) || null == num) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        boolean flag = false;
        Map map = this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode});
        List<RsSku> skus = this.rsSkuMapper.query(map);
        if (null == skus || ListUtil.isEmpty(skus)) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u65e0\u6570\u636e");
            return false;
        }
        Integer dataOpbillstate = skus.get(0).getDataOpbillstate();
        if (dataOpbillstate == 1) {
            map.put("goodsSupplynum", num);
        } else {
            map.put("goodsNum", num);
        }
        map.put("dataOpbillstate", dataOpbillstate);
        int i = this.rsSkuMapper.updateNum(map);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.null");
        }
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsSku) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeSku", (Throwable)e);
            if (null == rsSku.getGoodsNum()) {
                rsSku.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsWeight()) {
                rsSku.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplynum()) {
                rsSku.setGoodsSupplynum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplyweight()) {
                rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsOneweight()) {
                rsSku.setGoodsOneweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsMinnum() || rsSku.getGoodsMinnum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsMinnum(new BigDecimal("1"));
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) != 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsSupplynum(rsSku.getGoodsNum());
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsNum(rsSku.getGoodsSupplynum());
                rsSku.setGoodsWeight(rsSku.getGoodsSupplyweight());
            }
            if (rsSku.getGoodsWeight().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsOneweight().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsWeight(rsSku.getGoodsNum().multiply(rsSku.getGoodsOneweight()));
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
        if (null != rsSku) {
            return rsSku.getSkuCode();
        }
        return null;
    }

    private RsSku saveSkuMode(RsSkuDomain rsSkuDomain) {
        RsSku oldRsSku;
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        if (null != rsSkuDomain.getOldDataState()) {
            rsSku.setDataState(rsSkuDomain.getOldDataState());
        }
        this.setSkuDefault(rsSku);
        rsSku.setSkuName(this.sortSkuName(rsSku.getSkuName()));
        if (StringUtils.isNotBlank((String)rsSkuDomain.getSkuCode()) && null != (oldRsSku = this.getSkuModelByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsSkuDomain.getSkuCode(), rsSkuDomain.getTenantCode()})))) {
            rsSku.setSkuId(oldRsSku.getSkuId());
        }
        if (null != rsSku.getSkuId()) {
            this.updateSkuModel(rsSku);
        } else {
            this.saveSkuModel(rsSku);
        }
        this.saveSpecList(rsSkuDomain.getSpecList(), rsSkuDomain.getGoodsCode());
        return rsSku;
    }

    @Override
    public List<RsSenddata> saveSkuListOne(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, false, false);
    }

    @Override
    public List<RsSenddata> updateSkuListOne(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, false, true);
    }

    public List<RsSenddata> saveSkuListRe(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods, boolean flag, boolean upflag) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty() || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuListRe.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        ArrayList<RsSku> rsSkuListsend = new ArrayList<RsSku>();
        boolean skuadd = false;
        String senddataParentcode = null;
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            skuadd = false;
            senddataParentcode = null;
            if (StringUtils.isBlank((String)rsSkuDomain.getSkuCode())) {
                skuadd = true;
            }
            Integer dataOpbillstate = rsSkuDomain.getDataOpbillstate();
            RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
            if (!upflag || skuadd) {
                rsSkuListsend.add(rsSku);
                List<RsSenddata> downList = this.saveSenddata(rsSkuListsend, "skuadd", rsResourceGoods.getGoodsEocode(), null);
                if (ListUtil.isNotEmpty(downList)) {
                    rsSenddataList.addAll(downList);
                }
            }
            if (flag) {
                List<RsSenddata> skuRsSenddataList;
                if (ResourcesConstants.DATA_OPBILLSTATE_1 != dataOpbillstate || !ListUtil.isNotEmpty(skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.GOODS_DATA_STATE_0, rsSku.getSkuCode(), rsSku.getTenantCode(), rsResourceGoods))) continue;
                senddataParentcode = skuRsSenddataList.get(0).getSenddataCode();
                rsSenddataList.addAll(skuRsSenddataList);
                continue;
            }
            if (upflag && ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == dataOpbillstate.intValue()) {
                this.saveMinNum(rsResourceGoods, rsSku, rsSenddataList, senddataParentcode);
                continue;
            }
            if (!upflag || ResourcesConstants.GOODS_DATA_STATE_4.intValue() != rsSku.getDataState().intValue()) continue;
            this.saveMinNum(rsResourceGoods, rsSku, rsSenddataList, senddataParentcode);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsSenddata> saveSkuList(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, true, false);
    }

    private RsSku saveSkuDomain(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        this.makeInfo(rsSkuDomain);
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsSkuDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        this.makePic(rsSkuDomain, rsGoodsFileDomainList, dataPic);
        RsSku rsSku = this.saveSkuMode(rsSkuDomain);
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{rsSku.getSkuCode(), rsSku.getTenantCode()});
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (ListUtil.isNotEmpty(rsSkuDomain.getRsGoodsFileDomainList())) {
            ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsFileDomain.setGoodsFileCode(null);
                rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
                rsGoodsFileDomain.setGoodsFileId(null);
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsskuGoodsFileDomainList);
        }
        rsSkuDomain.setSkuCode(rsSku.getSkuCode());
        this.saveSkuRel(rsSkuDomain);
        return rsSku;
    }

    private void makePic(RsSkuDomain rsSkuDomain, List<RsGoodsFileDomain> rsGoodsFileDomainList, String dataPic) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (null == rsGoodsFileDomain || StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSkuDomain.setDataPic(dataPic);
    }

    private String sortSkuName(String skuName) {
        if (StringUtils.isBlank((String)skuName)) {
            return null;
        }
        List<String> spcList = Arrays.asList(skuName.split("\\/"));
        return this.sortSpcList(spcList);
    }

    private String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }

    private void saveSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : valueList) {
            rsSpecValueDomain.setSpecValueBillno(goodsCode);
        }
        this.rsSpecValueService.saveSpecValueList(valueList);
    }

    @Override
    public void updateSkuState(RsSku rsSku, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rsSku || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"\u6570\u636e\u4e3a\u7a7a");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuState", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateSkuModel(rsSku.getSkuId(), dataState, oldDataState);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"rsSkuDomain is null");
            return;
        }
        if (ResourcesConstants.GOODS_DATA_STATE_NO.equals(dataState)) {
            // empty if block
        }
        if (ResourcesConstants.GOODS_DATA_STATE_0.equals(dataState)) {
            // empty if block
        }
    }

    @Override
    public void updateSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
            rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        }
        this.updateComSku(rsSkuDomain, oldRsSku);
    }

    private RsSku updateComSku(RsSkuDomain rsSkuDomain, RsSku oldRsSku) {
        if (null == rsSkuDomain || null == oldRsSku) {
            return null;
        }
        this.makeInfo(rsSkuDomain);
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuFile(rsSkuDomain.getRsGoodsFileDomainList(), rsSku);
        this.setSkuUpdataDefault(rsSku);
        this.updateSkuModel(rsSku);
        this.saveSkuRel(rsSkuDomain);
        this.deltaUpdateSpecList(rsSkuDomain.getSpecList(), rsSku.getGoodsCode());
        return rsSku;
    }

    private void saveSkuRel(RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsRelType", "3");
        map.put("goodsSkuCode", rsSkuDomain.getSkuCode());
        map.put("tenantCode", rsSkuDomain.getTenantCode());
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
        if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode("");
                rsGoodsRelDomain.setGoodsSkuCode(rsSkuDomain.getSkuCode());
                rsGoodsRelDomain.setGoodsRelType("3");
                rsGoodsRelDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsSkuDomain.getMemberName());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsSkuDomain.getRsGoodsRelDomainList());
        }
    }

    @Override
    public void updateSkuFile(String skuCode, String tenantCode, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || CollectionUtils.isEmpty(rsGoodsFileDomainList)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile param null");
            return;
        }
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode});
        RsSku rsSku = this.getSkuModelByCode(paramMap);
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile rsSku null");
            return;
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (null == rsGoodsFileDomain.getDefaultState() || rsGoodsFileDomain.getDefaultState() != ResourcesConstants.FILE_DEFAULTSTATE_1 || !FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSku.setDataPic(dataPic);
        this.updateSkuModel(rsSku);
    }

    private void deltaUpdateSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (CollectionUtils.isEmpty(valueList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsSpecValueDomain> i = valueList.iterator();
        while (i.hasNext()) {
            RsSpecValueDomain valueDomain = i.next();
            valueDomain.setSpecValueBillno(goodsCode);
            params.put("tenantCode", valueDomain.getTenantCode());
            params.put("specValueCode", valueDomain.getSpecValueCode());
            RsSpecValue exist = this.rsSpecValueService.getSpecValueByCode(params);
            if (exist == null) continue;
            this.rsSpecValueService.updateSpecValue(valueDomain);
            i.remove();
        }
        this.saveSpecList(valueList, goodsCode);
    }

    @Override
    public RsSku getSku(Integer skuId) {
        return this.getSkuModelById(skuId);
    }

    @Override
    public void deleteSkuSyn(Integer skuId) {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
    }

    @Override
    public void deleteSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
        this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
    }

    private RsSkuDomain makeRsSkuNofileDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSkuDomain;
    }

    private RsSkuDomain makeRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("skuCode", rsSku.getSkuCode());
        map1.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
        if (null != rsSkuFileList) {
            rsSkuDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsSkuFileList.getList()));
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("goodsSkuCode", rsSku.getSkuCode());
        map2.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsRel> rsSkuRelList = this.rsGoodsOtherService.queryGoodsRelPage(map2);
        if (null != rsSkuRelList) {
            rsSkuDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsSkuRelList.getList()));
        }
        return rsSkuDomain;
    }

    private List<RsSkuDomain> makeRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception e) {
            // empty catch block
        }
        RsSku rsSku = this.rsSkuMapper.getByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRelDomain.getSkuCode(), rsGoodsRelDomain.getTenantCode()}));
        if (null != rsSku) {
            rsGoodsRelDomain.setSkuNo(rsSku.getSkuNo());
        }
        return rsGoodsRelDomain;
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    @Override
    public RsSkuDomain getSkuBySkuEocode(String skuEocode, String memberCcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCcode) && StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("skuEocode", skuEocode);
        if (StringUtils.isNotBlank((String)memberCcode)) {
            parammap.put("memberCcode", memberCcode);
        } else {
            parammap.put("memberCode", memberCode);
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(parammap);
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        return this.makeRsSkuNofileDomain(rsSkuList.get(0));
    }

    @Override
    public QueryResult<RsSku> querySkuOnePage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            throw new ApiException("rs.RsSkuServiceImpl.querySkuOnePage.param is null or tenantCode is null ");
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        map.remove("startRow");
        map.remove("rows");
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public RsSku getSkuBySpec(List<String> spcList, String goodsCode, String tenantCode) {
        if (null == spcList || spcList.isEmpty() || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String skuName = this.sortSpcList(spcList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public RsSku getSkuByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return rsSku;
    }

    @Override
    public RsSkuDomain getSkuDomainByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return this.makeRsSkuDomain(rsSku);
    }

    @Override
    public List<RsSku> checkSkuNo(String skuNo, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkSkuNo.param.null");
        }
        return this.rsSkuMapper.query(this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode}));
    }

    @Override
    public void delSkuByCode(Map<String, Object> map) throws ApiException {
        RsSku rsSku = this.getSkuModelByCode(map);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuByCode.rsSku");
        }
        this.delSkuModelByCode(map);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public void deleteSkuList(List<Integer> skuIds) throws ApiException {
        if (skuIds == null || skuIds.isEmpty()) {
            return;
        }
        for (Integer skuId : skuIds) {
            this.deleteSku(skuId);
        }
    }

    @Override
    public void updateAhSkuList(List<RsSkuDomain> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        for (RsSkuDomain rsSkuDomain : skuList) {
            RsSku rsSku = new RsSku();
            this.makeSku(rsSkuDomain, rsSku);
            rsSkus.add(rsSku);
        }
        this.updateAh(rsSkus);
    }

    public void updateAhSku(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.checkSku", msg);
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_3 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_4) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        rsSku.setSkuSort(null);
        this.updateSkuModelWithNull(rsSku);
    }

    @Override
    public void updateCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, false);
    }

    @Override
    public void updateGoodsCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, true);
    }

    public void updateCannelSkuList(List<Integer> skuIds, boolean disflag) throws ApiException {
        if (ListUtil.isEmpty(skuIds)) {
            this.logger.error("rs.RsSkuServiceImpl.updateCannelSkuList", (Object)"skuIds is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "skuIds is null");
        }
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (ListUtil.isEmpty(skuList)) {
            return;
        }
        this.updateCannel(skuList);
    }

    public RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsResourceGoodsReDomain;
    }

    private void updateCannel(List<RsSku> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, false);
        }
    }

    private void updateCannelMode(RsSku rsSku, boolean dataState) {
        if (null == rsSku) {
            return;
        }
        BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
        rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsSupplyweight));
        }
        rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().subtract(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().subtract(goodsSupplyweight));
        }
        rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
        if (dataState) {
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
        }
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
        this.updateSkuModel(rsSku);
    }

    @Override
    public void updateAuditSkuPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    private void updateAuditPass(List<RsSku> skuList, boolean put) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateAuditModel(rsSku, put);
        }
    }

    @Override
    public void updateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSku> skuList;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (skuList = this.querySkuModelPage(parammap)) || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, true);
        }
    }

    private void updateAuditModel(RsSku rsSku, boolean put) {
        this.setAuditModel(rsSku, put);
        this.updateSkuModel(rsSku);
    }

    private void setAuditModel(RsSku rsSku, boolean put) {
        if (null == rsSku) {
            return;
        }
        rsSku.setSkuHdate(this.getSysDate());
    }

    @Override
    public void updateAuditSkuNoPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsAhnum));
            if (goodsAhweight == null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            this.updateSkuModel(rsSku);
        }
    }

    private List<RsSku> checkAuditSku(List<Integer> skuIds) {
        if (skuIds == null || skuIds.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.getSkuModelById(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            skuList.add(rsSku);
        }
        return skuList;
    }

    private List<RsSku> checkAuditSku(String goodsCode, String tenantCode) {
        if (goodsCode == null || goodsCode.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.goodsCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", 0);
        List<RsSku> skuList = this.rsSkuMapper.query(map);
        if (ListUtil.isEmpty(skuList)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.skuList", "\u6570\u636e\u4e3a\u7a7a:" + ((Object)map).toString());
        }
        String mschannelName = null;
        String mschannelCode = null;
        map.remove("dataOpbillstate");
        for (RsSku rsSku : skuList) {
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.rsSku", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            rsSku.setMschannelCode(mschannelCode);
            rsSku.setMschannelName(mschannelName);
        }
        return skuList;
    }

    @Override
    public void querySkuAll(Map<String, Object> map) {
        if (map != null) {
            map.put("dataOpbillstate", 1);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(this.queryforEs(map)));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<EsSku> queryforEs(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.queryForEs(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.queryforEs.error", e.getMessage());
        }
    }

    @Override
    public void updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("goodsCode", goodsCode);
        parammap.put("dataState", 0);
        List<RsSku> skuList = this.querySkuModelPage(parammap);
        this.updateAh(skuList);
    }

    private void updateAh(List<RsSku> skuList) {
        if (null == skuList || skuList.isEmpty()) {
            return;
        }
        List skuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(skuList), RsSkuDomain.class);
        for (RsSkuDomain rsSkuDomain : skuDomainList) {
            this.updateAhModel(rsSkuDomain);
        }
    }

    protected void updateAhModel(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return;
        }
        BigDecimal goodsNum = rsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = rsSkuDomain.getGoodsWeight();
        goodsNum = goodsNum == null ? BigDecimal.ZERO : goodsNum;
        goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
        rsSkuDomain.setGoodsAhnum(goodsNum);
        rsSkuDomain.setGoodsAhweight(goodsWeight);
        rsSkuDomain.setGoodsNum(goodsNum.subtract(goodsNum));
        rsSkuDomain.setGoodsWeight(goodsWeight.subtract(goodsWeight));
        this.updateAhSku(rsSkuDomain);
    }

    @Override
    public void updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    @Override
    public void updatetSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, true);
    }

    @Override
    public void updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsSkuMapper.updateByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String goodsCode, String tenantCode) {
        if (goodsNum == null || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", "param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsNum", goodsNum);
        map.put("skuCode", goodsCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuGoodsNumByGoodsCode(map);
    }

    private void updateSkuGoodsNumByGoodsCode(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuGoodsNumByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.null");
        }
    }

    private List<RsSku> queryDisSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countDisSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countDisSku(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<RsSku> queryDisSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryDisSku(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDisSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> queryDisAndSkuPage(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisAndSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.queryDisAndSku(map));
        return queryResult;
    }

    private List<RsSku> queryDisAndSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisAndSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int queryDisAndSkuCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.queryDisAndSkuCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.updateSku(rsSkuDomain);
        }
    }

    @Override
    public List<RsSku> querySkuByPntreeCode(Map<String, Object> map) {
        try {
            return this.rsSkuMapper.querySkuByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByPntreeCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        this.updateSortNoSkuModel(tenantCode, goodsCode, skuCode, sortNo);
    }

    private void updateSortNoSkuModel(String tenantCode, String goodsCode, String skuCode, Integer sortNo) throws ApiException {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode) && StringUtil.isBlank((String)skuCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        map.put("skuCode", skuCode);
        map.put("gmtModified", this.getSysDate());
        map.put("sortNo", sortNo);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSortNoSku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.null");
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.null", map.toString());
        }
    }

    @Override
    public void updateSkuStock(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModel(map);
    }

    @Override
    public List<RsSku> querySkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        return this.querySkuModelPage(map);
    }

    @Override
    public void updateSkuEditOne(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit", "editSkuDomain/oldRsSku is null");
        }
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuEdit.checkSkuEdit", (Object)msg);
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.checkSku", msg);
        }
        this.updateEditSku(editSkuDomain);
    }

    @Override
    public List<RsSenddata> updateSkuEdit(EditSkuDomain editSkuDomain, RsResourceGoods rsResourceGoods) {
        if (null == editSkuDomain || null == rsResourceGoods) {
            return null;
        }
        this.updateSkuEditOne(editSkuDomain);
        RsSku oldRsSku = this.getSku(editSkuDomain.getSkuId());
        if (oldRsSku == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.RsSku", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(oldRsSku);
        List<RsSenddata> rsSenddataList = this.saveSenddata(rsSkuList, "edit", editSkuDomain.getGoodsEocode(), null);
        String parentCode = null;
        if (null == rsSenddataList) {
            rsSenddataList = new ArrayList<RsSenddata>();
        } else if (ListUtil.isNotEmpty(rsSenddataList)) {
            parentCode = rsSenddataList.get(0).getSenddataCode();
        }
        this.saveMinNum(rsResourceGoods, oldRsSku, rsSenddataList, parentCode);
        return rsSenddataList;
    }

    private void saveMinNum(RsResourceGoods rsResourceGoods, RsSku oldRsSku, List<RsSenddata> rsSenddataList, String senddataParentcode) {
        List<RsSenddata> rlist;
        if (null == rsSenddataList || null == rsResourceGoods || null == oldRsSku || null == oldRsSku.getDataOpbillstate()) {
            return;
        }
        DisChannel disChannel = this.getChannel(oldRsSku.getChannelCode(), oldRsSku.getTenantCode());
        if (null == disChannel) {
            return;
        }
        if (oldRsSku.getDataOpbillstate().intValue() == ResourcesConstants.DATA_OPBILLSTATE_1.intValue()) {
            List<RsSenddata> rlist2;
            if (this.makeNum(rsResourceGoods, oldRsSku, disChannel, false) && ListUtil.isNotEmpty(rlist2 = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_4, oldRsSku.getDataState(), oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods, false, senddataParentcode))) {
                rsSenddataList.addAll(rlist2);
            }
        } else if (ResourcesConstants.GOODS_DATA_STATE_4.intValue() == oldRsSku.getDataState().intValue() && this.makeNum(rsResourceGoods, oldRsSku, disChannel, true) && ListUtil.isNotEmpty(rlist = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, oldRsSku.getDataState(), oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods, false, senddataParentcode))) {
            rsSenddataList.addAll(rlist);
        }
    }

    private RsSkuDomain makeSkuDomain(RsSku oldRsSku, RsSkuDomain rsSkuDomain) {
        if (null == oldRsSku) {
            return null;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = new RsSkuDomain();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)oldRsSku);
            return rsSkuDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeRsSkuDomain", (Throwable)e);
            return rsSkuDomain;
        }
    }

    private void updateEditSku(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            return;
        }
        try {
            this.rsSkuMapper.updateEditSku(editSkuDomain);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private String checkSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)editSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getSkuCode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public RsSku getRsSkuModelByOldCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByOldCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getRsSkuModelByOldCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> updateDisAuditSku(RsSkuDomain rsSkuDomain, RsResourceGoods rsResourceGoods, String dgoodsPut) throws ApiException {
        if (null == rsSkuDomain || null == rsResourceGoods) {
            this.logger.error("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null", (Object)"rsSkuDomain is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null");
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku && (oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}))) == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        rsSkuDomain.setDataOpnextbillstate(0);
        rsSkuDomain.setGoodsSp(oldRsSku.getGoodsSp());
        rsSkuDomain.setSkuId(oldRsSku.getSkuId());
        rsSkuDomain.setOldDataState(oldRsSku.getDataState());
        rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        Integer oldDataState = oldRsSku.getDataState();
        oldRsSku = this.updateComSku(rsSkuDomain, oldRsSku);
        List<RsSenddata> skuRsSenddataList = null;
        if ("1".equals(dgoodsPut) && oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_3.intValue()) {
            skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, oldDataState, oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods);
        }
        return skuRsSenddataList;
    }

    private void setSkuFile(List<RsGoodsFileDomain> rsGoodsFileDomainList, RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.setSkuFile param null");
            throw new ApiException("rs.RsSkuServiceImpl.setSkuFile.param.null");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCode", rsSku.getSkuCode());
        paramMap.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
            rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
            rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
            rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
            rsGoodsFileDomain.setGoodsFileId(null);
            rsGoodsFileDomain.setGoodsFileCode(null);
            if (rsGoodsFileDomain.getDefaultState() != null && rsGoodsFileDomain.getDefaultState() == 1) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            }
            rsSku.setDataPic(dataPic);
        }
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
    }

    @Override
    public void updateSoldOutSku(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSoldOutSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateSoldOutSku.null");
        }
        this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSku(rsSku.getSkuId());
    }

    @Override
    public void updateShelveSku(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
        this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{rsSku.getSkuCode(), rsSku.getTenantCode()}));
        if (rsSku == null) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
    }

    @Override
    public void updateSkuStateBySkuId(RsSku rsSku, Integer dataState, Integer oldState) {
        if (null == rsSku || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuId.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuId.null");
        }
        this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        rsSku.setDataState(dataState);
    }

    @Override
    public void deleteSkuByCode(RsSku rsSku) {
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSku.null", (Object)"rsSku is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.null");
        }
        this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
    }

    @Override
    public List<RsSkuDomain> queryHotSkuList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList", (Object)"map is null");
            return null;
        }
        return this.queryHotGoods(map);
    }

    public List<RsSkuDomain> queryHotGoods(Map<String, Object> map) {
        String rsSkuDomainrList = "";
        try {
            rsSkuDomainrList = (String)this.getInternalRouter().inInvoke("omns.mb.sendqueryGoodsList", map);
            if (StringUtils.isBlank((String)rsSkuDomainrList)) {
                this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter", (Object)("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
            return null;
        }
        List rsSkuDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(rsSkuDomainrList, RsSkuDomain.class);
        return rsSkuDomainList;
    }

    @Override
    public void updatetSkuSoldOutByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updatetSkuShelveByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuShelveByGoodsCode", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updateSkuStateByGoodsCode(Map<String, Object> parammap) {
        if (null == parammap || parammap.isEmpty()) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        Integer dataState = (Integer)parammap.remove("dataState");
        if (null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "dataState is null");
        }
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(parammap);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        }
    }

    @Override
    public void deleteSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuByGoodsCode", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuByGoodsCode.", (Object)"rsSkus is null");
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    private boolean deleteSkuBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCode", "skuCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCode", ((Object)map).toString(), (Throwable)e);
        }
        return i > 0;
    }

    private boolean deleteSkuModelByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.rsSkuMapper.delByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", ((Object)map).toString(), (Throwable)e);
        }
        return i > 0;
    }

    private boolean updateSkuStateBySkuCode(String skuCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStateBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", (Throwable)e);
        }
        return i > 0;
    }

    private boolean updateSkuStateByGoodsCode(String goodsCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState, String oldDataStateStr) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Object)"parammap is null");
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        map.put("oldDataStateStr", oldDataStateStr);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStateByGoodsCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Throwable)e);
        }
        return i > 0;
    }

    private void updatetSkuShelveBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuShelveBySkuCode.null", (Object)"param is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveBySkuCode.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updatetSkuPassBySkuCode(map);
    }

    private void updatetSkuPassBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeMap is null");
        }
        try {
            this.rsSkuMapper.updatetSkuPassBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImplupdatetSkuShelveBySkuCode.", (Throwable)e);
        }
    }

    private void updateCannelSku(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updateCannelSku.null", (Object)"param is nulll");
            throw new ApiException("rs.RsSkuServiceImpl.updateCannelSku.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updateCannelSkuBySkuCode(map);
    }

    private void updateCannelSkuBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuCannel.map is null");
        }
        try {
            this.rsSkuMapper.updateCannelSkuBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuCannel", (Throwable)e);
        }
    }

    private List<RsSku> querySkuByGoodsCodeAndState(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.querySkuByGoodsCodeAndState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByGoodsCodeAndState", (Throwable)e);
            return null;
        }
    }

    private void makeDefSku(RsSku rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
        BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
        BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
        BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
        BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
        BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
        BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
        rsResourceGoods.setPricesetMakeprice(rsResourceGoods.getPricesetMakeprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetMakeprice());
        rsResourceGoods.setPricesetBaseprice(rsResourceGoods.getPricesetBaseprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetBaseprice());
        rsResourceGoods.setPricesetAsprice(rsResourceGoods.getPricesetAsprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetAsprice());
        rsResourceGoods.setPricesetPrefprice(rsResourceGoods.getPricesetPrefprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetPrefprice());
        rsResourceGoods.setPricesetRefrice(rsResourceGoods.getPricesetRefrice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetRefrice());
        rsResourceGoods.setPricesetInsideprice(rsResourceGoods.getPricesetInsideprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetInsideprice());
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
        rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
        rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
        rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
        rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
        rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
        rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
    }

    @Override
    public RsSku getSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        List<RsSku> rsSkuList = this.querySkuModelPage(this.getQueryParamMap("skuNo,memberCcode,memberCode,channelCode,tenantCode", new Object[]{skuNo, memberCcode, memberCode, channelCode, tenantCode}));
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        if (null == channelCode) {
            channelCode = "";
        }
        for (RsSku rsSku : rsSkuList) {
            if (null == rsSku.getChannelCode()) {
                rsSku.setChannelCode("");
            }
            if (!channelCode.equals(rsSku.getChannelCode())) continue;
            return rsSku;
        }
        return null;
    }

    @Override
    public RsSku getSkuBySkuNoAndMemberCode(String skuNo, String memberCode, String tenantCode) {
        List<RsSku> rsSkuList = this.querySkuModelPage(this.getQueryParamMap("skuNo,memberCode,tenantCode", new Object[]{skuNo, memberCode, tenantCode}));
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        for (RsSku rsSku : rsSkuList) {
            if ("18".equals(rsSku.getGoodsOrigin())) continue;
            return rsSku;
        }
        return null;
    }

    @Override
    public void updateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("skuEocode", skuEocode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public void updateSkuEocodeByNo(String skuNo, String memberCcode, String skuEocode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", skuNo);
        map.put("skuEocode", skuEocode);
        map.put("memberCcode", memberCcode);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public void updateVerByNo(String skuNo, String memberCcode, Integer channelTver, String channelCode, String tenantCode) throws ApiException {
        if (null == channelTver || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateVerByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", skuNo);
        map.put("channelTver", channelTver);
        map.put("memberCcode", memberCcode);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public List<RsSenddata> deleteSkuByGoodsCodeNew(String goodsCode, String tenantCode, List<RsSku> rsSkuList) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode) || ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        if (!this.deleteSkuModelByGoodsCode(goodsCode, tenantCode)) {
            return null;
        }
        for (RsSku rsSku : rsSkuList) {
            this.deleteSkuData(rsSku.getSkuCode(), tenantCode);
        }
        return null;
    }

    @Override
    public List<RsSenddata> deleteSkuByGoodsCodeNoNew(String goodsCode, String tenantCode, String goodsEocode, Map<String, String> skuCodeMap) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return null;
        }
        List<RsSku> rsSkuList = this.querySkuByGoodsCode(goodsCode, tenantCode);
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSenddata> relist = new ArrayList<RsSenddata>();
        for (RsSku rsSku : rsSkuList) {
            List<RsSenddata> list;
            if (MapUtil.isNotEmpty(skuCodeMap) && StringUtils.isNotBlank((String)skuCodeMap.get(rsSku.getSkuCode()))) continue;
            this.deleteSkuModel(rsSku.getSkuId());
            this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!ListUtil.isNotEmpty(list = this.saveSenddata(rsSkuList, "skudelete", goodsEocode, rsSkuDomain, null))) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<RsSenddata> deleteSkuBySkuCodeNew(RsSkuDomain rsSkuDomain, RsResourceGoods rsResourceGoods) {
        if (null == rsSkuDomain || null == rsResourceGoods) {
            return null;
        }
        RsSku rsSku = new RsSku();
        try {
            BeanUtils.copyAllPropertys((Object)rsSku, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode())) {
            return null;
        }
        this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(rsSku);
        return this.saveSenddata(rsSkuList, "skudelete", rsResourceGoods.getGoodsEocode(), rsSkuDomain, null);
    }

    private void deleteSkuData(String skuCode, String tenantCode) {
        if (StringUtil.isBlank((String)skuCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", skuCode);
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public List<RsSenddata> updatetSkuPassByGoodsCodeNew(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, String senddataParentcode) {
        if (null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.rsResourceGoods", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.updatetSkuPassByGoodsCodeNew(dataState, oldDataState, rsResourceGoods, true, senddataParentcode);
    }

    private List<RsSenddata> updatetSkuPassByGoodsCodeNew(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, boolean minnum, String senddataParentcode) {
        if (null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.rsResourceGoods", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String goodsCode = rsResourceGoods.getGoodsCode();
        String tenantCode = rsResourceGoods.getTenantCode();
        if (null == dataState || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String requestType = "";
        if (null == oldDataState) {
            oldDataState = rsResourceGoods.getDataState();
        }
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "insert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "down";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "deleteop";
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "add";
        }
        if (!this.updateSkuStateByGoodsCode(goodsCode, tenantCode, dataState, dataOpbillstate, oldDataState, null)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.updateSkuStateByGoodsCode", (Object)(goodsCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        if (StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.requestType", (Object)(goodsCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        return this.saveSkuSend(dataState, oldDataState, rsResourceGoods, requestType, null, minnum, senddataParentcode);
    }

    private List<RsSenddata> saveSkuSend(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, String requestType, RsSku rsSku, boolean minnum, String senddataParentcode) {
        List<RsSenddata> downList;
        List<RsSenddata> upList;
        if (null == rsResourceGoods || null == dataState) {
            return null;
        }
        List<Object> rsSkuList = new ArrayList<RsSku>();
        boolean skuflag = true;
        if (null == rsSku) {
            skuflag = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoods.getGoodsCode());
            map.put("tenantCode", rsResourceGoods.getTenantCode());
            rsSkuList = this.querySkuModelPage(map);
        } else {
            rsSkuList.add(rsSku);
        }
        List<RsSku> rsSkuListsend = new ArrayList<RsSku>();
        String goodsEocode = rsResourceGoods.getGoodsEocode();
        ArrayList<RsSku> rsSkuDownListsend = new ArrayList<RsSku>();
        if (minnum && dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            DisChannel disChannel = this.getChannel(rsResourceGoods.getChannelCode(), rsResourceGoods.getTenantCode());
            if (null != disChannel) {
                for (RsSku rsSku2 : rsSkuList) {
                    rsSkuListsend.add(rsSku2);
                    if (!this.makeNum(rsResourceGoods, rsSku2, disChannel, false)) continue;
                    this.updateSkuStateBySkuCode(rsSku2.getSkuCode(), rsSku2.getTenantCode(), ResourcesConstants.GOODS_DATA_STATE_4, ResourcesConstants.DATA_OPBILLSTATE_0, dataState);
                    if (null == oldDataState || oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_4.intValue()) continue;
                    rsSkuDownListsend.add(rsSku2);
                }
            } else {
                rsSkuListsend = rsSkuList;
            }
        } else {
            rsSkuListsend = rsSkuList;
        }
        ArrayList<RsSenddata> reList = new ArrayList<RsSenddata>();
        if (skuflag && ListUtil.isNotEmpty(upList = this.saveSenddata(rsSkuListsend, requestType, goodsEocode, senddataParentcode))) {
            reList.addAll(upList);
            senddataParentcode = upList.get(0).getSenddataCode();
        }
        if (ListUtil.isNotEmpty(downList = this.saveSenddata(rsSkuDownListsend, "skudown", goodsEocode, senddataParentcode))) {
            reList.addAll(downList);
        }
        return reList;
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private boolean makeNum(RsResourceGoods rsResourceGoods, RsSku rsSku, DisChannel disChannel, boolean up) {
        if (null == rsSku || null == rsResourceGoods || null == disChannel) {
            return false;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        }
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            return false;
        }
        if (this.makeNum(disDpriceList, rsResourceGoods, rsSku, up)) {
            return true;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
            return this.makeNum(disDpriceList, rsResourceGoods, rsSku, up);
        }
        return false;
    }

    private Map<String, Object> makeObject(RsResourceGoods rsResourceGoods, RsSku rsSku) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != rsResourceGoods) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods), String.class, Object.class));
        }
        if (null != rsSku) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsSku), String.class, Object.class));
        }
        return obj;
    }

    private boolean makeNum(List<DisDgnumDomain> disDgnumDomainList, RsResourceGoods rsResourceGoods, RsSku rsSku, boolean up) {
        if (ListUtil.isEmpty(disDgnumDomainList) || null == rsResourceGoods || null == rsSku) {
            return false;
        }
        if (null == rsSku.getGoodsSupplynum()) {
            rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        Map<String, Object> mapobj = this.makeObject(rsResourceGoods, rsSku);
        for (DisDgnumDomain disDgnumDomain : disDgnumDomainList) {
            Map<String, List<String>> map = this.makeDgnumlist(disDgnumDomain.getDisDgnumListList());
            if (!this.checkConf(map, mapobj)) continue;
            this.makeListNum(disDgnumDomain, mapobj);
            if (null == disDgnumDomain.getDgnumMin()) {
                disDgnumDomain.setDgnumMin(BigDecimal.ZERO);
            }
            if (!up && rsSku.getGoodsSupplynum().compareTo(disDgnumDomain.getDgnumMin()) <= 0) {
                return true;
            }
            return up && rsSku.getGoodsSupplynum().compareTo(disDgnumDomain.getDgnumMin()) > 0;
        }
        return false;
    }

    private void makeListNum(DisDgnumDomain disDgnumDomain, Object mapobj) {
        if (null == disDgnumDomain || ListUtil.isEmpty(disDgnumDomain.getDisDgnumListList())) {
            return;
        }
        String confList = disDgnumDomain.getDisDgnumListList().get(0).getDgnumListType();
        if ("2".equals(disDgnumDomain.getDgnumPro()) || "goodsNo".equals(confList) || "skuNo".equals(confList)) {
            for (DisDgnumList disDgnumList : disDgnumDomain.getDisDgnumListList()) {
                Object objValue = BeanUtils.newForceGetProperty((Object)mapobj, (String)disDgnumList.getDgnumListType());
                ArrayList<String> relist = new ArrayList<String>();
                relist.add(disDgnumList.getDgnumListValue());
                if (!this.cond(relist, disDgnumList.getDgnumListTerm(), objValue)) continue;
                if (null != disDgnumList.getDgnumListPrice() && disDgnumList.getDgnumListPrice().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumPrice(disDgnumList.getDgnumListPrice());
                } else if (StringUtils.isNotBlank((String)disDgnumList.getDgnumListValuename())) {
                    try {
                        disDgnumDomain.setDgnumPrice(new BigDecimal(disDgnumList.getDgnumListValuename()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (null != disDgnumList.getDgnumListMax() && disDgnumList.getDgnumListMax().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumMax(disDgnumList.getDgnumListMax());
                }
                if (null == disDgnumList.getDgnumListMinx() || disDgnumList.getDgnumListMinx().compareTo(BigDecimal.ZERO) <= 0) break;
                disDgnumDomain.setDgnumMin(disDgnumList.getDgnumListMinx());
                break;
            }
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<DisDgnumList> disDgnumListList) {
        if (ListUtil.isEmpty(disDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgnumList disDpriceConf : disDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDgnumListTerm())) {
                disDpriceConf.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm(), list);
            }
            list.add(disDpriceConf.getDgnumListValue());
        }
        return map;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private List<RsSenddata> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, String senddataParentcode) {
        return this.saveSenddata(rsSkuList, requestType, goodsEocode, null, senddataParentcode);
    }

    private List<RsSenddata> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, RsSkuDomain rsSkuDomain, String senddataParentcode) {
        if (ListUtil.isEmpty(rsSkuList) || StringUtils.isBlank((String)requestType)) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        HashMap<String, RsResourceGoodsReDomain> rsmap = new HashMap<String, RsResourceGoodsReDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsmap.get(rsSku.getGoodsCode());
            if (null == rsResourceGoodsReDomain) {
                rsResourceGoodsReDomain = this.getRsResourceGoodsService().getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), rsSku.getTenantCode()}));
                if (null != rsSkuDomain) {
                    if (ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                        rsSkuDomainList.add(rsSkuDomain);
                        rsResourceGoodsReDomain.setRsSkuDomainList(rsSkuDomainList);
                    } else {
                        boolean fl = true;
                        for (RsSkuDomain rsSkuDomainOld : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                            if (!rsSkuDomainOld.getSkuCode().equals(rsSkuDomain.getSkuCode())) continue;
                            fl = false;
                            break;
                        }
                        if (fl) {
                            rsResourceGoodsReDomain.getRsSkuDomainList().add(rsSkuDomain);
                        }
                    }
                }
                rsmap.put(rsSku.getGoodsCode(), rsResourceGoodsReDomain);
            }
            String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain);
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setSenddataParentcode(senddataParentcode);
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsSku.getMemberCode());
            rsSenddataDomain.setChannelCode(rsSku.getChannelCode());
            rsSenddataDomain.setTenantCode(rsSku.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsSku.getSkuCode());
            rsSenddataDomain.setFdBiztype("RsSku");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(rsSku.getDataState());
            rsSenddataDomain.setFdBizid(rsSku.getSkuId());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    @Override
    public List<RsSenddata> updatetSkuPassBySkuCodeNew(Integer dataState, Integer oldDataState, String skuCode, String tenantCode, RsResourceGoods rsResourceGoods) {
        if (null == dataState || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.updatetSkuPassBySkuCodeNew(dataState, oldDataState, skuCode, tenantCode, rsResourceGoods, true, null);
    }

    private List<RsSenddata> updatetSkuPassBySkuCodeNew(Integer dataState, Integer oldDataState, String skuCode, String tenantCode, RsResourceGoods rsResourceGoods, boolean minnum, String senddataParentcode) {
        if (null == dataState || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        RsSku rsSku = this.getSkuModelByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{skuCode, tenantCode}));
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.rsSku", (Object)(skuCode + "-" + tenantCode + "-" + dataState + "+" + oldDataState));
            return null;
        }
        if (null == oldDataState) {
            oldDataState = rsSku.getDataState();
        }
        String requestType = "";
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "skuinsert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "skudown";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "skudeleteop";
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "skuadd";
        }
        if (!this.updateSkuStateBySkuCode(skuCode, tenantCode, dataState, dataOpbillstate, rsSku.getDataState())) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.dataState", (Object)(skuCode + "-" + tenantCode + "-" + dataState + "-" + dataOpbillstate + "-" + oldDataState));
            return null;
        }
        if (StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.requestType", (Object)(skuCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        rsSku.setDataOpbillstate(dataOpbillstate);
        rsSku.setDataState(dataState);
        return this.saveSkuSend(dataState, oldDataState, rsResourceGoods, requestType, rsSku, minnum, senddataParentcode);
    }

    @Override
    public void updateGoodsEocodeByNo(String goodsCode, String goodsEocode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("goodsEocode", goodsEocode);
        map.put("tenantCode", tenantCode);
        this.updateGoodsEocodeModelByCode(map);
    }

    @Override
    public void updateGoodsSpByNo(String goodsSp, String skuNo, String memberCcode, String tenantCode, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSp", goodsSp);
        map.put("skuNo", skuNo);
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        this.updateGoodsSpModelByNo(map);
    }

    @Override
    public void updateGoodsSpByCode(String goodsSp, String skuCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpByCode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSp", goodsSp);
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updateGoodsSpModelByNo(map);
    }

    @Override
    public void updateSkuNprice(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNprice.param.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", rsSkuDomain.getSkuNo());
        map.put("goodsOrigin", "17");
        map.put("memberCode", rsSkuDomain.getMemberCode());
        map.put("tenantCode", rsSkuDomain.getTenantCode());
        map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
        this.updateSkuNewNprice(map);
    }

    public void updateSkuNewNprice(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSKuPriceBySku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSKuPriceBySku.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSKuPriceBySku.num");
        }
    }

    public void updateGoodsSpModelByNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateGoodsSp(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpModelByNo.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpModelByNo.num");
        }
    }

    @Override
    public void updateSkuNextState(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        this.updateSkuNextModelByCode(map);
    }
}

