/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsBrandMapper;
import com.yqbsoft.laser.service.resources.dao.RsBrandRelationMapper;
import com.yqbsoft.laser.service.resources.dao.RsPntreeMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecGroupMapper;
import com.yqbsoft.laser.service.resources.domain.RsBrandRelationDomain;
import com.yqbsoft.laser.service.resources.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.resources.model.RsBrand;
import com.yqbsoft.laser.service.resources.model.RsPntree;
import com.yqbsoft.laser.service.resources.model.RsSpecGroup;
import com.yqbsoft.laser.service.resources.service.RsBrandRelationService;
import com.yqbsoft.laser.service.resources.service.RsPntreeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsPntreeServiceImpl
extends BaseServiceImpl
implements RsPntreeService {
    public static final String SYS_CODE = "rs.RsPntreeServiceImpl";
    private RsPntreeMapper rsPntreeMapper;
    private RsSpecGroupMapper rsSpecGroupMapper;
    private RsBrandRelationService rsBrandRelationService;
    private RsBrandRelationMapper rsBrandRelationMapper;
    private RsBrandMapper rsBrandMapper;

    public static void setListTree(List<RsPntree> oslist, RsPntree tree) {
        if (tree == null || StringUtils.isBlank((String)tree.getPntreeCode())) {
            return;
        }
        ArrayList<RsPntree> tmplist = new ArrayList<RsPntree>();
        tmplist.addAll(oslist);
        for (RsPntree bsPntree : oslist) {
            if (!bsPntree.getPntreeParentcode().equals(tree.getPntreeCode())) continue;
            List<RsPntree> list = tree.getChildren();
            if (list == null) {
                list = new ArrayList<RsPntree>();
            }
            tmplist.remove(bsPntree);
            RsPntreeServiceImpl.setListTree(tmplist, bsPntree);
            list.add(bsPntree);
            tree.setChildren(list);
        }
    }

    public RsBrandRelationService getRsBrandRelationService() {
        return this.rsBrandRelationService;
    }

    public void setRsBrandRelationService(RsBrandRelationService rsBrandRelationService) {
        this.rsBrandRelationService = rsBrandRelationService;
    }

    public void setRsBrandRelationMapper(RsBrandRelationMapper rsBrandRelationMapper) {
        this.rsBrandRelationMapper = rsBrandRelationMapper;
    }

    public RsSpecGroupMapper getRsSpecGroupMapper() {
        return this.rsSpecGroupMapper;
    }

    public void setRsSpecGroupMapper(RsSpecGroupMapper rsSpecGroupMapper) {
        this.rsSpecGroupMapper = rsSpecGroupMapper;
    }

    public RsBrandMapper getRsBrandMapper() {
        return this.rsBrandMapper;
    }

    public void setRsBrandMapper(RsBrandMapper rsBrandMapper) {
        this.rsBrandMapper = rsBrandMapper;
    }

    public void setRsPntreeMapper(RsPntreeMapper rsPntreeMapper) {
        this.rsPntreeMapper = rsPntreeMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsPntreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPntree(RsPntreeDomain bsPntreeDomain) {
        if (null == bsPntreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPntreeDefault(RsPntree bsPntree) {
        if (null == bsPntree) {
            return;
        }
        if (null == bsPntree.getDataState()) {
            bsPntree.setDataState(0);
        }
        if (null == bsPntree.getGmtCreate()) {
            bsPntree.setGmtCreate(this.getSysDate());
        }
        bsPntree.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsPntree.getPntreeParentcode())) {
            bsPntree.setPntreeParentcode("-1");
        }
        if (StringUtils.isBlank((String)bsPntree.getPntreeCode())) {
            String pntreeCode = this.getNo("1", RsPntree.class.getSimpleName(), "pntreeCode", bsPntree.getTenantCode());
            Integer pntreeStep = ResourcesConstants.PNTREE_ROOT_STAEP;
            String parentCode = bsPntree.getPntreeParentcode();
            if (!"-1".equals(parentCode)) {
                String step = parentCode.substring(0, 1);
                pntreeStep = Integer.parseInt(step) + 1;
            }
            bsPntree.setPntreeStep(pntreeStep);
            bsPntree.setPntreeCode(pntreeStep + pntreeCode);
        }
    }

    private int getPntreeMaxCode() {
        int code = 0;
        try {
            return this.rsPntreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.getPntreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPntreeUpdataDefault(RsPntree bsPntree) {
        if (null == bsPntree) {
            return;
        }
        bsPntree.setGmtModified(this.getSysDate());
    }

    private void savePntreeModel(RsPntree bsPntree) throws ApiException {
        if (null == bsPntree) {
            return;
        }
        try {
            this.rsPntreeMapper.insert(bsPntree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeServiceImpl.savePntreeModel.ex", (Throwable)e);
        }
    }

    private RsPntree getPntreeModelById(Integer pntreeId) {
        if (null == pntreeId) {
            return null;
        }
        try {
            return this.rsPntreeMapper.selectByPrimaryKey(pntreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.getPntreeModelById", (Throwable)e);
            return null;
        }
    }

    public RsPntree getPntreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPntreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.getPntreeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPntreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPntreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeServiceImpl.delPntreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPntreeServiceImpl.delPntreeModelByCode.num");
        }
    }

    private void deletePntreeModel(Integer pntreeId) throws ApiException {
        if (null == pntreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPntreeMapper.deleteByPrimaryKey(pntreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeServiceImpl.deletePntreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPntreeServiceImpl.deletePntreeModel.num");
        }
    }

    private void updatePntreeModel(RsPntree bsPntree) throws ApiException {
        if (null == bsPntree) {
            return;
        }
        try {
            this.rsPntreeMapper.updateByPrimaryKeySelective(bsPntree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeServiceImpl.updatePntreeModel.ex", (Throwable)e);
        }
    }

    private void updateStatePntreeModel(Integer pntreeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pntreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeId", pntreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsPntreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeServiceImpl.updateStatePntreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPntreeServiceImpl.updateStatePntreeModel.null");
        }
    }

    private RsPntree makePntree(RsPntreeDomain bsPntreeDomain, RsPntree bsPntree) {
        if (null == bsPntreeDomain) {
            return null;
        }
        if (null == bsPntree) {
            bsPntree = new RsPntree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsPntree, (Object)bsPntreeDomain);
            return bsPntree;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.makePntree", (Throwable)e);
            return null;
        }
    }

    private List<RsPntree> queryPntreeModelPage(Map<String, Object> parammap) {
        try {
            return this.rsPntreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.queryPntreeModel", (Throwable)e);
            return null;
        }
    }

    private int countPntree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsPntreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.countPntree", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePntree(RsPntreeDomain bsPntreeDomain) throws ApiException {
        String msg = this.checkPntree(bsPntreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPntreeServiceImpl.savePntree.checkPntree", msg);
        }
        RsPntree bsPntree = this.makePntree(bsPntreeDomain, null);
        this.setPntreeDefault(bsPntree);
        this.savePntreeModel(bsPntree);
        String pntreeCode = bsPntree.getPntreeCode();
        if (StringUtils.isNotBlank((String)bsPntreeDomain.getBrandCodeStr())) {
            String[] bCode;
            for (String bc : bCode = bsPntreeDomain.getBrandCodeStr().split(",")) {
                RsBrandRelationDomain rsBrandRelationDomain = new RsBrandRelationDomain();
                rsBrandRelationDomain.setBrandCode(bc);
                rsBrandRelationDomain.setTenantCode(bsPntreeDomain.getTenantCode());
                rsBrandRelationDomain.setPntreeCode(pntreeCode);
                this.rsBrandRelationService.saveBrandRelation(rsBrandRelationDomain);
            }
        }
        if (StringUtils.isNotBlank((String)bsPntreeDomain.getSpecGroupCodeStr())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("specGroupCode", bsPntreeDomain.getSpecGroupCodeStr());
            map.put("tenantCode", bsPntree.getTenantCode());
            RsSpecGroup rsSpecGroup = this.rsSpecGroupMapper.getByCode(map);
            if (null != rsSpecGroup) {
                rsSpecGroup.setPntreeCode(pntreeCode);
                this.rsSpecGroupMapper.updateByPrimaryKey(rsSpecGroup);
            }
        }
        return pntreeCode;
    }

    @Override
    public void updatePntreeState(Integer pntreeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePntreeModel(pntreeId, dataState, oldDataState);
    }

    @Override
    public void updatePntree(RsPntreeDomain bsPntreeDomain) throws ApiException {
        String msg = this.checkPntree(bsPntreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPntreeServiceImpl.updatePntree.checkPntree", msg);
        }
        RsPntree oldRsPntree = this.getPntreeModelById(bsPntreeDomain.getPntreeId());
        if (null == oldRsPntree) {
            throw new ApiException("rs.RsPntreeServiceImpl.updatePntree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsPntree bsPntree = this.makePntree(bsPntreeDomain, oldRsPntree);
        this.setPntreeUpdataDefault(bsPntree);
        this.updatePntreeModel(bsPntree);
        String pntreeCode = bsPntree.getPntreeCode();
        if (StringUtils.isNotBlank((String)bsPntreeDomain.getBrandCodeStr())) {
            this.rsBrandRelationMapper.deleteBrandRelationByPntreeCode(pntreeCode);
            String[] bCode = bsPntreeDomain.getBrandCodeStr().split(",");
            HashMap<String, String> brandMap = new HashMap<String, String>();
            List<RsBrand> brandList = this.rsBrandMapper.query(this.getQueryMapParam("tenantCode,brandCode", new Object[]{bsPntree.getTenantCode(), bsPntreeDomain.getBrandCodeStr()}));
            if (ListUtil.isNotEmpty(brandList)) {
                for (RsBrand rsBrand : brandList) {
                    brandMap.put(rsBrand.getBrandCode(), rsBrand.getBrandName());
                }
            }
            for (String bc : bCode) {
                RsBrandRelationDomain rsBrandRelationDomain = new RsBrandRelationDomain();
                rsBrandRelationDomain.setBrandCode(bc);
                rsBrandRelationDomain.setTenantCode(bsPntreeDomain.getTenantCode());
                rsBrandRelationDomain.setPntreeCode(pntreeCode);
                if (MapUtil.isNotEmpty(brandMap)) {
                    rsBrandRelationDomain.setBrandName((String)brandMap.get(bc));
                }
                rsBrandRelationDomain.setPntreeName(bsPntree.getPntreeName());
                this.rsBrandRelationService.saveBrandRelation(rsBrandRelationDomain);
            }
        }
        if (StringUtils.isNotBlank((String)bsPntreeDomain.getSpecGroupCodeStr())) {
            this.rsSpecGroupMapper.updateSpecGroupByPntreeCode(pntreeCode);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("specGroupCode", bsPntreeDomain.getSpecGroupCodeStr());
            map.put("tenantCode", bsPntree.getTenantCode());
            RsSpecGroup rsSpecGroup = this.rsSpecGroupMapper.getByCode(map);
            if (null != rsSpecGroup) {
                rsSpecGroup.setPntreeCode(pntreeCode);
                this.rsSpecGroupMapper.updateByPrimaryKey(rsSpecGroup);
            }
        }
    }

    @Override
    public RsPntree getPntree(Integer pntreeId) {
        return this.getPntreeModelById(pntreeId);
    }

    @Override
    public void deletePntree(Integer pntreeId) throws ApiException {
        this.deletePntreeModel(pntreeId);
    }

    @Override
    public QueryResult<RsPntree> queryPntreePage(Map<String, Object> map) {
        List<RsPntree> bsPntreeList = this.queryPntreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPntree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsPntreeList);
        return queryResult;
    }

    @Override
    public RsPntree getPntreeByCode(Map<String, Object> map) {
        return this.getPntreeModelByCode(map);
    }

    @Override
    public void delPntreeByCode(Map<String, Object> map) throws ApiException {
        this.delPntreeModelByCode(map);
    }

    @Override
    public List<RsPntree> queryPntreeList(String appmanageIcode, String pntreeType) {
        if (StringUtils.isBlank((String)appmanageIcode)) {
            throw new ApiException("rs.RsPntreeServiceImpl.queryPntreeList.null", "app_id\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageIcode", appmanageIcode);
        map.put("pntreeType", pntreeType);
        return this.queryPntreeTree(map);
    }

    @Override
    public List<RsPntree> queryPntreeTree(Map<String, Object> map) {
        List<RsPntree> bsPntreeList = this.queryPntreeModelPage(map);
        if (bsPntreeList == null || bsPntreeList.size() == 0) {
            return null;
        }
        RsPntree tree = new RsPntree();
        tree.setPntreeCode("-1");
        RsPntreeServiceImpl.setListTree(bsPntreeList, tree);
        return tree.getChildren();
    }

    @Override
    public RsPntree getPntreeByName(String pntreeName, String tenantCode) {
        if (StringUtils.isBlank((String)pntreeName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsPntreeServiceImpl.getPntreeByName.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return this.rsPntreeMapper.selectByName(pntreeName, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.queryPntreeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsPntree> getChildByPntree(Map<String, Object> map) {
        try {
            return this.rsPntreeMapper.getChild(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.getChildByPntree", (Throwable)e);
            return null;
        }
    }

    @Override
    public void savePntreeInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        QueryResult<RsPntree> rsPntreeQueryResult = this.queryPntreePage(map);
        if (null == rsPntreeQueryResult || ListUtil.isEmpty((Collection)rsPntreeQueryResult.getList())) {
            return;
        }
        List rsPntreeList = rsPntreeQueryResult.getList();
        for (RsPntree rsPntree : rsPntreeList) {
            RsPntree pntreeByCode = this.getPntreeByCode(this.getQueryMapParam("pntreeCode,tenantCode", new Object[]{rsPntree.getPntreeCode(), tenantCode}));
            if (null != pntreeByCode) continue;
            RsPntreeDomain rsPntreeDomain = this.makeRsPntreeDomain(rsPntree);
            rsPntreeDomain.setPntreeId(null);
            rsPntreeDomain.setTenantCode(tenantCode);
            this.savePntree(rsPntreeDomain);
        }
    }

    private RsPntreeDomain makeRsPntreeDomain(RsPntree rsPntree) {
        if (null == rsPntree) {
            return null;
        }
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsPntreeDomain, (Object)rsPntree);
            return rsPntreeDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeServiceImpl.makeRsPntreeDomain", (Throwable)e);
            return null;
        }
    }
}

