/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsBrandMapper;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.model.RsBrand;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsBrandServiceImpl
extends BaseServiceImpl
implements RsBrandService {
    public static final String SYS_CODE = "rs.RsBrandServiceImpl";
    private RsBrandMapper rsBrandMapper;
    private RsSenddataBaseService rsSenddataBaseService;

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public void setRsBrandMapper(RsBrandMapper rsBrandMapper) {
        this.rsBrandMapper = rsBrandMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsBrandMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBrand(RsBrandDomain bsBrandDomain) {
        if (null == bsBrandDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBrandDefault(RsBrand bsBrand) {
        if (null == bsBrand) {
            return;
        }
        if (null == bsBrand.getDataState()) {
            bsBrand.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == bsBrand.getGmtCreate()) {
            bsBrand.setGmtCreate(date);
        }
        bsBrand.setGmtModified(date);
        if (StringUtils.isBlank((String)bsBrand.getBrandCode())) {
            bsBrand.setBrandCode(this.getNo(null, RsBrand.class.getSimpleName(), "brandCode", bsBrand.getTenantCode()));
        }
        if (StringUtils.isBlank((String)bsBrand.getBrandNo())) {
            bsBrand.setBrandNo(this.getNo(null, RsBrand.class.getSimpleName(), "brandNo", bsBrand.getTenantCode()));
        }
    }

    private int getBrandMaxCode() {
        int code = 0;
        try {
            return this.rsBrandMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBrandUpdataDefault(RsBrand bsBrand) {
        if (null == bsBrand) {
            return;
        }
        bsBrand.setGmtModified(this.getSysDate());
    }

    private void saveBrandModel(RsBrand bsBrand) throws ApiException {
        if (null == bsBrand) {
            return;
        }
        try {
            this.rsBrandMapper.insert(bsBrand);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.saveBrandModel.ex", (Throwable)e);
        }
    }

    private RsBrand getBrandModelById(Integer brandId) {
        if (null == brandId) {
            return null;
        }
        try {
            return this.rsBrandMapper.selectByPrimaryKey(brandId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandModelById", (Throwable)e);
            return null;
        }
    }

    public RsBrand getBrandModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        if (null == map.get("channelCode") || StringUtils.isEmpty((String)((String)map.get("channelCode")))) {
            List<RsBrand> rsBrands = this.queryBrandModelPage(map);
            for (RsBrand rsBrand : rsBrands) {
                if (!StringUtils.isBlank((String)rsBrand.getChannelCode())) continue;
                return rsBrand;
            }
        }
        try {
            return this.rsBrandMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandModelByCode", (Object)(map + "=:=" + e));
            return null;
        }
    }

    public void delBrandModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.delBrandModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandServiceImpl.delBrandModelByCode.num");
        }
    }

    private void deleteBrandModel(Integer brandId) throws ApiException {
        if (null == brandId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandMapper.deleteByPrimaryKey(brandId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrandModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrandModel.num");
        }
    }

    private void updateBrandModel(RsBrand bsBrand) throws ApiException {
        if (null == bsBrand) {
            return;
        }
        try {
            this.rsBrandMapper.updateByPrimaryKeySelective(bsBrand);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrandModel.ex", (Throwable)e);
        }
    }

    private void updateStateBrandModel(Integer brandId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == brandId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandId", brandId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsBrandMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.updateStateBrandModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsBrandServiceImpl.updateStateBrandModel.null");
        }
    }

    private RsBrand makeBrand(RsBrandDomain bsBrandDomain, RsBrand bsBrand) {
        if (null == bsBrandDomain) {
            return null;
        }
        if (null == bsBrand) {
            bsBrand = new RsBrand();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsBrand, (Object)bsBrandDomain);
            return bsBrand;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.makeBrand", (Throwable)e);
            return null;
        }
    }

    private List<RsBrand> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.rsBrandMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.queryBrandModel", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsBrandMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.countBrand", (Throwable)e);
        }
        return i;
    }

    public RsBrand getBrandModelByNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsBrandMapper.getByNo(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandModelByNo", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> saveBrand(RsBrandDomain bsBrandDomain) throws ApiException {
        String msg = this.checkBrand(bsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandServiceImpl.saveBrand.checkBrand", msg);
        }
        RsBrand rsBrand = this.makeBrand(bsBrandDomain, null);
        this.setBrandDefault(rsBrand);
        this.saveBrandModel(rsBrand);
        if (null == rsBrand) {
            return null;
        }
        ArrayList<RsBrand> rsBrands = new ArrayList<RsBrand>();
        rsBrands.add(rsBrand);
        List<RsSenddata> rsSenddata = this.saveSenddata(rsBrands, "add");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    private List<RsSenddata> saveSenddata(List<RsBrand> rsBrands, String requestType) {
        if (ListUtil.isEmpty(rsBrands) || StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsBrandServiceImpl.saveSenddata.rsBrands/requestType:", (Object)(rsBrands + "=:=" + requestType));
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsBrand rsBrand : rsBrands) {
            String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsBrand);
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsBrand.getMemberCode());
            rsSenddataDomain.setChannelCode(rsBrand.getChannelCode());
            rsSenddataDomain.setTenantCode(rsBrand.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsBrand.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsBrand.getBrandNo());
            rsSenddataDomain.setFdBiztype("RsBrand");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(rsBrand.getDataState());
            rsSenddataDomain.setFdBizid(rsBrand.getBrandId());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        this.logger.error("rs.RsBrandServiceImpl.saveSenddata.rsSenddataDomainList.", (Object)JsonUtil.buildNormalBinder().toJson(rsSenddataDomainList));
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    @Override
    public void updateBrandState(Integer brandId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBrandModel(brandId, dataState, oldDataState);
    }

    @Override
    public List<RsSenddata> updateBrand(RsBrandDomain bsBrandDomain) throws ApiException {
        String msg = this.checkBrand(bsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrand.checkBrand", msg);
        }
        RsBrand oldRsBrand = this.getBrandModelById(bsBrandDomain.getBrandId());
        if (null == oldRsBrand) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrand.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrand bsBrand = this.makeBrand(bsBrandDomain, oldRsBrand);
        this.setBrandUpdataDefault(bsBrand);
        this.updateBrandModel(bsBrand);
        oldRsBrand = this.getBrandModelById(bsBrandDomain.getBrandId());
        ArrayList<RsBrand> rsBrands = new ArrayList<RsBrand>();
        rsBrands.add(oldRsBrand);
        List<RsSenddata> rsSenddata = this.saveSenddata(rsBrands, "update");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    @Override
    public RsBrand getBrand(Integer brandId) {
        return this.getBrandModelById(brandId);
    }

    @Override
    public List<RsSenddata> deleteBrand(Integer brandId) throws ApiException {
        if (null == brandId) {
            this.logger.error("rs.RsBrandServiceImpl.deleteBrandbrandId is null");
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrand.null", "brandId is null");
        }
        RsBrand rsBrand = this.getBrand(brandId);
        if (null == rsBrand) {
            this.logger.error("rs.RsBrandServiceImpl.deleteBrand.nullrsBrand is null");
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrand.null");
        }
        ArrayList<RsBrand> rsBrands = new ArrayList<RsBrand>();
        rsBrands.add(rsBrand);
        List<RsSenddata> rsSenddata = this.saveSenddata(rsBrands, "delete");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        this.deleteBrandModel(brandId);
        return rsSenddata;
    }

    @Override
    public QueryResult<RsBrand> queryBrandPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        this.logger.error("rs.RsBrandServiceImpl.queryBrandPage", (Object)map.toString());
        List<RsBrand> bsBrandList = this.queryBrandModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsBrandList);
        return queryResult;
    }

    @Override
    public RsBrand getBrandByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.getBrandModelByCode(map);
    }

    public RsBrandDomain getBrandDomainByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.makeRsBrandDomain(this.getBrandModelByCode(map));
    }

    @Override
    public void delBrandByCode(Map<String, Object> map) throws ApiException {
        this.delBrandModelByCode(map);
    }

    @Override
    public List<RsBrand> queryBrandByPntree(Map<String, Object> map) {
        return this.rsBrandMapper.selectByPntree(map);
    }

    @Override
    public RsBrand getBrandByName(String brandName, String tenantCode) {
        if (StringUtils.isEmpty((String)brandName) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsBrandServiceImpl.getBrandByName.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandName", brandName);
        map.put("tenantCode", tenantCode);
        try {
            return this.rsBrandMapper.selectByName(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandByName", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveBrandInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        QueryResult<RsBrand> rsBrandQueryResult = this.queryBrandPage(map);
        if (null == rsBrandQueryResult || ListUtil.isEmpty((Collection)rsBrandQueryResult.getList())) {
            return;
        }
        List rsBrandList = rsBrandQueryResult.getList();
        for (RsBrand rsBrand : rsBrandList) {
            RsBrand brandByCode = this.getBrandByCode(this.getQueryMapParam("brandCode,tenantCode", new Object[]{rsBrand.getBrandCode(), tenantCode}));
            if (null != brandByCode) continue;
            RsBrandDomain rsBrandDomain = this.makeRsBrandDomain(rsBrand);
            rsBrandDomain.setBrandId(null);
            rsBrandDomain.setTenantCode(tenantCode);
            this.saveBrand(rsBrandDomain);
        }
    }

    @Override
    public RsBrand getBrandByEcode(String brandEocode, String tenantCode) {
        if (StringUtils.isEmpty((String)brandEocode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsBrandServiceImpl.getBrandByEcode.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandEocode", brandEocode);
        map.put("tenantCode", tenantCode);
        try {
            return this.rsBrandMapper.selectByEcode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandByName", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> deleteBrandByNo(String brandNo, String channelCode, String tenantCode) throws ApiException {
        List<RsBrand> rsBrands;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("brandNo", brandNo);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (rsBrands = this.queryBrandModelPage(parammap)) || ListUtil.isEmpty(rsBrands)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsBrand rsBrand : rsBrands) {
            List<RsSenddata> rsSenddatas = this.deleteBrand(rsBrand.getBrandId());
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public RsBrandDomain getBrandByNo(Map<String, Object> map) {
        return this.makeRsBrandDomain(this.getBrandModelByNo(map));
    }

    @Override
    public void saveOrUpdateBrandBatch(List<RsBrandDomain> rsBrandDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsBrandDomainList)) {
            this.logger.error("rs.RsBrandServiceImpl.saveOrUpdateBrandBatch", (Object)"rsBrandDomainList is null");
            return;
        }
        for (RsBrandDomain rsBrandDomain : rsBrandDomainList) {
            if (rsBrandDomain.getBrandId() == null) {
                this.saveBrand(rsBrandDomain);
                continue;
            }
            this.updateBrand(rsBrandDomain);
        }
    }

    @Override
    public List<RsSenddata> saveBatchDisBrand(List<RsBrandDomain> rsBrandDomains) throws ApiException {
        if (ListUtil.isEmpty(rsBrandDomains)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsBrandDomain rsBrandDomain : rsBrandDomains) {
            List<RsSenddata> skursSenddataList;
            RsBrandDomain brandDomain;
            parammap.put("brandNo", rsBrandDomain.getBrandOldno());
            parammap.put("tenantCode", rsBrandDomain.getTenantCode());
            parammap.put("channelCode", rsBrandDomain.getChannelCode());
            if (StringUtils.isBlank((String)rsBrandDomain.getChannelCode())) {
                parammap.put("memberCode", rsBrandDomain.getMemberCode());
            }
            if (null == (brandDomain = this.getBrandByNo(parammap))) {
                skursSenddataList = this.saveBrand(rsBrandDomain);
                if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
                rsSenddataList.addAll(skursSenddataList);
                continue;
            }
            skursSenddataList = this.updateBrand(rsBrandDomain);
            if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
            rsSenddataList.addAll(skursSenddataList);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsSenddata> updateBatchDisBrand(List<RsBrandDomain> rsBrandDomains) throws ApiException {
        if (ListUtil.isEmpty(rsBrandDomains)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsBrandDomain rsBrandDomain : rsBrandDomains) {
            List<RsSenddata> rsSenddatas = this.updateBrand(rsBrandDomain);
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    private RsBrandDomain makeRsBrandDomain(RsBrand rsBrand) {
        if (null == rsBrand) {
            return null;
        }
        RsBrandDomain rsBrandDomain = new RsBrandDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsBrandDomain, (Object)rsBrand);
            return rsBrandDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.makeRsBrandDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> deleteBrandByCode(String brandCode, String channelCode, String tenantCode) throws ApiException {
        List<RsBrand> rsBrands;
        if (StringUtils.isBlank((String)brandCode)) {
            this.logger.error("rs.RsBrandServiceImpl.deleteBrandByCode.brandCode is null ", (Object)(channelCode + "=:=" + tenantCode));
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("brandCode", brandCode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (rsBrands = this.queryBrandModelPage(parammap)) || ListUtil.isEmpty(rsBrands)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsBrand rsBrand : rsBrands) {
            List<RsSenddata> rsSenddatas = this.deleteBrand(rsBrand.getBrandId());
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }
}

