/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsPropertiesValueMapper;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class RsPropertiesValueServiceImpl
extends BaseServiceImpl
implements RsPropertiesValueService {
    public static final String SYS_CODE = "rs.RsPropertiesValueServiceImpl";
    private RsPropertiesValueMapper rsPropertiesValueMapper;

    public void setRsPropertiesValueMapper(RsPropertiesValueMapper rsPropertiesValueMapper) {
        this.rsPropertiesValueMapper = rsPropertiesValueMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsPropertiesValueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPropertiesValue(RsPropertiesValueDomain rsPropertiesValueDomain) {
        if (null == rsPropertiesValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPropertiesValueDefault(RsPropertiesValue rsPropertiesValue) {
        if (null == rsPropertiesValue) {
            return;
        }
        if (null == rsPropertiesValue.getDataState()) {
            rsPropertiesValue.setDataState(0);
        }
        if (null == rsPropertiesValue.getGmtCreate()) {
            rsPropertiesValue.setGmtCreate(this.getSysDate());
        }
        rsPropertiesValue.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsPropertiesValue.getPropertiesValueCode())) {
            rsPropertiesValue.setPropertiesValueCode(this.createUUIDString());
        }
    }

    private int getPropertiesValueMaxCode() {
        int code = 0;
        try {
            return this.rsPropertiesValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.getPropertiesValueMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertiesValueUpdataDefault(RsPropertiesValue rsPropertiesValue) {
        if (null == rsPropertiesValue) {
            return;
        }
        rsPropertiesValue.setGmtModified(this.getSysDate());
    }

    private void savePropertiesValueModel(RsPropertiesValue rsPropertiesValue) throws ApiException {
        if (null == rsPropertiesValue) {
            return;
        }
        try {
            this.rsPropertiesValueMapper.insert(rsPropertiesValue);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.savePropertiesValueModel.ex", (Throwable)e);
        }
    }

    private void savePropertiesValueModelList(List<RsPropertiesValue> rsPropertiesValueList) throws ApiException {
        if (null == rsPropertiesValueList || rsPropertiesValueList.isEmpty()) {
            return;
        }
        try {
            this.rsPropertiesValueMapper.insertBatch(rsPropertiesValueList);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            throw new ApiException("rs.RsPropertiesValueServiceImpl.savePropertiesValueModelList.ex", (Throwable)e);
        }
    }

    private RsPropertiesValue getPropertiesValueModelById(Integer propertiesValueId) {
        if (null == propertiesValueId) {
            return null;
        }
        try {
            return this.rsPropertiesValueMapper.selectByPrimaryKey(propertiesValueId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.getPropertiesValueModelById", (Throwable)e);
            return null;
        }
    }

    public RsPropertiesValue getPropertiesValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPropertiesValueMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.getPropertiesValueModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPropertiesValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesValueMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.delPropertiesValueModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.delPropertiesValueModelByCode.num");
        }
    }

    private void deletePropertiesValueModel(Integer propertiesValueId) throws ApiException {
        if (null == propertiesValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesValueMapper.deleteByPrimaryKey(propertiesValueId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.deletePropertiesValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.deletePropertiesValueModel.num");
        }
    }

    private void updatePropertiesValueModel(RsPropertiesValue rsPropertiesValue) throws ApiException {
        if (null == rsPropertiesValue) {
            return;
        }
        try {
            this.rsPropertiesValueMapper.updateByPrimaryKeySelective(rsPropertiesValue);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.updatePropertiesValueModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertiesValueModel(Integer propertiesValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == propertiesValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertiesValueId", propertiesValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsPropertiesValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.updateStatePropertiesValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.updateStatePropertiesValueModel.null");
        }
    }

    private RsPropertiesValue makePropertiesValue(RsPropertiesValueDomain rsPropertiesValueDomain, RsPropertiesValue rsPropertiesValue) {
        if (null == rsPropertiesValueDomain) {
            return null;
        }
        if (null == rsPropertiesValue) {
            rsPropertiesValue = new RsPropertiesValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsPropertiesValue, (Object)rsPropertiesValueDomain);
            return rsPropertiesValue;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.makePropertiesValue", (Throwable)e);
            return null;
        }
    }

    private List<RsPropertiesValue> queryPropertiesValueModelPage(Map<String, Object> parammap) {
        try {
            return this.rsPropertiesValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.queryPropertiesValueModel", (Throwable)e);
            return null;
        }
    }

    private int countPropertiesValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsPropertiesValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.countPropertiesValue", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePropertiesValue(RsPropertiesValueDomain rsPropertiesValueDomain) throws ApiException {
        String msg = this.checkPropertiesValue(rsPropertiesValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.savePropertiesValue.checkPropertiesValue", msg);
        }
        RsPropertiesValue rsPropertiesValue = this.makePropertiesValue(rsPropertiesValueDomain, null);
        this.setPropertiesValueDefault(rsPropertiesValue);
        this.savePropertiesValueModel(rsPropertiesValue);
    }

    @Override
    public void savePropertiesValueList(List<RsPropertiesValueDomain> propertiesValueList) throws ApiException {
        if (propertiesValueList == null || propertiesValueList.isEmpty()) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.savePropertiesValueList", "\u5bf9\u8c61\u4e3a\u7a7a");
        }
        ArrayList<RsPropertiesValue> valueList = new ArrayList<RsPropertiesValue>();
        for (RsPropertiesValueDomain rsPropertiesValueDomain : propertiesValueList) {
            String msg = this.checkPropertiesValue(rsPropertiesValueDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsPropertiesValueServiceImpl.savePropertiesValue.checkPropertiesValue", msg);
            }
            RsPropertiesValue rsPropertiesValue = this.makePropertiesValue(rsPropertiesValueDomain, null);
            this.setPropertiesValueDefault(rsPropertiesValue);
            valueList.add(rsPropertiesValue);
        }
        this.savePropertiesValueModelList(valueList);
    }

    @Override
    public void updatePropertiesValueState(Integer propertiesValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertiesValueModel(propertiesValueId, dataState, oldDataState);
    }

    @Override
    public void updatePropertiesValue(RsPropertiesValueDomain rsPropertiesValueDomain) throws ApiException {
        String msg = this.checkPropertiesValue(rsPropertiesValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.updatePropertiesValue.checkPropertiesValue", msg);
        }
        RsPropertiesValue oldRsPropertiesValue = this.getPropertiesValueModelById(rsPropertiesValueDomain.getPropertiesValueId());
        if (null == oldRsPropertiesValue) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.updatePropertiesValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsPropertiesValue rsPropertiesValue = this.makePropertiesValue(rsPropertiesValueDomain, oldRsPropertiesValue);
        this.setPropertiesValueUpdataDefault(rsPropertiesValue);
        this.updatePropertiesValueModel(rsPropertiesValue);
    }

    @Override
    public RsPropertiesValue getPropertiesValue(Integer propertiesValueId) {
        return this.getPropertiesValueModelById(propertiesValueId);
    }

    @Override
    public void deletePropertiesValue(Integer propertiesValueId) throws ApiException {
        this.deletePropertiesValueModel(propertiesValueId);
    }

    @Override
    public QueryResult<RsPropertiesValue> queryPropertiesValuePage(Map<String, Object> map) {
        List<RsPropertiesValue> rsPropertiesValueList = this.queryPropertiesValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPropertiesValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsPropertiesValueList);
        return queryResult;
    }

    @Override
    public RsPropertiesValue getPropertiesValueByCode(Map<String, Object> map) {
        return this.getPropertiesValueModelByCode(map);
    }

    @Override
    public void delPropertiesValueByCode(Map<String, Object> map) throws ApiException {
        this.delPropertiesValueModelByCode(map);
    }

    @Override
    public void deletePropertiesValueBySpu(Map<String, Object> map) {
        try {
            this.rsPropertiesValueMapper.delBySpu(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.deletePropertiesValueBySku", (Throwable)e);
        }
    }

    @Override
    public List<String> queryPropertiesValueByGoods(Map<String, Object> map) {
        try {
            return this.rsPropertiesValueMapper.selectByGoods(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.queryPropertiesValueByGoods", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, String>> queryPropertiesByGoods(String tenantCode, String goodsCode) {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        try {
            return this.rsPropertiesValueMapper.queryPropertiesByGoods(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.queryPropertiesByGoods", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deletePropertiesValueByGoods(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.deletePropertiesValueByGoods.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<RsPropertiesValue> vlist = this.queryPropertiesValueModelPage(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        if (ListUtil.isEmpty(vlist)) {
            return;
        }
        for (RsPropertiesValue rsPropertiesValue : vlist) {
            this.deletePropertiesValue(rsPropertiesValue.getPropertiesValueId());
        }
    }

    private void deletePropertiesValueByGoodsModel(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsPropertiesValueServiceImpl.deletePropertiesValueByGoodsModel.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsPropertiesValueMapper.delByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesValueServiceImpl.deletePropertiesValueByGoodsModel", (Throwable)e);
        }
    }
}

