/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsBrandRelationMapper;
import com.yqbsoft.laser.service.resources.domain.RsBrandRelationDomain;
import com.yqbsoft.laser.service.resources.model.RsBrandRelation;
import com.yqbsoft.laser.service.resources.service.RsBrandRelationService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsBrandRelationServiceImpl
extends BaseServiceImpl
implements RsBrandRelationService {
    public static final String SYS_CODE = "rs.RsBrandRelationServiceImpl";
    private RsBrandRelationMapper rsBrandRelationMapper;

    public void setRsBrandRelationMapper(RsBrandRelationMapper rsBrandRelationMapper) {
        this.rsBrandRelationMapper = rsBrandRelationMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsBrandRelationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBrandRelation(RsBrandRelationDomain rsBrandRelationDomain) {
        if (null == rsBrandRelationDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBrandRelationDefault(RsBrandRelation bsBrandRelation) {
        if (null == bsBrandRelation) {
            return;
        }
        if (null == bsBrandRelation.getDataState()) {
            bsBrandRelation.setDataState(0);
        }
        if (null == bsBrandRelation.getGmtCreate()) {
            bsBrandRelation.setGmtCreate(this.getSysDate());
        }
        bsBrandRelation.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsBrandRelation.getBrandRelationCode())) {
            bsBrandRelation.setBrandRelationCode(this.createUUIDString());
        }
    }

    private int getBrandRelationMaxCode() {
        int code = 0;
        try {
            return this.rsBrandRelationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.getBrandRelationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBrandRelationUpdataDefault(RsBrandRelation bsBrandRelation) {
        if (null == bsBrandRelation) {
            return;
        }
        bsBrandRelation.setGmtModified(this.getSysDate());
    }

    private void saveBrandRelationModel(RsBrandRelation bsBrandRelation) throws ApiException {
        if (null == bsBrandRelation) {
            return;
        }
        try {
            this.rsBrandRelationMapper.insert(bsBrandRelation);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.saveBrandRelationModel.ex", (Throwable)e);
        }
    }

    private RsBrandRelation getBrandRelationModelById(Integer brandRelationId) {
        if (null == brandRelationId) {
            return null;
        }
        try {
            return this.rsBrandRelationMapper.selectByPrimaryKey(brandRelationId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.getBrandRelationModelById", (Throwable)e);
            return null;
        }
    }

    public RsBrandRelation getBrandRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsBrandRelationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.getBrandRelationModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delBrandRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandRelationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.delBrandRelationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.delBrandRelationModelByCode.num");
        }
    }

    private void deleteBrandRelationModel(Integer brandRelationId) throws ApiException {
        if (null == brandRelationId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandRelationMapper.deleteByPrimaryKey(brandRelationId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.deleteBrandRelationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.deleteBrandRelationModel.num");
        }
    }

    private void updateBrandRelationModel(RsBrandRelation bsBrandRelation) throws ApiException {
        if (null == bsBrandRelation) {
            return;
        }
        try {
            this.rsBrandRelationMapper.updateByPrimaryKeySelective(bsBrandRelation);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.updateBrandRelationModel.ex", (Throwable)e);
        }
    }

    private void updateStateBrandRelationModel(Integer brandRelationId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == brandRelationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandRelationId", brandRelationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsBrandRelationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.updateStateBrandRelationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.updateStateBrandRelationModel.null");
        }
    }

    private RsBrandRelation makeBrandRelation(RsBrandRelationDomain rsBrandRelationDomain, RsBrandRelation bsBrandRelation) {
        if (null == rsBrandRelationDomain) {
            return null;
        }
        if (null == bsBrandRelation) {
            bsBrandRelation = new RsBrandRelation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsBrandRelation, (Object)rsBrandRelationDomain);
            return bsBrandRelation;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.makeBrandRelation", (Throwable)e);
            return null;
        }
    }

    private List<RsBrandRelation> queryBrandRelationModelPage(Map<String, Object> parammap) {
        try {
            return this.rsBrandRelationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.queryBrandRelationModel", (Throwable)e);
            return null;
        }
    }

    private int countBrandRelation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsBrandRelationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandRelationServiceImpl.countBrandRelation", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveBrandRelation(RsBrandRelationDomain rsBrandRelationDomain) throws ApiException {
        String msg = this.checkBrandRelation(rsBrandRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.saveBrandRelation.checkBrandRelation", msg);
        }
        RsBrandRelation bsBrandRelation = this.makeBrandRelation(rsBrandRelationDomain, null);
        this.setBrandRelationDefault(bsBrandRelation);
        this.saveBrandRelationModel(bsBrandRelation);
    }

    @Override
    public void updateBrandRelationState(Integer brandRelationId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBrandRelationModel(brandRelationId, dataState, oldDataState);
    }

    @Override
    public void updateBrandRelation(RsBrandRelationDomain rsBrandRelationDomain) throws ApiException {
        String msg = this.checkBrandRelation(rsBrandRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.updateBrandRelation.checkBrandRelation", msg);
        }
        RsBrandRelation oldRsBrandRelation = this.getBrandRelationModelById(rsBrandRelationDomain.getBrandRelationId());
        if (null == oldRsBrandRelation) {
            throw new ApiException("rs.RsBrandRelationServiceImpl.updateBrandRelation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandRelation bsBrandRelation = this.makeBrandRelation(rsBrandRelationDomain, oldRsBrandRelation);
        this.setBrandRelationUpdataDefault(bsBrandRelation);
        this.updateBrandRelationModel(bsBrandRelation);
    }

    @Override
    public RsBrandRelation getBrandRelation(Integer brandRelationId) {
        return this.getBrandRelationModelById(brandRelationId);
    }

    @Override
    public void deleteBrandRelation(Integer brandRelationId) throws ApiException {
        this.deleteBrandRelationModel(brandRelationId);
    }

    @Override
    public QueryResult<RsBrandRelation> queryBrandRelationPage(Map<String, Object> map) {
        List<RsBrandRelation> bsBrandRelationList = this.queryBrandRelationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrandRelation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsBrandRelationList);
        return queryResult;
    }

    @Override
    public RsBrandRelation getBrandRelationByCode(Map<String, Object> map) {
        return this.getBrandRelationModelByCode(map);
    }

    @Override
    public void delBrandRelationByCode(Map<String, Object> map) throws ApiException {
        this.delBrandRelationModelByCode(map);
    }

    @Override
    public void deleteBrandRelationByPntree(String pntreeCode) {
        this.rsBrandRelationMapper.deleteBrandRelationByPntreeCode(pntreeCode);
    }
}

