/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsWhMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsWhDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsWhReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsWh;
import com.yqbsoft.laser.service.resources.service.RsGoodsWhService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsWhServiceImpl
extends BaseServiceImpl
implements RsGoodsWhService {
    private static final String SYS_CODE = "rs.RsGoodsWhServiceImpl";
    private RsGoodsWhMapper rsGoodsWhMapper;

    public void setRsGoodsWhMapper(RsGoodsWhMapper rsGoodsWhMapper) {
        this.rsGoodsWhMapper = rsGoodsWhMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsWhMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsWh(RsGoodsWhDomain rsGoodsWhDomain) {
        if (null == rsGoodsWhDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsWhDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsWhDefault(RsGoodsWh rsGoodsWh) {
        if (null == rsGoodsWh) {
            return;
        }
        if (null == rsGoodsWh.getDataState()) {
            rsGoodsWh.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsGoodsWh.getGmtCreate()) {
            rsGoodsWh.setGmtCreate(date);
        }
        rsGoodsWh.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsWh.getGoodsWhCode())) {
            rsGoodsWh.setGoodsWhCode(this.getNo(null, "RsGoodsWh", "rsGoodsWh", rsGoodsWh.getTenantCode()));
        }
    }

    private int getGoodsWhMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsWhMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.getGoodsWhMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsWhUpdataDefault(RsGoodsWh rsGoodsWh) {
        if (null == rsGoodsWh) {
            return;
        }
        rsGoodsWh.setGmtModified(this.getSysDate());
    }

    private void saveGoodsWhModel(RsGoodsWh rsGoodsWh) throws ApiException {
        if (null == rsGoodsWh) {
            return;
        }
        try {
            this.rsGoodsWhMapper.insert(rsGoodsWh);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.saveGoodsWhModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsWhBatchModel(List<RsGoodsWh> rsGoodsWhList) throws ApiException {
        if (null == rsGoodsWhList || rsGoodsWhList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsWhMapper.insertBatch(rsGoodsWhList);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Duplicate")) {
                this.logger.error("rs.RsGoodsWhServiceImplsaveGoodsShopBatchModel.ex \u552f\u4e00\u4e3b\u952e\u5f02\u5e38 >>>", (Throwable)e);
                return;
            }
            throw new ApiException("rs.RsGoodsWhServiceImpl.saveGoodsWhBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsWh getGoodsWhModelById(Integer goodsWhId) {
        if (null == goodsWhId) {
            return null;
        }
        try {
            return this.rsGoodsWhMapper.selectByPrimaryKey(goodsWhId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.getGoodsWhModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsWh getGoodsWhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsWhMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.getGoodsWhModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsWhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.delGoodsWhModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.delGoodsWhModelByCode.num");
        }
    }

    private void delGoodsWhModelByGoodsCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsWhMapper.delByGoodCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.delGoodsWhModelByGoodsCode.ex", (Throwable)e);
        }
    }

    private void deleteGoodsWhModel(Integer goodsWhId) throws ApiException {
        if (null == goodsWhId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.deleteByPrimaryKey(goodsWhId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.deleteGoodsWhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.deleteGoodsWhModel.num");
        }
    }

    private void updateGoodsWhModel(RsGoodsWh rsGoodsWh) throws ApiException {
        if (null == rsGoodsWh) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.updateByPrimaryKey(rsGoodsWh);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateGoodsWhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateGoodsWhModel.num");
        }
    }

    private void updateStateGoodsWhModel(Integer goodsWhId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsWhId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsWhId", goodsWhId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateStateGoodsWhModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateStateGoodsWhModel.null");
        }
    }

    private void updateStateGoodsWhModelByCode(String tenantCode, String goodsWhCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsWhCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsWhCode", goodsWhCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateStateGoodsWhModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateStateGoodsWhModelByCode.null");
        }
    }

    private RsGoodsWh makeGoodsWh(RsGoodsWhDomain rsGoodsWhDomain, RsGoodsWh rsGoodsWh) {
        if (null == rsGoodsWhDomain) {
            return null;
        }
        if (null == rsGoodsWh) {
            rsGoodsWh = new RsGoodsWh();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsWh, (Object)rsGoodsWhDomain);
            return rsGoodsWh;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.makeGoodsWh", (Throwable)e);
            return null;
        }
    }

    private RsGoodsWhReDomain makeRsGoodsWhReDomain(RsGoodsWh rsGoodsWh) {
        if (null == rsGoodsWh) {
            return null;
        }
        RsGoodsWhReDomain rsGoodsWhReDomain = new RsGoodsWhReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsWhReDomain, (Object)rsGoodsWh);
            return rsGoodsWhReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.makeRsGoodsWhReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsWh> queryGoodsWhModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsWhMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.queryGoodsWhModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsWh(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsWhMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsWhServiceImpl.countGoodsWh", (Throwable)e);
        }
        return i;
    }

    private RsGoodsWh createRsGoodsWh(RsGoodsWhDomain rsGoodsWhDomain) {
        String msg = this.checkGoodsWh(rsGoodsWhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.saveGoodsWh.checkGoodsWh", msg);
        }
        RsGoodsWh rsGoodsWh = this.makeGoodsWh(rsGoodsWhDomain, null);
        this.setGoodsWhDefault(rsGoodsWh);
        return rsGoodsWh;
    }

    @Override
    public String saveGoodsWh(RsGoodsWhDomain rsGoodsWhDomain) throws ApiException {
        RsGoodsWh rsGoodsWh = this.createRsGoodsWh(rsGoodsWhDomain);
        this.saveGoodsWhModel(rsGoodsWh);
        return rsGoodsWh.getGoodsWhCode();
    }

    @Override
    public String saveGoodsWhBatch(List<RsGoodsWhDomain> rsGoodsWhDomainList) throws ApiException {
        if (null == rsGoodsWhDomainList || rsGoodsWhDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsWh> rsGoodsWhList = new ArrayList<RsGoodsWh>();
        String code = "";
        for (RsGoodsWhDomain rsGoodsWhDomain : rsGoodsWhDomainList) {
            RsGoodsWh rsGoodsWh = this.createRsGoodsWh(rsGoodsWhDomain);
            code = rsGoodsWh.getGoodsWhCode();
            rsGoodsWhList.add(rsGoodsWh);
        }
        this.saveGoodsWhBatchModel(rsGoodsWhList);
        return code;
    }

    @Override
    public void updateGoodsWhState(Integer goodsWhId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsWhId) {
            return;
        }
        this.updateStateGoodsWhModel(goodsWhId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsWhStateByCode(String tenantCode, String goodsWhCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsWhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsWhModelByCode(tenantCode, goodsWhCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsWh(RsGoodsWhDomain rsGoodsWhDomain) throws ApiException {
        String msg = this.checkGoodsWh(rsGoodsWhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateGoodsWh.checkGoodsWh", msg);
        }
        RsGoodsWh oldRsGoodsWh = this.getGoodsWhModelById(rsGoodsWhDomain.getGoodsWhId());
        if (null == oldRsGoodsWh) {
            throw new ApiException("rs.RsGoodsWhServiceImpl.updateGoodsWh.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsWh rsGoodsWh = this.makeGoodsWh(rsGoodsWhDomain, oldRsGoodsWh);
        this.setGoodsWhUpdataDefault(rsGoodsWh);
        this.updateGoodsWhModel(rsGoodsWh);
    }

    @Override
    public RsGoodsWh getGoodsWh(Integer goodsWhId) {
        if (null == goodsWhId) {
            return null;
        }
        return this.getGoodsWhModelById(goodsWhId);
    }

    @Override
    public void deleteGoodsWh(Integer goodsWhId) throws ApiException {
        if (null == goodsWhId) {
            return;
        }
        this.deleteGoodsWhModel(goodsWhId);
    }

    @Override
    public QueryResult<RsGoodsWh> queryGoodsWhPage(Map<String, Object> map) {
        List<RsGoodsWh> rsGoodsWhList = this.queryGoodsWhModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsWh(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsWhList);
        return queryResult;
    }

    @Override
    public RsGoodsWh getGoodsWhByCode(String tenantCode, String goodsWhCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsWhCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsWhCode", goodsWhCode);
        return this.getGoodsWhModelByCode(map);
    }

    @Override
    public void deleteGoodsWhByCode(String tenantCode, String goodsWhCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsWhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsWhCode", goodsWhCode);
        this.delGoodsWhModelByCode(map);
    }

    @Override
    public void deleteGoodsWhByGoodsCode(String tenantCode, String goodsCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        this.delGoodsWhModelByGoodsCode(map);
    }
}

