/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSpecValueMapper;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DuplicateKeyException;

public class RsSpecValueServiceImpl
extends BaseServiceImpl
implements RsSpecValueService {
    public static final String SYS_CODE = "rs.RsSpecValueServiceImpl";
    private RsSpecValueMapper rsSpecValueMapper;

    public void setRsSpecValueMapper(RsSpecValueMapper rsSpecValueMapper) {
        this.rsSpecValueMapper = rsSpecValueMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSpecValueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSpecValue(RsSpecValueDomain rsSpecValueDomain) {
        if (null == rsSpecValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSpecValueDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSpecValueDomain.getSpecCode())) {
            msg = msg + "\u89c4\u683c\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSpecValueDomain.getSpecGroupCode())) {
            msg = msg + "\u89c4\u683c\u7ec4\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSpecValueDomain.getSpecValueBillno())) {
            msg = msg + "\u5173\u8054\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSpecValueDomain.getSpecValueValue())) {
            msg = msg + "\u5173\u8054\u503c\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSpecValueDefault(RsSpecValue rsSpecValue) {
        if (null == rsSpecValue) {
            return;
        }
        if (null == rsSpecValue.getDataState()) {
            rsSpecValue.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSpecValue.getGmtCreate()) {
            rsSpecValue.setGmtCreate(date);
        }
        rsSpecValue.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSpecValue.getSpecValueCode())) {
            rsSpecValue.setSpecValueCode(this.createUUIDString());
        }
    }

    private int getSpecValueMaxCode() {
        int code = 0;
        try {
            return this.rsSpecValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.getSpecValueMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSpecValueUpdataDefault(RsSpecValue rsSpecValue) {
        if (null == rsSpecValue) {
            return;
        }
        rsSpecValue.setGmtModified(this.getSysDate());
    }

    private void saveSpecValueModel(RsSpecValue rsSpecValue) throws ApiException {
        if (null == rsSpecValue) {
            return;
        }
        try {
            this.rsSpecValueMapper.insert(rsSpecValue);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                this.logger.error("rs.RsSpecValueServiceImplsaveSpecValueModel.ex ==========\u4e3b\u952e\u51b2\u7a81==========");
                return;
            }
            throw new ApiException("rs.RsSpecValueServiceImpl.saveSpecValueModel.ex", (Throwable)e);
        }
    }

    private void saveSpecValueModel(List<RsSpecValue> rsSpecValueList) throws ApiException {
        if (null == rsSpecValueList || rsSpecValueList.isEmpty()) {
            return;
        }
        try {
            this.rsSpecValueMapper.insertBatch(rsSpecValueList);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                this.logger.error("rs.RsSpecValueServiceImplsavePropertiesModel.ex ==========\u4e3b\u952e\u51b2\u7a81==========");
                return;
            }
            throw new ApiException("rs.RsSpecValueServiceImpl.saveSpecValueModel.ex");
        }
    }

    private RsSpecValue getSpecValueModelById(Integer specValueId) {
        if (null == specValueId) {
            return null;
        }
        try {
            return this.rsSpecValueMapper.selectByPrimaryKey(specValueId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.getSpecValueModelById", (Throwable)e);
            return null;
        }
    }

    public RsSpecValue getSpecValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSpecValueMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.getSpecValueModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSpecValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecValueMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecValueServiceImpl.delSpecValueModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecValueServiceImpl.delSpecValueModelByCode.num");
        }
    }

    private void deleteSpecValueModel(Integer specValueId) throws ApiException {
        if (null == specValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecValueMapper.deleteByPrimaryKey(specValueId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecValueServiceImpl.deleteSpecValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecValueServiceImpl.deleteSpecValueModel.num");
        }
    }

    private void updateSpecValueModel(RsSpecValue rsSpecValue) throws ApiException {
        if (null == rsSpecValue) {
            return;
        }
        try {
            this.rsSpecValueMapper.updateByPrimaryKeySelective(rsSpecValue);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecValueServiceImpl.updateSpecValueModel.ex", (Throwable)e);
        }
    }

    private void updateStateSpecValueModel(Integer specValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == specValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specValueId", specValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSpecValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecValueServiceImpl.updateStateSpecValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSpecValueServiceImpl.updateStateSpecValueModel.null");
        }
    }

    private RsSpecValue makeSpecValue(RsSpecValueDomain rsSpecValueDomain, RsSpecValue rsSpecValue) {
        if (null == rsSpecValueDomain) {
            return null;
        }
        if (null == rsSpecValue) {
            rsSpecValue = new RsSpecValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValue, (Object)rsSpecValueDomain);
            return rsSpecValue;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.makeSpecValue", (Throwable)e);
            return null;
        }
    }

    private List<RsSpecValue> querySpecValueModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.querySpecValueModel", (Throwable)e);
            return null;
        }
    }

    private int countSpecValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSpecValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecValueServiceImpl.countSpecValue", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveSpecValue(RsSpecValueDomain rsSpecValueDomain) throws ApiException {
        String msg = this.checkSpecValue(rsSpecValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecValueServiceImpl.saveSpecValue.checkSpecValue", msg);
        }
        RsSpecValue rsSpecValue = this.makeSpecValue(rsSpecValueDomain, null);
        this.setSpecValueDefault(rsSpecValue);
        this.saveSpecValueModel(rsSpecValue);
    }

    @Override
    public void saveSpecValueList(List<RsSpecValueDomain> rsSpecValueList) throws ApiException {
        if (rsSpecValueList == null || rsSpecValueList.isEmpty()) {
            throw new ApiException("rs.RsSpecValueServiceImpl.saveSpecValueList.null", "\u53c2\u6570\u4e3a\u7a7a!");
        }
        ArrayList<RsSpecValue> valueList = new ArrayList<RsSpecValue>();
        for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueList) {
            String msg = this.checkSpecValue(rsSpecValueDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsSpecValueServiceImpl.saveSpecValueList.checkSpecValue", msg);
            }
            RsSpecValue rsSpecValue = this.makeSpecValue(rsSpecValueDomain, null);
            this.setSpecValueDefault(rsSpecValue);
            valueList.add(rsSpecValue);
        }
        this.saveSpecValueModel(valueList);
    }

    @Override
    public void updateSpecValueState(Integer specValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSpecValueModel(specValueId, dataState, oldDataState);
    }

    @Override
    public void updateSpecValue(RsSpecValueDomain rsSpecValueDomain) throws ApiException {
        String msg = this.checkSpecValue(rsSpecValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecValueServiceImpl.updateSpecValue.checkSpecValue", msg);
        }
        RsSpecValue oldRsSpecValue = this.getSpecValueModelById(rsSpecValueDomain.getSpecValueId());
        if (null == oldRsSpecValue) {
            throw new ApiException("rs.RsSpecValueServiceImpl.updateSpecValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSpecValue rsSpecValue = this.makeSpecValue(rsSpecValueDomain, oldRsSpecValue);
        this.setSpecValueUpdataDefault(rsSpecValue);
        this.updateSpecValueModel(rsSpecValue);
    }

    @Override
    public RsSpecValue getSpecValue(Integer specValueId) {
        return this.getSpecValueModelById(specValueId);
    }

    @Override
    public void deleteSpecValue(Integer specValueId) throws ApiException {
        this.deleteSpecValueModel(specValueId);
    }

    @Override
    public QueryResult<RsSpecValue> querySpecValuePage(Map<String, Object> map) {
        List<RsSpecValue> rsSpecValueList = this.querySpecValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSpecValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSpecValueList);
        return queryResult;
    }

    @Override
    public RsSpecValue getSpecValueByCode(Map<String, Object> map) {
        return this.getSpecValueModelByCode(map);
    }

    @Override
    public void delSpecValueByCode(Map<String, Object> map) throws ApiException {
        this.delSpecValueModelByCode(map);
    }

    @Override
    public void deleteSpecValueBySpu(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        List<RsSpecValue> vlist = this.querySpecValueModelPage(map);
        if (ListUtil.isEmpty(vlist)) {
            return;
        }
        for (RsSpecValue rsSpecValue : vlist) {
            this.deleteSpecValue(rsSpecValue.getSpecValueId());
        }
    }

    private void deleteSpecValueBySpuModel(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            this.rsSpecValueMapper.delSpecValueBySpu(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecValueServiceImpl.deleteSpecValueBySpuModel.ex", (Throwable)e);
        }
    }
}

