/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSkuStoreMapper;
import com.yqbsoft.laser.service.resources.domain.RsSkuStoreDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuStoreReDomain;
import com.yqbsoft.laser.service.resources.model.RsSkuStore;
import com.yqbsoft.laser.service.resources.service.RsSkuStoreService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSkuStoreServiceImpl
extends BaseServiceImpl
implements RsSkuStoreService {
    private static final String SYS_CODE = "rs.RsSkuStoreServiceImpl";
    private RsSkuStoreMapper rsSkuStoreMapper;

    public void setRsSkuStoreMapper(RsSkuStoreMapper rsSkuStoreMapper) {
        this.rsSkuStoreMapper = rsSkuStoreMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuStoreMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSkuStore(RsSkuStoreDomain rsSkuStoreDomain) {
        if (null == rsSkuStoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuStoreDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuStoreDefault(RsSkuStore rsSkuStore) {
        if (null == rsSkuStore) {
            return;
        }
        Date date = this.getSysDate();
        if (null == rsSkuStore.getGmtCreate()) {
            rsSkuStore.setGmtCreate(date);
        }
        rsSkuStore.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSkuStore.getStoreCode())) {
            rsSkuStore.setStoreCode(this.getNo(null, "RsSkuStore", "rsSkuStore", rsSkuStore.getTenantCode()));
        }
    }

    private int getSkuStoreMaxCode() {
        int code = 0;
        try {
            return this.rsSkuStoreMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.getSkuStoreMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuStoreUpdataDefault(RsSkuStore rsSkuStore) {
        if (null == rsSkuStore) {
            return;
        }
        rsSkuStore.setGmtModified(this.getSysDate());
    }

    private void saveSkuStoreModel(RsSkuStore rsSkuStore) throws ApiException {
        if (null == rsSkuStore) {
            return;
        }
        try {
            this.rsSkuStoreMapper.insert(rsSkuStore);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.saveSkuStoreModel.ex", (Throwable)e);
        }
    }

    private void saveSkuStoreBatchModel(List<RsSkuStore> rsSkuStoreList) throws ApiException {
        if (null == rsSkuStoreList || rsSkuStoreList.isEmpty()) {
            return;
        }
        try {
            this.rsSkuStoreMapper.insertBatch(rsSkuStoreList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.saveSkuStoreBatchModel.ex", (Throwable)e);
        }
    }

    private RsSkuStore getSkuStoreModelById(Integer storeId) {
        if (null == storeId) {
            return null;
        }
        try {
            return this.rsSkuStoreMapper.selectByPrimaryKey(storeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.getSkuStoreModelById", (Throwable)e);
            return null;
        }
    }

    private RsSkuStore getSkuStoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuStoreMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.getSkuStoreModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSkuStoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.delSkuStoreModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.delSkuStoreModelByCode.num");
        }
    }

    private void deleteSkuStoreModel(Integer storeId) throws ApiException {
        if (null == storeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.deleteByPrimaryKey(storeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.deleteSkuStoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.deleteSkuStoreModel.num");
        }
    }

    private void updateSkuStoreModel(RsSkuStore rsSkuStore) throws ApiException {
        if (null == rsSkuStore) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.updateByPrimaryKey(rsSkuStore);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateSkuStoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateSkuStoreModel.num");
        }
    }

    private void updateStateSkuStoreModel(Integer storeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeId", storeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateStateSkuStoreModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateStateSkuStoreModel.null");
        }
    }

    private void updateStateSkuStoreModelByCode(String tenantCode, String storeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCode", storeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateStateSkuStoreModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateStateSkuStoreModelByCode.null");
        }
    }

    private RsSkuStore makeSkuStore(RsSkuStoreDomain rsSkuStoreDomain, RsSkuStore rsSkuStore) {
        if (null == rsSkuStoreDomain) {
            return null;
        }
        if (null == rsSkuStore) {
            rsSkuStore = new RsSkuStore();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuStore, (Object)rsSkuStoreDomain);
            return rsSkuStore;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.makeSkuStore", (Throwable)e);
            return null;
        }
    }

    private RsSkuStoreReDomain makeRsSkuStoreReDomain(RsSkuStore rsSkuStore) {
        if (null == rsSkuStore) {
            return null;
        }
        RsSkuStoreReDomain rsSkuStoreReDomain = new RsSkuStoreReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuStoreReDomain, (Object)rsSkuStore);
            return rsSkuStoreReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.makeRsSkuStoreReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSkuStore> querySkuStoreModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuStoreMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.querySkuStoreModel", (Throwable)e);
            return null;
        }
    }

    private int countSkuStore(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuStoreMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuStoreServiceImpl.countSkuStore", (Throwable)e);
        }
        return i;
    }

    private RsSkuStore createRsSkuStore(RsSkuStoreDomain rsSkuStoreDomain) {
        String msg = this.checkSkuStore(rsSkuStoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.saveSkuStore.checkSkuStore", msg);
        }
        RsSkuStore rsSkuStore = this.makeSkuStore(rsSkuStoreDomain, null);
        this.setSkuStoreDefault(rsSkuStore);
        return rsSkuStore;
    }

    @Override
    public String saveSkuStore(RsSkuStoreDomain rsSkuStoreDomain) throws ApiException {
        RsSkuStore rsSkuStore = this.createRsSkuStore(rsSkuStoreDomain);
        this.saveSkuStoreModel(rsSkuStore);
        return rsSkuStore.getStoreCode();
    }

    @Override
    public String saveSkuStoreBatch(List<RsSkuStoreDomain> rsSkuStoreDomainList) throws ApiException {
        if (null == rsSkuStoreDomainList || rsSkuStoreDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSkuStore> rsSkuStoreList = new ArrayList<RsSkuStore>();
        String code = "";
        for (RsSkuStoreDomain rsSkuStoreDomain : rsSkuStoreDomainList) {
            RsSkuStore rsSkuStore = this.createRsSkuStore(rsSkuStoreDomain);
            code = rsSkuStore.getStoreCode();
            rsSkuStoreList.add(rsSkuStore);
        }
        this.saveSkuStoreBatchModel(rsSkuStoreList);
        return code;
    }

    @Override
    public void updateSkuStoreState(Integer storeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeId) {
            return;
        }
        this.updateStateSkuStoreModel(storeId, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuStoreStateByCode(String tenantCode, String storeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSkuStoreModelByCode(tenantCode, storeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuStore(RsSkuStoreDomain rsSkuStoreDomain) throws ApiException {
        String msg = this.checkSkuStore(rsSkuStoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateSkuStore.checkSkuStore", msg);
        }
        RsSkuStore oldRsSkuStore = this.getSkuStoreModelById(rsSkuStoreDomain.getStoreId());
        if (null == oldRsSkuStore) {
            throw new ApiException("rs.RsSkuStoreServiceImpl.updateSkuStore.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuStore rsSkuStore = this.makeSkuStore(rsSkuStoreDomain, oldRsSkuStore);
        this.setSkuStoreUpdataDefault(rsSkuStore);
        this.updateSkuStoreModel(rsSkuStore);
    }

    @Override
    public RsSkuStore getSkuStore(Integer storeId) {
        if (null == storeId) {
            return null;
        }
        return this.getSkuStoreModelById(storeId);
    }

    @Override
    public void deleteSkuStore(Integer storeId) throws ApiException {
        if (null == storeId) {
            return;
        }
        this.deleteSkuStoreModel(storeId);
    }

    @Override
    public QueryResult<RsSkuStore> querySkuStorePage(Map<String, Object> map) {
        List<RsSkuStore> rsSkuStoreList = this.querySkuStoreModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuStore(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuStoreList);
        return queryResult;
    }

    @Override
    public RsSkuStore getSkuStoreByCode(String tenantCode, String storeCode) throws ApiException {
        if (StringUtils.isBlank((String)storeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCode", storeCode);
        return this.getSkuStoreModelByCode(map);
    }

    @Override
    public void deleteSkuStoreByCode(String tenantCode, String storeCode) throws ApiException {
        if (StringUtils.isBlank((String)storeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCode", storeCode);
        this.delSkuStoreModelByCode(map);
    }
}

