/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsContractMtMapper;
import com.yqbsoft.laser.service.resources.domain.ActCommonDomain;
import com.yqbsoft.laser.service.resources.domain.RsContractMtDomain;
import com.yqbsoft.laser.service.resources.domain.RsContractMtReDomain;
import com.yqbsoft.laser.service.resources.model.RsContractMt;
import com.yqbsoft.laser.service.resources.service.RsContractMtService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsContractMtServiceImpl
extends BaseServiceImpl
implements RsContractMtService {
    private static final String SYS_CODE = "rs.RsContractMtServiceImpl";
    private RsContractMtMapper rsContractMtMapper;

    public void setRsContractMtMapper(RsContractMtMapper rsContractMtMapper) {
        this.rsContractMtMapper = rsContractMtMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsContractMtMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractMt(RsContractMtDomain rsContractMtDomain) {
        if (null == rsContractMtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsContractMtDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractMtDefault(RsContractMt rsContractMt) {
        if (null == rsContractMt) {
            return;
        }
        if (null == rsContractMt.getDataState()) {
            rsContractMt.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsContractMt.getGmtCreate()) {
            rsContractMt.setGmtCreate(date);
        }
        rsContractMt.setGmtModified(date);
        if (StringUtils.isBlank((String)rsContractMt.getContractMtCode())) {
            rsContractMt.setContractMtCode(this.getNo(null, "RsContractMt", "rsContractMt", rsContractMt.getTenantCode()));
        }
    }

    private int getContractMtMaxCode() {
        int code = 0;
        try {
            return this.rsContractMtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.getContractMtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractMtUpdataDefault(RsContractMt rsContractMt) {
        if (null == rsContractMt) {
            return;
        }
        rsContractMt.setGmtModified(this.getSysDate());
    }

    private void saveContractMtModel(RsContractMt rsContractMt) throws ApiException {
        if (null == rsContractMt) {
            return;
        }
        try {
            this.rsContractMtMapper.insert(rsContractMt);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.saveContractMtModel.ex", (Throwable)e);
        }
    }

    private void saveContractMtBatchModel(List<RsContractMt> rsContractMtList) throws ApiException {
        if (null == rsContractMtList || rsContractMtList.isEmpty()) {
            return;
        }
        try {
            this.rsContractMtMapper.insertBatch(rsContractMtList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.saveContractMtBatchModel.ex", (Throwable)e);
        }
    }

    private RsContractMt getContractMtModelById(Integer contractMtId) {
        if (null == contractMtId) {
            return null;
        }
        try {
            return this.rsContractMtMapper.selectByPrimaryKey(contractMtId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.getContractMtModelById", (Throwable)e);
            return null;
        }
    }

    private RsContractMt getContractMtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsContractMtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.getContractMtModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractMtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.delContractMtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsContractMtServiceImpl.delContractMtModelByCode.num");
        }
    }

    private void deleteContractMtModel(Integer contractMtId) throws ApiException {
        if (null == contractMtId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.deleteByPrimaryKey(contractMtId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.deleteContractMtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsContractMtServiceImpl.deleteContractMtModel.num");
        }
    }

    private void updateContractMtModel(RsContractMt rsContractMt) throws ApiException {
        if (null == rsContractMt) {
            return;
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.updateByPrimaryKey(rsContractMt);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMtModel.num");
        }
    }

    private void updateStateContractMtModel(Integer contractMtId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractMtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractMtId", contractMtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateStateContractMtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateStateContractMtModel.null");
        }
    }

    private void updateStateContractMtModelByCode(String tenantCode, String contractMt, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractMt) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractMt", contractMt);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateStateContractMtModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateStateContractMtModelByCode.null");
        }
    }

    private RsContractMt makeContractMt(RsContractMtDomain rsContractMtDomain, RsContractMt rsContractMt) {
        if (null == rsContractMtDomain) {
            return null;
        }
        if (null == rsContractMt) {
            rsContractMt = new RsContractMt();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsContractMt, (Object)rsContractMtDomain);
            return rsContractMt;
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.makeContractMt", (Throwable)e);
            return null;
        }
    }

    private RsContractMtReDomain makeRsContractMtReDomain(RsContractMt rsContractMt) {
        if (null == rsContractMt) {
            return null;
        }
        RsContractMtReDomain rsContractMtReDomain = new RsContractMtReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsContractMtReDomain, (Object)rsContractMt);
            return rsContractMtReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.makeRsContractMtReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsContractMt> queryContractMtModelPage(Map<String, Object> parammap) {
        try {
            return this.rsContractMtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.queryContractMtModel", (Throwable)e);
            return null;
        }
    }

    private int countContractMt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsContractMtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsContractMtServiceImpl.countContractMt", (Throwable)e);
        }
        return i;
    }

    private RsContractMt createRsContractMt(RsContractMtDomain rsContractMtDomain) {
        String msg = this.checkContractMt(rsContractMtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsContractMtServiceImpl.saveContractMt.checkContractMt", msg);
        }
        RsContractMt rsContractMt = this.makeContractMt(rsContractMtDomain, null);
        this.setContractMtDefault(rsContractMt);
        return rsContractMt;
    }

    @Override
    public String saveContractMt(RsContractMtDomain rsContractMtDomain) throws ApiException {
        RsContractMt rsContractMt = this.createRsContractMt(rsContractMtDomain);
        this.saveContractMtModel(rsContractMt);
        return rsContractMt.getContractMtCode();
    }

    @Override
    public String saveContractMtBatch(List<RsContractMtDomain> rsContractMtDomainList) throws ApiException {
        if (null == rsContractMtDomainList || rsContractMtDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsContractMt> rsContractMtList = new ArrayList<RsContractMt>();
        String code = "";
        for (RsContractMtDomain rsContractMtDomain : rsContractMtDomainList) {
            RsContractMt rsContractMt = this.createRsContractMt(rsContractMtDomain);
            code = rsContractMt.getContractMtCode();
            rsContractMtList.add(rsContractMt);
        }
        this.saveContractMtBatchModel(rsContractMtList);
        return code;
    }

    @Override
    public void updateContractMtState(Integer contractMtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractMtId) {
            return;
        }
        this.updateStateContractMtModel(contractMtId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractMtStateByCode(String tenantCode, String contractMt, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractMt) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractMtModelByCode(tenantCode, contractMt, dataState, oldDataState, map);
    }

    @Override
    public void updateContractMt(RsContractMtDomain rsContractMtDomain) throws ApiException {
        String msg = this.checkContractMt(rsContractMtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMt.checkContractMt", msg);
        }
        RsContractMt oldRsContractMt = this.getContractMtModelById(rsContractMtDomain.getContractMtId());
        if (null == oldRsContractMt) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsContractMt rsContractMt = this.makeContractMt(rsContractMtDomain, oldRsContractMt);
        this.setContractMtUpdataDefault(rsContractMt);
        this.updateContractMtModel(rsContractMt);
    }

    @Override
    public RsContractMt getContractMt(Integer contractMtId) {
        if (null == contractMtId) {
            return null;
        }
        return this.getContractMtModelById(contractMtId);
    }

    @Override
    public void deleteContractMt(Integer contractMtId) throws ApiException {
        if (null == contractMtId) {
            return;
        }
        this.deleteContractMtModel(contractMtId);
    }

    @Override
    public QueryResult<RsContractMt> queryContractMtPage(Map<String, Object> map) {
        List<RsContractMt> rsContractMtList = this.queryContractMtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractMt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsContractMtList);
        return queryResult;
    }

    @Override
    public RsContractMt getContractMtByCode(String tenantCode, String contractMt) throws ApiException {
        if (StringUtils.isBlank((String)contractMt) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractMt", contractMt);
        return this.getContractMtModelByCode(map);
    }

    @Override
    public void deleteContractMtByCode(String tenantCode, String contractMt) throws ApiException {
        if (StringUtils.isBlank((String)contractMt) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractMt", contractMt);
        this.delContractMtModelByCode(map);
    }

    @Override
    public void actSubmitMt(List<RsContractMtDomain> rsContractMtDomainList) throws ApiException {
        this.logger.error("rs.RsContractMtServiceImpl.actSubmitMt =====\u5408\u540c\u7ef4\u4fdd\u5ba1\u63d0\u4ea4\u5ba1\u6279\u6d41\u5f00\u59cb======");
        if (rsContractMtDomainList == null || ListUtil.isEmpty(rsContractMtDomainList)) {
            this.logger.error("rs.RsContractMtServiceImpl.actSubmitMt.null");
        }
        this.activeAct(rsContractMtDomainList);
        this.logger.error("rs.RsContractMtServiceImpl.actSubmitMt =====\u5408\u540c\u7ef4\u4fdd\u5ba1\u63d0\u4ea4\u5ba1\u6279\u6d41\u7ed3\u675f======");
    }

    private void activeAct(List<RsContractMtDomain> rsContractMtDomainList) {
        RsContractMtDomain rsContractMtDomain = rsContractMtDomainList.get(0);
        HashMap<String, String> actParamMap = new HashMap<String, String>();
        HashMap<String, Object> sendParamMap = new HashMap<String, Object>();
        sendParamMap.put("applyUserCode", rsContractMtDomain.getExtend());
        sendParamMap.put("applyUserName", rsContractMtDomain.getExtend1());
        sendParamMap.put("dataList", rsContractMtDomainList);
        sendParamMap.put("submitRemark", rsContractMtDomain.getMemo());
        sendParamMap.put("title", rsContractMtDomain.getMemberName());
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(rsContractMtDomain.getTenantCode());
        actCommonDomain.setBusinessKey(rsContractMtDomain.getMemberCode());
        actCommonDomain.setInterfaceType("RsContractMt");
        actCommonDomain.setCallUrl("rs.contractMt.actAuditCallMt");
        actCommonDomain.setStartUserType("1");
        actCommonDomain.setStartUser(rsContractMtDomain.getMemberCode());
        actCommonDomain.setStartName(rsContractMtDomain.getMemberName());
        actCommonDomain.setUserCode(rsContractMtDomain.getMemberCode());
        actCommonDomain.setParamMap(sendParamMap);
        this.updateContractState(rsContractMtDomainList, ResourcesConstants.MT_DATA_STATE_4, null);
        actParamMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", actParamMap);
    }

    @Override
    public void actAuditCallMt(Map<String, Object> map) throws ApiException {
        this.logger.error("rs.RsContractMtServiceImpl.actAuditCallMt =====\u5408\u540c\u7ef4\u4fdd\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb======");
        if (map.get("auditStatus") == null) {
            throw new ApiException("rs.RsContractMtServiceImpl.actAuditCallMt.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        StringBuffer contractMtIdStr = new StringBuffer();
        List rsContractMtDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(map.get("dataList")), RsContractMtDomain.class);
        for (RsContractMtDomain rsContractMtDomain : rsContractMtDomainList) {
            if (StringUtils.isNotBlank((String)contractMtIdStr.toString())) {
                contractMtIdStr.append(",");
            }
            contractMtIdStr.append(rsContractMtDomain.getContractMtId());
        }
        if ("YES".equals(auditStatus)) {
            this.updateContractMtDataState(contractMtIdStr.toString(), ResourcesConstants.MT_DATA_STATE_1, null);
        } else {
            this.updateContractMtDataState(contractMtIdStr.toString(), ResourcesConstants.MT_DATA_STATE_2, null);
        }
        this.logger.error("rs.RsContractMtServiceImpl.actAuditCallMt =====\u5408\u540c\u7ef4\u4fdd\u5ba1\u6279\u6d41\u56de\u8c03\u7ed3\u675f======");
    }

    private void updateContractState(List<RsContractMtDomain> rsContractMtDomainList, Integer dataState, Integer oldDataState) {
        StringBuffer contractMtIdStr = new StringBuffer();
        for (RsContractMtDomain rsContractMtDomain : rsContractMtDomainList) {
            if (StringUtils.isNotBlank((String)contractMtIdStr.toString())) {
                contractMtIdStr.append(",");
            }
            contractMtIdStr.append(rsContractMtDomain.getContractMtId());
        }
        this.updateContractMtDataState(contractMtIdStr.toString(), dataState, oldDataState);
    }

    private void updateContractMtDataState(String contractMtIdStr, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractMtIdStr || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractMtIdStr", contractMtIdStr);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (ResourcesConstants.MT_DATA_STATE_1.intValue() == dataState.intValue()) {
            map.put("auditApprove", "true");
        }
        int i = 0;
        try {
            i = this.rsContractMtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMtDataState.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsContractMtServiceImpl.updateContractMtDataState.null");
        }
    }
}

