/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmRolePermissionMapper;
import com.yqbsoft.laser.service.user.domain.UmRolePermissionDomain;
import com.yqbsoft.laser.service.user.domain.UmRolePermissionReDomain;
import com.yqbsoft.laser.service.user.model.UmRolePermission;
import com.yqbsoft.laser.service.user.service.UmRolePermissionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmRolePermissionServiceImpl
extends BaseServiceImpl
implements UmRolePermissionService {
    private static final String SYS_CODE = "um.USER.UmRolePermissionServiceImpl";
    private UmRolePermissionMapper umRolePermissionMapper;

    public void setUmRolePermissionMapper(UmRolePermissionMapper umRolePermissionMapper) {
        this.umRolePermissionMapper = umRolePermissionMapper;
    }

    private Date getSysDate() {
        try {
            return this.umRolePermissionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRolePermission(UmRolePermissionDomain umRolePermissionDomain) {
        if (null == umRolePermissionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umRolePermissionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRolePermissionDefault(UmRolePermission umRolePermission) {
        if (null == umRolePermission) {
            return;
        }
        if (null == umRolePermission.getDataState()) {
            umRolePermission.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umRolePermission.getGmtCreate()) {
            umRolePermission.setGmtCreate(date);
        }
        umRolePermission.setGmtModified(date);
        if (StringUtils.isBlank((String)umRolePermission.getPermissionCode())) {
            umRolePermission.setPermissionCode(this.getNo(null, "UmRolePermission", "umRolePermission", umRolePermission.getTenantCode()));
        }
    }

    private int getRolePermissionMaxCode() {
        int code = 0;
        try {
            return this.umRolePermissionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.getRolePermissionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRolePermissionUpdataDefault(UmRolePermission umRolePermission) {
        if (null == umRolePermission) {
            return;
        }
        umRolePermission.setGmtModified(this.getSysDate());
    }

    private void saveRolePermissionModel(UmRolePermission umRolePermission) throws ApiException {
        if (null == umRolePermission) {
            return;
        }
        try {
            this.umRolePermissionMapper.insert(umRolePermission);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.saveRolePermissionModel.ex", (Throwable)e);
        }
    }

    private void saveRolePermissionBatchModel(List<UmRolePermission> umRolePermissionList) throws ApiException {
        if (null == umRolePermissionList || umRolePermissionList.isEmpty()) {
            return;
        }
        try {
            this.umRolePermissionMapper.insertBatch(umRolePermissionList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.saveRolePermissionBatchModel.ex", (Throwable)e);
        }
    }

    private UmRolePermission getRolePermissionModelById(Integer permissionId) {
        if (null == permissionId) {
            return null;
        }
        try {
            return this.umRolePermissionMapper.selectByPrimaryKey(permissionId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.getRolePermissionModelById", (Throwable)e);
            return null;
        }
    }

    private UmRolePermission getRolePermissionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umRolePermissionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.getRolePermissionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRolePermissionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.delRolePermissionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.delRolePermissionModelByCode.num");
        }
    }

    private void deleteRolePermissionModel(Integer permissionId) throws ApiException {
        if (null == permissionId) {
            return;
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.deleteByPrimaryKey(permissionId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.deleteRolePermissionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.deleteRolePermissionModel.num");
        }
    }

    private void updateRolePermissionModel(UmRolePermission umRolePermission) throws ApiException {
        if (null == umRolePermission) {
            return;
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.updateByPrimaryKey(umRolePermission);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateRolePermissionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateRolePermissionModel.num");
        }
    }

    private void updateStateRolePermissionModel(Integer permissionId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == permissionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("permissionId", permissionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateStateRolePermissionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateStateRolePermissionModel.null");
        }
    }

    private void updateStateRolePermissionModelByCode(String tenantCode, String permissionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)permissionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("permissionCode", permissionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateStateRolePermissionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateStateRolePermissionModelByCode.null");
        }
    }

    private UmRolePermission makeRolePermission(UmRolePermissionDomain umRolePermissionDomain, UmRolePermission umRolePermission) {
        if (null == umRolePermissionDomain) {
            return null;
        }
        if (null == umRolePermission) {
            umRolePermission = new UmRolePermission();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umRolePermission, (Object)umRolePermissionDomain);
            return umRolePermission;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.makeRolePermission", (Throwable)e);
            return null;
        }
    }

    private UmRolePermissionReDomain makeUmRolePermissionReDomain(UmRolePermission umRolePermission) {
        if (null == umRolePermission) {
            return null;
        }
        UmRolePermissionReDomain umRolePermissionReDomain = new UmRolePermissionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umRolePermissionReDomain, (Object)umRolePermission);
            return umRolePermissionReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.makeUmRolePermissionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmRolePermission> queryRolePermissionModelPage(Map<String, Object> parammap) {
        try {
            return this.umRolePermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.queryRolePermissionModel", (Throwable)e);
            return null;
        }
    }

    private int countRolePermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umRolePermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRolePermissionServiceImpl.countRolePermission", (Throwable)e);
        }
        return i;
    }

    private UmRolePermission createUmRolePermission(UmRolePermissionDomain umRolePermissionDomain) {
        String msg = this.checkRolePermission(umRolePermissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.saveRolePermission.checkRolePermission", msg);
        }
        UmRolePermission umRolePermission = this.makeRolePermission(umRolePermissionDomain, null);
        this.setRolePermissionDefault(umRolePermission);
        return umRolePermission;
    }

    @Override
    public String saveRolePermission(UmRolePermissionDomain umRolePermissionDomain) throws ApiException {
        UmRolePermission umRolePermission = this.createUmRolePermission(umRolePermissionDomain);
        this.saveRolePermissionModel(umRolePermission);
        return umRolePermission.getPermissionCode();
    }

    @Override
    public String saveRolePermissionBatch(List<UmRolePermissionDomain> umRolePermissionDomainList) throws ApiException {
        if (null == umRolePermissionDomainList || umRolePermissionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmRolePermission> umRolePermissionList = new ArrayList<UmRolePermission>();
        String code = "";
        for (UmRolePermissionDomain umRolePermissionDomain : umRolePermissionDomainList) {
            UmRolePermission umRolePermission = this.createUmRolePermission(umRolePermissionDomain);
            code = umRolePermission.getPermissionCode();
            umRolePermissionList.add(umRolePermission);
        }
        this.saveRolePermissionBatchModel(umRolePermissionList);
        return code;
    }

    @Override
    public void updateRolePermissionState(Integer permissionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == permissionId) {
            return;
        }
        this.updateStateRolePermissionModel(permissionId, dataState, oldDataState, map);
    }

    @Override
    public void updateRolePermissionStateByCode(String tenantCode, String permissionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)permissionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRolePermissionModelByCode(tenantCode, permissionCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRolePermission(UmRolePermissionDomain umRolePermissionDomain) throws ApiException {
        String msg = this.checkRolePermission(umRolePermissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateRolePermission.checkRolePermission", msg);
        }
        UmRolePermission oldUmRolePermission = this.getRolePermissionModelById(umRolePermissionDomain.getPermissionId());
        if (null == oldUmRolePermission) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.updateRolePermission.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmRolePermission umRolePermission = this.makeRolePermission(umRolePermissionDomain, oldUmRolePermission);
        this.setRolePermissionUpdataDefault(umRolePermission);
        this.updateRolePermissionModel(umRolePermission);
    }

    @Override
    public UmRolePermission getRolePermission(Integer permissionId) {
        if (null == permissionId) {
            return null;
        }
        return this.getRolePermissionModelById(permissionId);
    }

    @Override
    public void deleteRolePermission(Integer permissionId) throws ApiException {
        if (null == permissionId) {
            return;
        }
        this.deleteRolePermissionModel(permissionId);
    }

    @Override
    public QueryResult<UmRolePermission> queryRolePermissionPage(Map<String, Object> map) {
        List<UmRolePermission> umRolePermissionList = this.queryRolePermissionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRolePermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umRolePermissionList);
        return queryResult;
    }

    @Override
    public UmRolePermission getRolePermissionByCode(String tenantCode, String permissionCode) throws ApiException {
        if (StringUtils.isBlank((String)permissionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("permissionCode", permissionCode);
        return this.getRolePermissionModelByCode(map);
    }

    @Override
    public void deleteRolePermissionByCode(String tenantCode, String permissionCode) throws ApiException {
        if (StringUtils.isBlank((String)permissionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("permissionCode", permissionCode);
        this.delRolePermissionModelByCode(map);
    }

    @Override
    public void deleteRolePerByRoleCode(String tenantCode, String roleCode) throws ApiException {
        if (StringUtils.isBlank((String)roleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("roleCode", roleCode);
        this.logger.error(".\u5220\u9664\u89d2\u8272\u6743\u9650----", (Object)((Object)map).toString());
        this.deleteRolePerModelByRoleCode(map);
    }

    private void deleteRolePerModelByRoleCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umRolePermissionMapper.delByRoleCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRolePermissionServiceImpl.deleteRolePerModelByRoleCode.ex", (Throwable)e);
        }
    }
}

